/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.messaging.message;

import com.beyondcron.core.Filter;
import com.beyondcron.core.Result;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.message.AbstractCommandMessage;
import com.beyondcron.messaging.message.Queue;
import com.beyondcron.messaging.message.ResultList;
import com.beyondcron.messaging.message.ResultMessage;
import com.beyondcron.messaging.proto.ProtoQueue;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.List;

public class QueueQuery
extends AbstractCommandMessage<QueueQuery> {
    private static final String MESSAGE_TAG = "query";
    private Filter filter = new Filter();

    public QueueQuery() {
    }

    public QueueQuery(Filter filter) {
        this.filter = filter;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public QueueQuery setFilter(Filter filter) {
        this.filter = filter;
        return this;
    }

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    public ProtoQueue.Query.Builder toProto() {
        ProtoQueue.Query.Builder builder = ProtoQueue.Query.newBuilder();
        builder.setClientId(this.clientId);
        if (this.filter.getType() != Filter.Type.ANY) {
            builder.setFilter(this.filter.toProto());
        }
        return builder;
    }

    @Override
    public QueueQuery fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoQueue.Query proto = ProtoQueue.Query.parseFrom(data);
        this.clientId = proto.getClientId();
        this.filter = new Filter();
        if (proto.hasFilter()) {
            this.filter.fromProto(proto.getFilter().toByteArray());
        }
        return this;
    }

    public static class Response
    implements Message<Response>,
    ResultMessage,
    ResultList {
        private static final String MESSAGE_TAG = "response";
        private Result result = new Result();
        private List<Queue> queues = new ArrayList<Queue>();

        public Response addQueue(Queue queue) {
            this.queues.add(queue);
            return this;
        }

        public List<Queue> getQueues() {
            return this.queues;
        }

        @Override
        public Result getResult() {
            return this.result;
        }

        public Response setResult(Result result) {
            this.result = result;
            return this;
        }

        @Override
        public boolean isEmpty() {
            return this.queues.isEmpty();
        }

        @Override
        public String getMessageTag() {
            return MESSAGE_TAG;
        }

        public ProtoQueue.QueryResponse.Builder toProto() {
            ProtoQueue.QueryResponse.Builder builder = ProtoQueue.QueryResponse.newBuilder();
            builder.setResult(this.result.toProto());
            for (Queue queue : this.queues) {
                builder.addQueues(queue.toProto());
            }
            return builder;
        }

        @Override
        public Response fromProto(byte[] data) throws InvalidProtocolBufferException {
            ProtoQueue.QueryResponse proto = ProtoQueue.QueryResponse.parseFrom(data);
            this.result = new Result().fromProto(proto.getResult().toByteArray());
            for (ProtoQueue.Queue queue : proto.getQueuesList()) {
                this.queues.add(new Queue().fromProto(queue.toByteArray()));
            }
            return this;
        }
    }
}

