/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.messaging.message;

import com.beyondcron.core.Filter;
import com.beyondcron.core.Result;
import com.beyondcron.core.Role;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.message.AbstractCommandMessage;
import com.beyondcron.messaging.message.ResultList;
import com.beyondcron.messaging.message.ResultMessage;
import com.beyondcron.messaging.proto.ProtoRole;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RoleQuery
extends AbstractCommandMessage<RoleQuery> {
    private static final String MESSAGE_TAG = "query";
    private Filter filter = new Filter();
    private boolean includeUsers = false;

    public RoleQuery() {
    }

    public RoleQuery(String name, boolean includeUsers) {
        this.filter = new Filter(name);
        this.includeUsers = includeUsers;
    }

    public RoleQuery(Filter filter) {
        this.filter = filter;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public RoleQuery setFilter(Filter filter) {
        this.filter = filter;
        return this;
    }

    public boolean includeUsers() {
        return this.includeUsers;
    }

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    public ProtoRole.Query.Builder toProto() {
        ProtoRole.Query.Builder builder = ProtoRole.Query.newBuilder();
        builder.setClientId(this.clientId);
        if (this.filter.getType() != Filter.Type.ANY) {
            builder.setFilter(this.filter.toProto());
        }
        if (this.includeUsers) {
            builder.setIncludeUsers(true);
        }
        return builder;
    }

    @Override
    public RoleQuery fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoRole.Query proto = ProtoRole.Query.parseFrom(data);
        this.clientId = proto.getClientId();
        this.filter = new Filter();
        if (proto.hasFilter()) {
            this.filter.fromProto(proto.getFilter().toByteArray());
        }
        this.includeUsers = proto.getIncludeUsers();
        return this;
    }

    public static class Response
    implements Message<Response>,
    ResultMessage,
    ResultList {
        private static final String MESSAGE_TAG = "response";
        private Result result = new Result();
        private List<Role> roles = new ArrayList<Role>();

        public Response addRole(Role role) {
            this.roles.add(role);
            return this;
        }

        public Role getRole() {
            return this.result.wasSuccess() && this.roles.size() == 1 ? this.roles.get(0) : null;
        }

        public List<Role> getRoles() {
            Collections.sort(this.roles);
            return this.roles;
        }

        @Override
        public Result getResult() {
            return this.result;
        }

        public Response setResult(Result result) {
            this.result = result;
            return this;
        }

        @Override
        public boolean isEmpty() {
            return this.roles.isEmpty();
        }

        @Override
        public String getMessageTag() {
            return MESSAGE_TAG;
        }

        public ProtoRole.QueryResponse.Builder toProto() {
            ProtoRole.QueryResponse.Builder builder = ProtoRole.QueryResponse.newBuilder();
            builder.setResult(this.result.toProto());
            for (Role role : this.roles) {
                builder.addRoles(role.toProto());
            }
            return builder;
        }

        @Override
        public Response fromProto(byte[] data) throws InvalidProtocolBufferException {
            ProtoRole.QueryResponse proto = ProtoRole.QueryResponse.parseFrom(data);
            this.result = new Result().fromProto(proto.getResult().toByteArray());
            this.roles.clear();
            for (ProtoRole.Role role : proto.getRolesList()) {
                this.roles.add(new Role().fromProto(role.toByteArray()));
            }
            return this;
        }
    }
}

