/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.messaging.message;

import com.beyondcron.core.Result;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.message.AbstractCommandMessage;
import com.beyondcron.messaging.message.Connection;
import com.beyondcron.messaging.message.ResultList;
import com.beyondcron.messaging.message.ResultMessage;
import com.beyondcron.messaging.proto.ProtoConnection;
import com.beyondcron.messaging.proto.ProtoServer;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.List;

public class ServerQuery
extends AbstractCommandMessage<ServerQuery> {
    private static final String MESSAGE_TAG = "query";

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    public ProtoServer.Query.Builder toProto() {
        ProtoServer.Query.Builder builder = ProtoServer.Query.newBuilder();
        builder.setClientId(this.clientId);
        return builder;
    }

    @Override
    public ServerQuery fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoServer.Query proto = ProtoServer.Query.parseFrom(data);
        this.clientId = proto.getClientId();
        return this;
    }

    public static class Response
    implements Message<Response>,
    ResultMessage,
    ResultList {
        private static final String MESSAGE_TAG = "response";
        private Result result = new Result();
        private List<Connection> servers = new ArrayList<Connection>();

        public Response addServer(Connection server) {
            this.servers.add(server);
            return this;
        }

        public List<Connection> getServers() {
            return this.servers;
        }

        @Override
        public Result getResult() {
            return this.result;
        }

        public Response setResult(Result result) {
            this.result = result;
            return this;
        }

        @Override
        public boolean isEmpty() {
            return this.servers.isEmpty();
        }

        @Override
        public String getMessageTag() {
            return MESSAGE_TAG;
        }

        public ProtoServer.QueryResponse.Builder toProto() {
            ProtoServer.QueryResponse.Builder builder = ProtoServer.QueryResponse.newBuilder();
            builder.setResult(this.result.toProto());
            for (Connection server : this.servers) {
                builder.addServers(server.toProto());
            }
            return builder;
        }

        @Override
        public Response fromProto(byte[] data) throws InvalidProtocolBufferException {
            ProtoServer.QueryResponse proto = ProtoServer.QueryResponse.parseFrom(data);
            this.result = new Result().fromProto(proto.getResult().toByteArray());
            for (ProtoConnection.Connection server : proto.getServersList()) {
                this.servers.add(new Connection().fromProto(server.toByteArray()));
            }
            return this;
        }
    }
}

