/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.messaging.message;

import com.beyondcron.core.Filter;
import com.beyondcron.core.Result;
import com.beyondcron.core.user.User;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.message.AbstractCommandMessage;
import com.beyondcron.messaging.message.ResultList;
import com.beyondcron.messaging.message.ResultMessage;
import com.beyondcron.messaging.proto.ProtoUser;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.List;

public class UserQuery
extends AbstractCommandMessage<UserQuery> {
    private static final String MESSAGE_TAG = "query";
    private Filter filter = new Filter();

    public UserQuery() {
    }

    public UserQuery(String name) {
        this.filter = new Filter(name);
    }

    public Filter getFilter() {
        return this.filter;
    }

    public UserQuery setFilter(Filter filter) {
        this.filter = filter;
        return this;
    }

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    public ProtoUser.Query.Builder toProto() {
        ProtoUser.Query.Builder builder = ProtoUser.Query.newBuilder();
        builder.setClientId(this.clientId);
        if (this.filter.getType() != Filter.Type.ANY) {
            builder.setFilter(this.filter.toProto());
        }
        return builder;
    }

    @Override
    public UserQuery fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoUser.Query proto = ProtoUser.Query.parseFrom(data);
        this.clientId = proto.getClientId();
        this.filter = new Filter();
        if (proto.hasFilter()) {
            this.filter.fromProto(proto.getFilter().toByteArray());
        }
        return this;
    }

    public static class Response
    implements Message<Response>,
    ResultMessage,
    ResultList {
        private static final String MESSAGE_TAG = "response";
        private Result result = new Result();
        private List<User> users = new ArrayList<User>();

        public Response addUser(User user) {
            this.users.add(user);
            return this;
        }

        public User getUser() {
            return this.result.wasSuccess() && this.users.size() == 1 ? this.users.get(0) : null;
        }

        public List<User> getUsers() {
            return this.users;
        }

        @Override
        public Result getResult() {
            return this.result;
        }

        public Response setResult(Result result) {
            this.result = result;
            return this;
        }

        @Override
        public boolean isEmpty() {
            return this.users.isEmpty();
        }

        @Override
        public String getMessageTag() {
            return MESSAGE_TAG;
        }

        public ProtoUser.QueryResponse.Builder toProto() {
            ProtoUser.QueryResponse.Builder builder = ProtoUser.QueryResponse.newBuilder();
            builder.setResult(this.result.toProto());
            for (User user : this.users) {
                builder.addUsers(user.toProto(true));
            }
            return builder;
        }

        @Override
        public Response fromProto(byte[] data) throws InvalidProtocolBufferException {
            ProtoUser.QueryResponse proto = ProtoUser.QueryResponse.parseFrom(data);
            this.result = new Result().fromProto(proto.getResult().toByteArray());
            this.users.clear();
            for (ProtoUser.User user : proto.getUsersList()) {
                this.users.add(new User().fromProto(user.toByteArray()));
            }
            return this;
        }
    }
}

