/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.messaging.message;

import com.beyondcron.core.EnumMap;
import com.beyondcron.core.user.User;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.proto.ProtoUser;
import com.google.protobuf.InvalidProtocolBufferException;

public class UserUpdate
implements Message<UserUpdate> {
    private static final String MESSAGE_TAG = "update";
    private User user;
    private Type type;
    private boolean excludePassword = true;

    public UserUpdate() {
    }

    public UserUpdate(User user, Type type) {
        this.user = user;
        this.type = type;
    }

    public void setIncludePassword(boolean includePassword) {
        this.excludePassword = !includePassword;
    }

    public User getUser() {
        return this.user;
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    public ProtoUser.Update.Builder toProto() {
        ProtoUser.Update.Builder builder = ProtoUser.Update.newBuilder();
        builder.setUser(this.user.toProto(this.excludePassword));
        builder.setType(this.type.toProto());
        return builder;
    }

    @Override
    public UserUpdate fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoUser.Update proto = ProtoUser.Update.parseFrom(data);
        this.user = new User().fromProto(proto.getUser().toByteArray());
        this.type = Type.fromProto(proto.getType());
        return this;
    }

    public static enum Type {
        CREATED,
        UPDATED,
        DELETED;

        static EnumMap<Type, ProtoUser.Update.Type> typeMap;

        public static Type fromProto(ProtoUser.Update.Type type) {
            return typeMap.getA(type);
        }

        public ProtoUser.Update.Type toProto() {
            return typeMap.getB(this);
        }

        static {
            typeMap = new EnumMap<Type, ProtoUser.Update.Type>(Type.class, ProtoUser.Update.Type.class);
        }
    }
}

