/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.messaging.message.calendar;

import com.beyondcron.core.BlissUtils;
import com.beyondcron.core.CollectionUtils;
import com.beyondcron.core.Diff;
import com.beyondcron.core.JSON;
import com.beyondcron.core.Localise;
import com.beyondcron.core.Name;
import com.beyondcron.core.NetUtils;
import com.beyondcron.core.StringUtils;
import com.beyondcron.core.calendar.ICalendarData;
import com.beyondcron.messaging.NamedMessage;
import com.beyondcron.messaging.proto.ProtoCalendar;
import com.google.protobuf.InvalidProtocolBufferException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;
import java.util.TreeSet;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Calendar
implements Comparable<Calendar>,
Diff<Calendar>,
NamedMessage<Calendar>,
JSON<Calendar> {
    public static final String MESSAGE_TAG = "cal";
    private static final int MESSAGE_TYPE = "au.com.tonbo.bliss.messaging.message.calendar.Calendar".hashCode();
    public static final Name ALL_CALENDARS = BlissUtils.ACL_DIR_CALENDARS;
    private static URI DAILY_CALENDAR = ICalendarData.DAILY.getURI();
    public static final String JSON_NAME = "name";
    public static final String JSON_DESCRIPTION = "description";
    public static final String JSON_INCLUSIVE_CALENDARS = "includes";
    public static final String JSON_EXCLUSIVE_CALENDARS = "excludes";
    private Name name;
    private String description = "";
    private Set<URI> inclusiveCalendars = new TreeSet<URI>();
    private Set<URI> exclusiveCalendars = new TreeSet<URI>();
    private int jobReferenceCount = 0;
    private long lastUpdated = 0L;

    public Calendar() {
        this.initCalendars();
    }

    public Calendar(Name name) {
        this.name = name;
        this.initCalendars();
    }

    public Calendar(Name name, String description) {
        this.name = name;
        this.setDescription(description);
        this.initCalendars();
    }

    private void initCalendars() {
        this.inclusiveCalendars.clear();
        this.inclusiveCalendars.add(DAILY_CALENDAR);
        this.exclusiveCalendars.clear();
    }

    @Override
    public Name getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Calendar setDescription(String description) {
        this.description = description != null ? StringUtils.stripDuplicateSpaces(description) : "";
        return this;
    }

    public long getLastUpdated() {
        return this.lastUpdated;
    }

    public Calendar setLastUpdated(long lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this;
    }

    public Calendar addInclusiveCalendar(URI uri) {
        if (uri.equals(DAILY_CALENDAR)) {
            this.inclusiveCalendars.clear();
            this.inclusiveCalendars.add(uri);
        } else if (this.inclusiveCalendars.add(uri)) {
            this.inclusiveCalendars.remove(DAILY_CALENDAR);
        }
        return this;
    }

    public Calendar removeInclusiveCalendar(URI uri) {
        if (this.inclusiveCalendars.remove(uri) && this.inclusiveCalendars.isEmpty()) {
            this.inclusiveCalendars.add(DAILY_CALENDAR);
        }
        return this;
    }

    public Set<URI> getInclusiveCalendars() {
        return this.inclusiveCalendars;
    }

    public Calendar addExclusiveCalendar(URI uri) {
        this.exclusiveCalendars.add(uri);
        return this;
    }

    public Calendar removeExclusiveCalendar(URI uri) {
        this.exclusiveCalendars.remove(uri);
        return this;
    }

    public Set<URI> getExclusiveCalendars() {
        return this.exclusiveCalendars;
    }

    public Set<URI> getCalendars() {
        return CollectionUtils.join(this.inclusiveCalendars, this.exclusiveCalendars);
    }

    public boolean includesCalendar(URI uri) {
        return this.inclusiveCalendars.contains(uri) || this.exclusiveCalendars.contains(uri);
    }

    public int getJobReferenceCount() {
        return this.jobReferenceCount;
    }

    public Calendar setJobReferenceCount(int jobReferenceCount) {
        this.jobReferenceCount = jobReferenceCount;
        return this;
    }

    @Override
    public JSONObject diff(Calendar that) {
        JSONArray diff;
        JSONObject diffs = new JSONObject();
        if (!this.name.equals(that.name)) {
            diffs.put(JSON_NAME, JSON.array(this.name, that.name));
        }
        if (!this.description.equals(that.description)) {
            diffs.put(JSON_DESCRIPTION, JSON.array(this.description, that.description));
        }
        if (!this.inclusiveCalendars.equals(that.inclusiveCalendars)) {
            diff = new JSONArray();
            diff.put(JSON.array(this.inclusiveCalendars.toArray()));
            diff.put(JSON.array(that.inclusiveCalendars.toArray()));
            diffs.put(JSON_INCLUSIVE_CALENDARS, diff);
        }
        if (!this.exclusiveCalendars.equals(that.exclusiveCalendars)) {
            diff = new JSONArray();
            diff.put(JSON.array(this.exclusiveCalendars.toArray()));
            diff.put(JSON.array(that.exclusiveCalendars.toArray()));
            diffs.put(JSON_EXCLUSIVE_CALENDARS, diff);
        }
        return diffs;
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        json.put(JSON_NAME, this.name.toString());
        if (!StringUtils.isNullOrEmpty(this.description)) {
            json.put(JSON_DESCRIPTION, this.description);
        }
        if (!(this.inclusiveCalendars.isEmpty() || this.inclusiveCalendars.size() == 1 && this.inclusiveCalendars.iterator().next().equals(DAILY_CALENDAR))) {
            json.put(JSON_INCLUSIVE_CALENDARS, this.getStringArray(this.inclusiveCalendars));
        }
        if (!this.exclusiveCalendars.isEmpty()) {
            json.put(JSON_EXCLUSIVE_CALENDARS, this.getStringArray(this.exclusiveCalendars));
        }
        return json;
    }

    private JSONArray getStringArray(Set values) {
        JSONArray array = new JSONArray();
        for (Object value : values) {
            array.put(value.toString());
        }
        return array;
    }

    @Override
    public Calendar fromJSON(JSONObject json) throws JSONException {
        int i;
        try {
            this.name = new Name(json.getString(JSON_NAME));
        }
        catch (URISyntaxException e) {
            throw new JSONException(Localise.format("invalid %1$s - %2$s - %3$s", JSON_NAME, json.getString(JSON_NAME), e.getMessage()));
        }
        this.description = json.optString(JSON_DESCRIPTION);
        this.initCalendars();
        JSONArray array = json.optJSONArray(JSON_INCLUSIVE_CALENDARS);
        if (array != null) {
            for (i = 0; i < array.length(); ++i) {
                try {
                    this.addInclusiveCalendar(NetUtils.parseURI(array.getString(i), "bliss", "beyondcron"));
                    continue;
                }
                catch (IllegalArgumentException e) {
                    throw new JSONException(Localise.format("invalid %1$s - %2$s - %3$s", JSON_INCLUSIVE_CALENDARS, array.get(i).toString(), e.getMessage()));
                }
            }
        }
        if ((array = json.optJSONArray(JSON_EXCLUSIVE_CALENDARS)) != null) {
            for (i = 0; i < array.length(); ++i) {
                try {
                    this.exclusiveCalendars.add(NetUtils.parseURI(array.getString(i), "bliss", "beyondcron"));
                    continue;
                }
                catch (IllegalArgumentException e) {
                    throw new JSONException(Localise.format("invalid %1$s - %2$s - %3$s", JSON_EXCLUSIVE_CALENDARS, array.getString(i), e.getMessage()));
                }
            }
        }
        this.jobReferenceCount = 0;
        this.lastUpdated = 0L;
        return this;
    }

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    @Override
    public int getMessageType() {
        return MESSAGE_TYPE;
    }

    public ProtoCalendar.Calendar.Builder toProto() {
        ProtoCalendar.Calendar.Builder builder = ProtoCalendar.Calendar.newBuilder();
        builder.setName(this.name.toProto());
        if (!this.description.isEmpty()) {
            builder.setDescription(this.description);
        }
        builder.setLastUpdated(this.lastUpdated);
        for (URI include : this.inclusiveCalendars) {
            builder.addIncludes(include.toString());
        }
        for (URI exclude : this.exclusiveCalendars) {
            builder.addExcludes(exclude.toString());
        }
        if (this.jobReferenceCount > 0) {
            builder.setJobReferences(this.jobReferenceCount);
        }
        return builder;
    }

    @Override
    public Calendar fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoCalendar.Calendar proto = ProtoCalendar.Calendar.parseFrom(data);
        this.name = new Name(proto.getName());
        this.description = proto.hasDescription() ? proto.getDescription() : "";
        this.lastUpdated = proto.getLastUpdated();
        this.inclusiveCalendars.clear();
        for (String include : proto.getIncludesList()) {
            this.inclusiveCalendars.add(NetUtils.parseURI(include, "bliss", "beyondcron"));
        }
        this.exclusiveCalendars.clear();
        for (String exclude : proto.getExcludesList()) {
            this.exclusiveCalendars.add(NetUtils.parseURI(exclude, "bliss", "beyondcron"));
        }
        this.jobReferenceCount = proto.getJobReferences();
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Calendar)) {
            return false;
        }
        return this.compareTo((Calendar)obj) == 0;
    }

    @Override
    public int compareTo(Calendar that) {
        return this.name.compareTo(that.name);
    }
}

