/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.agent;

import com.beyondcron.core.Configs;
import com.beyondcron.core.Localise;
import com.beyondcron.core.LogUtils;
import com.beyondcron.core.Period;
import com.beyondcron.core.Property;
import com.beyondcron.core.config.PeriodConfig;
import com.beyondcron.core.config.StringConfig;
import com.beyondcron.core.job.Job;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Logger;

public class EchoUtil {
    static final Logger logger = LogUtils.getLogger(EchoUtil.class);
    private final long startTime = System.currentTimeMillis();
    public Period runtime = new Period(0, Period.Unit.SECOND);
    public Period runtimeMin = new Period(0, Period.Unit.SECOND);
    public Period runtimeMax = new Period(0, Period.Unit.SECOND);
    public int success = 100;
    public boolean wasSuccess = true;
    public String message = Localise.format((String)"Unknown state");

    public EchoUtil(Job job) {
        this.runtime = this.getPeriod(job, "echo.run");
        this.runtimeMin = this.getPeriod(job, "echo.run.min");
        this.runtimeMax = this.getPeriod(job, "echo.run.max");
        if (this.runtimeMax.getMilliseconds() < this.runtimeMin.getMilliseconds()) {
            this.runtimeMin = this.runtimeMax;
        }
        this.success = this.getPercentage(job, "echo.success");
        if (this.success < 0) {
            this.success = 0;
        } else if (this.success > 100) {
            this.success = 100;
        }
        if (logger.isDebugEnabled()) {
            Localise.logDebug((Logger)logger, (String)"runtime: %1$s", (Object[])new Object[]{this.runtime.toString()});
            Localise.logDebug((Logger)logger, (String)"runtimeMin: %1$s", (Object[])new Object[]{this.runtimeMin.toString()});
            Localise.logDebug((Logger)logger, (String)"runtimeMax: %1$s", (Object[])new Object[]{this.runtimeMax.toString()});
            Localise.logDebug((Logger)logger, (String)"success: %1$d", (Object[])new Object[]{this.success});
        }
    }

    public boolean run() {
        long pause = 0L;
        if (this.runtime.getMilliseconds() > 0L) {
            pause = this.runtime.getMilliseconds() - (System.currentTimeMillis() - this.startTime);
        } else if (this.runtimeMax.getMilliseconds() > 0L) {
            pause = (long)((double)this.runtimeMin.getMilliseconds() + Math.random() * (double)(this.runtimeMax.getMilliseconds() - this.runtimeMin.getMilliseconds())) - (System.currentTimeMillis() - this.startTime);
        }
        if (pause > 0L) {
            try {
                Thread.sleep(pause);
            }
            catch (InterruptedException e) {
                Localise.logError((Logger)logger, (Exception)e, (String)"echo sleep(%1$s) unexpectedly interrupted", (Object[])new Object[]{pause});
            }
        }
        this.wasSuccess = this.success >= 100 || (int)(Math.random() * 100.0) <= this.success;
        this.message = this.wasSuccess ? Localise.format((String)"Success") : Localise.format((String)"Random failure");
        return this.wasSuccess;
    }

    private int getPercentage(Job job, String configName) {
        Property property;
        Matcher matcher;
        int value = 0;
        Pattern regex = Pattern.compile("(([1-9]?[0-9])|100)%");
        StringConfig config = (StringConfig)Configs.getConfig((String)configName);
        if (config != null && (matcher = regex.matcher(config.getValue())).matches()) {
            value = Integer.parseInt(matcher.group(1));
        }
        if ((property = job.getProperty(configName)) != null) {
            matcher = regex.matcher(property.getValue());
            if (matcher.matches()) {
                value = Integer.parseInt(matcher.group(1));
            } else {
                Localise.logWarn((Logger)logger, (String)"%1$s: invalid value (%2$s) for %3$s using default (%$4d)", (Object[])new Object[]{job.getName().toString(), property.getValue(), configName, value});
            }
        }
        return value;
    }

    private Period getPeriod(Job job, String configName) {
        PeriodConfig config = (PeriodConfig)Configs.getConfig((String)configName);
        Period value = config != null ? (Period)config.getValue() : new Period(0, Period.Unit.SECOND);
        Property property = job.getProperty(configName);
        if (property != null) {
            try {
                Period v = new Period(property.getValue());
                String error = config.validate(v);
                if (error == null) {
                    value = v;
                } else {
                    Localise.logWarn((Logger)logger, (String)"%1$s: invalid value (%2$s) for %3$s using default (%4$s)", (Object[])new Object[]{job.getName().toString(), property.getValue(), configName, value.toString()});
                }
            }
            catch (IllegalArgumentException e) {
                Localise.logWarn((Logger)logger, (String)"%1$s: invalid value (%2$s) for %3$s using default (%$4s)", (Object[])new Object[]{job.getName().toString(), property.getValue(), configName, value.toString()});
            }
        }
        return value;
    }
}

