/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.agent;

import com.beyondcron.agent.EchoUtil;
import com.beyondcron.agent.service.CommandService;
import com.beyondcron.agent.service.SQLService;
import com.beyondcron.core.Configs;
import com.beyondcron.core.FileUtils;
import com.beyondcron.core.HTTPUtils;
import com.beyondcron.core.Localise;
import com.beyondcron.core.LogUtils;
import com.beyondcron.core.MailUtils;
import com.beyondcron.core.Name;
import com.beyondcron.core.NetUtils;
import com.beyondcron.core.Period;
import com.beyondcron.core.Program;
import com.beyondcron.core.Property;
import com.beyondcron.core.ResizableSemaphore;
import com.beyondcron.core.ServiceException;
import com.beyondcron.core.StringUtils;
import com.beyondcron.core.TableFormatter;
import com.beyondcron.core.ThreadUtils;
import com.beyondcron.core.TimeUtils;
import com.beyondcron.core.agent.AgentService;
import com.beyondcron.core.job.Job;
import com.beyondcron.core.job.MailJob;
import com.beyondcron.core.job.Output;
import com.beyondcron.core.job.Status;
import com.beyondcron.core.job.URLJob;
import com.beyondcron.messaging.Connection;
import com.beyondcron.messaging.Hazelcast;
import com.beyondcron.messaging.message.JobExecute;
import com.hazelcast.client.HazelcastClientNotActiveException;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.IMap;
import com.hazelcast.core.IQueue;
import com.hazelcast.spi.exception.TargetDisconnectedException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Logger;

public class ProcessManager
implements Connection.ConnectionListener,
AgentService.Listener {
    static final Logger logger = LogUtils.getLogger(ProcessManager.class);
    private static final Period defaultLimitStart;
    private final String hostName;
    private final Map<Job.Type, AgentService> services = new HashMap<Job.Type, AgentService>();
    private final List<String> serviceNames = new ArrayList<String>();
    private final boolean localAgent;
    private final Connection connection;
    private final Object reconnected = new Object();
    private final IQueue<JobExecute> commandQueue;
    private final IQueue<Status> statusQueue;
    private final IMap<Name, String> jobAgentMap;
    private final IMap<Name, Long> activeJobs;
    private final IQueue<JobExecute> sshCommandQueue;
    private final ResizableSemaphore sshThreads = new ResizableSemaphore(((Integer)Configs.get((String)"beyondcron.agent.ssh.threads")).intValue());
    private final Set<Name> sshThreadCommands = Collections.synchronizedSet(new HashSet());
    private Thread sshCommandThread = null;
    private final Map<Name, JobProcess> processes = new HashMap<Name, JobProcess>();

    public ProcessManager(Connection connection, boolean localAgent) {
        this.connection = connection;
        this.localAgent = localAgent;
        HazelcastInstance hazelcast = connection.getHazelcast();
        this.hostName = connection.getClientHostName();
        this.statusQueue = Hazelcast.getJobStatusQueue((HazelcastInstance)hazelcast);
        this.commandQueue = Hazelcast.getAgentCommandQueue((HazelcastInstance)hazelcast, (String)connection.getClientHostName());
        this.sshCommandQueue = localAgent ? null : Hazelcast.getAgentSshCommandQueue((HazelcastInstance)hazelcast);
        this.jobAgentMap = Hazelcast.getJobAgentMap((HazelcastInstance)hazelcast);
        this.activeJobs = Hazelcast.getJobActiveMap((HazelcastInstance)hazelcast);
        Configs.addListener((String)"beyondcron.agent.ssh.threads", config -> this.sshThreads.resize(((Integer)config.getValue()).intValue()));
        this.initServices(hazelcast);
        connection.setConnectionListener((Connection.ConnectionListener)this);
    }

    private void initServices(HazelcastInstance hazelcast) {
        if (Program.getOs() != Program.OS.WINDOWS) {
            this.registerService(new CommandService(hazelcast));
        }
        this.registerService(new SQLService());
        try {
            AgentService service = AgentService.getService((HazelcastInstance)hazelcast);
            if (service != null) {
                this.registerService(service);
            }
        }
        catch (ServiceException e) {
            Localise.logFatal((Logger)logger, (String)"Could not initialise agent service - %s", (Object[])new Object[]{e.getMessage()});
            Program.exit((int)1);
        }
    }

    private void registerService(AgentService service) {
        service.setListener((AgentService.Listener)this);
        this.services.put(service.getJobType(), service);
        if (service.getJobType() != Job.Type.COMMAND) {
            this.serviceNames.add(service.getServiceName());
        } else {
            this.serviceNames.add(service.getServiceName() + (this.sshCommandQueue == null ? " local" : " local/ssh"));
        }
    }

    public List<String> getServiceNames() {
        return this.serviceNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            if (this.sshCommandQueue != null) {
                this.sshCommandThread = new Thread(() -> {
                    boolean threadPoolFull = false;
                    while (true) {
                        if (logger.isDebugEnabled()) {
                            Localise.logDebug((Logger)logger, (String)"ssh threads: %1$d/%2$d", (Object[])new Object[]{this.sshThreads.availablePermits(), this.sshThreads.getTotalPermits()});
                            Localise.logDebug((Logger)logger, (String)"- thread pool - %1$d", (Object[])new Object[]{ThreadUtils.getActiveThreadCount()});
                        }
                        try {
                            if (this.sshThreads.tryAcquire(defaultLimitStart.getSeconds(), TimeUnit.SECONDS)) {
                                if (threadPoolFull) {
                                    Localise.logWarn((Logger)logger, (String)"Acquired a thread, %1$d commands waiting", (Object[])new Object[]{this.sshCommandQueue.size()});
                                    threadPoolFull = false;
                                }
                            } else {
                                if (!threadPoolFull) {
                                    Localise.logWarn((Logger)logger, (String)"Waiting more than %1$d seconds for a thread, %2$d commands waiting", (Object[])new Object[]{defaultLimitStart.getSeconds(), this.sshCommandQueue.size()});
                                    threadPoolFull = true;
                                }
                                this.sshThreads.acquire();
                            }
                            this.execute((JobExecute)this.sshCommandQueue.take(), true);
                            continue;
                        }
                        catch (HazelcastClientNotActiveException | HazelcastInstanceNotActiveException | TargetDisconnectedException e) {
                            if (this.connection.isClosing()) break;
                            Localise.logWarn((Logger)logger, (String)"Connection to server lost - %s", (Object[])new Object[]{e.getClass()});
                        }
                        catch (InterruptedException e) {
                            Localise.logFatal((Logger)logger, (String)"Unexpectedly interrupted - %s", (Object[])new Object[]{e.getMessage()});
                        }
                        catch (Exception e) {
                            Localise.logError((Logger)logger, (Exception)e, (String)"Unexpected exception - %s", (Object[])new Object[]{e.getClass()});
                            continue;
                        }
                        break;
                    }
                }, ThreadUtils.getName((Object)this, (String[])new String[0]));
                this.sshCommandThread.start();
            }
            while (true) {
                try {
                    while (true) {
                        this.execute((JobExecute)this.commandQueue.take(), false);
                    }
                }
                catch (HazelcastClientNotActiveException | HazelcastInstanceNotActiveException | TargetDisconnectedException e) {
                    if (this.connection.isClosing()) break;
                    Localise.logWarn((Logger)logger, (String)"Connection to server lost - %s", (Object[])new Object[]{e.getClass()});
                }
                catch (InterruptedException e) {
                    Localise.logFatal((Logger)logger, (String)"Unexpectedly interrupted - %s", (Object[])new Object[]{e.getMessage()});
                }
                catch (Exception e) {
                    Localise.logError((Logger)logger, (Exception)e, (String)"Unexpected exception - %s", (Object[])new Object[]{e.getClass()});
                    continue;
                }
                break;
            }
            if (this.connection.isClosing()) break;
            Object object = this.reconnected;
            synchronized (object) {
                try {
                    this.reconnected.wait();
                }
                catch (InterruptedException e) {
                    Localise.logFatal((Logger)logger, (String)"Unexpectedly interrupted - %s", (Object[])new Object[]{e.getMessage()});
                    break;
                }
            }
        }
    }

    public void execute(JobExecute command, boolean sshCommand) {
        JobProcess process;
        Job.Action action;
        block15: {
            Name name;
            block13: {
                block14: {
                    long startTimestamp = command.getStartTimestamp();
                    Job job = command.getJob().expand(startTimestamp, command.getTrigger(), command.getTriggerStatus());
                    name = job.getName();
                    action = command.getAction();
                    Long activeStartTimestamp = (Long)this.activeJobs.get((Object)name);
                    if (activeStartTimestamp != null && activeStartTimestamp != startTimestamp) {
                        Localise.logInfo((Logger)logger, (String)"ignoring %s %s %d != %s", (Object[])new Object[]{name, action, startTimestamp, activeStartTimestamp});
                        if (sshCommand) {
                            this.sshThreads.release();
                        }
                        return;
                    }
                    if (sshCommand) {
                        this.sshThreadCommands.add(name);
                    }
                    Localise.logInfo((Logger)logger, (String)"execute: %1$s %2$s", (Object[])new Object[]{action, name});
                    if (!FileUtils.isAbsolute((String)job.getOutput().getPath())) {
                        this.sendUpdate(new Status(name, Status.Result.ERROR).setMessage(Localise.format((String)"Output file %s not absolute", (Object[])new Object[]{job.getOutput().getPath()})));
                        return;
                    }
                    AgentService service = this.services.get(job.getType());
                    if (service != null) {
                        try {
                            service.execute(command);
                        }
                        catch (ServiceException e) {
                            this.sendUpdate(new Status(name, Status.Result.EXCEPTION).setException((Exception)((Object)e)));
                        }
                        return;
                    }
                    Name jobName = job.getName();
                    process = this.processes.get(jobName);
                    if (action != Job.Action.START) break block13;
                    if (process != null) break block14;
                    switch (job.getType()) {
                        case COMMAND: {
                            this.sendUpdate(new Status(name, Status.Result.ERROR).setMessage(Localise.format((String)"Command jobs not yet supported on Windows")));
                            return;
                        }
                        case MAIL: {
                            process = new MailJobProcess((MailJob)job);
                            break block15;
                        }
                        case URL: {
                            process = new URLJobProcess((URLJob)job);
                            break block15;
                        }
                        default: {
                            this.sendUpdate(new Status(name, Status.Result.ERROR).setMessage(Localise.format((String)"Unsupported job type %s", (Object[])new Object[]{job.getType()})));
                            return;
                        }
                    }
                }
                this.sendUpdate(new Status(name, Status.Result.ERROR).setMessage(Localise.format((String)"Already running")));
                return;
            }
            if (process == null) {
                this.sendUpdate(new Status(name, Status.Result.ERROR).setMessage(Localise.format((String)"Not running")));
                return;
            }
        }
        process.execute(action);
    }

    private void sendUpdate(Status update) {
        Name name = update.getName();
        Status.Result result = update.getResult();
        if (result == Status.Result.EXCEPTION) {
            if (update.hasOutput()) {
                Localise.logError((Logger)logger, (String)"%1$s %2$s (%3$d) - %4$s\n%5$s", (Object[])new Object[]{result, name, ThreadUtils.getActiveThreadCount(), update.getMessage(), update.getOutput().toString()});
            } else {
                Localise.logError((Logger)logger, (String)"%1$s %2$s (%3$d) - %4$s", (Object[])new Object[]{result, name, ThreadUtils.getActiveThreadCount(), update.getMessage()});
            }
        } else {
            Localise.logInfo((Logger)logger, (String)"sendUpdate: %1$s %2$s", (Object[])new Object[]{name, update});
            if (logger.isDebugEnabled() && update.hasOutput()) {
                Localise.logDebug((Logger)logger, (String)"    output: %1$s %2$s", (Object[])new Object[]{name, update.getOutput().toString()});
            }
        }
        if (update.getState() == Status.State.RUNNING) {
            this.jobAgentMap.put((Object)name, (Object)this.hostName);
        } else if (update.isInactive()) {
            this.jobAgentMap.remove((Object)name);
        }
        if (update.isInactive() && this.sshThreadCommands.remove(name)) {
            this.sshThreads.release();
        }
        this.statusQueue.add((Object)update);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connected(String reason) {
        Object object = this.reconnected;
        synchronized (object) {
            this.reconnected.notify();
        }
    }

    public void disconnected(String reason) {
    }

    public void closed(String reason) {
    }

    public void locked(String reason) {
    }

    public void agentException(ServiceException exception) {
        logger.error(exception.getMessage(), (Throwable)exception);
    }

    public void agentUpdate(Status status) {
        this.sendUpdate(status);
    }

    public static File getOutputFile(Job job) {
        ArrayList<String> errors = new ArrayList<String>();
        File outputFile = null;
        for (File file : ProcessManager.getOutputFiles(job)) {
            if (FileUtils.canWrite((File)file)) {
                outputFile = file;
                break;
            }
            errors.add(file.toString());
        }
        if (!errors.isEmpty() && logger.isDebugEnabled()) {
            if (outputFile != null) {
                Localise.logError((Logger)logger, (String)"Writing output to %1$s for job %2$s", (Object[])new Object[]{outputFile, job.getName()});
                Localise.logError((Logger)logger, (String)" - instead of %1$s", (Object[])new Object[]{StringUtils.join((String)", ", (String)" & ", errors)});
            } else {
                Localise.logError((Logger)logger, (String)"Could not create an output file for job %2$s", (Object[])new Object[]{job.getName()});
                Localise.logError((Logger)logger, (String)" - tried %1$s", (Object[])new Object[]{StringUtils.join((String)", ", (String)" & ", errors)});
            }
        }
        return outputFile;
    }

    public static List<File> getOutputFiles(Job job) {
        ArrayList<File> files = new ArrayList<File>();
        URL output = job.getOutput();
        if (output != null) {
            if (output.getProtocol().equals("file")) {
                files.add(new File(output.getPath()));
            } else {
                Localise.logError((Logger)logger, (String)"Unsupported output protocol %1$s for job %2$s", (Object[])new Object[]{output.getProtocol(), job.getName()});
            }
        }
        if ((output = job.getDefaultOutput()) != null) {
            files.add(new File(output.getPath()));
        }
        files.add(new File(FileUtils.temporaryDirectory, String.format("beyondcron.%1$s.log", UUID.randomUUID())));
        return files;
    }

    static {
        System.setProperty("http.agent", Program.getName() + "/" + Program.getVersion());
        defaultLimitStart = (Period)Configs.get((String)"beyondcron.job.default.limit.start");
    }

    public class URLJobProcess
    extends JobProcess {
        private final URLJob job;
        private URL url;
        private final URLJob.Method method;
        private HttpURLConnection connection;
        private boolean killed;
        private boolean echoJob;

        public URLJobProcess(URLJob job) {
            String urlString;
            String queryDelim;
            super((Job)job);
            this.connection = null;
            this.killed = false;
            this.echoJob = false;
            this.job = job;
            this.method = job.getMethod();
            List properties = job.getProperties(Property.Type.PARAMETER);
            String urlSource = null;
            URL jUrl = job.getURL();
            String string = queryDelim = jUrl.getQuery() == null ? "?" : "&";
            if (!job.isEchoJob()) {
                urlString = this.method == URLJob.Method.GET && !properties.isEmpty() ? String.format("%1$s%2$s%3$s", jUrl, queryDelim, job.getFormContent()) : jUrl.toString();
            } else {
                this.echoJob = true;
                urlSource = jUrl.toString();
                urlString = this.method == URLJob.Method.GET && !properties.isEmpty() ? String.format("%1$s%2$s%3$s%4$s", Configs.get((String)"beyondcron.echo.url"), jUrl.getPath(), queryDelim, job.getFormContent()) : String.format("%1$s%2$s", Configs.get((String)"beyondcron.echo.url"), jUrl.getPath());
            }
            try {
                this.url = new URL(urlString);
            }
            catch (MalformedURLException e) {
                Localise.logError((Logger)logger, (String)"Could not create url from %1$s - %2$s", (Object[])new Object[]{urlString, e.getMessage()});
                ProcessManager.this.sendUpdate(new Status(this.getName(), Status.Result.EXCEPTION).setMessage(Localise.format((String)"Could not create url - %s", (Object[])new Object[]{e.getMessage()})));
                this.done();
                return;
            }
            this.connection = this.getConnection();
            if (this.connection == null) {
                this.done();
                return;
            }
            for (Property property : job.getProperties(Property.Type.HEADER)) {
                if (this.setRequestProperty(property.getName(), property.getValue())) continue;
                this.done();
                return;
            }
            if (urlSource != null) {
                this.setRequestProperty("echo_url", urlSource);
            }
        }

        private boolean setRequestProperty(String name, String value) {
            try {
                this.connection.setRequestProperty(name, value);
            }
            catch (Exception e) {
                this.connection = null;
                Localise.logError((Logger)logger, (String)"Could not set connection property %1$s - %2$s", (Object[])new Object[]{name, e.getMessage()});
                ProcessManager.this.sendUpdate(new Status(this.getName(), Status.Result.EXCEPTION).setMessage(Localise.format((String)"Could not set connection property %1$s - %2$s", (Object[])new Object[]{name, e.getMessage()})));
                return false;
            }
            return true;
        }

        private HttpURLConnection getConnection() {
            HttpURLConnection connection;
            Name name = this.getName();
            if (!this.url.getProtocol().matches("^https?$")) {
                ProcessManager.this.sendUpdate(new Status(name, Status.Result.ERROR).setMessage(Localise.format((String)"Unsupported protocol: %s", (Object[])new Object[]{this.url.getProtocol()})));
                return null;
            }
            try {
                connection = (HttpURLConnection)this.url.openConnection();
                connection.setRequestMethod(this.method.getMethod());
            }
            catch (IOException e) {
                ProcessManager.this.sendUpdate(new Status(name, Status.Result.ERROR).setMessage(Localise.format((String)"Could not open %1$s - %2$s", (Object[])new Object[]{this.url, e.getMessage()})));
                return null;
            }
            connection.setRequestProperty("Content-Type", this.job.getContentType() + "; charset=UTF-8");
            connection.setRequestProperty("Accept-Charset", "UTF-8");
            if (!this.job.getEffectiveContent().isEmpty()) {
                connection.setDoOutput(true);
            }
            return connection;
        }

        private String getParameterStrings(List<Property> properties) {
            LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
            for (Property property : properties) {
                props.put(property.getName(), property.getValue());
            }
            return NetUtils.getParameterString(props);
        }

        @Override
        public void start() {
            URLJob job = (URLJob)this.getJob();
            if (this.connection == null) {
                return;
            }
            ThreadUtils.submit(() -> {
                Status status;
                block14: {
                    FileOutputStream out;
                    Name name = job.getName();
                    EchoUtil echo = new EchoUtil((Job)job);
                    status = new Status(name, Status.State.STOPPED);
                    ProcessManager.this.sendUpdate(new Status(name, Status.State.RUNNING));
                    File outputFile = ProcessManager.getOutputFile((Job)job);
                    if (outputFile == null) {
                        ProcessManager.this.sendUpdate(new Status(name, Status.Result.ERROR).setMessage(Localise.format((String)"Could not create output file")));
                        this.done();
                        return;
                    }
                    try {
                        out = new FileOutputStream(outputFile);
                    }
                    catch (FileNotFoundException e) {
                        ProcessManager.this.sendUpdate(new Status(name, Status.Result.ERROR).setMessage(Localise.format((String)"Could not open %s - %s", (Object[])new Object[]{name, e.getMessage()})));
                        this.done();
                        return;
                    }
                    try {
                        int exitValue;
                        String content;
                        if (this.method != URLJob.Method.GET && !(content = job.getEffectiveContent()).isEmpty()) {
                            this.connection.getOutputStream().write(content.getBytes("UTF-8"));
                        }
                        boolean success = (exitValue = this.connection.getResponseCode()) >= 200 && exitValue < 300;
                        status.setExitValue(exitValue, success, this.connection.getResponseMessage());
                        if (this.echoJob && !echo.run() && success) {
                            status.setExitValue(HTTPUtils.Error.HTTP_IM_A_TEAPOT.getCode(), false, Localise.format((String)"Random failure"));
                        }
                        if (status.getMessage() == null) {
                            status.setMessage((String)HTTPUtils.INSTANCE.getErrors().get(exitValue));
                        }
                        if (success) {
                            int i;
                            InputStream in = this.connection.getInputStream();
                            byte[] buf = new byte[1024];
                            while ((i = in.read(buf)) != -1) {
                                out.write(buf, 0, i);
                            }
                            out.close();
                        }
                        try {
                            status.setOutput(new Output(outputFile));
                        }
                        catch (IOException e) {
                            String msg = Localise.format((String)"Could not read output file %1$s - %2$s", (Object[])new Object[]{outputFile, e.getMessage()});
                            logger.error(msg);
                            status.setMessage(msg);
                        }
                    }
                    catch (UnknownHostException e) {
                        status.setResult(Status.Result.ERROR).setMessage(Localise.format((String)"Unknown host - %1$s", (Object[])new Object[]{e.getMessage()}));
                    }
                    catch (Exception e) {
                        if (e instanceof IOException && this.killed) break block14;
                        status.setResult(Status.Result.EXCEPTION).setMessage(Localise.format((String)"Error calling %1$s - %2$s", (Object[])new Object[]{this.connection.getURL(), e.getMessage()}));
                    }
                }
                if (this.killed) {
                    status.setResult(Status.Result.KILLED);
                }
                ProcessManager.this.sendUpdate(status.updateTimestamp());
                this.done();
            });
        }

        @Override
        public void kill() {
            if (this.done() != null && this.connection != null) {
                this.killed = true;
                this.connection.disconnect();
            }
        }
    }

    public class MailJobProcess
    extends JobProcess {
        public MailJobProcess(MailJob job) {
            super((Job)job);
        }

        @Override
        protected void start() {
            MailJob job = (MailJob)this.job;
            Status status = new Status(this.getName(), Status.State.STOPPED);
            if (!job.isEchoJob()) {
                try {
                    MailUtils.send((String)job.getMessage(), (String)job.getSubject(), (String[])new String[]{job.getRecipient()});
                }
                catch (MailUtils.MailException e) {
                    Localise.logError((Logger)logger, (String)"Could not send mail for job %1$s - %2$s", (Object[])new Object[]{this.getName().toProto(), e.getMessage()});
                    status.setResult(Status.Result.EXCEPTION).setMessage(Localise.format((String)"Could not send mail - %s", (Object[])new Object[]{e.getMessage()}));
                }
            } else {
                status = this.echoEmail(job);
            }
            ProcessManager.this.sendUpdate(status.updateTimestamp());
            this.done();
        }

        private Status echoEmail(MailJob job) {
            EchoUtil echo = new EchoUtil((Job)job);
            Status status = new Status(job.getName(), Status.State.STOPPED);
            TableFormatter table = new TableFormatter();
            table.alignColumn(0, TableFormatter.Column.Align.RIGHT);
            table.addRow(new Object[]{Localise.format((String)"To:"), job.getRecipient()});
            table.addRow(new Object[]{Localise.format((String)"Subject:"), job.getSubject()});
            table.addRow(new Object[]{Localise.format((String)"Message:"), job.getMessage()});
            status.setOutput(new Output(table));
            if (!echo.run()) {
                status.setResult(Status.Result.ERROR).setMessage(echo.message);
            }
            return status;
        }

        @Override
        protected void kill() {
            ProcessManager.this.sendUpdate(new Status(this.getName(), Status.Result.KILLED));
        }
    }

    private abstract class JobProcess {
        private final Job job;
        private TimeZone timeZone = null;

        public JobProcess(Job job) {
            this.job = job;
            Property property = job.getProperty("TZ");
            if (property != null && !StringUtils.isNullOrEmpty((String)property.getValue())) {
                this.timeZone = TimeUtils.getTimeZone((String)property.getValue());
            }
            if (this.timeZone == null) {
                this.timeZone = job.getTimeZone();
            }
            ProcessManager.this.processes.put(this.getName(), this);
        }

        public JobProcess done() {
            return ProcessManager.this.processes.remove(this.getName());
        }

        public Job getJob() {
            return this.job;
        }

        public Name getName() {
            return this.job.getName();
        }

        public boolean isAction(Job.Action action) {
            return action == Job.Action.START || action == Job.Action.KILL;
        }

        public void execute(Job.Action action) {
            if (this.isAction(action)) {
                switch (action) {
                    case START: {
                        this.start();
                        break;
                    }
                    case STOP: {
                        this.stop();
                        break;
                    }
                    case KILL: {
                        this.kill();
                        break;
                    }
                    case PROBE: {
                        this.probe();
                        break;
                    }
                    default: {
                        Localise.logError((Logger)logger, (String)"unsupported action %s for job %s", (Object[])new Object[]{action, this.getName()});
                        break;
                    }
                }
            } else {
                Name name = this.getName();
                Localise.logError((Logger)logger, (String)"unsupported action %s for job %s", (Object[])new Object[]{action, name});
                ProcessManager.this.sendUpdate(new Status(name, Status.Result.ERROR).setMessage(Localise.format((String)"Unsupported action %s", (Object[])new Object[]{action})));
            }
        }

        protected abstract void start();

        protected void stop() {
        }

        protected abstract void kill();

        protected void probe() {
        }
    }
}

