/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.agent.service;

import com.beyondcron.agent.EchoUtil;
import com.beyondcron.agent.service.ProcessList;
import com.beyondcron.agent.service.Shell;
import com.beyondcron.core.Configs;
import com.beyondcron.core.Localise;
import com.beyondcron.core.LogUtils;
import com.beyondcron.core.Name;
import com.beyondcron.core.NetUtils;
import com.beyondcron.core.Program;
import com.beyondcron.core.Property;
import com.beyondcron.core.ServiceException;
import com.beyondcron.core.StringUtils;
import com.beyondcron.core.ThreadUtils;
import com.beyondcron.core.agent.AgentService;
import com.beyondcron.core.config.BooleanConfig;
import com.beyondcron.core.config.StringConfig;
import com.beyondcron.core.job.CommandJob;
import com.beyondcron.core.job.Job;
import com.beyondcron.core.job.Output;
import com.beyondcron.core.job.Status;
import com.beyondcron.messaging.message.JobExecute;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.core.LifecycleListener;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public class CommandService
extends AgentService
implements LifecycleListener {
    static Logger logger = LogUtils.getLogger(CommandService.class);
    public static final String SERVICE_NAME = "Command";
    @StringConfig.Annotation(defaultValue="/tmp/.beyondcron.%1$s.pid")
    public static final String FILE_PID = "beyondcron.agent.job.pid.file";
    @BooleanConfig.Annotation(defaultValue=true, description="Check that command jobs hosts are reachable, before trying to start a job on them.")
    public static final String CHECK_HOSTS_REACHABLE = "beyondcron.agent.check.hosts.reachable";
    @BooleanConfig.Annotation(defaultValue=false, description="ssh directly to the command job user, rather than ssh'ing as bc-daemon and then sudo'ing to the command job user.")
    public static final String SSH_DIRECT = "beyondcron.agent.ssh.direct";
    @StringConfig.Annotation(defaultValue="cat %s")
    public static final String COMMAND_CAT = "beyondcron.agent.command.cat";
    @StringConfig.Annotation(defaultValue="%s 2>&1 << '<< EOF >>'")
    public static final String COMMAND_JOB = "beyondcron.agent.command.job";
    @StringConfig.Annotation(defaultValue="%1$s %2$s 2>&1 << '<< EOF >>'")
    public static final String COMMAND_JOB_ECHO = "beyondcron.agent.command.job.echo";
    @StringConfig.Annotation(defaultValue="<< EOF >>")
    public static final String COMMAND_JOB_EOF = "beyondcron.agent.command.job.eof";
    @StringConfig.Annotation(defaultValue="kill -9 %s")
    public static final String COMMAND_KILL = "beyondcron.agent.command.kill";
    @StringConfig.Annotation(defaultValue="ps -p $$ -o pid= -o user= -o lstart= > %s")
    public static final String COMMAND_PID_SAVE = "beyondcron.agent.command.pid.save";
    @StringConfig.Annotation(defaultValue="ps -p %s -o pid= -o user= -o lstart=")
    public static final String COMMAND_PROCESS = "beyondcron.agent.command.process";
    @StringConfig.Annotation(defaultValue="rm %s")
    public static final String COMMAND_RM = "beyondcron.agent.command.rm";
    @StringConfig.Annotation(defaultValue="%1$s")
    public static final String COMMAND_SELF = "beyondcron.agent.command.self";
    @StringConfig.Annotation(defaultValue="env -i %1$s %2$s | tee -i %3$s")
    public static final String COMMAND_SELF_TEE = "beyondcron.agent.command.self.tee";
    @StringConfig.Annotation(defaultValue="sudo -n -u %1$s %2$s")
    public static final String COMMAND_SUDO = "beyondcron.agent.command.sudo";
    @StringConfig.Annotation(defaultValue="sudo -n -u %1$s %2$s %3$s | sudo -n -u %1$s tee -i %4$s")
    public static final String COMMAND_SUDO_TEE = "beyondcron.agent.command.sudo.tee";
    private boolean alwaysUseSsh = false;

    private static void initConfigs() {
        Configs.addConfigs(CommandService.class);
    }

    public CommandService() {
        this(null);
    }

    public CommandService(HazelcastInstance hazelcast) {
        super(SERVICE_NAME);
        if (hazelcast != null) {
            hazelcast.getLifecycleService().addLifecycleListener((LifecycleListener)this);
        }
    }

    protected void init() {
    }

    public CommandService setAlwaysUseSsh(boolean alwaysUseSsh) {
        this.alwaysUseSsh = alwaysUseSsh;
        return this;
    }

    public Job.Type getJobType() {
        return Job.Type.COMMAND;
    }

    public void close() {
    }

    public void execute(JobExecute command) throws ServiceException {
        new CommandProcess(command, false);
    }

    public void stateChanged(LifecycleEvent event) {
        Localise.logDebug((Logger)logger, (String)"connection - %1$s", (Object[])new Object[]{event.getState().toString()});
        if (event.getState() == LifecycleEvent.LifecycleState.CLIENT_CONNECTED) {
            CommandService.initConfigs();
        }
    }

    public static String getEchoCommand() {
        String command = (String)Configs.get((String)"beyondcron.echo.command");
        if (!command.contains(File.separator)) {
            String dir = (String)Configs.get((String)"BEYONDCRON_BIN_DIR");
            command = dir.endsWith(File.separator) ? String.format("%s%s", dir, command) : String.format("%s%s%s", dir, File.separator, command);
        }
        return command;
    }

    public static boolean isLocalHost(String hostName) throws UnknownHostException {
        return NetUtils.isEchoHost((String)hostName) || NetUtils.isLocalHost((String)hostName);
    }

    public static boolean isTargetUser(String userName) {
        return Program.getUserName().equals(userName);
    }

    static {
        CommandService.initConfigs();
    }

    public class CommandProcess
    implements Runnable {
        private final CommandJob job;
        private final Job.Action action;
        private Shell shell = null;
        private final Status status;
        private final boolean localHost;
        private final String userName;
        private boolean targetUser;
        private final File pidFile;

        public CommandProcess(JobExecute command, boolean jUnit) throws ServiceException {
            Job.Type type = command.getJob().getType();
            if (type != Job.Type.COMMAND) {
                throw new ServiceException(Localise.format((String)"Unsupported job type - %s", (Object[])new Object[]{type}));
            }
            this.job = (CommandJob)command.getJob();
            this.action = command.getAction();
            switch (this.action) {
                case START: {
                    try {
                        this.job.getCommand().validate();
                        break;
                    }
                    catch (IllegalArgumentException e) {
                        throw new ServiceException(e.getMessage(), (Throwable)e).setDescription(this.job.getCommand().getCommand());
                    }
                }
                case KILL: {
                    break;
                }
                default: {
                    throw new ServiceException(Localise.format((String)"Unsupported action - %s", (Object[])new Object[]{this.action}));
                }
            }
            try {
                this.localHost = !CommandService.this.alwaysUseSsh && CommandService.isLocalHost(this.job.getHostName());
            }
            catch (UnknownHostException e) {
                throw new ServiceException(Localise.format((String)"Unknown host - %s", (Object[])new Object[]{this.job.getHostName()}));
            }
            this.status = new Status(this.job.getName(), Status.State.STOPPED);
            this.userName = this.job.getUserName();
            this.targetUser = CommandService.isTargetUser(this.userName);
            this.pidFile = this.getPidFile(this.job.getName());
            if (!jUnit) {
                ThreadUtils.submit((Runnable)this);
            }
        }

        protected Shell getShell() {
            return this.shell;
        }

        protected Status getStatus() {
            return this.status;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block29: {
                try {
                    HashMap<String, String> debugEnvironment = new HashMap<String, String>();
                    if (logger.isDebugEnabled()) {
                        debugEnvironment.put("_bcJobName", this.job.getName().toString());
                    }
                    if (!this.localHost) {
                        String hostName = this.job.getHostName();
                        try {
                            InetAddress address = InetAddress.getByName(hostName);
                            if (((Boolean)Configs.get((String)CommandService.CHECK_HOSTS_REACHABLE)).booleanValue() && !NetUtils.isReachable((InetAddress)address)) {
                                CommandService.this.notifyListener(new Status(this.job.getName(), Status.Result.ERROR).setMessage(Localise.format((String)"Could not connect to %s - not reachable", (Object[])new Object[]{hostName})));
                                return;
                            }
                        }
                        catch (UnknownHostException e) {
                            CommandService.this.notifyListener(new Status(this.job.getName(), Status.Result.ERROR).setMessage(Localise.format((String)"Could not connect to %s - not reachable", (Object[])new Object[]{hostName})));
                            return;
                        }
                    }
                    if (this.localHost) {
                        this.shell = new Shell(null, null, debugEnvironment);
                    } else if (((Boolean)Configs.get((String)CommandService.SSH_DIRECT)).booleanValue()) {
                        this.shell = new Shell(this.job.getHostName(), this.userName, debugEnvironment);
                        this.targetUser = true;
                    } else {
                        this.shell = new Shell(this.job.getHostName(), null, debugEnvironment);
                    }
                    if (!this.shell.isConnected()) {
                        CommandService.this.notifyListener(new Status(this.job.getName(), Status.Result.ERROR).setMessage(Localise.format((String)"Could not connect to %1$s - %2$s", (Object[])new Object[]{this.job.getHostName(), this.shell.getErrorMessage()})));
                        return;
                    }
                }
                catch (Exception e) {
                    CommandService.this.notifyListener(new Status(this.job.getName(), e));
                    return;
                }
                {
                    Localise.logTrace((Logger)logger, (String)"%s: shell started", (Object[])new Object[]{this.job.getName()});
                    try {
                        switch (this.action) {
                            case START: {
                                try {
                                    this.start();
                                    break block29;
                                }
                                finally {
                                    if (this.shell != null && this.shell.isConnected()) {
                                        this.deletePidFile();
                                    }
                                }
                            }
                            case KILL: {
                                this.kill();
                            }
                        }
                    }
                    catch (Exception e) {
                        CommandService.this.notifyListener(new Status(this.job.getName(), e));
                    }
                    break block29;
                }
                finally {
                    if (this.shell != null) {
                        this.shell.close();
                    }
                }
            }
        }

        private void start() throws IOException, ServiceException {
            EchoUtil echo = new EchoUtil((Job)this.job);
            Name name = this.job.getName();
            if (this.getPid() > 1) {
                CommandService.this.notifyListener(new Status(name, Status.Result.ERROR).setMessage(Localise.format((String)"Already running")));
                return;
            }
            this.createPidFile();
            CommandService.this.notifyListener(new Status(name, Status.State.RUNNING));
            String command = this.job.getCommand().getCommand();
            command = !this.job.isEchoJob() ? String.format(this.getProperty(CommandService.COMMAND_JOB), command) : String.format(this.getProperty(CommandService.COMMAND_JOB_ECHO), CommandService.getEchoCommand(), command);
            ArrayList<String> environment = new ArrayList<String>();
            for (Property property : this.job.getProperties(Property.Type.ENVIRONMENT)) {
                environment.add(String.format("'%1$s'='%2$s'", property.getName(), property.getValue()));
            }
            URL output = this.job.getOutput();
            if (output == null || this.job.isEchoJob()) {
                output = this.job.getDefaultOutput();
            }
            command = this.targetUser ? String.format(this.getProperty(CommandService.COMMAND_SELF_TEE), StringUtils.join((String)" ", environment), command, output.getPath()) : String.format(this.getProperty(CommandService.COMMAND_SUDO_TEE), this.userName, StringUtils.join((String)" ", environment), command, output.getPath());
            List input = this.job.getCommand().getInput();
            if (this.job.isEchoJob()) {
                URL jobOutput = this.job.getOutput();
                input.add(0, jobOutput != null ? jobOutput.getPath() : "");
            }
            input.add(this.getProperty(CommandService.COMMAND_JOB_EOF));
            int exitValue = this.shell.executeCommand(command, input, true, new int[0]);
            if (this.job.isEchoJob()) {
                echo.run();
            }
            this.status.updateTimestamp();
            this.status.setOutput(this.shell.getOutput());
            if (exitValue != 0) {
                this.status.setExitValue(exitValue);
                if (this.status.hasOutput()) {
                    this.status.setMessage(this.status.getOutput().getLastLine());
                }
                if (exitValue > 128) {
                    this.status.setResult(Status.Result.KILLED);
                }
            } else if (!echo.wasSuccess) {
                this.status.setExitValue(1);
                this.status.setMessage(echo.message);
            }
            CommandService.this.notifyListener(this.status);
        }

        private void kill() throws IOException, ServiceException {
            String command;
            Name name = this.job.getName();
            int pid = this.getPid();
            if (pid < 1) {
                CommandService.this.notifyListener(new Status(name, Status.Result.ERROR).setMessage(Localise.format((String)"%s not running", (Object[])new Object[]{name})));
                return;
            }
            ProcessList processes = new ProcessList(this.shell.getOS());
            this.shell.executeCommand(new Output.Builder(Integer.MAX_VALUE, Integer.MAX_VALUE), processes.getProcessListCommand(), null, false, 0);
            if (this.shell.getExitValue() != 0) {
                CommandService.this.notifyListener(new Status(name, Status.Result.ERROR).setMessage(Localise.format((String)"Could not get process list - %s", (Object[])new Object[]{this.shell.getErrorMessage()})));
                return;
            }
            processes.addProcessList(this.shell.getOutput());
            if (processes.isEmpty()) {
                CommandService.this.notifyListener(new Status(name, Status.Result.ERROR).setMessage(Localise.format((String)"Could not get process list")));
                return;
            }
            String jobCommand = this.job.getCommand().getCommand();
            int targetPid = -1;
            Set<Integer> descendents = this.getChildPids(processes, pid);
            for (int p : descendents) {
                if (!processes.getProcess(p).getCommand().endsWith(jobCommand)) continue;
                targetPid = p;
                break;
            }
            HashSet<Integer> children = new HashSet<Integer>();
            if (targetPid > 0) {
                children.addAll(processes.getProcess(targetPid).getChildPids());
            } else {
                children.addAll(descendents);
            }
            if (!children.isEmpty()) {
                String command2 = String.format(this.getProperty(CommandService.COMMAND_KILL), StringUtils.join((String)" ", children));
                command2 = this.targetUser ? String.format(this.getProperty(CommandService.COMMAND_SELF), command2) : String.format(this.getProperty(CommandService.COMMAND_SUDO), this.userName, command2);
                this.shell.executeCommand(command2, null, true, 0, 1);
                if (!this.shell.wasSuccess()) {
                    Localise.logWarn((Logger)logger, (String)"Could not kill process %1$s children - (%2$d) %3$s", (Object[])new Object[]{targetPid, this.shell.getExitValue(), this.shell.getErrorMessage()});
                }
            }
            boolean self = this.targetUser;
            if (targetPid > 0) {
                command = String.format(this.getProperty(CommandService.COMMAND_KILL), targetPid);
            } else {
                command = String.format(this.getProperty(CommandService.COMMAND_KILL), pid);
                self = true;
            }
            command = self ? String.format(this.getProperty(CommandService.COMMAND_SELF), command) : String.format(this.getProperty(CommandService.COMMAND_SUDO), this.userName, command);
            this.shell.executeCommand(command, null, true, 0, 1);
            if (!this.shell.wasSuccess()) {
                String message = Localise.format((String)"Could not kill process %1$s - (%2$d) %3$s", (Object[])new Object[]{targetPid, this.shell.getExitValue(), this.shell.getErrorMessage()});
                logger.warn(message);
                CommandService.this.notifyListener(new Status(name, Status.State.RUNNING, Status.Result.ERROR).setMessage(message));
            }
        }

        private String getProperty(String name) {
            return this.shell != null ? (String)Configs.get((String)name, (Program.OS)this.shell.getOS()) : (String)Configs.get((String)name);
        }

        private Set<Integer> getChildPids(ProcessList processes, int pid) {
            HashSet<Integer> children = new HashSet<Integer>();
            ProcessList.Process process = processes.getProcess(pid);
            if (process != null) {
                for (int childPid : process.getChildPids()) {
                    ProcessList.Process child = processes.getProcess(childPid);
                    if (child.getUser().equals(this.userName)) {
                        children.add(childPid);
                        continue;
                    }
                    children.addAll(this.getChildPids(processes, childPid));
                }
            }
            return children;
        }

        private void createPidFile() throws IOException, ServiceException {
            String command = String.format(this.getProperty(CommandService.COMMAND_PID_SAVE), this.pidFile.toString());
            if (this.shell.executeCommand(command) != 0) {
                throw new ServiceException(Localise.format((String)"Could not execute (%1$s) - %2$s", (Object[])new Object[]{command, this.shell.getErrorMessage()}));
            }
        }

        private void deletePidFile() {
            block3: {
                try {
                    String command = String.format(this.getProperty(CommandService.COMMAND_RM), this.pidFile.toString());
                    if (this.shell.executeCommand(command) == 0) break block3;
                    if (this.shell.getErrorMessage().contains("No such file or directory")) {
                        Localise.logDebug((Logger)logger, (String)"Could not delete %1$s - %2$s", (Object[])new Object[]{this.pidFile.toString(), this.shell.getErrorMessage()});
                        break block3;
                    }
                    throw new ServiceException(this.shell.getErrorMessage());
                }
                catch (Exception e) {
                    Localise.logWarn((Logger)logger, (String)"Could not delete %1$s - %2$s", (Object[])new Object[]{this.pidFile.toString(), e.getMessage()});
                }
            }
        }

        private File getPidFile(Name name) {
            return new File(String.format(this.getProperty(CommandService.FILE_PID), name.getPath().substring(1).replaceAll("[/@:]", "_")));
        }

        private int getPid() throws IOException, ServiceException {
            String processDetails;
            if (this.shell.executeCommand(String.format(this.getProperty(CommandService.COMMAND_CAT), this.pidFile.toString())) != 0) {
                return -1;
            }
            String s = this.shell.getOutput().getFirstLine();
            String string = processDetails = s != null ? s.trim() : null;
            if (StringUtils.isNullOrEmpty((String)processDetails)) {
                this.deletePidFile();
                throw new ServiceException(Localise.format((String)"pid file %s is empty", (Object[])new Object[]{this.pidFile}));
            }
            int pid = -1;
            try {
                pid = Integer.parseInt(StringUtils.split((String)processDetails)[0]);
            }
            catch (NumberFormatException e) {
                this.deletePidFile();
                throw new ServiceException(Localise.format((String)"Invalid process id (%1$s) in %2$s", (Object[])new Object[]{pid, processDetails}));
            }
            String command = String.format(this.getProperty(CommandService.COMMAND_PROCESS), pid);
            if (this.shell.executeCommand(command) != 0) {
                String error = this.shell.getErrorMessage();
                if (!StringUtils.isNullOrEmpty((String)error)) {
                    throw new ServiceException(Localise.format((String)"Could not execute (%1$s) - %2$s", (Object[])new Object[]{command, this.shell.getErrorMessage()}));
                }
                this.deletePidFile();
                return -1;
            }
            return processDetails.equals(this.shell.getOutput().getLastLine().trim()) ? pid : -1;
        }
    }
}

