/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.agent.service;

import com.beyondcron.agent.EchoUtil;
import com.beyondcron.agent.ProcessManager;
import com.beyondcron.core.Configs;
import com.beyondcron.core.Localise;
import com.beyondcron.core.LogUtils;
import com.beyondcron.core.Name;
import com.beyondcron.core.Property;
import com.beyondcron.core.ServiceException;
import com.beyondcron.core.StringUtils;
import com.beyondcron.core.TableFormatter;
import com.beyondcron.core.ThreadUtils;
import com.beyondcron.core.agent.AgentService;
import com.beyondcron.core.job.Job;
import com.beyondcron.core.job.Output;
import com.beyondcron.core.job.SQLJob;
import com.beyondcron.core.job.Status;
import com.beyondcron.messaging.message.JobExecute;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Logger;

public class SQLService
extends AgentService {
    static Logger logger = LogUtils.getLogger(SQLService.class);
    public static final String SERVICE_NAME = "SQL";
    public static final String CSV_SUFFIX = ".csv";
    public static final int OUTPUT_LINES = (Integer)Configs.get((String)"beyondcron.output.lines.head");
    private final Map<Name, SQLProcess> processes = new HashMap<Name, SQLProcess>();

    public SQLService() {
        super(SERVICE_NAME);
    }

    protected void init() {
    }

    public Job.Type getJobType() {
        return Job.Type.SQL;
    }

    public void close() {
    }

    public void execute(JobExecute command) throws ServiceException {
        new SQLProcess(command, false);
    }

    private static class DummyFuture
    implements Future {
        private DummyFuture() {
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return false;
        }

        public Object get() {
            return null;
        }

        public Object get(long timeout, TimeUnit unit) {
            return null;
        }
    }

    public class SQLProcess
    implements Runnable {
        private final SQLJob job;
        private final Job.Action action;
        private final Future task;
        private Connection connection;
        private boolean killed = false;
        private PrintStream out = null;
        private Output.Builder output = null;
        private boolean outputCSV = false;

        public SQLProcess(JobExecute command, boolean jUnit) throws ServiceException {
            Job.Type type = command.getJob().getType();
            if (type != Job.Type.SQL) {
                throw new ServiceException(Localise.format((String)"unsupported job type - %s", (Object[])new Object[]{type}));
            }
            this.job = (SQLJob)command.getJob();
            this.action = command.getAction();
            if (this.action != Job.Action.START && this.action != Job.Action.KILL) {
                throw new ServiceException(Localise.format((String)"unsupported action - %s", (Object[])new Object[]{command.getAction()}));
            }
            this.task = !jUnit ? ThreadUtils.submit((Runnable)this) : new DummyFuture();
        }

        @Override
        public void run() {
            try {
                switch (this.action) {
                    case START: {
                        if (!this.job.isEchoJob()) {
                            this.start();
                            break;
                        }
                        this.echo();
                        break;
                    }
                    case KILL: {
                        this.kill();
                    }
                }
            }
            catch (SQLException e) {
                SQLService.this.notifyListener(new Status(this.job.getName(), (Exception)e).setResult(Status.Result.ERROR));
            }
            catch (Exception e) {
                SQLService.this.notifyListener(new Status(this.job.getName(), e));
            }
        }

        private void start() throws SQLException {
            Name name = this.job.getName();
            SQLService.this.processes.put(name, this);
            File file = ProcessManager.getOutputFile((Job)this.job);
            if (file != null) {
                try {
                    this.out = new PrintStream(file);
                }
                catch (FileNotFoundException e) {
                    Localise.logError((Logger)logger, (String)"Cannot not open output file %1$s for job %2$s - %3$s", (Object[])new Object[]{file.toString(), name.toString(), e.getMessage()});
                }
                this.outputCSV = file.getName().endsWith(SQLService.CSV_SUFFIX);
            }
            this.output = new Output.Builder(OUTPUT_LINES, 0);
            Properties properties = new Properties();
            for (Property property : this.job.getProperties(Property.Type.PARAMETER)) {
                properties.put(property.getName(), property.getValue());
            }
            this.connection = DriverManager.getConnection(this.job.getURL().toString(), properties);
            SQLService.this.notifyListener(new Status(name, Status.State.RUNNING));
            Statement statement = this.connection.createStatement();
            statement.execute(StringUtils.join((String)"\n", (Collection)this.job.getSQL()));
            this.readOutput(statement);
            this.connection.close();
        }

        private void kill() {
            Name name = this.job.getName();
            SQLProcess process = SQLService.this.processes.remove(name);
            if (process == null) {
                SQLService.this.notifyListener(new Status(name, Status.Result.ERROR).setMessage(Localise.format((String)"Not running", (Object[])new Object[]{name})));
                return;
            }
            this.killed = true;
            process.task.cancel(true);
        }

        private void echo() {
            EchoUtil echo = new EchoUtil((Job)this.job);
            Status status = new Status(this.job.getName(), Status.State.STOPPED);
            this.output = new Output.Builder();
            String s = Localise.format((String)SQLService.SERVICE_NAME);
            this.output.addLines(new String[]{s, StringUtils.fill((char)'-', (int)s.length())});
            for (String line : this.job.getSQL()) {
                this.output.addLine("  " + line);
            }
            s = Localise.format((String)"URL");
            this.output.addLines(new String[]{"", s, StringUtils.fill((char)'-', (int)s.length()), "  " + this.job.getURL().toString()});
            s = Localise.format((String)"Properties");
            this.output.addLines(new String[]{"", s, StringUtils.fill((char)'-', (int)s.length())});
            for (Property property : this.job.getProperties(Property.Type.PARAMETER)) {
                this.output.addLines(new String[]{"  " + property.getName() + " = " + property.getValue()});
            }
            s = Localise.format((String)"Output");
            this.output.addLines(new String[]{"", s, StringUtils.fill((char)'-', (int)s.length()), this.job.getOutput().toString()});
            status.setOutput(this.output.build());
            if (!echo.run()) {
                status.setExitValue(1).setMessage(echo.message);
            }
            SQLService.this.notifyListener(status);
        }

        private void readOutput(Statement statement) throws SQLException {
            while (true) {
                ResultSet result;
                if ((result = statement.getResultSet()) != null) {
                    if (this.outputCSV) {
                        this.outputCSV(result);
                    } else {
                        this.outputText(result);
                    }
                } else {
                    int updates = statement.getUpdateCount();
                    if (updates < 0) break;
                    String s = String.format("(%d updates)", updates);
                    if (!this.outputCSV) {
                        this.output(s, true);
                    } else {
                        this.output.appendTail(s);
                    }
                }
                if (this.task.isCancelled()) {
                    this.killed = true;
                    break;
                }
                statement.getMoreResults();
            }
            Status status = new Status(this.job.getName()).setOutput(this.output.build());
            if (!this.killed) {
                status.setResult(Status.Result.SUCCESS).setExitValue(0);
            } else {
                status.setResult(Status.Result.KILLED);
            }
            SQLService.this.notifyListener(status);
        }

        private void outputText(ResultSet result) throws SQLException {
            TableFormatter table = new TableFormatter();
            table.setHeaderSeparator('-');
            table.setHeaderColumnSeparator("-+-");
            table.setColumnSeparator(" | ");
            ResultSetMetaData metaData = result.getMetaData();
            int columns = metaData.getColumnCount();
            int rows = 0;
            int i = 0;
            while (i++ < columns) {
                String name = metaData.getColumnName(i);
                int type = metaData.getColumnType(i);
                table.addColumn(name);
                if (type != -5 && type != -7 && type != 3 && type != 8 && type != 6 && type != 4 && type != 7 && type != 5 && type != 93 && type != 2014 && type != -6) continue;
                table.alignColumn(name, TableFormatter.Column.Align.RIGHT);
            }
            int maxLines = this.output.getHeadLinesMax();
            while (result.next()) {
                int i2 = 0;
                while (i2++ < columns) {
                    table.addValue((Object)result.getString(i2));
                }
                table.endRow();
                ++rows;
                if (this.task.isCancelled()) {
                    this.killed = true;
                    break;
                }
                if (table.getLineCount() < maxLines) continue;
            }
            for (String line : table.toString().split("\\n")) {
                this.output(line, false);
            }
            if (result.next() && !this.killed) {
                Object[] row = new String[columns];
                do {
                    int i3 = 0;
                    while (i3 < columns) {
                        row[i3++] = result.getString(i3);
                    }
                    this.output(table.toString(row), false);
                    ++rows;
                    if (!this.task.isCancelled()) continue;
                    this.killed = true;
                    break;
                } while (result.next());
            }
            this.output(String.format(this.killed ? "(>%d rows)" : "(%d rows)", rows), true);
        }

        private void outputCSV(ResultSet result) throws SQLException {
            ResultSetMetaData metaData = result.getMetaData();
            int columns = metaData.getColumnCount();
            int rows = 0;
            String[] row = new String[columns];
            int i = 0;
            while (i < columns) {
                row[i++] = StringUtils.csvQuote((String)metaData.getColumnName(i));
            }
            this.output(StringUtils.join((String)",", (String[])row), false);
            while (result.next()) {
                i = 0;
                while (i < columns) {
                    row[i++] = StringUtils.csvQuote((String)result.getString(i));
                }
                this.output(StringUtils.join((String)",", (String[])row), false);
                ++rows;
                if (!this.task.isCancelled()) continue;
                this.killed = true;
                break;
            }
            String s = String.format(this.killed ? "(>%d rows)" : "(%d rows)", rows);
            if (!this.output.isHeadFull()) {
                this.output.addLine(s);
            } else {
                this.output.appendTail(s);
            }
        }

        private void output(String line, boolean forceAppend) {
            if (!this.output.isHeadFull()) {
                this.output.addLine(line);
            } else if (forceAppend) {
                this.output.appendTail(line);
            }
            if (this.out != null) {
                this.out.println(line);
            }
        }
    }
}

