/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.cli;

import com.beyondcron.messaging.Hazelcast;
import com.beyondcron.messaging.message.Announcement;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.Message;
import com.hazelcast.core.MessageListener;
import java.io.PrintStream;

public class AnnouncementListener
implements MessageListener<Announcement> {
    private HazelcastInstance hazelcast;
    private ITopic<Announcement> announcements = null;
    private String announcementsListener;
    private PrintStream out;

    public AnnouncementListener(HazelcastInstance hazelcast) {
        this.hazelcast = hazelcast;
        this.out = System.out;
        this.start();
    }

    public void start() {
        if (this.announcements == null) {
            this.announcements = Hazelcast.getAnnouncementTopic((HazelcastInstance)this.hazelcast);
            this.announcementsListener = this.announcements.addMessageListener((MessageListener)this);
        }
    }

    public void stop() {
        if (this.announcements != null) {
            this.announcements.removeMessageListener(this.announcementsListener);
            this.announcements = null;
        }
    }

    public void onMessage(Message<Announcement> message) {
        Announcement announcement = (Announcement)message.getMessageObject();
        this.out.println();
        this.out.println();
        this.out.println(String.format("%s: %s", announcement.getLevel(), announcement.getMessage()));
        this.out.println();
        this.out.println();
    }
}

