/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.cli;

import com.beyondcron.cli.AnnouncementListener;
import com.beyondcron.cli.CommandExecutor;
import com.beyondcron.cli.antlr.CommandsBaseListener;
import com.beyondcron.core.Configs;
import com.beyondcron.core.IOUtils;
import com.beyondcron.core.InetSocketAddress;
import com.beyondcron.core.Localise;
import com.beyondcron.core.LogUtils;
import com.beyondcron.core.NetUtils;
import com.beyondcron.core.Period;
import com.beyondcron.core.Program;
import com.beyondcron.core.StringUtils;
import com.beyondcron.core.TableFormatter;
import com.beyondcron.core.TimeUtils;
import com.beyondcron.core.user.LocalUser;
import com.beyondcron.messaging.CommandConnection;
import com.beyondcron.messaging.Connection;
import com.beyondcron.messaging.Hazelcast;
import com.beyondcron.messaging.message.CommandMessage;
import com.beyondcron.messaging.message.LicenseQuery;
import com.beyondcron.messaging.message.ResultMessage;
import java.io.Console;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.Option;

public class App
extends CommandsBaseListener {
    static final Logger logger = LogUtils.getLogger(App.class);
    static String commandPrompt;
    static String everyoneRoleName;
    @Option(name="--admin", aliases={"-a"}, usage="Login as the admin user.")
    private boolean argAdmin;
    @Option(name="--cluster", aliases={"-c"}, usage="Name of cluster to connect to. Default = beyondcron.")
    private String argCluster = null;
    @Option(name="--debug", aliases={"-d"}, usage="Enable debug mode")
    private boolean argDebug;
    @Option(name="--user", aliases={"-u"}, usage="Name of user to login as.")
    private String argUser;
    @Option(name="--help", aliases={"-?"}, usage="Print this message.")
    private boolean argHelp;
    @Option(name="--version", aliases={"-v"}, usage="Print program version.")
    private boolean argVersion;
    @Argument(metaVar="[<server>][:<port>] ...", usage="Server/s name and/or port number")
    private List<InetSocketAddress> servers;
    private boolean argCommand = false;
    private String command = "";
    private int exitCode = 0;
    private CommandConnection connection;
    private boolean consolePassword = true;
    CommandExecutor commandExecutor;
    AnnouncementListener announcementListener;

    public static void main(String[] args) {
        Localise.addBundle((String)"bc-cli");
        NetUtils.setDefaultHostName((String)Hazelcast.DEFAULT_HOST);
        NetUtils.setDefaultPort((int)Hazelcast.DEFAULT_PORT);
        App app = null;
        try {
            app = new App(args);
            int exitCode = 0;
            if (app.argCommand) {
                int i = 0;
                for (String command : app.command.split("\\s*;\\s*")) {
                    if (StringUtils.isNullOrEmpty((String)command)) continue;
                    if (i++ > 0) {
                        System.out.println();
                    }
                    if ((exitCode = app.commandExecutor.executeCommand(command)) == 0) {
                        continue;
                    }
                    break;
                }
            } else {
                exitCode = app.run();
            }
            Program.exit((int)exitCode, (exitCode != 0 ? 1 : 0) != 0, (boolean)false);
        }
        catch (Exception e) {
            Localise.logFatal((Logger)logger, (Exception)e, (String)"Unexpected exception", (Object[])new Object[0]);
            Localise.logFatal((Logger)logger, (String)"  OS: %s %s %s", (Object[])new Object[]{Program.getOsName(), Program.getOsArch(), Program.getOsVersion()});
            Localise.logFatal((Logger)logger, (String)"Java: %s %s", (Object[])new Object[]{Program.getJavaVersion(), Program.getJavaVendor()});
            if (app != null) {
                app.close();
            }
            Program.exit((int)1);
        }
    }

    public App(String[] args) {
        String arg;
        int i;
        Program program = new Program((Object)this);
        for (i = 0; i < args.length && (arg = args[i]).startsWith("-"); ++i) {
            if (arg.equals("--admin") || arg.equals("-a")) {
                this.argAdmin = true;
                continue;
            }
            if (arg.equals("--user") || arg.equals("-u")) {
                if (++i >= args.length) continue;
                this.argUser = args[i];
                continue;
            }
            if (!arg.equals("--command") && !arg.equals("-c")) continue;
            this.argCommand = true;
            break;
        }
        if (this.argCommand) {
            this.command = StringUtils.join((String)" ", (int)(++i), (int)args.length, (String[])args);
        } else {
            try {
                program.parseArgs(args);
            }
            catch (CmdLineException e) {
                System.err.println(Program.getName() + ": " + e.getMessage());
                program.printUsage((OutputStream)System.err);
                System.exit(1);
            }
            if (!StringUtils.isNullOrEmpty((String)this.argUser) && this.argAdmin) {
                Program.println((OutputStream)System.err, (String)Localise.format((String)"--admin and --user are mutually exclusive"));
                program.printUsage((OutputStream)System.err);
                System.exit(1);
            }
        }
        if (this.argVersion) {
            Program.printVersion();
            System.exit(0);
        } else if (this.argHelp) {
            program.printUsage((OutputStream)System.out, true);
            System.exit(0);
        }
        this.init();
    }

    private synchronized void close() {
        if (this.connection == null || this.connection.isClosing()) {
            return;
        }
        this.connection.setConnectionListener(null);
        this.connection.close();
        this.connection = null;
    }

    private void init() {
        TimeUtils.initDefaultTimeZone();
        if (!this.argCommand) {
            System.out.println(Program.getName() + " " + Program.getVersion());
            if (Configs.hasService()) {
                Localise.println((String)"Configuration service: %1$s", (Object[])new Object[]{Configs.getService().getServiceDescription()});
            }
            System.out.println();
        }
        if (this.argAdmin) {
            this.argUser = (String)Configs.get((String)"beyondcron.admin.user.name");
        }
        if (StringUtils.isNullOrEmpty((String)this.argUser)) {
            this.argUser = (String)Configs.get((String)"BEYONDCRON_USER_NAME");
            if (StringUtils.isNullOrEmpty((String)this.argUser)) {
                this.argUser = System.getProperty("user.name");
            }
        }
        commandPrompt = (String)Configs.get((String)"beyondcron.command.prompt");
        everyoneRoleName = (String)Configs.get((String)"beyondcron.everyone.role.name");
        this.initShutdownHandlers();
        this.initConnection();
        if (!this.argCommand && (Integer)Configs.get((String)"beyondcron.license.expiry.warning") > 0) {
            ResultMessage result = this.connection.sendReceive((CommandMessage)new LicenseQuery(LicenseQuery.Type.SERVER));
            if (result.getResult().wasSuccess()) {
                String expiryMessage = ((LicenseQuery.Response)result).getLicense().getExpiryMessage();
                if (!StringUtils.isNullOrEmpty((String)expiryMessage)) {
                    System.out.println(expiryMessage);
                    System.out.println();
                }
            } else {
                Localise.println((String)"Could not get server license: %1$s", (Object[])new Object[]{result.getResult().getMessage()});
                System.out.println();
            }
        }
        this.commandExecutor = new CommandExecutor(this.connection, null);
        if (this.argCommand) {
            this.commandExecutor.setRawOutput(true);
        }
    }

    private void initConnection() {
        if (!StringUtils.isNullOrEmpty((String)this.argCluster)) {
            Configs.set((String)"BEYONDCRON_CLUSTER_NAME", (Object)this.argCluster);
        }
        try {
            this.connection = new CommandConnection(this.argUser, this.getPassword(), Connection.Type.COMMAND, this.servers);
        }
        catch (Exception e) {
            Localise.logFatal((Logger)logger, (String)"Could not connect to BeyondCron server/s - %s", (Object[])new Object[]{e.getMessage()});
            Program.exit((int)1);
        }
        this.connection.setConnectionListener((Connection.ConnectionListener)new ConnectionListener());
        this.announcementListener = new AnnouncementListener(this.connection.getHazelcast());
    }

    private int run() {
        while (true) {
            String command;
            if ((command = IOUtils.readLine((String)commandPrompt)) != null) {
                if (command.equals("exit") || command.equals("quit")) {
                    break;
                }
            } else {
                System.out.println();
                continue;
            }
            if ((command = this.commandExecutor.getCommand(command)) == null) continue;
            if (this.connection.isLocked() || !this.connection.isAuthenticated()) {
                long delay = ((Period)Configs.get((String)"beyondcron.connection.unlock.delay")).getMilliseconds();
                int attempts = (Integer)Configs.get((String)"beyondcron.connection.unlock.attempts");
                long multiplier = ((Integer)Configs.get((String)"beyondcron.connection.unlock.multiplier")).longValue();
                if (attempts == 0) {
                    System.out.println();
                    Localise.println((String)"Quiting due to inactivity", (Object[])new Object[0]);
                    break;
                }
                if (this.connection.isLocked()) {
                    Localise.println((String)"Connection locked due to inactivity", (Object[])new Object[0]);
                } else if (this.consolePassword) {
                    Localise.println((String)"Re-authenticate connection", (Object[])new Object[0]);
                }
                while (!this.connection.authenticate(this.getPassword())) {
                    if (--attempts == 0) {
                        Localise.println((String)"Too many password failures", (Object[])new Object[0]);
                        Program.exit((int)0);
                    }
                    try {
                        Thread.sleep(delay);
                    }
                    catch (InterruptedException e) {
                        Localise.logWarn((Logger)logger, (Exception)e, (String)"unlock delay interrupted", (Object[])new Object[0]);
                    }
                    delay *= multiplier;
                }
            }
            this.commandExecutor.executeCommand(command);
        }
        this.close();
        return this.exitCode;
    }

    private String getPassword() {
        String password = null;
        this.consolePassword = false;
        if (this.argAdmin && StringUtils.isNullOrEmpty((String)(password = LocalUser.getPassword((String)this.argUser)))) {
            Program.println((OutputStream)System.err, (String)Localise.format((String)"admin user password not found"));
            Program.exit((int)1, (boolean)true, (!this.argCommand ? 1 : 0) != 0);
        }
        if (StringUtils.isNullOrEmpty(password)) {
            try {
                password = Configs.getPassword((String)"BEYONDCRON_USER_PASSWORD");
            }
            catch (IOException e) {
                Program.println((OutputStream)System.err, (String)e.getMessage());
                Program.exit((int)1, (boolean)true, (!this.argCommand ? 1 : 0) != 0);
            }
        }
        if (StringUtils.isNullOrEmpty((String)password)) {
            Console console = System.console();
            if (console == null && !this.argDebug) {
                Program.println((OutputStream)System.err, (String)Localise.format((String)"no console available to read password"));
                Program.exit((int)1, (boolean)true, (!this.argCommand ? 1 : 0) != 0);
            }
            this.consolePassword = true;
            String prompt = Localise.format((String)"%s's password: ", (Object[])new Object[]{this.argUser});
            int nullAttempts = (Integer)Configs.get((String)"BEYONDCRON_NULL_PASSWORD_ATTEMPTS");
            while (StringUtils.isNullOrEmpty((String)password)) {
                if (nullAttempts-- > 0) {
                    if (console != null) {
                        char[] ca = console.readPassword(prompt, new Object[0]);
                        if (ca == null) continue;
                        password = new String(ca);
                        continue;
                    }
                    password = StringUtils.readLine((String)prompt);
                    continue;
                }
                Program.println((OutputStream)System.err, (String)Localise.format((String)"too many null passwords"));
                Program.exit((int)1, (boolean)true, (!this.argCommand ? 1 : 0) != 0);
            }
        }
        return password;
    }

    private void initShutdownHandlers() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            Localise.logDebug((Logger)logger, (String)"Shutdown hook called", (Object[])new Object[0]);
            this.close();
        }));
    }

    static {
        TableFormatter.setDefaultColumnSeparator((String)"  ");
        TableFormatter.setDefaultHeaderSeparator((char)'-');
        TableFormatter.setDefaultIndent((String)"  ");
    }

    private class ConnectionListener
    implements Connection.ConnectionListener {
        public ConnectionListener() {
            if (!App.this.consolePassword) {
                App.this.connection.setInactiveLockPeriod(0L);
            }
        }

        public void connected(String reason) {
            this.printReason(reason, false);
        }

        public void disconnected(String reason) {
            this.printReason(reason, true);
        }

        public void closed(String reason) {
            this.printReason(reason, true);
            Program.exit((int)1);
        }

        public void locked(String reason) {
            this.printReason(reason, true);
        }

        private void printReason(String reason, boolean leadingLine) {
            if (!StringUtils.isNullOrEmpty((String)reason)) {
                if (leadingLine) {
                    System.out.println();
                }
                System.out.println(reason);
            }
        }
    }
}

