/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.cli;

import com.beyondcron.cli.CommandListener;
import com.beyondcron.cli.CommandOutput;
import com.beyondcron.cli.antlr.CommandsBaseListener;
import com.beyondcron.cli.antlr.CommandsLexer;
import com.beyondcron.cli.antlr.CommandsParser;
import com.beyondcron.cli.command.ImportCommand;
import com.beyondcron.cli.command.LicenseLoadCommand;
import com.beyondcron.core.BlissUtils;
import com.beyondcron.core.BooleanUtils;
import com.beyondcron.core.City;
import com.beyondcron.core.Configs;
import com.beyondcron.core.Credit;
import com.beyondcron.core.Day;
import com.beyondcron.core.FileUtils;
import com.beyondcron.core.Filter;
import com.beyondcron.core.IOUtils;
import com.beyondcron.core.JSONUtils;
import com.beyondcron.core.License;
import com.beyondcron.core.Limit;
import com.beyondcron.core.Localise;
import com.beyondcron.core.LogUtils;
import com.beyondcron.core.MailUtils;
import com.beyondcron.core.Name;
import com.beyondcron.core.NameUtils;
import com.beyondcron.core.NetUtils;
import com.beyondcron.core.NumberUtils;
import com.beyondcron.core.Period;
import com.beyondcron.core.Program;
import com.beyondcron.core.Property;
import com.beyondcron.core.PropertyDefaults;
import com.beyondcron.core.PropertyList;
import com.beyondcron.core.Result;
import com.beyondcron.core.Role;
import com.beyondcron.core.Service;
import com.beyondcron.core.StringUtils;
import com.beyondcron.core.TableFormatter;
import com.beyondcron.core.Time;
import com.beyondcron.core.TimeUtils;
import com.beyondcron.core.Updates;
import com.beyondcron.core.Usage;
import com.beyondcron.core.UsageFormatter;
import com.beyondcron.core.Usages;
import com.beyondcron.core.Version;
import com.beyondcron.core.Versions;
import com.beyondcron.core.config.Config;
import com.beyondcron.core.io.AbstractIO;
import com.beyondcron.core.io.ExportIO;
import com.beyondcron.core.io.ImportIO;
import com.beyondcron.core.job.Command;
import com.beyondcron.core.job.CommandJob;
import com.beyondcron.core.job.Condition;
import com.beyondcron.core.job.ConsolidatedStatus;
import com.beyondcron.core.job.ContainerJob;
import com.beyondcron.core.job.CustomJob;
import com.beyondcron.core.job.Job;
import com.beyondcron.core.job.JobConfirmValidator;
import com.beyondcron.core.job.MailJob;
import com.beyondcron.core.job.SQLJob;
import com.beyondcron.core.job.Status;
import com.beyondcron.core.job.StatusConsolidator;
import com.beyondcron.core.job.Trigger;
import com.beyondcron.core.job.TriggerJob;
import com.beyondcron.core.job.URLJob;
import com.beyondcron.core.property.Schema;
import com.beyondcron.core.schedule.CalendarSchedule;
import com.beyondcron.core.schedule.CronSchedule;
import com.beyondcron.core.schedule.DailySchedule;
import com.beyondcron.core.schedule.DateSchedule;
import com.beyondcron.core.schedule.MonthlySchedule;
import com.beyondcron.core.schedule.RepeatSchedule;
import com.beyondcron.core.schedule.Schedule;
import com.beyondcron.core.schedule.SolarSchedule;
import com.beyondcron.core.schedule.cron.Import;
import com.beyondcron.core.security.ACL;
import com.beyondcron.core.security.HostACL;
import com.beyondcron.core.security.HostACLValidator;
import com.beyondcron.core.security.Protected;
import com.beyondcron.core.user.User;
import com.beyondcron.messaging.CommandConnection;
import com.beyondcron.messaging.Hazelcast;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.message.ACLCommand;
import com.beyondcron.messaging.message.ACLQuery;
import com.beyondcron.messaging.message.AgentQuery;
import com.beyondcron.messaging.message.Announcement;
import com.beyondcron.messaging.message.AnnouncementCommand;
import com.beyondcron.messaging.message.CalendarCommand;
import com.beyondcron.messaging.message.CalendarJobsQuery;
import com.beyondcron.messaging.message.CalendarQuery;
import com.beyondcron.messaging.message.Change;
import com.beyondcron.messaging.message.ChangeQuery;
import com.beyondcron.messaging.message.ClusterQuery;
import com.beyondcron.messaging.message.CommandMessage;
import com.beyondcron.messaging.message.ConfigCommand;
import com.beyondcron.messaging.message.ConfigQuery;
import com.beyondcron.messaging.message.Connection;
import com.beyondcron.messaging.message.ConnectionQuery;
import com.beyondcron.messaging.message.DateQuery;
import com.beyondcron.messaging.message.Group;
import com.beyondcron.messaging.message.GroupQuery;
import com.beyondcron.messaging.message.HostACLCommand;
import com.beyondcron.messaging.message.HostACLList;
import com.beyondcron.messaging.message.HostACLQuery;
import com.beyondcron.messaging.message.ICalendarCommand;
import com.beyondcron.messaging.message.ICalendarQuery;
import com.beyondcron.messaging.message.JobCommand;
import com.beyondcron.messaging.message.JobControl;
import com.beyondcron.messaging.message.JobHistoryClear;
import com.beyondcron.messaging.message.JobHistoryQuery;
import com.beyondcron.messaging.message.JobOutputQuery;
import com.beyondcron.messaging.message.JobQuery;
import com.beyondcron.messaging.message.JobStatusQuery;
import com.beyondcron.messaging.message.LicenseQuery;
import com.beyondcron.messaging.message.LimitQuery;
import com.beyondcron.messaging.message.LimitReset;
import com.beyondcron.messaging.message.Link;
import com.beyondcron.messaging.message.PropertyCommand;
import com.beyondcron.messaging.message.PropertyQuery;
import com.beyondcron.messaging.message.ProtectedCommand;
import com.beyondcron.messaging.message.ProtectedList;
import com.beyondcron.messaging.message.ProtectedQuery;
import com.beyondcron.messaging.message.Queue;
import com.beyondcron.messaging.message.QueueCommand;
import com.beyondcron.messaging.message.QueueQuery;
import com.beyondcron.messaging.message.ResultList;
import com.beyondcron.messaging.message.ResultMessage;
import com.beyondcron.messaging.message.RoleCommand;
import com.beyondcron.messaging.message.RoleQuery;
import com.beyondcron.messaging.message.ServerQuery;
import com.beyondcron.messaging.message.ServiceCommand;
import com.beyondcron.messaging.message.ServiceQuery;
import com.beyondcron.messaging.message.Topic;
import com.beyondcron.messaging.message.TopicQuery;
import com.beyondcron.messaging.message.UserCommand;
import com.beyondcron.messaging.message.UserPassword;
import com.beyondcron.messaging.message.UserQuery;
import com.beyondcron.messaging.message.calendar.Calendar;
import com.beyondcron.messaging.message.calendar.ICalendar;
import com.beyondcron.messaging.proto.ProtoCalendar;
import com.beyondcron.messaging.proto.ProtoJob;
import com.google.protobuf.InvalidProtocolBufferException;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.OperationTimeoutException;
import com.hazelcast.map.listener.EntryAddedListener;
import com.hazelcast.map.listener.EntryUpdatedListener;
import com.hazelcast.map.listener.MapListener;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.invoke.CallSite;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ConsoleErrorListener;
import org.antlr.v4.runtime.IntStream;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.atn.ATNConfigSet;
import org.antlr.v4.runtime.dfa.DFA;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class CommandExecutor
extends CommandsBaseListener {
    static final Logger logger = LogUtils.getLogger(CommandExecutor.class);
    private static final String USER_SELF = "self";
    private static final String PASSWORD_MASK = "********";
    static final Pattern PROPERTY_DEFINE_REGEX = Pattern.compile("(.+?)=(.+)");
    private static final Map<String, String> tagLables = new HashMap<String, String>();
    private static String everyoneRoleName;
    private final DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("EEE MMM dd");
    private final DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern("HH:mm:ss");
    private final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("EEE MMM dd HH:mm:ss zzz yyyy");
    private final CommandConnection connection;
    private User user;
    private String defaultJobUserName = null;
    private Name currentGroup = Name.ROOT;
    private boolean currentGroupSet = false;
    private String currentName = "/";
    private final boolean checkHostsExist = Boolean.TRUE.equals(Configs.get((String)"beyondcron.check.hosts.exist"));
    private final CommandListener commandListener;
    private CommandOutput lastOutput;
    private JobStatusListener jobStatusListener = null;
    private TimeZone timeZone;
    private TimeZone jobTimeZone = this.timeZone = TimeZone.getDefault();
    private ZoneId zoneId = this.timeZone.toZoneId();
    private boolean timestamp = false;
    private boolean debug = false;
    private CommandParser parser;
    private CommandStack commands;
    private boolean rawOutput = false;
    private boolean summaryOutput = true;
    private final Status.Filter jobHistoryFilter = new Status.Filter();
    private JobConfirmValidator jobConfirmValidator;
    private boolean hasHtml = false;

    public CommandExecutor(CommandConnection connection, CommandListener commandListener) {
        this.connection = connection;
        this.commandListener = commandListener;
        this.init();
    }

    private void init() {
        this.hasHtml = this.commandListener != null && this.commandListener.supportsHtml();
        this.commands = new CommandStack(100);
        everyoneRoleName = (String)Configs.get((String)"beyondcron.everyone.role.name");
        this.user = this.connection.getUser();
        this.setCurrentGroup(this.user.getHome());
        this.defaultJobUserName = HostACLValidator.getInstance((HazelcastInstance)this.connection.getHazelcast()).getDefaultUserName(this.user);
        this.jobConfirmValidator = JobConfirmValidator.getInstance((HazelcastInstance)this.connection.getHazelcast());
        this.initParser();
    }

    private void initParser() {
        try {
            this.parser = new CommandParser(this);
        }
        catch (IOException e) {
            this.output(CommandOutput.Level.FATAL, e, "Error creating parser", new Object[0]);
        }
    }

    public void setRawOutput(boolean rawOutput) {
        this.rawOutput = rawOutput;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setJobTimeZone(TimeZone timeZone) {
        this.jobTimeZone = timeZone;
    }

    public TimeZone getJobTimeZone() {
        return this.jobTimeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        TimeZone tz;
        TimeZone timeZone2 = tz = timeZone != null ? timeZone : TimeZone.getDefault();
        if (tz != this.timeZone) {
            this.timeZone = tz;
            this.zoneId = this.timeZone.toZoneId();
            if (this.commandListener != null) {
                this.commandListener.timeZoneUpdated(this.timeZone);
            }
        }
    }

    public void setDefaultIndent(String indent) {
        TableFormatter.setDefaultIndent((String)indent);
    }

    private void setCurrentGroup(Name group) {
        if (this.connection.hasPermission(group, ACL.Permission.READ)) {
            this.currentGroup = group != null ? group : Name.ROOT;
            this.currentGroupSet = this.currentGroup.getPath().length() > 1;
        } else {
            this.outputError("%1$s does not have read permission on %2$s", this.user.getName(), group);
        }
    }

    public Name getCurrentGroup() {
        return this.currentGroup;
    }

    public String getCommand(String command) {
        return this.commands.get(command);
    }

    public void addCommand(String command) {
        this.commands.add(command);
    }

    public String maskPassword(String command) {
        return this.commands.maskPassword(command);
    }

    public int executeCommand(String command) {
        block11: {
            String cmd = this.commands.get(command);
            if (cmd == null) {
                return this.outputError("%s : event not found", command).getLevel().getCode();
            }
            if (cmd.matches("\\s*")) {
                return 0;
            }
            if (this.commands.historyCommand(cmd)) {
                return 0;
            }
            if (cmd.matches("read\\s+\\S.*")) {
                this.commands.add(cmd);
                this.importConfig(cmd.substring("read".length()).trim());
                return 0;
            }
            try {
                Message message = this.parser.parse(cmd);
                if (!this.parser.wasError() || this.commandListener != null) {
                    this.commands.add(cmd);
                }
                if (message != null && message instanceof CommandMessage) {
                    long time = System.currentTimeMillis();
                    this.parseResponse(this.connection.sendReceive((CommandMessage)message));
                    if (this.timestamp) {
                        this.printTimestamp(System.currentTimeMillis() - time);
                    }
                }
            }
            catch (OperationTimeoutException e) {
                this.outputError("Timeout executing command", new Object[0]);
            }
            catch (Exception e) {
                if (logger.isDebugEnabled()) {
                    Localise.logDebug((Logger)logger, (Exception)e, (String)"Unknown command - %1$s", (Object[])new Object[]{e.getMessage()});
                }
                this.outputError(e, "Unknown command", new Object[0]);
                if (!this.debug) break block11;
                this.outputError(e, StringUtils.stackTrace((Exception)e), new Object[0]);
            }
        }
        return this.lastOutput != null ? this.lastOutput.getLevel().getCode() : 0;
    }

    private void printTimestamp(long runtime) {
        this.output(new CommandOutput(Localise.format((String)"runtime %s", (Object[])new Object[]{TimeUtils.formatDuration((long)runtime, (boolean)true)})), false, true);
    }

    private void importConfig(String configFileName) {
        BufferedReader in;
        File configFile = new File(configFileName);
        if (!configFile.exists()) {
            this.outputError("%s does not exist", configFileName);
            return;
        }
        if (!configFile.isFile()) {
            this.outputError("%s is not a file", configFileName);
            return;
        }
        if (!configFile.canRead()) {
            this.outputError("Cannot read %s", configFileName);
            return;
        }
        try {
            in = new BufferedReader(new FileReader(configFile));
        }
        catch (FileNotFoundException e) {
            this.outputError("Could not open %1$s - %2$s", configFileName, e.getMessage());
            return;
        }
        while (true) {
            String command;
            try {
                command = in.readLine();
            }
            catch (IOException e) {
                this.outputError("Could not read line from %1$s - %2$s", configFileName, e.getMessage());
                break;
            }
            if (command == null) break;
            if ((command = command.replaceAll("#.*", "")).matches("\\s*")) continue;
            try {
                CommandMessage message = (CommandMessage)this.parser.parse(command);
                if (message == null) {
                    if (!this.parser.wasError()) continue;
                    break;
                }
                if (message instanceof Result) continue;
                this.parseResponse(this.connection.sendReceive(message));
            }
            catch (Exception e) {
                this.outputError(e, "Exception parsing %s", command);
            }
        }
        try {
            in.close();
        }
        catch (IOException e) {
            this.outputError(e, "Could not close %s", configFileName);
        }
    }

    private int parseResponse(ResultMessage response) {
        Result result = response.getResult();
        if (!result.wasSuccess()) {
            this.outputError(result.getMessage(), new Object[0]);
            List references = result.getReferences();
            if (!references.isEmpty()) {
                String prefix;
                ArrayList<String> lines = new ArrayList<String>();
                if (references.size() > 1) {
                    lines.add(Localise.format((String)"For help see:"));
                    prefix = this.hasHtml ? "<span>&bull;</span>" : "- ";
                } else {
                    prefix = Localise.format((String)"For help see: ");
                }
                for (Link reference : references) {
                    if (this.hasHtml) {
                        lines.add(String.format("%1$s <a href=\"%2$s\" target=\"%4$s\">%3$s %4$s</a>", prefix, reference.getUrl(), reference.getDescription(), reference.getType() == Link.Type.MANPAGE ? "bc_docs" : "_blank", "<i class=\"fas fa-external-link-alt\"></i>"));
                        continue;
                    }
                    lines.add(String.format("%1$s %2$s: %3$s", prefix, reference.getDescription(), reference.getUrl().toString()));
                }
                if (this.hasHtml) {
                    this.output(new CommandOutput(CommandOutput.Level.INFO, StringUtils.join((String)"\n", lines)).setHtml(true), true);
                } else {
                    this.output(StringUtils.join((String)"\n", lines), new Object[0]);
                }
            }
            return 1;
        }
        if (response instanceof ResultList && ((ResultList)response).isEmpty()) {
            return 0;
        }
        if (response instanceof ACLQuery.Response) {
            ACLQuery.Response r = (ACLQuery.Response)response;
            if (r.getChangeIds().size() < 2) {
                this.responseACLQuery(r);
            } else {
                this.responseACLDiff(r);
            }
        } else if (response instanceof AgentQuery.Response) {
            this.responseAgentQuery((AgentQuery.Response)response);
        } else if (response instanceof CalendarQuery.Response) {
            CalendarQuery.Response r = (CalendarQuery.Response)response;
            if (r.getChangeIds().size() < 2) {
                this.responseCalendarQuery(r);
            } else {
                this.responseCalendarDiff(r);
            }
        } else if (response instanceof CalendarJobsQuery.Response) {
            this.responseCalendarJobsQuery((CalendarJobsQuery.Response)response);
        } else if (response instanceof ConfigQuery.Response) {
            ConfigQuery.Response r = (ConfigQuery.Response)response;
            if (r.getChangeIds().size() < 2) {
                this.responseConfigQuery(r);
            } else {
                this.responseConfigDiff(r);
            }
        } else if (response instanceof ConnectionQuery.Response) {
            this.responseConnectionList((ConnectionQuery.Response)response);
        } else if (response instanceof ChangeQuery.Response) {
            this.responseChangeQuery((ChangeQuery.Response)response);
        } else if (response instanceof ClusterQuery.Response) {
            this.responseClusterQuery((ClusterQuery.Response)response);
        } else if (response instanceof DateQuery.Response) {
            this.responseDateQuery((DateQuery.Response)response);
        } else if (response instanceof ICalendarQuery.Response) {
            this.responseICalendarQuery((ICalendarQuery.Response)response);
        } else if (response instanceof GroupQuery.Response) {
            this.responseGroupQuery((GroupQuery.Response)response);
        } else if (response instanceof JobQuery.Response) {
            JobQuery.Response r = (JobQuery.Response)response;
            if (r.getChangeIds().size() < 2) {
                this.responseJobQuery(r);
            } else {
                this.responseJobDiff(r);
            }
        } else if (response instanceof JobStatusQuery.Response) {
            this.responseJobStatus((JobStatusQuery.Response)response);
        } else if (response instanceof JobHistoryQuery.Response) {
            this.responseJobHistory((JobHistoryQuery.Response)response);
        } else if (response instanceof JobOutputQuery.Response) {
            this.responseJobOutput((JobOutputQuery.Response)response);
        } else if (response instanceof LicenseQuery.Response) {
            this.responseLicenseQuery((LicenseQuery.Response)response);
        } else if (response instanceof LimitQuery.Response) {
            this.responseLimitQuery((LimitQuery.Response)response);
        } else if (response instanceof ProtectedQuery.Response) {
            ProtectedQuery.Response r = (ProtectedQuery.Response)response;
            if (r.getChangeIds().size() < 2) {
                this.responseProtectedQuery(r);
            } else {
                this.responseProtectedDiff(r);
            }
        } else if (response instanceof QueueQuery.Response) {
            this.responseQueueQuery((QueueQuery.Response)response);
        } else if (response instanceof RoleQuery.Response) {
            this.responseRoleQuery((RoleQuery.Response)response);
        } else if (response instanceof ServerQuery.Response) {
            this.responseServerQuery((ServerQuery.Response)response);
        } else if (response instanceof TopicQuery.Response) {
            this.responseTopicQuery((TopicQuery.Response)response);
        } else if (response instanceof UserQuery.Response) {
            this.responseUserQuery((UserQuery.Response)response);
        } else if (response instanceof UserCommand.Response) {
            this.responseUserCommand((UserCommand.Response)response);
        } else if (response instanceof HostACLQuery.Response) {
            HostACLQuery.Response r = (HostACLQuery.Response)response;
            if (r.getChangeIds().size() < 2) {
                this.responseHostACLQuery((HostACLQuery.Response)response);
            } else {
                this.responseHostACLDiff((HostACLQuery.Response)response);
            }
        } else if (response instanceof PropertyQuery.Response) {
            PropertyQuery.Response r = (PropertyQuery.Response)response;
            if (r.getChangeIds().size() < 2) {
                this.responsePropertyQuery(r);
            } else {
                this.responsePropertyDiff(r);
            }
        } else if (response instanceof ServiceQuery.Response) {
            this.responseServiceQuery((ServiceQuery.Response)response);
        } else if (response instanceof Result) {
            this.output(((Result)response).getMessage(), new Object[0]);
        } else {
            logger.trace("unexpected message received: {} {}", (Object)response.getClass().getName(), (Object)response.toString());
            this.lastOutput = null;
        }
        return 0;
    }

    private void responseACLQuery(ACLQuery.Response response) {
        TableFormatter table = new TableFormatter();
        table.addColumns(new String[]{Localise.format((String)"Name"), Localise.format((String)"User/Role"), Localise.format((String)"Permissions")});
        Name currentName = null;
        for (ACL acl : new TreeSet(response.getACLs(0))) {
            table.startRow();
            Name name = acl.getName();
            if (!name.equals(currentName)) {
                table.addValue((Object)acl.getName());
                currentName = name;
            } else {
                table.addValue((Object)"");
            }
            table.addValue((Object)acl.getUserRole());
            if (acl.getValue() > 1 && Integer.bitCount(acl.getValue() + 1) == 1) {
                if (acl.hasPermission(ACL.Permission.ADMIN)) {
                    table.addValue((Object)(ACL.Permission.ADMIN.toString() + "+").toLowerCase());
                    continue;
                }
                if (acl.hasPermission(ACL.Permission.WRITE)) {
                    table.addValue((Object)(ACL.Permission.WRITE.toString() + "+").toLowerCase());
                    continue;
                }
                if (acl.hasPermission(ACL.Permission.ENABLE)) {
                    table.addValue((Object)(ACL.Permission.ENABLE.toString() + "+").toLowerCase());
                    continue;
                }
                if (!acl.hasPermission(ACL.Permission.EXECUTE)) continue;
                table.addValue((Object)(ACL.Permission.EXECUTE.toString() + "+").toLowerCase());
                continue;
            }
            table.addValue((Object)StringUtils.join((String)" ", (Object[])acl.getPermissions()).toLowerCase());
        }
        this.output(table);
    }

    private void responseACLDiff(ACLQuery.Response response) {
        Iterator acls = response.getACLs().iterator();
        if (acls.hasNext()) {
            TableFormatter table = new TableFormatter(false).setColumnSeparator(" ");
            TreeSet acls1 = new TreeSet((Collection)acls.next());
            while (acls.hasNext()) {
                TreeSet acls2 = new TreeSet((Collection)acls.next());
                if (acls1.equals(acls2)) continue;
                table.clear();
                for (ACL acl : acls1) {
                    if (acls2.contains(acl)) continue;
                    table.addRow(new Object[]{"-", acl.getUserRole(), StringUtils.join((String)" ", (Object[])acl.getPermissions())});
                }
                for (ACL acl : acls2) {
                    if (acls1.contains(acl)) continue;
                    table.addRow(new Object[]{"+", acl.getUserRole(), StringUtils.join((String)" ", (Object[])acl.getPermissions())});
                }
                this.output(table);
            }
        }
    }

    private void responseAgentQuery(AgentQuery.Response response) {
        TableFormatter table = new TableFormatter();
        if (this.summaryOutput) {
            table.addColumns(new String[]{Localise.format((String)"Host"), Localise.format((String)"State"), Localise.format((String)"Type")});
        } else {
            table.addColumns(new String[]{Localise.format((String)"Host"), Localise.format((String)"State"), Localise.format((String)"%s User", (Object[])new Object[]{"bc".toUpperCase()}), Localise.format((String)"OS User"), Localise.format((String)"Version"), Localise.format((String)"Type"), Localise.format((String)"OS"), Localise.format((String)"Address"), Localise.format((String)"Connected/disconnected")});
            table.alignColumn(Localise.format((String)"Connected/disconnected"), TableFormatter.Column.Align.RIGHT);
        }
        table.alignColumn(Localise.format((String)"State"), TableFormatter.Column.Align.RIGHT);
        for (Connection agent : new TreeSet(response.getAgents())) {
            table.startRow();
            table.addValue((Object)agent.getClientHostName());
            table.addValue((Object)StringUtils.capitalise((Object)agent.getClientState()));
            if (this.summaryOutput) {
                table.addValue((Object)agent.getClientType().getLabel());
                continue;
            }
            table.addValue((Object)agent.getClientUserName());
            table.addValue((Object)agent.getOsUserName());
            table.addValue((Object)agent.getClientVersion());
            table.addValue((Object)agent.getClientType().getLabel());
            table.addValue((Object)agent.getOS());
            table.addValue((Object)agent.getClientAddress());
            table.addValue((Object)TimeUtils.format((long)agent.getUpdateTime(), (TimeZone)this.timeZone));
        }
        this.output(table);
    }

    private void responseCalendarQuery(CalendarQuery.Response response) {
        TableFormatter table = new TableFormatter();
        TreeMap<String, Calendar> calendars = new TreeMap<String, Calendar>();
        for (Calendar calendar : response.getCalendars()) {
            calendars.put(TimeUtils.getMonthSortKey((Name)calendar.getName()), calendar);
        }
        if (this.summaryOutput) {
            table.addColumns(new String[]{Localise.format((String)"Name"), Localise.format((String)"Jobs"), Localise.format((String)"Description")});
            for (Calendar calendar : calendars.values()) {
                table.addRow(new Object[]{calendar.getName(), calendar.getJobReferenceCount(), calendar.getDescription()});
            }
        } else {
            int row = 0;
            table.alignColumn(1, TableFormatter.Column.Align.LEFT);
            for (Calendar calendar : calendars.values()) {
                if (row++ > 0) {
                    table.addRow(new Object[]{"", ""});
                }
                table.addRow(new Object[]{Localise.format((String)"Name"), calendar.getName()});
                table.addRow(new Object[]{Localise.format((String)"Description"), calendar.getDescription()});
                ArrayList uris = new ArrayList(calendar.getInclusiveCalendars());
                table.addRow(new Object[]{Localise.format((String)"iCal include"), uris.isEmpty() ? "" : uris.remove(0)});
                for (URI uri : uris) {
                    table.addRow(new Object[]{"", uri});
                }
                uris = new ArrayList(calendar.getExclusiveCalendars());
                table.addRow(new Object[]{Localise.format((String)"iCal exclude"), uris.isEmpty() ? "" : uris.remove(0)});
                for (URI uri : uris) {
                    table.addRow(new Object[]{"", uri});
                }
                if (!response.getChangeIds().isEmpty()) continue;
                table.addRow(new Object[]{Localise.format((String)"References"), calendar.getJobReferenceCount()});
                table.addRow(new Object[]{Localise.format((String)"Last updated"), TimeUtils.format((long)calendar.getLastUpdated(), (TimeZone)this.timeZone)});
            }
        }
        this.output(table);
    }

    private void responseCalendarDiff(CalendarQuery.Response response) {
        Iterator calendars = response.getCalendars().iterator();
        if (calendars.hasNext()) {
            Calendar calendar1 = (Calendar)calendars.next();
            while (calendars.hasNext()) {
                Calendar calendar2 = (Calendar)calendars.next();
                this.outputDiff(calendar1.diff(calendar2));
                calendar1 = calendar2;
            }
        }
    }

    private void responseCalendarJobsQuery(CalendarJobsQuery.Response response) {
        TableFormatter table = new TableFormatter();
        ArrayList jobs = new ArrayList(response.getJobs());
        table.addRow(new Object[]{Localise.format((String)"Job"), jobs.isEmpty() ? "" : jobs.remove(0)});
        for (Name job : jobs) {
            table.addRow(new Object[]{"", job});
        }
        this.output(table);
    }

    private void responseChangeQuery(ChangeQuery.Response response) {
        boolean commit = response.getType() == ChangeQuery.Type.COMMIT;
        TableFormatter table = new TableFormatter();
        if (this.summaryOutput) {
            table.addColumns(new String[]{Localise.format((String)"Time"), Localise.format((String)"Change"), "", Localise.format((String)"Action"), Localise.format((String)"User"), Localise.format((String)"Host")});
            table.alignColumn(2, TableFormatter.Column.Align.RIGHT);
            int index = 0;
            for (Change change : response.getChanges()) {
                String action;
                String string = change.getEntryCount() > 1 ? Localise.format((String)"Import") : (action = StringUtils.capitalise((Object)change.getAction().getLabel(!commit)));
                if (change.getAction() != Change.Action.REMOVED || commit) {
                    table.addRow(new Object[]{TimeUtils.format((long)change.getTimestamp(), (TimeZone)this.timeZone), change.getId(), Integer.toString(index--), action, change.getUser(), change.getHost()});
                    continue;
                }
                table.addRow(new Object[]{TimeUtils.format((long)change.getTimestamp(), (TimeZone)this.timeZone), change.getId(), "", action, change.getUser(), change.getHost()});
            }
        } else {
            int row = 0;
            table.alignColumn(1, TableFormatter.Column.Align.LEFT);
            for (Change change : response.getChanges()) {
                if (row++ > 0) {
                    table.addRow(new Object[]{"", ""});
                }
                table.addRow(new Object[]{Localise.format((String)"Change"), change.getId()});
                String s = change.getReference();
                if (!s.isEmpty()) {
                    table.addRow(new Object[]{Localise.format((String)"Reference"), s});
                }
                table.addRow(new Object[]{Localise.format((String)"Time"), TimeUtils.format((long)change.getTimestamp(), (TimeZone)this.timeZone)});
                table.addRow(new Object[]{Localise.format((String)"Author"), change.getAuthor()});
                table.addRow(new Object[]{Localise.format((String)"User"), change.getUser()});
                table.addRow(new Object[]{Localise.format((String)"Host"), change.getHost()});
                table.addRow(new Object[]{Localise.format((String)"Client"), change.getClient(false)});
                table.addRow(new Object[]{Localise.format((String)"Changes"), change.getEntryCount()});
                HashSet<CallSite> logged = new HashSet<CallSite>();
                TableFormatter createTable = new TableFormatter(false).setIndent("").alignColumn(0, TableFormatter.Column.Align.RIGHT);
                TableFormatter updateTable = new TableFormatter(false).setIndent("");
                TableFormatter removeTable = new TableFormatter(false).setIndent("");
                TableFormatter unknownTable = new TableFormatter(false).setIndent("");
                ArrayList<String> data = new ArrayList<String>();
                for (Change.Entry entry : change.getEntries()) {
                    String tag = entry.getTag();
                    data.clear();
                    data.add(tagLables.get(tag));
                    Name name = entry.getName();
                    s = name.toString();
                    data.add(s.equals("/_") ? "/" : s);
                    String id = tag + s;
                    switch (entry.getAction()) {
                        case CREATED: {
                            createTable.addRow(data.toArray());
                            logged.add((CallSite)((Object)id));
                            break;
                        }
                        case REMOVED: {
                            removeTable.addRow(data.toArray());
                            break;
                        }
                        case UPDATED: {
                            if (!logged.add((CallSite)((Object)id))) break;
                            updateTable.addRow(data.toArray());
                            break;
                        }
                        case UNKNOWN: {
                            unknownTable.addRow(data.toArray());
                        }
                    }
                }
                if (createTable.getRowCount() > 0) {
                    table.addRow(new Object[]{Localise.format((String)"Created"), createTable});
                }
                if (updateTable.getRowCount() > 0) {
                    table.addRow(new Object[]{Localise.format((String)"Updated"), updateTable});
                }
                if (removeTable.getRowCount() > 0) {
                    table.addRow(new Object[]{Localise.format((String)"Removed"), removeTable});
                }
                if (unknownTable.getRowCount() <= 0) continue;
                table.addRow(new Object[]{Localise.format((String)"Other"), unknownTable});
            }
        }
        this.output(table);
    }

    private void responseConfigQuery(ConfigQuery.Response response) {
        boolean showSecrets = this.connection.hasPermission(BlissUtils.ACL_DIR_CONFIGURATION, ACL.Permission.WRITE);
        TableFormatter table = new TableFormatter();
        if (this.summaryOutput) {
            table.addColumns(new String[]{"Type", "Name", "Value"});
            for (Config config : response.getConfigs()) {
                String type;
                switch (config.getType()) {
                    case EXTERNAL: {
                        type = "external";
                        break;
                    }
                    case INTERNAL: {
                        type = config.isDefault() ? "default" : "custom";
                        break;
                    }
                    case USER: {
                        type = "user";
                        break;
                    }
                    default: {
                        type = "unknown";
                    }
                }
                table.addRow(new Object[]{type, config.getName(), !config.isSecret() || showSecrets ? config.getValue() : PASSWORD_MASK});
            }
        } else {
            int row = 0;
            table.alignColumn(1, TableFormatter.Column.Align.LEFT);
            for (Config config : response.getConfigs()) {
                if (row++ > 0) {
                    table.addRow(new Object[]{"", ""});
                }
                table.addRow(new Object[]{Localise.format((String)"Name"), config.getName()});
                if (config.hasDescription()) {
                    table.addRow(new Object[]{Localise.format((String)"Description"), StringUtils.wrap((int)60, (String)config.getDescription())});
                }
                if (config.hasDefault()) {
                    table.addRow(new Object[]{Localise.format((String)"Default"), config.getDefault()});
                }
                if (!config.isDefault()) {
                    table.addRow(new Object[]{Localise.format((String)"Value"), !config.isSecret() || showSecrets ? config.getValue() : PASSWORD_MASK});
                }
                if (!config.isSecret()) continue;
                table.addRow(new Object[]{Localise.format((String)"Secret")});
            }
        }
        this.output(table);
    }

    private void responseConfigDiff(ConfigQuery.Response response) {
        Iterator configs = response.getConfigs().iterator();
        if (configs.hasNext()) {
            Config config1 = (Config)configs.next();
            boolean showSecrets = this.connection.hasPermission(config1.getPath(), ACL.Permission.WRITE);
            while (configs.hasNext()) {
                Config config2 = (Config)configs.next();
                this.outputDiff(config1.diff(config2, showSecrets));
                config1 = config2;
            }
        }
    }

    private void responseConnectionList(ConnectionQuery.Response response) {
        TableFormatter table = new TableFormatter();
        if (this.summaryOutput) {
            table.addColumns(new String[]{Localise.format((String)"Host"), Localise.format((String)"%s User", (Object[])new Object[]{"bc".toUpperCase()}), Localise.format((String)"Type"), Localise.format((String)"Client")});
            table.alignColumn(Localise.format((String)"Client"), TableFormatter.Column.Align.RIGHT);
        } else {
            table.addColumns(new String[]{Localise.format((String)"Host"), Localise.format((String)"%s User", (Object[])new Object[]{"bc".toUpperCase()}), Localise.format((String)"OS User"), Localise.format((String)"Client"), Localise.format((String)"Type"), Localise.format((String)"OS"), Localise.format((String)"Java"), Localise.format((String)"Address"), Localise.format((String)"Connection"), Localise.format((String)"Authenticated"), Localise.format((String)"Connected/disconnected")});
            table.alignColumn(Localise.format((String)"Client"), TableFormatter.Column.Align.RIGHT);
            table.alignColumn(Localise.format((String)"Connection"), TableFormatter.Column.Align.RIGHT);
            table.alignColumn(Localise.format((String)"Authenticated"), TableFormatter.Column.Align.RIGHT);
            table.alignColumn(Localise.format((String)"Connected/disconnected"), TableFormatter.Column.Align.RIGHT);
        }
        String connectionId = this.connection.getConnection().getId();
        for (Connection connection : new TreeSet(response.getConnections())) {
            table.startRow();
            table.addValue((Object)connection.getClientHostName());
            table.addValue((Object)connection.getClientUserName());
            if (this.summaryOutput) {
                table.addValue((Object)connection.getClientType().getLabel());
                table.addValue((Object)connection.getClient());
                continue;
            }
            table.addValue((Object)connection.getOsUserName());
            table.addValue((Object)connection.getClient());
            table.addValue((Object)connection.getClientType().getLabel());
            table.addValue((Object)connection.getOS());
            table.addValue((Object)connection.getJava());
            table.addValue((Object)connection.getClientAddress());
            String id = connection.getId();
            if (id.equals(connectionId)) {
                table.addValue((Object)("> " + connection.getId()));
            } else {
                table.addValue((Object)id);
            }
            table.addValue((Object)BooleanUtils.toYesNo((boolean)connection.isAuthenticated()));
            table.addValue((Object)TimeUtils.format((long)connection.getUpdateTime(), (TimeZone)this.timeZone));
        }
        this.output(table);
    }

    private void responseDateQuery(DateQuery.Response response) {
        this.output(response.getDate().format(this.dateTimeFormatter), new Object[0]);
    }

    private void responseICalendarQuery(ICalendarQuery.Response response) {
        TableFormatter table = new TableFormatter();
        if (this.summaryOutput) {
            table.addColumns(new String[]{Localise.format((String)"Name"), Localise.format((String)"Description"), Localise.format((String)"URI")});
        } else {
            table.addColumns(new String[]{Localise.format((String)"Name"), Localise.format((String)"Description"), Localise.format((String)"URI"), Localise.format((String)"References"), Localise.format((String)"Last modified"), Localise.format((String)"Last refreshed")});
            table.alignColumn(Localise.format((String)"References"), TableFormatter.Column.Align.RIGHT);
            table.alignColumn(Localise.format((String)"Last modified"), TableFormatter.Column.Align.RIGHT);
            table.alignColumn(Localise.format((String)"Last refreshed"), TableFormatter.Column.Align.RIGHT);
        }
        TreeMap<String, ICalendar> calendars = new TreeMap<String, ICalendar>();
        for (ICalendar calendar : response.getICalendars()) {
            calendars.put(TimeUtils.getMonthSortKey((String)calendar.getName()), calendar);
        }
        for (ICalendar calendar : calendars.values()) {
            table.startRow();
            table.addValue((Object)calendar.getName());
            table.addValue((Object)calendar.getDescription(this.summaryOutput));
            table.addValue((Object)calendar.getURI());
            if (this.summaryOutput) continue;
            table.addValue((Object)calendar.getListenerCount());
            table.addValue((Object)TimeUtils.format((long)calendar.getLastModified(), (TimeZone)this.timeZone));
            table.addValue((Object)TimeUtils.format((long)calendar.getLastRefreshed(), (TimeZone)this.timeZone));
        }
        this.output(table);
    }

    private void responseGroupQuery(GroupQuery.Response response) {
        TableFormatter table = new TableFormatter();
        table.addColumns(new String[]{Localise.format((String)"Type"), Localise.format((String)"Name"), Localise.format((String)"Description")});
        String name = null;
        TreeSet<Group.Entry> entries = new TreeSet<Group.Entry>();
        for (Group.Entry entry : response.getEntries()) {
            if (!entry.getName().equals(name)) {
                if (!entries.isEmpty()) {
                    this.addGroupEntry(table, entries);
                    entries.clear();
                }
                name = entry.getName();
            }
            entries.add(entry);
        }
        if (!entries.isEmpty()) {
            this.addGroupEntry(table, entries);
        }
        this.output(table);
    }

    private void addGroupEntry(TableFormatter table, TreeSet<Group.Entry> entries) {
        StringBuilder type = new StringBuilder();
        for (Group.Entry e : entries.descendingSet()) {
            type.append(e.getType().getTag());
        }
        Group.Entry entry = entries.last();
        Object name = entry.getName();
        if (entry.getType() == Group.Entry.Type.GROUP && !((String)name).equals(".")) {
            name = (String)name + "/";
        }
        table.addRow(new Object[]{type.toString(), name, entry.getDescription()});
    }

    private void responseJobQuery(JobQuery.Response response) {
        TableFormatter table = new TableFormatter();
        if (response.isSummary()) {
            table.addColumns(new String[]{Localise.format((String)"Job"), Localise.format((String)"Type"), Localise.format((String)"Mode"), Localise.format((String)"Description")});
            table.alignColumn(Localise.format((String)"Job"), TableFormatter.Column.Align.LEFT);
            table.alignColumn(Localise.format((String)"Description"), TableFormatter.Column.Align.LEFT);
            for (Job job : response.getJobs()) {
                table.addRow(new Object[]{job.getName().toString(), job.getType().getLabel(), StringUtils.capitalise((Object)job.getMode()), job.getDescription()});
            }
            this.output(table);
        } else {
            this.outputJobs(response.getJobs(), false);
        }
    }

    private void outputJobs(List<Job> jobs, boolean summary) {
        TableFormatter table = new TableFormatter();
        table.alignColumn(1, TableFormatter.Column.Align.LEFT);
        for (Job job : jobs) {
            URLJob uJob;
            Name name = job.getName();
            CommandJob cJob = job instanceof CommandJob ? (CommandJob)job : null;
            MailJob mJob = job instanceof MailJob ? (MailJob)job : null;
            SQLJob sJob = job instanceof SQLJob ? (SQLJob)job : null;
            TriggerJob tJob = job instanceof TriggerJob ? (TriggerJob)job : null;
            URLJob uRLJob = uJob = job instanceof URLJob ? (URLJob)job : null;
            if (!table.isEmpty()) {
                table.addRow(new Object[]{"", ""});
            }
            table.addRow(new Object[]{Localise.format((String)"Name"), name});
            this.addRow(table, Localise.format((String)"Description"), job.getDescription(), summary);
            table.addRow(new Object[]{Localise.format((String)"Mode"), StringUtils.capitalise((Object)job.getMode())});
            table.addRow(new Object[]{Localise.format((String)"Type"), job.getType().getLabel()});
            if (cJob != null) {
                boolean container = cJob instanceof ContainerJob;
                if (!container) {
                    this.addRow(table, Localise.format((String)"Host"), cJob.getHostName(), summary);
                } else {
                    this.addRow(table, Localise.format((String)"Image"), ((ContainerJob)job).getImageName(), summary);
                }
                this.addRow(table, Localise.format((String)"User"), cJob.getUserName(), summary);
                Command command = cJob.getCommand();
                if (command != null) {
                    this.addRow(table, Localise.format((String)"Command"), command.getCommand(), summary);
                    if (!container) {
                        this.addRow(table, Localise.format((String)"Input"), command.hasInput() ? StringUtils.join((String)"\n", (Collection)command.getInput()) : "", summary);
                    }
                } else {
                    this.addRow(table, Localise.format((String)"Command"), "", summary);
                    if (!container) {
                        this.addRow(table, Localise.format((String)"Input"), "", summary);
                    }
                }
            }
            if (mJob != null) {
                this.addRow(table, Localise.format((String)"Email"), mJob.getRecipient(), summary);
                this.addRow(table, Localise.format((String)"Subject"), mJob.getSubject(), summary);
                this.addRow(table, Localise.format((String)"Message"), mJob.getMessage(), summary);
            }
            if (sJob != null) {
                this.addRow(table, Localise.format((String)"URL"), NetUtils.decodeBraces((String)sJob.getURL().toString()), summary);
                this.addRow(table, Localise.format((String)"SQL"), sJob.hasSQL() ? StringUtils.join((String)"\n", (Collection)sJob.getSQL()) : "", summary);
            }
            if (tJob != null) {
                this.addRow(table, Localise.format((String)"Delay"), tJob.getDelay().toString(true), summary);
            }
            if (uJob != null) {
                this.addRow(table, Localise.format((String)"URL"), uJob.getURL().toString(), summary);
                this.addRow(table, Localise.format((String)"Method"), uJob.getMethod().getLabel(), summary);
                this.addRow(table, Localise.format((String)"Content"), uJob.hasContent() ? StringUtils.join((String)"\n", (Collection)uJob.getContent()) : "", summary);
            }
            if (cJob != null && !(job instanceof ContainerJob) || sJob != null || uJob != null) {
                URL output = job.getOutput();
                this.addRow(table, Localise.format((String)"Output"), output != null ? output.getPath() : "", summary);
            }
            this.addRow(table, Localise.format((String)"Calendar"), job.getCalendar(), summary);
            this.addRow(table, Localise.format((String)"Timezone"), job.getTimeZone().getID(), summary);
            ArrayList<Condition> conditions = new ArrayList<Condition>();
            ArrayList<Condition> triggers = new ArrayList<Condition>();
            for (Condition condition : job.getConditions()) {
                if (condition.getType() == Condition.Type.ALL) {
                    conditions.add(condition);
                    continue;
                }
                triggers.add(condition);
            }
            if (!summary || !conditions.isEmpty()) {
                table.addRow(new Object[]{Localise.format((String)"Conditions"), conditions.isEmpty() ? "" : conditions.remove(0)});
                for (Condition condition : conditions) {
                    table.addRow(new Object[]{"", condition.toString()});
                }
            }
            if (!summary || !triggers.isEmpty()) {
                table.addRow(new Object[]{Localise.format((String)"Triggers"), triggers.isEmpty() ? "" : triggers.remove(0)});
                for (Condition condition : triggers) {
                    table.addRow(new Object[]{"", condition.toString()});
                }
            }
            ArrayList schedules = new ArrayList(job.getSchedules());
            if (!summary || !schedules.isEmpty()) {
                table.addRow(new Object[]{Localise.format((String)"Schedules"), schedules.isEmpty() ? "" : CommandExecutor.toString((Schedule)schedules.remove(0), job.getTimeZone())});
                for (Schedule schedule : schedules) {
                    table.addRow(new Object[]{"", CommandExecutor.toString(schedule, job.getTimeZone())});
                }
            }
            PropertyList propertyList = new PropertyList(name, this.connection.getACLValidator());
            propertyList.setDefaultType(job.getDefaultPropertyType());
            propertyList.setSupportedTypes((Collection)job.getPropertyTypes());
            propertyList.addSupportedType(Property.Type.SYSTEM);
            propertyList.addSupportedType(Property.Type.UNSET);
            propertyList.addProperties(job.getProperties());
            propertyList.addProperties(this.getGroupProperties(name));
            if (summary && propertyList.isEmpty()) continue;
            table.startRow();
            table.addValue((Object)Localise.format((String)"Properties"));
            if (propertyList.isEmpty()) continue;
            TableFormatter propertiesTable = propertyList.asTable(!summary);
            propertiesTable.alignColumn(0, TableFormatter.Column.Align.LEFT);
            propertiesTable.setIndent("");
            Iterator properties = propertiesTable.iterator();
            if (properties.hasNext()) {
                table.addValue(properties.next(), false);
            }
            while (properties.hasNext()) {
                table.startRow().addValue((Object)"").addValue(properties.next());
            }
        }
        this.output(table);
    }

    private void addRow(TableFormatter table, String name, Object value, boolean excludeEmpty) {
        String val;
        String string = val = value != null ? value.toString() : null;
        if (!excludeEmpty || !StringUtils.isNullOrEmpty((String)val)) {
            table.addRow(new Object[]{name, val});
        }
    }

    private void responseJobStatus(JobStatusQuery.Response response) {
        TableFormatter table = new TableFormatter();
        table.addColumns(new String[]{Localise.format((String)"Job"), Localise.format((String)"State"), Localise.format((String)"Result")});
        if (!this.summaryOutput) {
            table.addColumns(new String[]{Localise.format((String)"Time"), Localise.format((String)"Code"), Localise.format((String)"Message"), Localise.format((String)"Next Execution")});
            table.alignColumn(Localise.format((String)"Code"), TableFormatter.Column.Align.RIGHT);
            table.alignColumn(Localise.format((String)"Time"), TableFormatter.Column.Align.RIGHT);
            table.alignColumn(Localise.format((String)"Next Execution"), TableFormatter.Column.Align.RIGHT);
        }
        for (Status status : response.getStatuses()) {
            table.startRow();
            table.addValue((Object)status.getName());
            table.addValue((Object)StringUtils.capitalise((Object)status.getState()));
            table.addValue((Object)StringUtils.capitalise((Object)status.getResult()));
            if (this.summaryOutput) continue;
            table.addValue((Object)TimeUtils.format((long)status.getTimestamp(), (TimeZone)this.timeZone));
            table.addValue((Object)status.getExitValue());
            table.addValue((Object)status.getMessage());
            long l = status.getNextExecution();
            table.addValue((Object)(l >= 0L ? TimeUtils.format((long)l, (TimeZone)this.timeZone) : "-"));
        }
        this.output(table);
    }

    private void responseJobHistory(JobHistoryQuery.Response response) {
        boolean wildcard = response.getName().isWildcard();
        TableFormatter table = new TableFormatter();
        if (!this.summaryOutput) {
            table.addColumn(Localise.format((String)"Timestamp"));
        }
        if (wildcard) {
            table.addColumn(Localise.format((String)"Name"));
        }
        table.addColumns(new String[]{Localise.format((String)"Start time"), Localise.format((String)"Run time")});
        table.alignColumn(Localise.format((String)"Run time"), TableFormatter.Column.Align.RIGHT);
        if (!this.summaryOutput) {
            table.addColumn(Localise.format((String)"Trigger"));
        }
        table.addColumn(Localise.format((String)"Result"));
        table.alignColumn(Localise.format((String)"Result"), TableFormatter.Column.Align.RIGHT);
        if (!this.summaryOutput) {
            table.addColumns(new String[]{Localise.format((String)"Code"), Localise.format((String)"Output"), Localise.format((String)"Message")});
            table.alignColumn(Localise.format((String)"Code"), TableFormatter.Column.Align.RIGHT);
            table.alignColumn(Localise.format((String)"Output"), TableFormatter.Column.Align.RIGHT);
        }
        for (ConsolidatedStatus status : StatusConsolidator.consolidate((List)response.getStatuses())) {
            if (status.getResult() == Status.Result.UNKNOWN || !this.jobHistoryFilter.matches((Status)status)) continue;
            table.startRow();
            if (!this.summaryOutput) {
                table.addValue((Object)status.getTimestamp());
            }
            if (wildcard) {
                table.addValue((Object)status.getName());
            }
            table.addValue((Object)TimeUtils.format((long)status.getTimestamp(), (TimeZone)this.timeZone, (!this.summaryOutput ? 1 : 0) != 0));
            table.addValue((Object)TimeUtils.formatDuration((long)status.getRunTime(), (!this.summaryOutput ? 1 : 0) != 0));
            if (!this.summaryOutput) {
                ArrayList<String> triggers = new ArrayList<String>();
                for (Trigger trigger : status.getTriggers()) {
                    triggers.add(trigger.getText());
                }
                table.addValue((Object)StringUtils.join((String)"\n", triggers));
            }
            table.addValue((Object)status.getResult().getLabel());
            if (this.summaryOutput) continue;
            table.addValue((Object)status.getExitValue());
            table.addValue((Object)BooleanUtils.toYesNo((boolean)status.hasOutput()));
            table.addValue((Object)status.getMessage());
        }
        this.output(table);
    }

    private void responseJobOutput(JobOutputQuery.Response response) {
        if (response.hasOutput()) {
            this.output(response.getOutput().toString(), new Object[0]);
        }
    }

    private void responseJobDiff(JobQuery.Response response) {
        Iterator jobs = response.getJobs().iterator();
        if (jobs.hasNext()) {
            Job job1 = (Job)jobs.next();
            boolean showSecrets = this.connection.hasPermission(job1.getName(), ACL.Permission.WRITE);
            while (jobs.hasNext()) {
                Job job2 = (Job)jobs.next();
                this.outputDiff(job1.diff(job2, showSecrets));
                job1 = job2;
            }
        }
    }

    private void outputDiff(JSONObject diff) {
        TableFormatter table = new TableFormatter(false);
        for (String name : diff.keySet()) {
            String s;
            table.addRow(new Object[]{StringUtils.capitalise((Object)name)});
            JSONArray delta = diff.getJSONArray(name);
            if (delta.get(0) instanceof String) {
                String before = (String)delta.get(0);
                String after = (String)delta.get(1);
                if (before.length() < 20 && after.length() < 20) {
                    table.startRow().addValue((Object)String.format("  %s -> %s", before, after), false);
                    continue;
                }
                if (!StringUtils.isNullOrEmpty((String)before)) {
                    table.startRow().addValue((Object)String.format("  - %s", before), false);
                }
                if (StringUtils.isNullOrEmpty((String)after)) continue;
                table.startRow().addValue((Object)String.format("  + %s", after), false);
                continue;
            }
            JSONArray before = delta.getJSONArray(0);
            for (int i = 0; i < before.length(); ++i) {
                s = before.getString(i);
                if (StringUtils.isNullOrEmpty((String)s)) continue;
                table.startRow().addValue((Object)String.format("  - %s", s), false);
            }
            JSONArray after = delta.getJSONArray(1);
            for (int i = 0; i < after.length(); ++i) {
                s = after.getString(i);
                if (StringUtils.isNullOrEmpty((String)s)) continue;
                table.startRow().addValue((Object)String.format("  + %s", s), false);
            }
        }
        this.output(table);
    }

    private void responseLicenseQuery(LicenseQuery.Response response) {
        if (response.getType() == LicenseQuery.Type.INSTANCE) {
            this.output(response.getInstance(), new Object[0]);
            return;
        }
        License license = response.getLicense();
        if (license == null) {
            this.outputError("No %s license", response.getType().toString().toLowerCase());
            return;
        }
        this.output(license.toTable());
    }

    private void responseLimitQuery(LimitQuery.Response response) {
        Limit limit = response.getLimit();
        boolean hideResetTime = limit == null || limit.getMaxExecutions() == Integer.MAX_VALUE;
        TableFormatter table = this.summaryOutput || hideResetTime ? new TableFormatter() : new TableFormatter(new String[]{"", "", Localise.format((String)"Counter reset time")});
        table.alignColumn(1, TableFormatter.Column.Align.RIGHT);
        if (limit != null) {
            table.addRow(new Object[]{Localise.format((String)"maxCalendars"), Limit.format((long)limit.getCalendars(), (long)limit.getMaxCalendars())});
            table.addRow(new Object[]{Localise.format((String)"maxJobs"), Limit.format((long)limit.getJobs(), (long)limit.getMaxJobs())});
            if (limit.getMaxExecutions() > 0L) {
                if (this.summaryOutput || hideResetTime) {
                    table.addRow(new Object[]{Localise.format((String)"maxExecutions"), Limit.format((long)limit.getExecutions(), (long)limit.getMaxExecutions())});
                } else {
                    table.addRow(new Object[]{Localise.format((String)"maxExecutions"), Limit.format((long)limit.getExecutions(), (long)limit.getMaxExecutions()), new Date(limit.getExecutionsEpoch())});
                }
                if (!this.summaryOutput) {
                    long daySeconds = Period.Unit.DAY.getUnitInSeconds();
                    long l = daySeconds - (limit.getExecutionsEpoch() - System.currentTimeMillis()) / 1000L;
                    double hours = (double)l / (double)daySeconds * 24.0;
                    double executions = (double)limit.getExecutions() / hours;
                    if (executions < 1.0) {
                        table.addRow(new Object[]{Localise.format((String)"maxExecutionsHour"), String.format("%.2f/-", executions)});
                    } else if (executions < 10.0) {
                        table.addRow(new Object[]{Localise.format((String)"maxExecutionsHour"), String.format("%.1f/-", executions)});
                    } else {
                        table.addRow(new Object[]{Localise.format((String)"maxExecutionsHour"), String.format("%d/-", (long)executions)});
                    }
                }
            } else {
                table.addRow(new Object[]{Localise.format((String)"Jobs/day"), Localise.format((String)"*")});
            }
        } else {
            table.addRow(new Object[]{Localise.format((String)"Calendars"), Localise.format((String)"*")});
            table.addRow(new Object[]{Localise.format((String)"Jobs"), Localise.format((String)"*")});
            table.addRow(new Object[]{Localise.format((String)"Jobs/day"), Localise.format((String)"*")});
        }
        this.output(table);
    }

    private void responsePropertyQuery(PropertyQuery.Response response) {
        PropertyList propertyList = new PropertyList(response.getName(), this.connection.getACLValidator());
        propertyList.addProperties((Collection)response.getProperties(0));
        this.output(propertyList.asTable());
    }

    private void responsePropertyDiff(PropertyQuery.Response response) {
        Iterator properties = response.getProperties().iterator();
        if (properties.hasNext()) {
            boolean showSecrets = this.connection.hasPermission(response.getName(), ACL.Permission.WRITE);
            TableFormatter table = new TableFormatter(false);
            TreeSet properties1 = new TreeSet((Collection)properties.next());
            while (properties.hasNext()) {
                TreeSet properties2 = new TreeSet((Collection)properties.next());
                if (properties1.equals(properties2)) continue;
                table.clear();
                for (Property property : properties1) {
                    if (properties2.contains(property)) continue;
                    table.startRow().addValue((Object)String.format("- %s", property.toString(showSecrets)), false);
                }
                for (Property property : properties2) {
                    if (properties1.contains(property)) continue;
                    table.startRow().addValue((Object)String.format("+ %s", property.toString(showSecrets)), false);
                }
                this.output(table);
            }
        }
    }

    private void responseProtectedQuery(ProtectedQuery.Response response) {
        TableFormatter table = new TableFormatter();
        table.addColumns(new String[]{response.getType() == Protected.Type.HOST ? Localise.format((String)"Host") : Localise.format((String)"User")});
        for (Protected value : (List)response.getValues().get(0)) {
            table.addRow(new Object[]{value.getValue()});
        }
        this.output(table);
    }

    private void responseProtectedDiff(ProtectedQuery.Response response) {
        Iterator values = response.getValues().iterator();
        if (values.hasNext()) {
            TableFormatter table = new TableFormatter(false);
            TreeSet values1 = new TreeSet((Collection)values.next());
            while (values.hasNext()) {
                TreeSet values2 = new TreeSet((Collection)values.next());
                if (values1.equals(values2)) continue;
                table.clear();
                for (Protected value : values1) {
                    if (values2.contains(value)) continue;
                    table.startRow().addValue((Object)String.format("- %s", value.getValue()));
                }
                for (Protected value : values2) {
                    if (values1.contains(value)) continue;
                    table.startRow().addValue((Object)String.format("+ %s", value.getValue()));
                }
                this.output(table);
            }
        }
    }

    private void responseQueueQuery(QueueQuery.Response response) {
        TableFormatter table = new TableFormatter();
        table.alignColumns(TableFormatter.Column.Align.RIGHT);
        if (this.summaryOutput) {
            table.addColumns(new String[]{Localise.format((String)"Name"), Localise.format((String)"Messages")});
        } else {
            table.addColumns(new String[]{Localise.format((String)"Name"), Localise.format((String)"Messages"), Localise.format((String)"Received"), Localise.format((String)"Minimum age"), Localise.format((String)"Maximum age"), Localise.format((String)"Average age")});
        }
        table.alignColumn(Localise.format((String)"Name"), TableFormatter.Column.Align.LEFT);
        for (Queue queue : response.getQueues()) {
            table.startRow();
            table.addValue((Object)queue.getName());
            table.addValue((Object)queue.getPending());
            if (this.summaryOutput) continue;
            table.addValue((Object)queue.getReceived());
            table.addValue((Object)queue.getMinimumAge());
            table.addValue((Object)queue.getMaximumAge());
            table.addValue((Object)queue.getAverageAge());
        }
        this.output(table);
    }

    private void responseRoleQuery(RoleQuery.Response response) {
        TableFormatter table = new TableFormatter();
        table.addColumns(new String[]{Localise.format((String)"Role"), Localise.format((String)"Service"), Localise.format((String)"Description")});
        for (Role role : response.getRoles()) {
            table.addRow(new Object[]{role.getName(), role.getRoleType(), role.getDescription()});
        }
        this.output(table);
    }

    private void responseServerQuery(ServerQuery.Response response) {
        TableFormatter table = new TableFormatter();
        if (this.summaryOutput) {
            table.addColumns(new String[]{Localise.format((String)"Host"), Localise.format((String)"State")});
        } else {
            table.addColumns(new String[]{Localise.format((String)"Host"), Localise.format((String)"State"), Localise.format((String)"%s User", (Object[])new Object[]{"bc".toUpperCase()}), Localise.format((String)"OS User"), Localise.format((String)"Version"), Localise.format((String)"OS"), Localise.format((String)"Address"), Localise.format((String)"Connected/disconnected")});
            table.alignColumn(Localise.format((String)"Connected/disconnected"), TableFormatter.Column.Align.RIGHT);
        }
        table.alignColumn(Localise.format((String)"State"), TableFormatter.Column.Align.RIGHT);
        for (Connection server : new TreeSet(response.getServers())) {
            table.startRow();
            table.addValue((Object)server.getClientHostName());
            table.addValue((Object)StringUtils.capitalise((Object)server.getClientState()));
            if (this.summaryOutput) continue;
            table.addValue((Object)server.getClientUserName());
            table.addValue((Object)server.getOsUserName());
            table.addValue((Object)server.getClientVersion());
            table.addValue((Object)server.getOS());
            table.addValue((Object)server.getClientAddress());
            table.addValue((Object)TimeUtils.format((long)server.getUpdateTime(), (TimeZone)this.timeZone));
        }
        this.output(table);
    }

    private void responseClusterQuery(ClusterQuery.Response response) {
        JSONObject info = JSONUtils.filter((JSONObject)response.getInfo(), (Set)response.getFilters());
        if (info.length() > 0) {
            this.output(info.toString(2), new Object[0]);
        }
    }

    private void responseTopicQuery(TopicQuery.Response response) {
        TableFormatter table = new TableFormatter();
        table.alignColumns(TableFormatter.Column.Align.RIGHT);
        if (this.summaryOutput) {
            table.addColumns(new String[]{Localise.format((String)"Name"), Localise.format((String)"Messages")});
        } else {
            table.addColumns(new String[]{Localise.format((String)"Name"), Localise.format((String)"Messages"), Localise.format((String)"Received")});
        }
        table.alignColumn(Localise.format((String)"Name"), TableFormatter.Column.Align.LEFT);
        for (Topic topic : response.getTopics()) {
            table.startRow();
            table.addValue((Object)topic.getName());
            table.addValue((Object)topic.getPending());
            if (this.summaryOutput) continue;
            table.addValue((Object)topic.getReceived());
        }
        this.output(table);
    }

    private void responseUserQuery(UserQuery.Response response) {
        TableFormatter table = new TableFormatter();
        table.addColumns(new String[]{Localise.format((String)"User"), Localise.format((String)"Service"), Localise.format((String)"Description"), Localise.format((String)"Roles")});
        for (User user : response.getUsers()) {
            table.startRow();
            table.addValue((Object)user.getName());
            table.addValue((Object)user.getUserType());
            table.addValue((Object)user.getDescription());
            table.addValue((Object)StringUtils.join((String)" ", (String)" ", (String[])new String[]{StringUtils.join((String)" ", (Collection)user.getRoles()), Role.EVERYONE_NAME}));
        }
        this.output(table);
    }

    private void responseUserCommand(UserCommand.Response response) {
        switch (response.getAction()) {
            case CREATE: {
                this.output("User %s added", response.getName());
                break;
            }
            case DELETE: {
                this.output("User %s deleted", response.getName());
                break;
            }
            case UPDATE: {
                this.output("User %s updated", response.getName());
            }
        }
    }

    private void responseHostACLQuery(HostACLQuery.Response response) {
        TableFormatter table = new TableFormatter();
        table.addColumns(new String[]{Localise.format((String)"User/Role"), Localise.format((String)"Pattern")});
        for (HostACL acl : (List)response.getValues().get(0)) {
            table.addRow(new Object[]{acl.getUserRole(), acl.getPattern()});
        }
        this.output(table);
    }

    private void responseHostACLDiff(HostACLQuery.Response response) {
        Iterator hostACLs = response.getValues().iterator();
        if (hostACLs.hasNext()) {
            TableFormatter table = new TableFormatter(false);
            TreeSet hostACLS1 = new TreeSet((Collection)hostACLs.next());
            while (hostACLs.hasNext()) {
                TreeSet hostACLS2 = new TreeSet((Collection)hostACLs.next());
                if (hostACLS1.equals(hostACLS2)) continue;
                table.clear();
                for (HostACL hostACL : hostACLS1) {
                    if (hostACLS2.contains(hostACL)) continue;
                    table.startRow().addValue((Object)String.format("- %s", hostACL.toString()));
                }
                for (HostACL hostACL : hostACLS2) {
                    if (hostACLS1.contains(hostACL)) continue;
                    table.startRow().addValue((Object)String.format("+ %s", hostACL.toString()));
                }
                this.output(table);
            }
        }
    }

    private void responseServiceQuery(ServiceQuery.Response response) {
        String name = response.getName();
        if (!StringUtils.isNullOrEmpty((String)name)) {
            TableFormatter table = new TableFormatter();
            table.displayHeader(false);
            table.alignColumn(0, TableFormatter.Column.Align.RIGHT);
            String s = response.isConnected() ? Localise.format((String)"%1$s - connected %2$s", (Object[])new Object[]{name, TimeUtils.format((long)response.getConnected())}) : Localise.format((String)"%1$s - connecting", (Object[])new Object[]{name});
            table.addRow(new Object[]{Localise.format((String)"%1$s service", (Object[])new Object[]{response.getType().getSuffix()}), s});
            s = response.getDescription();
            if (!StringUtils.isNullOrEmpty((String)s)) {
                table.addRow(new Object[]{"", s});
            }
            if (!StringUtils.isNullOrEmpty((String)(s = response.getMessage()))) {
                table.addRow(new Object[]{"Error", s});
            }
            this.output(table);
        } else {
            this.output("No %1$s service configured", response.getType().getSuffix().toLowerCase());
        }
    }

    private void cronImport(Name root, String hostName, File name, TimeZone timeZone, boolean raw, boolean enable) {
        ArrayList<File> files = new ArrayList<File>();
        ArrayList jobs = new ArrayList();
        if (!name.exists()) {
            this.outputError("%s is not a file or directory", name);
            return;
        }
        if (name.isFile()) {
            files.add(name);
        } else {
            File[] fa = name.listFiles();
            if (fa != null) {
                for (File file : fa) {
                    if (!file.isFile() || file.getName().startsWith(".")) continue;
                    files.add(file);
                }
            }
        }
        boolean hasErrors = false;
        Import importer = new Import(this.connection, root, raw);
        for (File file : files) {
            try {
                jobs.addAll(importer.parse(file, hostName, timeZone));
            }
            catch (IOException e) {
                this.outputError("Error importing %s - %s", file, e.getMessage());
                hasErrors = true;
                continue;
            }
            if (!importer.hasErrors()) continue;
            this.outputError("Errors importing %s", file);
            for (Import.Error error : importer.getErrors()) {
                this.outputError("- " + error.toString(), new Object[0]);
            }
            hasErrors = true;
        }
        if (hasErrors) {
            return;
        }
        if (enable) {
            for (Job job : jobs) {
                if (job.canEnable()) {
                    job.setMode(Job.Mode.ENABLED);
                    continue;
                }
                this.outputError("Cannot enable %s - %s", job.getName(), job.canEnableReason());
            }
        }
        TableFormatter results = new TableFormatter(false);
        for (Job job : jobs) {
            ResultMessage response = this.executeCommand((CommandMessage)new JobCommand(job, JobCommand.Action.CREATE), false);
            if (response != null) {
                Result result = response.getResult();
                if (result.wasSuccess()) {
                    results.addRow(new Object[]{job.getName(), Localise.format((String)"created")});
                    continue;
                }
                results.addRow(new Object[]{job.getName(), Localise.format((String)"error"), result.getMessage()});
                continue;
            }
            results.addRow(new Object[]{job.getName(), Localise.format((String)"fatal"), Localise.format((String)"unexpected error")});
        }
        this.output(results);
    }

    private boolean confirmJobAction(Job job, Job.Action action) {
        if (!this.jobConfirmValidator.getJobConfirm(job).isConfirm()) {
            return true;
        }
        if (this.commandListener != null) {
            this.output(CommandOutput.Level.WARN, "Append 'confirm' to command to %s job.", action.toString().toLowerCase());
            return false;
        }
        while (true) {
            String response;
            if ((response = IOUtils.readLine((String)Localise.format((String)"%s job (Yes/No): ", (Object[])new Object[]{StringUtils.capitalise((Object)action.toString())})).trim()) == null) {
                continue;
            }
            switch (response.toLowerCase()) {
                case "yes": {
                    return true;
                }
                case "no": {
                    return false;
                }
            }
        }
    }

    private ACL getACL(Name name, String role, boolean exact) {
        List acls = ((ACLQuery.Response)this.executeCommand((CommandMessage)new ACLQuery(name))).getACLs(0);
        if (acls.size() > 0 && (!exact || ((ACL)acls.get(0)).getName().equals((Object)name))) {
            for (ACL acl : acls) {
                if (!acl.getUserRole().equals(role)) continue;
                return acl;
            }
        }
        return null;
    }

    private Job getJob(Name name) {
        List jobs = ((JobQuery.Response)this.executeCommand((CommandMessage)new JobQuery(name))).getJobs();
        if (jobs.size() != 1) {
            this.outputError("Job %s does not exist", name);
            return null;
        }
        return (Job)jobs.get(0);
    }

    private CommandJob getCommandJob(Name name) {
        Job job = this.getJob(name);
        if (job != null && !(job instanceof CommandJob)) {
            job = new CommandJob(job);
            job.setDefaults(new PropertyDefaults(this.connection, this.getTimeZone(), name));
        }
        return (CommandJob)job;
    }

    private ContainerJob getContainerJob(Name name) {
        Job job = this.getJob(name);
        if (job != null && !(job instanceof ContainerJob)) {
            job = new ContainerJob(job);
            job.setDefaults(new PropertyDefaults(this.connection, this.getTimeZone(), name));
        }
        return (ContainerJob)job;
    }

    private MailJob getMailJob(Name name) {
        Job job = this.getJob(name);
        if (job != null && !(job instanceof MailJob)) {
            job = new MailJob(job);
            job.setDefaults(new PropertyDefaults(this.connection, this.getTimeZone(), name));
        }
        return (MailJob)job;
    }

    private TriggerJob getTriggerJob(Name name) {
        Job job = this.getJob(name);
        if (job != null && !(job instanceof TriggerJob)) {
            job = new TriggerJob(job);
            ((TriggerJob)job).setDelay(null);
            job.setDefaults(new PropertyDefaults(this.connection, this.getTimeZone(), name));
        }
        return (TriggerJob)job;
    }

    private SQLJob getSQLJob(Name name) {
        Job job = this.getJob(name);
        if (job != null && !(job instanceof SQLJob)) {
            job = new SQLJob(job);
            job.setDefaults(new PropertyDefaults(this.connection, this.getTimeZone(), name));
        }
        return (SQLJob)job;
    }

    private URLJob getURLJob(Name name) {
        Job job = this.getJob(name);
        if (job != null && !(job instanceof URLJob)) {
            job = new URLJob(job);
            ((URLJob)job).setMethod(null);
            job.setDefaults(new PropertyDefaults(this.connection, this.getTimeZone(), name));
        }
        return (URLJob)job;
    }

    private Calendar getCalendar(Name name) {
        Calendar calendar = ((CalendarQuery.Response)this.executeCommand((CommandMessage)new CalendarQuery(name))).getCalendar();
        if (calendar == null) {
            this.outputError("Calendar %s does not exist", name);
        }
        return calendar;
    }

    private User getUser(String name) {
        if (name.equals(USER_SELF)) {
            return this.user;
        }
        User user = ((UserQuery.Response)this.executeCommand((CommandMessage)new UserQuery(name))).getUser();
        if (user == null) {
            this.outputError("User %s does not exist", name);
        }
        return user;
    }

    private Role getRole(String name, boolean includeUsers) {
        Role role = ((RoleQuery.Response)this.executeCommand((CommandMessage)new RoleQuery(name, includeUsers))).getRole();
        if (role == null) {
            if (includeUsers) {
                this.outputError("User/role %s does not exist", name);
            } else {
                this.outputError("Role %s does not exist", name);
            }
            return null;
        }
        return role;
    }

    private boolean isGroup(Name group) {
        return this.executeCommand((CommandMessage)new GroupQuery(group), false).getResult().wasSuccess();
    }

    private List<Property> getGroupProperties(Name group) {
        PropertyQuery.Response propertiesResponse = (PropertyQuery.Response)this.executeCommand((CommandMessage)new PropertyQuery(group, false));
        return propertiesResponse.getResult().wasSuccess() ? propertiesResponse.getProperties(0) : new ArrayList();
    }

    private Property getGroupProperty(Name group, String name) {
        for (Property property : this.getGroupProperties(group)) {
            if (!property.getName().equals(name)) continue;
            return property;
        }
        return null;
    }

    private boolean isGroupProperty(Name group, String name) {
        return this.getGroupProperty(group, name) != null;
    }

    private ResultMessage executeCommand(CommandMessage command) {
        return this.executeCommand(command, true);
    }

    private ResultMessage executeCommand(CommandMessage command, boolean outputErrors) {
        ResultMessage response = this.connection.sendReceive(command);
        if (outputErrors && !response.getResult().wasSuccess()) {
            this.outputError(response.getResult().getMessage(), new Object[0]);
        }
        return response;
    }

    private static List<String> getChangeIds(List<? extends ParserRuleContext> tokens) {
        return CommandExecutor.getChangeIds(tokens, "-1", "0");
    }

    private static List<String> getChangeIds(List<? extends ParserRuleContext> tokens, String default1, String default2) {
        ArrayList<String> changeIds = new ArrayList<String>(CommandExecutor.getStrings(tokens));
        if (changeIds.isEmpty()) {
            changeIds.add(default1);
            changeIds.add(default2);
        } else if (changeIds.size() == 1) {
            changeIds.add(default2);
        }
        return changeIds;
    }

    private static String getString(List<? extends ParserRuleContext> tokens) {
        return StringUtils.join((String)" ", CommandExecutor.getStrings(tokens));
    }

    private static List<String> getStrings(ParserRuleContext parseTree) {
        ArrayList<String> strings = new ArrayList<String>();
        for (ParseTree child : parseTree.children) {
            strings.add(child.getText());
        }
        return strings;
    }

    private static List<String> getStrings(List<? extends ParserRuleContext> tokens) {
        ArrayList<String> strings = new ArrayList<String>();
        for (ParserRuleContext parserRuleContext : tokens) {
            strings.add(parserRuleContext.getText());
        }
        return strings;
    }

    private Time parseTime(String value) {
        int minute;
        int hour;
        int second = 0;
        String[] values = value.split(":");
        if (values.length != 2 && values.length != 3) {
            this.outputError("Invalid time: %s", value);
            return null;
        }
        try {
            hour = Integer.parseInt(values[0]) % 24;
            minute = Integer.parseInt(values[1]) % 60;
            if (values.length == 3) {
                second = Integer.parseInt(values[2]) % 60;
            }
        }
        catch (NumberFormatException e) {
            this.outputError("Invalid time: %s", value);
            return null;
        }
        return new Time(hour, minute, second);
    }

    private static String toString(Schedule schedule, TimeZone timeZone) {
        if (schedule instanceof CronSchedule) {
            return StringUtils.upperCaseFirst((Object)(schedule.getType().toString().toLowerCase() + " - " + schedule.getDefinition(timeZone)));
        }
        return StringUtils.upperCaseFirst((Object)schedule.getDefinition(timeZone));
    }

    public CommandOutput output(String message, boolean localise) {
        if (localise) {
            return this.output(message, new Object[0]);
        }
        return this.output(new CommandOutput(CommandOutput.Level.INFO, message, null), true);
    }

    public CommandOutput output(String message, Object ... args) {
        return this.output(CommandOutput.Level.INFO, message, args);
    }

    public CommandOutput output(TableFormatter table) {
        return this.output(CommandOutput.Level.INFO, table.toString());
    }

    public CommandOutput outputError(String message, Object ... args) {
        return this.output(CommandOutput.Level.ERROR, message, args);
    }

    public CommandOutput outputError(Exception exception, String message, Object ... args) {
        return this.output(CommandOutput.Level.ERROR, exception, message, args);
    }

    public CommandOutput output(CommandOutput.Level level, String message) {
        return this.output(new CommandOutput(level, message, null), level == CommandOutput.Level.INFO);
    }

    public CommandOutput output(CommandOutput.Level level, String message, Object ... args) {
        return this.output(new CommandOutput(level, Localise.format((String)message, (Object[])args), null), level == CommandOutput.Level.INFO);
    }

    public CommandOutput output(CommandOutput.Level level, Exception exception, String message, Object ... args) {
        return this.output(new CommandOutput(level, Localise.format((String)message, (Object[])args), exception), level == CommandOutput.Level.INFO);
    }

    public CommandOutput output(CommandOutput output, boolean pad) {
        return this.output(output, pad, pad);
    }

    public CommandOutput output(CommandOutput output, boolean padStart, boolean padEnd) {
        if (this.commandListener != null) {
            this.commandListener.commandOutput(output);
        } else {
            String message = output.getOutput();
            if (!StringUtils.isNullOrEmpty((String)message)) {
                if (this.rawOutput) {
                    for (String line : message.split("\\R")) {
                        System.out.println(StringUtils.stripPrefix((String)line, (String)"  "));
                    }
                } else if (padStart || padEnd) {
                    if (padStart) {
                        System.out.println();
                    }
                    System.out.println(message);
                    if (padEnd && !message.endsWith("\n")) {
                        System.out.println();
                    }
                } else if (message.endsWith("\n")) {
                    System.out.print(message);
                } else {
                    System.out.println(message);
                }
            }
        }
        if (output.hasException()) {
            logger.debug(output.getOutput(), (Throwable)output.getException());
        }
        this.lastOutput = output;
        return output;
    }

    static {
        tagLables.put("acl", "ACL");
        tagLables.put("acls", "ACL");
        tagLables.put("cal", "calendar");
        tagLables.put("file", "file");
        tagLables.put("ics", "iCalendar");
        tagLables.put("job", "job");
        tagLables.put("property", "property");
        tagLables.put("properties", "property");
        TableFormatter.setDefaultColumnSeparator((String)"  ");
        TableFormatter.setDefaultHeaderSeparator((char)'-');
        TableFormatter.setDefaultIndent((String)"  ");
    }

    private class CommandStack {
        private final Pattern nthCommandPattern = Pattern.compile("^!-([1-9][0-9]*)$");
        private final Pattern commandPattern = Pattern.compile("^!(.+)$");
        private final Pattern historyPattern = Pattern.compile("^history( +([1-9][0-9]*))?$");
        private final Pattern helpPattern = Pattern.compile("^help");
        private final Pattern hintPattern = Pattern.compile("^(\\S.*?)\\s+\\?$");
        private final Pattern passwordCommandPattern = Pattern.compile("(user\\s+password(\\s+\\S+)?\\s+)(\\S+)");
        private final int maxSize;
        private final LinkedList<String> commands = new LinkedList();

        public CommandStack(int maxSize) {
            this.maxSize = maxSize;
        }

        public void add(String command) {
            if (!this.commands.isEmpty() && command.equals(this.commands.getFirst())) {
                return;
            }
            this.commands.addFirst(this.maskPassword(command));
            if (this.commands.size() > this.maxSize) {
                this.commands.removeLast();
            }
        }

        public String maskPassword(String command) {
            Matcher m = this.passwordCommandPattern.matcher(command);
            return m.matches() ? m.group(1) + CommandExecutor.PASSWORD_MASK : command;
        }

        public String get(String expression) {
            if (expression.equals("!!")) {
                if (this.commands.size() > 0) {
                    return this.commands.getFirst();
                }
                return null;
            }
            Matcher m = this.nthCommandPattern.matcher(expression);
            if (m.matches()) {
                int i = Integer.parseInt(m.group(1)) - 1;
                if (i < this.commands.size()) {
                    return this.commands.get(i);
                }
                return null;
            }
            m = this.commandPattern.matcher(expression);
            if (m.matches()) {
                String s = m.group(1);
                for (String command : this.commands) {
                    if (!command.startsWith(s)) continue;
                    return command;
                }
                return null;
            }
            m = this.hintPattern.matcher(expression = expression.replace("$$", CommandExecutor.this.currentName));
            if (m.matches() && !this.helpPattern.matcher(expression).matches()) {
                return "? " + m.group(1);
            }
            return expression;
        }

        public boolean historyCommand(String expression) {
            Matcher m = this.historyPattern.matcher(expression);
            if (!m.matches()) {
                return false;
            }
            int i = m.group(2) != null ? Integer.parseInt(m.group(2)) : this.commands.size();
            i = Math.min(i, this.commands.size());
            TableFormatter table = new TableFormatter(false);
            while (i-- > 0) {
                table.addRow(new Object[]{this.commands.get(i)});
            }
            if (table.getRowCount() > 0) {
                CommandExecutor.this.output(table);
            }
            this.add(expression);
            return true;
        }
    }

    private class JobStatusListener {
        private IMap<Name, Status> statuses = null;
        private String entryAddedListener;
        private String entryUpdatedListener;
        private long expiry = 0L;
        private boolean filterNames = false;
        private Filter nameFilter = null;
        private boolean filterStatus = false;
        private Status.Filter statusFilter = new Status.Filter();
        private final int dateRows = (Integer)Configs.get((String)"beyondcron.status.subscribe.date.rows");
        private int dayOfYear = -1;
        private int count = this.dateRows;

        private JobStatusListener() {
        }

        private void reset() {
            this.expiry = 0L;
            this.filterNames = false;
            this.nameFilter = null;
            this.filterStatus = false;
            this.statusFilter = null;
        }

        public JobStatusListener setStatusFilter(Status.Filter filter) {
            this.filterStatus = !filter.isEmpty();
            this.statusFilter = filter;
            return this;
        }

        public JobStatusListener setExpiry(long expiry) {
            this.expiry = expiry;
            return this;
        }

        public void start() {
            this.start(null);
        }

        public void start(Filter nameFilter) {
            this.filterNames = nameFilter != null;
            this.nameFilter = nameFilter;
            if (this.statuses == null) {
                this.statuses = Hazelcast.getJobStatusMap((HazelcastInstance)CommandExecutor.this.connection.getHazelcast());
                this.entryAddedListener = this.statuses.addEntryListener((MapListener)((EntryAddedListener)event -> this.statusReceived((Status)event.getValue())), true);
                this.entryUpdatedListener = this.statuses.addEntryListener((MapListener)((EntryUpdatedListener)event -> this.statusReceived((Status)event.getValue())), true);
            }
        }

        public void stop() {
            if (this.statuses != null) {
                this.statuses.removeEntryListener(this.entryAddedListener);
                this.statuses.removeEntryListener(this.entryUpdatedListener);
                this.statuses = null;
            }
            this.reset();
        }

        public synchronized void statusReceived(Status status) {
            if (this.expiry > 0L && this.expiry < System.currentTimeMillis()) {
                this.output(CommandOutput.Level.INFO, Localise.format((String)"job status subscription completed"));
                this.stop();
                return;
            }
            if (this.filterNames && !this.nameFilter.matches(status.getName().toString())) {
                return;
            }
            if (this.filterStatus && !this.statusFilter.matches(status)) {
                return;
            }
            StringBuilder sb = new StringBuilder();
            ZonedDateTime date = Instant.ofEpochMilli(status.getTimestamp()).atZone(CommandExecutor.this.zoneId);
            if (this.dayOfYear != date.getDayOfYear() || this.count++ > this.dateRows) {
                this.output(CommandOutput.Level.INFO, date.format(CommandExecutor.this.dateFormatter));
                this.dayOfYear = date.getDayOfYear();
                this.count = 0;
            }
            if (status.isActive()) {
                if (status.getResult() == Status.Result.UNKNOWN) {
                    sb.append(String.format(" %1$s %2$9s %3$s", date.format(CommandExecutor.this.timeFormatter), status.getState().getLabel(), status.getName()));
                } else {
                    sb.append(String.format(" %1$s %2$9s %3$s (%4$s) %5$s %6$s", date.format(CommandExecutor.this.timeFormatter), status.getState().getLabel(), status.getName(), status.getExitValue(), status.getResult().getLabel(), status.getMessage() != null ? status.getMessage() : ""));
                }
            } else {
                sb.append(String.format(" %1$s %2$9s %3$s (%4$d) %5$s", date.format(CommandExecutor.this.timeFormatter), status.getResult().getLabel(), status.getName(), status.getExitValue(), status.getMessage() != null ? status.getMessage() : ""));
            }
            this.output(status.isInactive() && status.getResult() != Status.Result.SUCCESS ? CommandOutput.Level.ERROR : CommandOutput.Level.INFO, sb.toString());
        }

        private void output(CommandOutput.Level level, String message) {
            CommandExecutor.this.output(new CommandOutput(level, message).addStyle("bc-status"), false);
        }
    }

    private class CommandParser
    extends CommandsBaseListener
    implements ANTLRErrorListener {
        CommandsBaseListener listener;
        CommandsParser parser;
        UsageFormatter usage;
        Message command;
        int errors;

        public CommandParser(CommandsBaseListener listener) throws IOException {
            this.listener = listener;
            this.usage = new UsageFormatter((Object)this);
            this.parser = new CommandsParser(null);
            this.parser.setTrimParseTree(true);
            this.parser.removeErrorListener((ANTLRErrorListener)ConsoleErrorListener.INSTANCE);
            this.parser.addParseListener(this);
            this.parser.addErrorListener(this);
        }

        private Filter getPathFilter(String pattern) {
            String group = CommandExecutor.this.currentGroup.getPath();
            if (pattern.length() < 1) {
                if (group.length() < 1) {
                    return new Filter();
                }
                if (group.length() > 1) {
                    return new Filter(group + "/", Filter.Type.STARTS_WITH);
                }
                return new Filter(group, Filter.Type.STARTS_WITH);
            }
            String regex = pattern.startsWith("/") ? "^" + pattern : (pattern.startsWith("^") ? "^" + group + "/" + pattern.substring(1) : group + "/.*" + pattern);
            if (!regex.endsWith("$") && !regex.endsWith(".*")) {
                regex = regex + ".*";
            }
            return new Filter(regex.replaceAll("//", "/"), Filter.Type.REGEX);
        }

        private Name getName(ParserRuleContext name) {
            return this.getName(name, true);
        }

        private Name getName(ParserRuleContext name, boolean saveCurrent) {
            String value = name.getText();
            if (saveCurrent) {
                CommandExecutor.this.currentName = value;
            }
            return NameUtils.getCanonicalName((Name)(value.startsWith("/") ? Name.parse((String)value) : Name.parse((Name)CommandExecutor.this.currentGroup, (String[])new String[]{value})));
        }

        public Message parse(String commandLine) {
            this.command = null;
            this.errors = 0;
            ANTLRInputStream input = new ANTLRInputStream(commandLine);
            CommandsLexer lexer = new CommandsLexer((CharStream)input);
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            this.parser.setInputStream((IntStream)tokens);
            this.parser.command();
            return this.errors == 0 ? this.command : null;
        }

        public boolean wasError() {
            return this.errors != 0;
        }

        @Override
        @Usage(name="acl changes", args="<name>", description="List changes to a specific acl.")
        public void exitAclChanges(CommandsParser.AclChangesContext ctx) {
            if (this.wasError()) {
                return;
            }
            CommandExecutor.this.summaryOutput = true;
            this.command = new ChangeQuery(this.getName(ctx.uri()), ChangeQuery.Type.ACLS);
        }

        @Override
        @Usage(name="acl diff", args="<name> [<change> [<change>]]", description="Show the difference between two versions of an acl")
        public void exitAclDiff(CommandsParser.AclDiffContext ctx) {
            if (this.wasError()) {
                return;
            }
            this.command = new ACLQuery(this.getName(ctx.uri()), CommandExecutor.getChangeIds(ctx.token()));
        }

        @Override
        @Usage(name="acl list", args="[self] [<name>]", description="list all acls or acls for a specific user and/or group.")
        public void exitAclList(CommandsParser.AclListContext ctx) {
            if (this.wasError()) {
                return;
            }
            ACLQuery query = new ACLQuery();
            if (ctx.self() != null) {
                query.setUserName(CommandExecutor.this.user.getName());
            }
            if (ctx.uri() != null) {
                query.setName(this.getName(ctx.uri()));
            }
            this.command = query;
        }

        @Override
        @Usage(name="acl list", args="<name> <change>", description="List details of an acl for specific change.")
        public void exitAclListChange(CommandsParser.AclListChangeContext ctx) {
            if (this.wasError()) {
                return;
            }
            ACLQuery query = new ACLQuery();
            query.setName(this.getName(ctx.uri()));
            query.addChangeId(ctx.token().getText());
            this.command = query;
        }

        @Override
        @Usage(name="acl set", args="<name> <user/role> (read|execute|enable|write|admin) ...", description="Add/update a user/role acl on the specified name.")
        public void exitAclSet(CommandsParser.AclSetContext ctx) {
            if (this.wasError()) {
                return;
            }
            Name name = this.getName(ctx.uri());
            String role = ctx.role().getText();
            ACL acl = new ACL(name, role, new ACL.Permission[0]);
            if (!role.equals(everyoneRoleName) && CommandExecutor.this.getRole(role, true) == null) {
                return;
            }
            for (int i = 3; i < ctx.getChildCount(); ++i) {
                String s = ctx.getChild(i).getText();
                boolean plus = s.endsWith("+");
                if (plus) {
                    s = s.substring(0, s.length() - 1);
                }
                int perms = ACL.Permission.valueOf((String)s.toUpperCase()).getValue();
                if (plus) {
                    perms += perms - 1;
                }
                acl.addPermissions(perms);
            }
            this.command = new ACLCommand(acl, CommandExecutor.this.getACL(name, role, true) != null ? ACLCommand.Action.UPDATE : ACLCommand.Action.CREATE);
        }

        @Override
        @Usage(name="acl delete", args="<name> [<user/role>]", description="Delete an acl or an acls user/role from the specified name.")
        public void exitAclDelete(CommandsParser.AclDeleteContext ctx) {
            if (this.wasError()) {
                return;
            }
            CommandsParser.RoleContext role = ctx.role();
            ACL acl = new ACL(this.getName(ctx.uri()), role != null ? ctx.role().getText() : "", new ACL.Permission[0]);
            this.command = new ACLCommand(acl, ACLCommand.Action.DELETE);
        }

        @Override
        @Usage(name="agent list", args="[full] [<filter>]", description="List details of all or specific agents.")
        public void exitAgentList(CommandsParser.AgentListContext ctx) {
            if (this.wasError()) {
                return;
            }
            AgentQuery query = new AgentQuery();
            if (ctx.word() != null) {
                query.setFilter(new Filter(ctx.word().getText(), Filter.Type.CONTAINS));
            }
            CommandExecutor.this.summaryOutput = ctx.full() == null;
            this.command = query;
        }

        @Override
        @Usage(name="announce", args="(info|warn|error) <message>", description="Make an announcement to all users")
        public void exitAnnouncement(CommandsParser.AnnouncementContext ctx) {
            if (this.wasError()) {
                return;
            }
            this.command = new AnnouncementCommand(CommandExecutor.getString(ctx.word()), Announcement.Level.valueOf((String)this.getChild(ctx, 0).toUpperCase()));
        }

        @Override
        @Usage(name="calendar list", args="[<filter>]", description="List summary details of all calendars, or specific calendars.")
        public void exitCalendarList(CommandsParser.CalendarListContext ctx) {
            if (this.wasError()) {
                return;
            }
            CalendarQuery query = new CalendarQuery();
            if (ctx.uri() != null) {
                query.setFilter(new Filter(ctx.uri().getText(), Filter.Type.CONTAINS));
            } else {
                query.setFilter(this.getPathFilter(""));
            }
            CommandExecutor.this.summaryOutput = true;
            this.command = query;
        }

        @Override
        @Usage(name="calendar show", args="<name> [<change>]", description="Show the details of a calendar, or calendar change.")
        public void exitCalendarShow(CommandsParser.CalendarShowContext ctx) {
            if (this.wasError()) {
                return;
            }
            CalendarQuery query = new CalendarQuery();
            query.setFilter(new Filter(this.getName(ctx.uri())));
            if (ctx.token() != null) {
                query.addChangeId(ctx.token().getText());
            }
            CommandExecutor.this.summaryOutput = false;
            this.command = query;
        }

        @Override
        @Usage(name="calendar jobs", args="<name>", description="List jobs that reference a calendar.")
        public void exitCalendarJobs(CommandsParser.CalendarJobsContext ctx) {
            if (this.wasError()) {
                return;
            }
            this.command = new CalendarJobsQuery(this.getName(ctx.uri()));
        }

        @Override
        @Usage(name="calendar add", args="<name> [<description>]", description="Add/create the specified calendar.")
        public void exitCalendarAdd(CommandsParser.CalendarAddContext ctx) {
            if (this.wasError()) {
                return;
            }
            Calendar calendar = new Calendar(this.getName(ctx.uri()));
            if (ctx.token().size() > 0) {
                calendar.setDescription(CommandExecutor.getString(ctx.token()));
            }
            this.command = new CalendarCommand(calendar, CalendarCommand.Action.CREATE);
        }

        @Override
        @Usage(name="calendar copy", args="<name> <name>", description="Copy the specified calendar")
        public void exitCalendarCopy(CommandsParser.CalendarCopyContext ctx) {
            if (this.wasError()) {
                return;
            }
            Calendar calendar = CommandExecutor.this.getCalendar(this.getName(ctx.uri(0)));
            if (calendar != null) {
                ProtoCalendar.Calendar.Builder builder = calendar.toProto();
                builder.setName(this.getName(ctx.uri(1), false).toProto());
                try {
                    this.command = new CalendarCommand(new Calendar().fromProto(builder.build().toByteArray()), CalendarCommand.Action.CREATE);
                }
                catch (InvalidProtocolBufferException e) {
                    this.parseError(Localise.format((String)"Unexpected error copying calendar: %s", (Object[])new Object[]{e.getMessage()}), new Object[0]);
                }
            }
        }

        @Override
        @Usage(name="calendar changes", args="<nam>", description="List changes to a specific calendar.")
        public void exitCalendarChanges(CommandsParser.CalendarChangesContext ctx) {
            if (this.wasError()) {
                return;
            }
            CommandExecutor.this.summaryOutput = true;
            this.command = new ChangeQuery(this.getName(ctx.uri()), ChangeQuery.Type.CALENDAR);
        }

        @Override
        @Usage(name="calendar diff", args="<name> [<change> [<change>]]", description="Show the difference between two versions of a calendar")
        public void exitCalendarDiff(CommandsParser.CalendarDiffContext ctx) {
            if (this.wasError()) {
                return;
            }
            this.command = new CalendarQuery(this.getName(ctx.uri()), CommandExecutor.getChangeIds(ctx.token()));
        }

        @Override
        @Usage(name="calendar delete", args="<name>", description="Delete the specified calendar.")
        public void exitCalendarDelete(CommandsParser.CalendarDeleteContext ctx) {
            if (this.wasError()) {
                return;
            }
            this.command = new CalendarCommand(this.getName(ctx.uri()), CalendarCommand.Action.DELETE);
        }

        @Override
        @Usage(name="calendar description", args="<name> [<description>]", description="Change the specified calendars description.")
        public void exitCalendarDescription(CommandsParser.CalendarDescriptionContext ctx) {
            if (this.wasError()) {
                return;
            }
            Calendar calendar = CommandExecutor.this.getCalendar(this.getName(ctx.uri()));
            if (calendar != null) {
                calendar.setDescription(CommandExecutor.getString(ctx.token()));
                this.command = new CalendarCommand(calendar, CalendarCommand.Action.UPDATE);
            }
        }

        @Override
        @Usage(name="calendar", args="(include|exclude) (add|delete) <name> <icalendar> ...", description="Add/delete one or more inclusive or exclusive calendars.")
        public void exitCalendarIcalendar(CommandsParser.CalendarIcalendarContext ctx) {
            if (this.wasError()) {
                return;
            }
            List<CommandsParser.UriContext> uris = ctx.uri();
            Calendar calendar = CommandExecutor.this.getCalendar(this.getName(uris.get(0)));
            if (calendar == null) {
                return;
            }
            uris.remove(0);
            ArrayList<URI> l = new ArrayList<URI>();
            for (CommandsParser.UriContext uri : uris) {
                l.add(NetUtils.parseURI((String)uri.getText()));
            }
            boolean include = this.childEquals(ctx, 0, "include");
            boolean add = this.childEquals(ctx, 1, "add");
            if (add) {
                if (include) {
                    for (URI uri : l) {
                        calendar.addInclusiveCalendar(uri);
                    }
                } else {
                    for (URI uri : l) {
                        calendar.addExclusiveCalendar(uri);
                    }
                }
            } else if (include) {
                for (URI uri : l) {
                    calendar.removeInclusiveCalendar(uri);
                }
            } else {
                for (URI uri : l) {
                    calendar.removeExclusiveCalendar(uri);
                }
            }
            this.command = new CalendarCommand(calendar, CalendarCommand.Action.UPDATE);
        }

        @Override
        @Usage(name="calendar refresh", args="[<name>]", description="Refresh all calendars or a specific calendar, by ensuring that their underlying icalendars are up to date.")
        public void exitCalendarRefresh(CommandsParser.CalendarRefreshContext ctx) {
            if (this.wasError()) {
                return;
            }
            Name name = ctx.uri() != null ? this.getName(ctx.uri()) : Calendar.ALL_CALENDARS;
            this.command = new CalendarCommand(name, CalendarCommand.Action.REFRESH);
        }

        @Override
        @Usage(name="change list", args="[last <int>? (seconds|minutes|hours|days)]", description="List the BeyondCron data change history")
        public void exitChangeList(CommandsParser.ChangeListContext ctx) {
            Period.Unit unit;
            if (this.wasError()) {
                return;
            }
            List<String> tokens = CommandExecutor.getStrings(ctx);
            int len = tokens.size();
            int duration = -1;
            if (len > 1) {
                try {
                    duration = Integer.parseInt(ctx.NUMBER().getText()) * -1;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                unit = Period.Unit.valueOf((String)StringUtils.singular((String)tokens.get(--len).toUpperCase()));
            } else {
                unit = Period.Unit.DAY;
            }
            GregorianCalendar calendar = new GregorianCalendar();
            switch (unit) {
                case SECOND: {
                    calendar.add(13, duration);
                    break;
                }
                case MINUTE: {
                    calendar.add(12, duration);
                    break;
                }
                case HOUR: {
                    calendar.add(10, duration);
                    break;
                }
                case DAY: {
                    calendar.add(6, duration);
                    break;
                }
                case WEEK: {
                    calendar.add(3, duration);
                    break;
                }
                case MONTH: {
                    calendar.add(2, duration);
                    break;
                }
                case YEAR: {
                    calendar.add(1, duration);
                }
            }
            CommandExecutor.this.summaryOutput = true;
            this.command = new ChangeQuery(calendar.getTimeInMillis() / 1000L);
        }

        @Override
        @Usage(name="change show", args="[<change>]", description="Show the details of a data change")
        public void exitChangeShow(CommandsParser.ChangeShowContext ctx) {
            if (this.wasError()) {
                return;
            }
            CommandExecutor.this.summaryOutput = false;
            this.command = new ChangeQuery(ctx.token() != null ? ctx.token().getText() : "0");
        }

        @Override
        @Usage(name="config list", args="[startup] [<filter>]", description="List all or a selection of configuration properties")
        public void exitConfigList(CommandsParser.ConfigListContext ctx) {
            if (this.wasError()) {
                return;
            }
            ConfigQuery query = new ConfigQuery();
            if (ctx.word() != null) {
                query.setFilter(new Filter(ctx.word().getText(), Filter.Type.CONTAINS));
            }
            if (ctx.startup() != null) {
                query.setStartup(true);
            }
            if (ctx.hidden() != null) {
                query.setHidden(true);
            }
            CommandExecutor.this.summaryOutput = true;
            this.command = query;
        }

        @Override
        @Usage(name="config show", args="<name> [<change>]", description="Show full details of a configuration property, configuration property change.")
        public void exitConfigShow(CommandsParser.ConfigShowContext ctx) {
            if (this.wasError()) {
                return;
            }
            ConfigQuery query = new ConfigQuery(ctx.name().getText());
            if (ctx.token() != null) {
                query.addChangeId(ctx.token().getText());
            }
            CommandExecutor.this.summaryOutput = false;
            this.command = query;
        }

        @Override
        @Usage(name="config set", args="<name> [<value>]", description="Set the value of configuration property")
        public void exitConfigSet(CommandsParser.ConfigSetContext ctx) {
            if (this.wasError()) {
                return;
            }
            String name = ctx.name().getText();
            String value = ctx.token().size() > 0 ? CommandExecutor.getString(ctx.token()) : "";
            this.command = new ConfigCommand(name, value);
        }

        @Override
        @Usage(name="config unset", args="<name>", description="Unset a configuration property")
        public void exitConfigUnset(CommandsParser.ConfigUnsetContext ctx) {
            if (this.wasError()) {
                return;
            }
            String name = ctx.name().getText();
            this.command = new ConfigCommand(name, null);
        }

        @Override
        @Usage(name="config changes", args="<name>", description="List changes to a configuration property.")
        public void exitConfigChanges(CommandsParser.ConfigChangesContext ctx) {
            if (this.wasError()) {
                return;
            }
            CommandExecutor.this.summaryOutput = true;
            this.command = new ChangeQuery(Config.getPath((String)ctx.name().getText()), ChangeQuery.Type.CONFIG);
        }

        @Override
        @Usage(name="config diff", args="<name> [<change> [<change>]]", description="Show the difference between two versions of a configuration property")
        public void exitConfigDiff(CommandsParser.ConfigDiffContext ctx) {
            if (this.wasError()) {
                return;
            }
            this.command = new ConfigQuery(ctx.name().getText(), CommandExecutor.getChangeIds(ctx.token()));
        }

        @Override
        @Usage(name="connection list", args="[full] [<filter>]", description="List all or specific open connections on the BeyondCron server.")
        public void exitConnectionList(CommandsParser.ConnectionListContext ctx) {
            if (this.wasError()) {
                return;
            }
            ConnectionQuery query = new ConnectionQuery();
            if (ctx.word() != null) {
                query.setFilter(new Filter(ctx.word().getText(), Filter.Type.CONTAINS));
            }
            CommandExecutor.this.summaryOutput = ctx.full() == null;
            this.command = query;
        }

        @Override
        @Usage(name="cron", args="import [raw] [enable] <root> <host> (<file>|<directory>) [<timezone>]", description="Import a single users cron file or a directory of cron files for the specified host. Optionally enabling the jobs.")
        public void exitCronImport(CommandsParser.CronImportContext ctx) {
            if (this.wasError()) {
                return;
            }
            List<CommandsParser.UriContext> uris = ctx.uri();
            Name root = this.getName(uris.get(0), false);
            if (!CommandExecutor.this.connection.hasPermission(root, ACL.Permission.WRITE)) {
                this.parseError(Localise.format((String)"User %s does not have %s access to %s", (Object[])new Object[]{CommandExecutor.this.user.getName(), ACL.Permission.WRITE.toString().toLowerCase(), root}), new Object[0]);
                return;
            }
            String hostName = ctx.word(0).getText();
            String id = ctx.word().size() > 1 ? ctx.word(1).getText() : CommandExecutor.this.getTimeZone().getID();
            TimeZone timeZone = TimeUtils.getTimeZone((String)id);
            if (timeZone == null) {
                this.parseError(Localise.format((String)"Unknown timezone: %s", (Object[])new Object[]{id}), new Object[0]);
                return;
            }
            boolean raw = false;
            boolean enable = false;
            for (CommandsParser.CronFlagContext flag : ctx.cronFlag()) {
                String s = flag.getText().toLowerCase();
                if (s.equals("raw")) {
                    raw = true;
                    continue;
                }
                if (!s.equals("enable")) continue;
                enable = true;
            }
            CommandExecutor.this.cronImport(root, hostName, new File(uris.get(1).getText()), timeZone, raw, enable);
            this.command = new Result();
        }

        @Override
        @Usage(name="date", args="(client|server|<timezone>)", description="Print the data and time of BeyondCron client/server.")
        public void exitDate(CommandsParser.DateContext ctx) {
            if (this.wasError()) {
                return;
            }
            String id = ctx.token().getText();
            if (id.equals("server")) {
                this.command = new DateQuery();
            } else if (id.equals("client")) {
                CommandExecutor.this.output(ZonedDateTime.now(CommandExecutor.this.zoneId).format(CommandExecutor.this.dateTimeFormatter), new Object[0]);
            } else {
                TimeZone timeZone = TimeUtils.getTimeZone((String)id);
                if (timeZone == null) {
                    this.parseError(Localise.format((String)"Unknown timezone: %s", (Object[])new Object[]{id}), new Object[0]);
                    return;
                }
                CommandExecutor.this.output(ZonedDateTime.now(timeZone.toZoneId()).format(CommandExecutor.this.dateTimeFormatter), new Object[0]);
            }
        }

        @Override
        public void exitDebugOnOff(CommandsParser.DebugOnOffContext ctx) {
            if (this.wasError()) {
                return;
            }
            CommandExecutor.this.debug = ctx.onOff().getText().equals("on");
        }

        @Override
        @Usage(name="icalendar list", args="[full] [<filter>]", description="List details of all ical(endar)s or specific ical(endar)s.")
        public void exitIcalendarList(CommandsParser.IcalendarListContext ctx) {
            if (this.wasError()) {
                return;
            }
            ICalendarQuery query = new ICalendarQuery();
            if (ctx.uri() != null) {
                query.setFilter(Filter.getFilter((String)ctx.uri().getText()));
            }
            CommandExecutor.this.summaryOutput = ctx.full() == null;
            this.command = query;
        }

        @Override
        @Usage(name="icalendar add", args="<url>", description="Add/create the specified icalendar.")
        public void exitIcalendarAdd(CommandsParser.IcalendarAddContext ctx) {
            if (this.wasError()) {
                return;
            }
            this.command = new ICalendarCommand(NetUtils.parseURI((String)ctx.uri().getText()), ICalendarCommand.Action.CREATE);
        }

        @Override
        @Usage(name="icalendar delete", args="<urL>", description="Delete the specified icalendar.")
        public void exitIcalendarDelete(CommandsParser.IcalendarDeleteContext ctx) {
            if (this.wasError()) {
                return;
            }
            this.command = new ICalendarCommand(NetUtils.parseURI((String)ctx.uri().getText()), ICalendarCommand.Action.DELETE);
        }

        @Override
        @Usage(name="icalendar refresh", args="[<url>]", description="Refresh all icalendars or a specific icalendar.")
        public void exitIcalendarRefresh(CommandsParser.IcalendarRefreshContext ctx) {
            if (this.wasError()) {
                return;
            }
            URI uri = ctx.uri() != null ? NetUtils.parseURI((String)ctx.uri().getText()) : ICalendar.ALL_CALENDARS;
            this.command = new ICalendarCommand(uri, ICalendarCommand.Action.REFRESH);
        }

        @Override
        @Usage(name="cd", args="[<name>]", description="Set/change/clear the current working group.")
        public void exitDirectorySet(CommandsParser.DirectorySetContext ctx) {
            if (this.wasError()) {
                return;
            }
            if (ctx.uri() == null) {
                Name home = CommandExecutor.this.connection.getUser().getHome();
                CommandExecutor.this.setCurrentGroup(home != null ? home : Name.ROOT);
            } else {
                CommandExecutor.this.setCurrentGroup(this.getName(ctx.uri()));
            }
        }

        @Override
        @Usage(name="ls", args="[<filter>]", description="List the contents of a group.")
        public void exitDirectoryList(CommandsParser.DirectoryListContext ctx) {
            if (this.wasError()) {
                return;
            }
            this.command = new GroupQuery(ctx.uri() != null ? this.getName(ctx.uri()) : CommandExecutor.this.currentGroup);
        }

        @Override
        @Usage(name="pwd", description="Print the current working group name.")
        public void exitDirectoryPrint(CommandsParser.DirectoryPrintContext ctx) {
            if (this.wasError()) {
                return;
            }
            CommandExecutor.this.output(CommandExecutor.this.currentGroup.toString(), new Object[0]);
        }

        @Override
        @Usage(name="group list", args="[<filter>]", description="List the contents of a group.")
        public void exitGroupList(CommandsParser.GroupListContext ctx) {
            if (this.wasError()) {
                return;
            }
            this.command = new GroupQuery(ctx.uri() != null ? this.getName(ctx.uri()) : CommandExecutor.this.currentGroup);
        }

        @Override
        @Usage(name="group print", description="Print the current working group name.")
        public void exitGroupPrint(CommandsParser.GroupPrintContext ctx) {
            if (this.wasError()) {
                return;
            }
            CommandExecutor.this.output(CommandExecutor.this.currentGroup.toString(), new Object[0]);
        }

        @Override
        @Usage(name="group set", args="[<name>]", description="Set/change/clear the current working group.")
        public void exitGroupSet(CommandsParser.GroupSetContext ctx) {
            if (this.wasError()) {
                return;
            }
            if (ctx.uri() == null) {
                Name home = CommandExecutor.this.connection.getUser().getHome();
                CommandExecutor.this.setCurrentGroup(home != null ? home : Name.ROOT);
            } else {
                CommandExecutor.this.setCurrentGroup(this.getName(ctx.uri()));
            }
        }

        @Override
        @Usage(name="job list", args="[<filter>]", description="List summary details of all jobs, or specific job/s.")
        public void exitJobList(CommandsParser.JobListContext ctx) {
            if (this.wasError()) {
                return;
            }
            JobQuery query = new JobQuery(true);
            if (ctx.uri() != null) {
                query.setFilter(new Filter(ctx.uri().getText(), Filter.Type.CONTAINS));
            } else {
                query.setFilter(this.getPathFilter(""));
            }
            this.command = query;
        }

        @Override
        @Usage(name="job show", args="[full] <name> [<change>]", description="Show details of a job, or job change.")
        public void exitJobShow(CommandsParser.JobShowContext ctx) {
            if (this.wasError()) {
                return;
            }
            Job job = CommandExecutor.this.getJob(this.getName(ctx.uri()));
            if (job != null) {
                CommandExecutor.this.outputJobs(Collections.singletonList(job), ctx.full() == null);
            }
        }

        @Override
        @Usage(name="job add", args="<name> [<description>]", description="Add/create the specified job.")
        public void exitJobAdd(CommandsParser.JobAddContext ctx) {
            if (this.wasError()) {
                return;
            }
            Name name = this.getName(ctx.uri());
            CommandJob job = new CommandJob(name);
            job.setTimeZone(null);
            job.setDefaults(new PropertyDefaults(CommandExecutor.this.connection, CommandExecutor.this.getTimeZone(), name));
            if (!StringUtils.isNullOrEmpty((String)CommandExecutor.this.defaultJobUserName)) {
                job.setUserName(CommandExecutor.this.defaultJobUserName);
            }
            if (ctx.token().size() > 0) {
                job.setDescription(CommandExecutor.getString(ctx.token()));
            }
            job.setTimeZone(CommandExecutor.this.jobTimeZone);
            this.command = new JobCommand((Job)job, JobCommand.Action.CREATE);
        }

        @Override
        @Usage(name="job copy", args="<name> <name>", description="Copy the specified job.")
        public void exitJobCopy(CommandsParser.JobCopyContext ctx) {
            if (this.wasError()) {
                return;
            }
            Job job = CommandExecutor.this.getJob(this.getName(ctx.uri(0)));
            if (job != null) {
                ProtoJob.Job.Builder builder = job.toProto();
                builder.setName(this.getName(ctx.uri(1)).toProto());
                builder.setMode(ProtoJob.Job.Mode.DISABLED);
                try {
                    this.command = new JobCommand(Job.parseFromProto((byte[])builder.build().toByteArray()), JobCommand.Action.CREATE);
                }
                catch (InvalidProtocolBufferException e) {
                    this.parseError(Localise.format((String)"Unexpected error copying job: %s", (Object[])new Object[]{e.getMessage()}), new Object[0]);
                }
            }
        }

        @Override
        @Usage(name="job delete", args="<name>", description="Delete the specified job.")
        public void exitJobDelete(CommandsParser.JobDeleteContext ctx) {
            if (this.wasError()) {
                return;
            }
            this.command = new JobCommand(this.getName(ctx.uri()), JobCommand.Action.DELETE);
        }

        @Override
        @Usage(name="job type", args="<name> (command|container|custom|email|sql|trigger|webhook)", description="Set the job type.")
        public void exitJobType(CommandsParser.JobTypeContext ctx) {
            if (this.wasError()) {
                return;
            }
            Job job = CommandExecutor.this.getJob(this.getName(ctx.uri()));
            if (job == null) {
                return;
            }
            Job.Type type = Job.Type.valueOf((String)this.getChild(ctx, 2).toUpperCase());
            if (job.getType() == type) {
                return;
            }
            switch (type) {
                case COMMAND: {
                    job = new CommandJob(job);
                    break;
                }
                case CONTAINER: {
                    job = new ContainerJob(job);
                    break;
                }
                case CUSTOM: {
                    job = new CustomJob(job);
                    break;
                }
                case URL: {
                    job = new URLJob(job);
                    break;
                }
                case MAIL: {
                    job = new MailJob(job);
                    break;
                }
                case SQL: {
                    job = new SQLJob(job);
                    break;
                }
                case TRIGGER: {
                    job = new TriggerJob(job);
                }
            }
            this.command = new JobCommand(job, JobCommand.Action.UPDATE);
        }

        @Override
        @Usage(name="job", args="calendar set <name> <calendar>", description="Set the calendar within which the specified job executes.")
        public void exitJobCalendarSet(CommandsParser.JobCalendarSetContext ctx) {
            if (this.wasError()) {
                return;
            }
            Job job = CommandExecutor.this.getJob(this.getName(ctx.uri()));
            if (job != null) {
                job.setCalendar(this.getName(ctx.token(), false));
                this.command = new JobCommand(job, JobCommand.Action.UPDATE);
            }
        }

        @Override
        @Usage(name="job", args="calendar clear <name>", description="Clear the specified jobs calendar.")
        public void exitJobCalendarClear(CommandsParser.JobCalendarClearContext ctx) {
            if (this.wasError()) {
                return;
            }
            Job job = CommandExecutor.this.getJob(this.getName(ctx.uri()));
            if (job != null) {
                job.setCalendar(null);
                this.command = new JobCommand(job, JobCommand.Action.UPDATE);
            }
        }

        @Override
        @Usage(name="job command", args="<name> <command> [<args> ...]", description="Define the job type as command/container, and set its command and arguments")
        public void exitJobCmd(CommandsParser.JobCmdContext ctx) {
            if (this.wasError()) {
                return;
            }
            CommandJob job = CommandExecutor.this.getCommandJob(this.getName(ctx.uri()));
            if (job == null) {
                return;
            }
            Command jCommand = job.getCommand();
            if (jCommand == null) {
                jCommand = new Command(Job.Action.START);
                job.setCommand(jCommand);
            }
            jCommand.setCommand(StringUtils.join((String)" ", CommandExecutor.getStrings(ctx.token())));
            if (StringUtils.isNullOrEmpty((String)job.getUserName()) && !StringUtils.isNullOrEmpty((String)CommandExecutor.this.defaultJobUserName)) {
                job.setUserName(CommandExecutor.this.defaultJobUserName);
            }
            this.command = new JobCommand((Job)job, JobCommand.Action.UPDATE);
        }

        @Override
        @Usage(name="job content", args="clear <name>", description="Clear the webhook jobs content")
        public void exitJobContentClear(CommandsParser.JobContentClearContext ctx) {
            if (this.wasError()) {
                return;
            }
            Name name = this.getName(ctx.uri());
            URLJob job = CommandExecutor.this.getURLJob(name);
            if (job == null) {
                return;
            }
            if (!job.hasContent() && CommandExecutor.this.getJob(name) instanceof URLJob) {
                return;
            }
            job.clearContent();
            this.command = new JobCommand((Job)job, JobCommand.Action.UPDATE);
        }

        @Override
        @Usage(name="job content", args="(add|set) <name> <content>", description="Set or add to the webhook jobs content")
        public void exitJobContentAdd(CommandsParser.JobContentAddContext ctx) {
            if (this.wasError()) {
                return;
            }
            Name name = this.getName(ctx.uri());
            URLJob job = CommandExecutor.this.getURLJob(name);
            if (job == null) {
                return;
            }
            boolean set = this.childEquals(ctx, 1, "set");
            String content = CommandExecutor.getString(ctx.token());
            if (set) {
                job.setContent(new String[]{content});
            } else {
                job.addContent(new String[]{content});
            }
            this.command = new JobCommand((Job)job, JobCommand.Action.UPDATE);
        }

        @Override
        @Usage(name="job host", args="<name> <host>", description="Define the job type as command, and set the host on which to run the jobs command/s.")
        public void exitJobHost(CommandsParser.JobHostContext ctx) {
            if (this.wasError()) {
                return;
            }
            CommandJob job = CommandExecutor.this.getCommandJob(this.getName(ctx.uri()));
            if (job != null) {
                if (job instanceof ContainerJob) {
                    job = new CommandJob((Job)job);
                }
                job.setHostName(ctx.word().getText());
                if (CommandExecutor.this.checkHostsExist) {
                    try {
                        InetAddress.getByName(job.getHostName());
                    }
                    catch (UnknownHostException e) {
                        this.parseError(Localise.format((String)"Unknown host: %s", (Object[])new Object[]{job.getHostName()}), new Object[0]);
                        return;
                    }
                }
                this.command = new JobCommand((Job)job, JobCommand.Action.UPDATE);
            }
        }

        @Override
        @Usage(name="job image", args="<name> <image>", description="Define the container image to run the job within.")
        public void exitJobImage(CommandsParser.JobImageContext ctx) {
            if (this.wasError()) {
                return;
            }
            ContainerJob job = CommandExecutor.this.getContainerJob(this.getName(ctx.uri()));
            if (job != null) {
                job.setImageName(ctx.word().getText());
                this.command = new JobCommand((Job)job, JobCommand.Action.UPDATE);
            }
        }

        @Override
        @Usage(name="job input", args="clear <name>", description="Clear the jobs input line/s")
        public void exitJobInputClear(CommandsParser.JobInputClearContext ctx) {
            if (this.wasError()) {
                return;
            }
            Name name = this.getName(ctx.uri());
            CommandJob job = CommandExecutor.this.getCommandJob(name);
            if (job == null || !(CommandExecutor.this.getJob(name) instanceof CommandJob)) {
                return;
            }
            Command jCommand = job.getCommand();
            if (jCommand == null || !jCommand.hasInput()) {
                return;
            }
            jCommand.clearInput();
            this.command = new JobCommand((Job)job, JobCommand.Action.UPDATE);
        }

        @Override
        @Usage(name="job input", args="(add|set) <name> <line>", description="Set or add to the command jobs input line/s")
        public void exitJobInputAdd(CommandsParser.JobInputAddContext ctx) {
            if (this.wasError()) {
                return;
            }
            CommandJob job = CommandExecutor.this.getCommandJob(this.getName(ctx.uri()));
            if (job == null) {
                return;
            }
            boolean set = this.childEquals(ctx, 1, "set");
            String input = CommandExecutor.getString(ctx.token());
            Command jCommand = job.getCommand();
            if (jCommand == null) {
                jCommand = new Command(Job.Action.START);
                job.setCommand(jCommand);
            }
            if (set) {
                jCommand.setInput(new String[]{input});
            } else {
                jCommand.addInput(new String[]{input});
            }
            this.command = new JobCommand((Job)job, JobCommand.Action.UPDATE);
        }

        @Override
        @Usage(name="job sql", args="clear <name>", description="Clear the jobs sql line/s")
        public void exitJobSQLClear(CommandsParser.JobSQLClearContext ctx) {
            if (this.wasError()) {
                return;
            }
            Name name = this.getName(ctx.uri());
            SQLJob job = CommandExecutor.this.getSQLJob(name);
            if (job == null || !(CommandExecutor.this.getJob(name) instanceof SQLJob) || !job.hasSQL()) {
                return;
            }
            job.clearSQL();
            this.command = new JobCommand((Job)job, JobCommand.Action.UPDATE);
        }

        @Override
        @Usage(name="job sql", args="(add|set) <name> <line>", description="Set or add to the command jobs sql line/s")
        public void exitJobSQLAdd(CommandsParser.JobSQLAddContext ctx) {
            if (this.wasError()) {
                return;
            }
            SQLJob job = CommandExecutor.this.getSQLJob(this.getName(ctx.uri()));
            if (job == null) {
                return;
            }
            boolean set = this.childEquals(ctx, 1, "set");
            String[] lines = CommandExecutor.getString(ctx.token()).split("\\n");
            if (set) {
                job.setSQL(lines);
            } else {
                job.addInput(lines);
            }
            this.command = new JobCommand((Job)job, JobCommand.Action.UPDATE);
        }

        @Override
        @Usage(name="job user", args="<name> <user>", description="Define the job type as command, and set the user under which to run the jobs command/s as.")
        public void exitJobUser(CommandsParser.JobUserContext ctx) {
            if (this.wasError()) {
                return;
            }
            CommandJob job = CommandExecutor.this.getCommandJob(this.getName(ctx.uri()));
            if (job != null) {
                job.setUserName(ctx.word().getText());
                this.command = new JobCommand((Job)job, JobCommand.Action.UPDATE);
            }
        }

        @Override
        @Usage(name="job email", args="<name> <address>", description="Define the job type as email, and set the email address.")
        public void exitJobEmail(CommandsParser.JobEmailContext ctx) {
            if (this.wasError()) {
                return;
            }
            MailJob job = CommandExecutor.this.getMailJob(this.getName(ctx.uri()));
            if (job != null) {
                String address = ctx.token().getText();
                if (!MailUtils.isValidAddress((String)address)) {
                    CommandExecutor.this.outputError("Invalid email address: %s", address);
                    return;
                }
                job.setRecipient(address);
                this.command = new JobCommand((Job)job, JobCommand.Action.UPDATE);
            }
        }

        @Override
        @Usage(name="job subject", args="<name> <subject>", description="Define the job type as email, and set the email subject.")
        public void exitJobSubject(CommandsParser.JobSubjectContext ctx) {
            if (this.wasError()) {
                return;
            }
            MailJob job = CommandExecutor.this.getMailJob(this.getName(ctx.uri()));
            if (job != null) {
                job.setSubject(CommandExecutor.getString(ctx.token()));
                this.command = new JobCommand((Job)job, JobCommand.Action.UPDATE);
            }
        }

        @Override
        @Usage(name="job message", args="<name> <message>", description="Define the job type as email, and set the email message.")
        public void exitJobMessage(CommandsParser.JobMessageContext ctx) {
            if (this.wasError()) {
                return;
            }
            MailJob job = CommandExecutor.this.getMailJob(this.getName(ctx.uri()));
            if (job != null) {
                job.setMessage(CommandExecutor.getString(ctx.token()).replace(" \\n", "\n"));
                this.command = new JobCommand((Job)job, JobCommand.Action.UPDATE);
            }
        }

        @Override
        @Usage(name="job url", args="<name> (get|post|put|patch|delete|sql)? <url>", description="Define the job type as webhook/sql, and set its URL.")
        public void exitJobUrl(CommandsParser.JobUrlContext ctx) {
            if (this.wasError()) {
                return;
            }
            URLJob job = CommandExecutor.this.getURLJob(this.getName(ctx.uri()));
            if (job == null) {
                return;
            }
            String url = CommandExecutor.getString(ctx.token());
            try {
                job.setURL(new URL(url));
            }
            catch (MalformedURLException e) {
                CommandExecutor.this.outputError("Invalid URL: %s", url);
                return;
            }
            if (ctx.urlMethod() != null) {
                job.setMethod(URLJob.Method.valueOf((String)ctx.urlMethod().getText().toUpperCase()));
            }
            this.command = new JobCommand((Job)job, JobCommand.Action.UPDATE);
        }

        @Override
        public void exitJobSql(CommandsParser.JobSqlContext ctx) {
            if (this.wasError()) {
                return;
            }
            SQLJob job = CommandExecutor.this.getSQLJob(this.getName(ctx.uri()));
            if (job == null) {
                return;
            }
            String url = CommandExecutor.getString(ctx.token());
            try {
                job.setURL(new URI(NetUtils.encodeBraces((String)url)));
            }
            catch (URISyntaxException e) {
                CommandExecutor.this.outputError("Invalid URL: %s", url);
                return;
            }
            this.command = new JobCommand((Job)job, JobCommand.Action.UPDATE);
        }

        @Override
        @Usage(name="job delay", args="<name> <period> (seconds|minutes|hours)", description="Define the job type as trigger, and set its delay period.")
        public void exitJobDelay(CommandsParser.JobDelayContext ctx) {
            if (this.wasError()) {
                return;
            }
            TriggerJob job = CommandExecutor.this.getTriggerJob(this.getName(ctx.uri()));
            if (job == null) {
                return;
            }
            String period = ctx.NUMBER().getText() + " " + this.getChild(ctx, 3);
            try {
                job.setDelay(new Period(period, Period.Unit.HOUR));
            }
            catch (IllegalArgumentException e) {
                this.parseError("Invalid delay period: %s", period);
                return;
            }
            this.command = new JobCommand((Job)job, JobCommand.Action.UPDATE);
        }

        @Override
        @Usage(name="job condition", args="(add|delete) <name> (running|stopped|success|failed|error|exception|missed|killed) <name> [in last <period> (seconds|minutes|hours|days)]", description="Add/delete a job start condition.")
        public void exitJobCondition(CommandsParser.JobConditionContext ctx) {
            this.parseConditionTrigger(this.getName(ctx.uri(0)), this.getName(ctx.uri(1), false), Condition.Type.ALL, this.getChild(ctx, 3), ctx.getChildCount() > 8 ? ctx.NUMBER().getText() + " " + ctx.getChild(8) : null, this.childEquals(ctx, 1, "add"));
        }

        @Override
        @Usage(name="job trigger", args="(add|delete) <name> (running|stopped|success|failed|error|exception|missed|killed) <name>", description="Add/delete a job start condition.")
        public void exitJobTrigger(CommandsParser.JobTriggerContext ctx) {
            this.parseConditionTrigger(this.getName(ctx.uri(0)), this.getName(ctx.uri(1), false), Condition.Type.ANY, this.getChild(ctx, 3), null, this.childEquals(ctx, 1, "add"));
        }

        private void parseConditionTrigger(Name source, Name target, Condition.Type type, String stateResult, String period, boolean addCondition) {
            Period maxAge;
            if (this.wasError()) {
                return;
            }
            Job job = CommandExecutor.this.getJob(source);
            if (job == null) {
                return;
            }
            if (type == Condition.Type.ANY && job.hasSchedule()) {
                this.parseError("Job cannot have both triggers and schedules.", new Object[0]);
                return;
            }
            Status.State state = null;
            Status.Result result = null;
            switch (stateResult) {
                case "running": {
                    state = Status.State.RUNNING;
                    break;
                }
                case "stopped": {
                    state = Status.State.STOPPED;
                    break;
                }
                case "success": {
                    result = Status.Result.SUCCESS;
                    break;
                }
                case "failed": {
                    result = Status.Result.FAILED;
                    break;
                }
                case "error": {
                    result = Status.Result.ERROR;
                    break;
                }
                case "exception": {
                    result = Status.Result.EXCEPTION;
                    break;
                }
                case "missed": {
                    result = Status.Result.MISSED;
                    break;
                }
                case "killed": {
                    result = Status.Result.KILLED;
                    break;
                }
                default: {
                    this.parseError("Unsupported condition: %s", stateResult);
                    return;
                }
            }
            if (period != null) {
                try {
                    maxAge = new Period(period);
                }
                catch (IllegalArgumentException e) {
                    this.parseError("Invalid condition period: %s", period);
                    return;
                }
                if (maxAge.getValue() < 1) {
                    this.parseError("Condition period must be greater than 0.", new Object[0]);
                    return;
                }
            } else {
                maxAge = null;
            }
            Condition condition = new Condition(type, target, state, result, maxAge);
            if (addCondition) {
                job.addCondition(condition, type);
            } else {
                job.removeCondition(condition);
            }
            this.command = new JobCommand(job, JobCommand.Action.UPDATE);
        }

        @Override
        @Usages(value={@Usage(name="job schedule", args="(add|delete) <name> calendar (<offset> (seconds|minutes|hours))? (before|after)? (start|end|both)?", description="Add/delete a calendar start schedule to the specified job."), @Usage(name="job schedule", args="(add|delete) <name> calendar <offset> (seconds|minutes|hours) (inside|outside)", description="Add/delete a calendar start schedule to the specified job.")})
        public void exitJobCalendarSchedule(CommandsParser.JobCalendarScheduleContext ctx) {
            CalendarSchedule schedule;
            if (this.wasError()) {
                return;
            }
            CalendarSchedule.Boundary boundary = CalendarSchedule.Boundary.START;
            CalendarSchedule.Direction offsetDirection = CalendarSchedule.Direction.BEFORE;
            Period offset = new Period(0, Period.Unit.SECOND);
            Job job = CommandExecutor.this.getJob(this.getName(ctx.uri()));
            if (job == null) {
                return;
            }
            boolean add = this.childEquals(ctx, 1, "add");
            List<String> tokens = CommandExecutor.getStrings(ctx);
            for (String token : tokens.subList(4, tokens.size())) {
                token = token.toUpperCase();
                try {
                    boundary = CalendarSchedule.Boundary.valueOf((String)token);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    try {
                        offsetDirection = CalendarSchedule.Direction.valueOf((String)token);
                    }
                    catch (IllegalArgumentException illegalArgumentException2) {
                        try {
                            offset.setUnit(Period.Unit.valueOf((String)(token.endsWith("S") ? token.substring(0, token.length() - 1) : token)));
                        }
                        catch (IllegalArgumentException illegalArgumentException3) {
                            try {
                                offset.setValue(Integer.parseInt(token));
                            }
                            catch (NumberFormatException numberFormatException) {}
                        }
                    }
                }
            }
            if (offsetDirection == CalendarSchedule.Direction.INSIDE || offsetDirection == CalendarSchedule.Direction.OUTSIDE) {
                boundary = CalendarSchedule.Boundary.BOTH;
            }
            if (this.addRemoveSchedule(job, (Schedule)(schedule = new CalendarSchedule(boundary, offsetDirection, offset)), add)) {
                this.command = new JobCommand(job, JobCommand.Action.UPDATE);
            }
        }

        @Override
        @Usage(name="job schedule", args="(add|delete) <name> cron [<second>] <minute> <hour> <mday> <mon> <wday> [<year>]", description="Add/delete a cron start schedule to the specified job.")
        public void exitJobCronSchedule(CommandsParser.JobCronScheduleContext ctx) {
            CronSchedule schedule;
            String expression;
            if (this.wasError()) {
                return;
            }
            Job job = CommandExecutor.this.getJob(this.getName(ctx.uri()));
            if (job == null) {
                return;
            }
            boolean add = this.childEquals(ctx, 1, "add");
            List<String> tokens = CommandExecutor.getStrings(ctx.token());
            if (tokens.size() < 6) {
                tokens.add(0, "0");
            }
            if (!CronSchedule.isValidExpression((String)(expression = StringUtils.join((String)" ", tokens)))) {
                this.parseError(Localise.format((String)"Invalid cron expression: %s", (Object[])new Object[]{expression}), new Object[0]);
                return;
            }
            try {
                schedule = new CronSchedule(expression);
            }
            catch (ParseException e) {
                this.parseError(Localise.format((String)"Invalid cron expression: %s", (Object[])new Object[]{expression}), new Object[0]);
                return;
            }
            if (this.addRemoveSchedule(job, (Schedule)schedule, add)) {
                this.command = new JobCommand(job, JobCommand.Action.UPDATE);
            }
        }

        @Override
        @Usage(name="job schedule", args="(add|delete) <name> (mon|tue|wed|thu|fri|sat|sun|daily|weekdays|weekends)+ at <hh>:<mm>[:<ss>]", description="Add/delete a daily start schedule to the specified job.")
        public void exitJobDailySchedule(CommandsParser.JobDailyScheduleContext ctx) {
            if (this.wasError()) {
                return;
            }
            Job job = CommandExecutor.this.getJob(this.getName(ctx.uri()));
            if (job == null) {
                return;
            }
            boolean add = this.childEquals(ctx, 1, "add");
            List<String> tokens = CommandExecutor.getStrings(ctx.word());
            Time time = CommandExecutor.this.parseTime(tokens.remove(tokens.size() - 1));
            if (time == null) {
                return;
            }
            ArrayList<Day> days = new ArrayList<Day>();
            for (String day : tokens) {
                try {
                    days.add(Day.forName((String)day));
                }
                catch (IllegalArgumentException e) {
                    this.parseError(Localise.format((String)"Invalid day: %s", (Object[])new Object[]{day}), new Object[0]);
                    return;
                }
            }
            DailySchedule schedule = new DailySchedule(time, days);
            if (this.addRemoveSchedule(job, (Schedule)schedule, add)) {
                this.command = new JobCommand(job, JobCommand.Action.UPDATE);
            }
        }

        @Override
        @Usages(value={@Usage(name="job schedule", args="(add|delete) <name> at <hh:mm:mm> [<dd/mm/yyyy>]", description="Add/delete a date schedule to the specified job."), @Usage(name="job schedule", args="(add|delete) <name> at <hh:mm:mm> (mon|tue|wed|thu|fri|sat|sun)", description="Add/delete a date schedule to the specified job.")})
        public void exitJobDateSchedule(CommandsParser.JobDateScheduleContext ctx) {
            LocalDateTime dateTime;
            String value;
            if (this.wasError()) {
                return;
            }
            Job job = CommandExecutor.this.getJob(this.getName(ctx.uri()));
            if (job == null) {
                return;
            }
            boolean add = this.childEquals(ctx, 1, "add");
            ArrayList<String> l = new ArrayList<String>();
            for (CommandsParser.WordContext word : ctx.word()) {
                l.add(word.getText());
            }
            DayOfWeek day = null;
            if (l.size() > 1) {
                switch (((String)l.get(1)).toLowerCase()) {
                    case "mon": 
                    case "monday": {
                        day = DayOfWeek.MONDAY;
                        break;
                    }
                    case "tue": 
                    case "tuesday": {
                        day = DayOfWeek.TUESDAY;
                        break;
                    }
                    case "wed": 
                    case "wednesday": {
                        day = DayOfWeek.WEDNESDAY;
                        break;
                    }
                    case "thu": 
                    case "thursday": {
                        day = DayOfWeek.THURSDAY;
                        break;
                    }
                    case "fri": 
                    case "friday": {
                        day = DayOfWeek.FRIDAY;
                        break;
                    }
                    case "sat": 
                    case "saturday": {
                        day = DayOfWeek.SATURDAY;
                        break;
                    }
                    case "sun": 
                    case "sunday": {
                        day = DayOfWeek.SUNDAY;
                    }
                }
                value = day == null ? StringUtils.join((String)" ", l) : (String)l.get(0);
            } else {
                value = (String)l.get(0);
            }
            LocalDateTime now = LocalDateTime.now(job.getTimeZone().toZoneId());
            try {
                dateTime = TimeUtils.parseDateTime((String)value);
            }
            catch (ParseException e) {
                this.parseError(Localise.format((String)"Invalid from date/time: %s", (Object[])new Object[]{value}), new Object[0]);
                return;
            }
            if (l.size() == 1 || day != null) {
                if (dateTime.isBefore(now)) {
                    dateTime = dateTime.plusDays(1L);
                }
                if (day != null) {
                    while (dateTime.getDayOfWeek() != day) {
                        dateTime = dateTime.plusDays(1L);
                    }
                }
            }
            if (this.addRemoveSchedule(job, (Schedule)new DateSchedule(dateTime), add)) {
                this.command = new JobCommand(job, JobCommand.Action.UPDATE);
            }
        }

        @Override
        @Usages(value={@Usage(name="job schedule", args="(add|delete) <name> (1st|2nd|3rd|4th|5th|last) (mon|tue|wed|thu|fri|sat|sun) of month at <hh>:<mm>[:<ss>]", description="Add/delete a monthly start schedule to the specified job."), @Usage(name="job schedule", args="(add|delete) <name> [(2nd|3rd|4th|...)] last day of month at <hh>:<mm>[:<ss>]", description="Add/delete a monthly start schedule to the specified job."), @Usage(name="job schedule", args="(add|delete) <name> last weekday of month at <hh>:<mm>[:<ss>]", description="Add/delete a monthly start schedule to the specified job."), @Usage(name="job schedule", args="(add|delete) <name> <mday> [or closest weekday] of month at <hh>:<mm>[:<ss>]", description="Add/delete a monthly start schedule to the specified job.")})
        public void exitJobMonthlySchedule(CommandsParser.JobMonthlyScheduleContext ctx) {
            MonthlySchedule schedule;
            if (this.wasError()) {
                return;
            }
            Job job = CommandExecutor.this.getJob(this.getName(ctx.uri()));
            if (job == null) {
                return;
            }
            boolean add = this.childEquals(ctx, 1, "add");
            List tokens = StringUtils.lowerCaseAll(CommandExecutor.getStrings(ctx.word()));
            Time time = CommandExecutor.this.parseTime((String)tokens.remove(tokens.size() - 1));
            if (time == null) {
                return;
            }
            if (tokens.size() == 1 || tokens.size() == 4) {
                int i;
                String s = (String)tokens.remove(0);
                try {
                    i = NumberUtils.parseOrdinal((String)s);
                }
                catch (NumberFormatException e) {
                    this.parseError(Localise.format((String)"Invalid day of month: %s", (Object[])new Object[]{s}), new Object[0]);
                    return;
                }
                if (tokens.size() == 0) {
                    schedule = new MonthlySchedule(time, i);
                } else {
                    s = StringUtils.join((String)" ", (Collection)tokens);
                    if (!s.equals("or closest weekday")) {
                        this.parseError(Localise.format((String)"\"%s\" unexpected, did you mean \"or closest weekday\"?", (Object[])new Object[]{s}), new Object[0]);
                        return;
                    }
                    schedule = new MonthlySchedule(time, Day.WEEKDAY, i, false);
                }
            } else if (tokens.size() == 2 && ((String)tokens.get(0)).equals("last")) {
                Day day;
                String s = (String)tokens.get(1);
                if (!s.equals("day")) {
                    try {
                        day = Day.forName((String)s);
                    }
                    catch (IllegalArgumentException e) {
                        this.parseError(Localise.format((String)"Invalid day: %s", (Object[])new Object[]{s}), new Object[0]);
                        return;
                    }
                } else {
                    day = Day.DAILY;
                }
                schedule = new MonthlySchedule(time, day, 1, true);
            } else if (tokens.size() == 3) {
                int i;
                String s = (String)tokens.remove(0);
                try {
                    i = NumberUtils.parseOrdinal((String)s);
                }
                catch (NumberFormatException e) {
                    this.parseError(Localise.format((String)"Invalid number: %s", (Object[])new Object[]{s}), new Object[0]);
                    return;
                }
                s = StringUtils.join((String)" ", (Collection)tokens);
                if (!s.equals("last day")) {
                    this.parseError(Localise.format((String)"\"%s\" unexpected, did you mean \"last day\"?", (Object[])new Object[]{s}), new Object[0]);
                    return;
                }
                schedule = new MonthlySchedule(time, Day.DAILY, i, true);
            } else {
                if (tokens.size() == 2) {
                    int i;
                    String s = (String)tokens.get(0);
                    try {
                        i = NumberUtils.parseOrdinal((String)s);
                    }
                    catch (NumberFormatException e) {
                        this.parseError(Localise.format((String)"Invalid number: %s", (Object[])new Object[]{s}), new Object[0]);
                        return;
                    }
                    try {
                        s = (String)tokens.get(1);
                        schedule = new MonthlySchedule(time, Day.forName((String)s), i);
                    }
                    catch (IllegalArgumentException e) {
                        CommandExecutor.this.outputError(e, e.getMessage(), new Object[0]);
                        return;
                    }
                }
                this.parseError(Localise.format((String)"Invalid monthly schedule command"), new Object[0]);
                return;
            }
            if (this.addRemoveSchedule(job, (Schedule)schedule, add)) {
                this.command = new JobCommand(job, JobCommand.Action.UPDATE);
            }
        }

        @Override
        @Usage(name="job schedule", args="(add|delete) <name> every <period> (seconds|minutes|hours|days|weeks) [from <hh:mm:mm> [<dd/mm/yyyy>]]", description="Add/delete a repeating start schedule to the specified job.")
        public void exitJobRepeatSchedule(CommandsParser.JobRepeatScheduleContext ctx) {
            RepeatSchedule schedule;
            if (this.wasError()) {
                return;
            }
            Job job = CommandExecutor.this.getJob(this.getName(ctx.uri()));
            if (job == null) {
                return;
            }
            boolean add = this.childEquals(ctx, 1, "add");
            String period = ctx.NUMBER().getText() + " " + this.getChild(ctx, 5);
            try {
                schedule = new RepeatSchedule(new Period(period, Period.Unit.YEAR));
            }
            catch (IllegalArgumentException e) {
                this.parseError("Invalid repeat period: %s", period);
                return;
            }
            if (schedule.getPeriod().getValue() < 1) {
                this.parseError(Localise.format((String)"Repeat period must be greater than 0."), new Object[0]);
                return;
            }
            if (ctx.word().size() > 0) {
                ArrayList<String> l = new ArrayList<String>();
                for (CommandsParser.WordContext word : ctx.word()) {
                    l.add(word.getText());
                }
                String s = StringUtils.join((String)" ", l);
                try {
                    LocalDateTime epoch = TimeUtils.parseDateTime((String)s);
                    if (epoch.isAfter(LocalDateTime.now())) {
                        this.parseError(Localise.format((String)"From date/time must be in the past"), new Object[0]);
                        return;
                    }
                    schedule.setEpoch(epoch);
                }
                catch (ParseException e) {
                    this.parseError(Localise.format((String)"Invalid from date/time: %s", (Object[])new Object[]{s}), new Object[0]);
                    return;
                }
            }
            if (this.addRemoveSchedule(job, (Schedule)schedule, add)) {
                this.command = new JobCommand(job, JobCommand.Action.UPDATE);
            }
        }

        @Override
        @Usage(name="job schedule", args="(add|delete) <name> [<offset> (seconds|minutes|hours)]? (before|after)? (astronomical|civil|nautical|official)? (sunrise|sunset) <city>", description="Add/delete a sunrise/sunset start schedule to the specified job.")
        public void exitJobSolarSchedule(CommandsParser.JobSolarScheduleContext ctx) {
            City city;
            String token;
            if (this.wasError()) {
                return;
            }
            Job job = CommandExecutor.this.getJob(this.getName(ctx.uri()));
            if (job == null) {
                return;
            }
            boolean add = this.childEquals(ctx, 1, "add");
            SolarSchedule.Zenith zenith = SolarSchedule.Zenith.CIVIL;
            SolarSchedule.Event event = SolarSchedule.Event.SUNRISE;
            boolean offsetBefore = true;
            Period offset = new Period(0, Period.Unit.SECOND);
            List<String> tokens = CommandExecutor.getStrings(ctx);
            int i = 3;
            block20: while (i < tokens.size()) {
                switch (token = tokens.get(i++).toUpperCase()) {
                    case "BEFORE": {
                        continue block20;
                    }
                    case "AFTER": {
                        offsetBefore = false;
                        continue block20;
                    }
                    case "SUNRISE": {
                        event = SolarSchedule.Event.SUNRISE;
                        continue block20;
                    }
                    case "SUNSET": {
                        event = SolarSchedule.Event.SUNSET;
                        continue block20;
                    }
                    case "IN": {
                        break block20;
                    }
                    default: {
                        try {
                            offset.setValue(Integer.parseInt(token));
                            continue block20;
                        }
                        catch (NumberFormatException numberFormatException) {
                            try {
                                offset.setUnit(Period.Unit.valueOf((String)(token.endsWith("S") ? token.substring(0, token.length() - 1) : token)));
                                continue block20;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                try {
                                    zenith = SolarSchedule.Zenith.valueOf((String)token);
                                    continue block20;
                                }
                                catch (IllegalArgumentException illegalArgumentException2) {
                                    break block20;
                                }
                            }
                        }
                    }
                }
            }
            if ((city = City.getCity((String)(token = StringUtils.join((String)" ", tokens.subList(i, tokens.size()))))) == null) {
                this.parseError(Localise.format((String)"Unknown city %s", (Object[])new Object[]{token}), new Object[0]);
                return;
            }
            SolarSchedule schedule = new SolarSchedule(zenith, event, offsetBefore, offset, city);
            if (this.addRemoveSchedule(job, (Schedule)schedule, add)) {
                this.command = new JobCommand(job, JobCommand.Action.UPDATE);
            }
        }

        private boolean addRemoveSchedule(Job job, Schedule schedule, boolean add) {
            boolean success;
            if (add) {
                success = job.addSchedule(schedule);
                if (!success) {
                    CommandExecutor.this.output("Duplicate schedule", new Object[0]);
                }
            } else {
                success = job.removeSchedule(schedule);
                if (!success) {
                    CommandExecutor.this.output("Non-existant schedule", new Object[0]);
                }
            }
            return success;
        }

        @Override
        @Usage(name="job property set", args="<name> [secret] [environment|header|parameter|resource|variable] <property> <value>", description="Set an environment variable on the specified job.")
        public void exitJobPropertySet(CommandsParser.JobPropertySetContext ctx) {
            String message;
            if (this.wasError()) {
                return;
            }
            Job job = CommandExecutor.this.getJob(this.getName(ctx.uri()));
            if (job == null) {
                return;
            }
            Property property = new Property(ctx.propertyName().getText(), CommandExecutor.getString(ctx.token()));
            if (ctx.propertySecret() != null) {
                property.setSecret(true);
            }
            if (ctx.propertyType() != null) {
                property.setType(Property.Type.getType((String)ctx.propertyType().getText()));
            }
            if ((message = property.validate(Schema.Scope.JOB).getMessage()) != null) {
                CommandExecutor.this.outputError(message, new Object[0]);
                return;
            }
            Property.Type propertyType = property.getType();
            if (propertyType != Property.Type.SYSTEM) {
                if (propertyType != Property.Type.DEFAULT && !job.getPropertyTypes().contains(propertyType)) {
                    CommandExecutor.this.outputError("%s jobs do not support %s properties", job.getType().getLabel(), property.getType().getLabel());
                    return;
                }
            } else if (!property.getSchema().inScope(Schema.Scope.JOB)) {
                CommandExecutor.this.outputError("System property %s is not supported in jobs", property.getName());
                return;
            }
            job.setProperty(property);
            this.command = new JobCommand(job, JobCommand.Action.UPDATE);
        }

        @Override
        @Usage(name="job property delete", args="<name> <property>", description="Delete a property from the specified job.")
        public void exitJobPropertyDelete(CommandsParser.JobPropertyDeleteContext ctx) {
            if (this.wasError()) {
                return;
            }
            Job job = CommandExecutor.this.getJob(this.getName(ctx.uri()));
            if (job == null) {
                return;
            }
            job.removeProperty(ctx.propertyName().getText());
            this.command = new JobCommand(job, JobCommand.Action.UPDATE);
        }

        @Override
        @Usage(name="job property unset", args="<name> <property>", description="Unset an inherited property in the specified job")
        public void exitJobPropertyUnset(CommandsParser.JobPropertyUnsetContext ctx) {
            if (this.wasError()) {
                return;
            }
            Job job = CommandExecutor.this.getJob(this.getName(ctx.uri()));
            if (job == null) {
                return;
            }
            String name = ctx.propertyName().getText();
            if (!CommandExecutor.this.isGroupProperty(job.getName(), name)) {
                CommandExecutor.this.outputError("Property %s is not inherited by %s", name, job.getName());
                return;
            }
            Property property = new Property(name, "");
            property.setType(Property.Type.UNSET);
            if (!property.canUnset()) {
                CommandExecutor.this.outputError("Cannot unset property", new Object[0]);
                return;
            }
            job.setProperty(property);
            this.command = new JobCommand(job, JobCommand.Action.UPDATE);
        }

        @Override
        @Usage(name="job description", args="<name> [<description>]", description="Change the specified jobs description.")
        public void exitJobDescription(CommandsParser.JobDescriptionContext ctx) {
            if (this.wasError()) {
                return;
            }
            Job job = CommandExecutor.this.getJob(this.getName(ctx.uri()));
            if (job != null) {
                job.setDescription(CommandExecutor.getString(ctx.token()));
                this.command = new JobCommand(job, JobCommand.Action.UPDATE);
            }
        }

        @Override
        @Usages(value={@Usage(name="job start", args="<name> [confirm]", description="Start a job."), @Usage(name="job force start", args="<name>", description="Force start a job, even if its start conditions are not met.")})
        public void exitJobStart(CommandsParser.JobStartContext ctx) {
            if (this.wasError()) {
                return;
            }
            Name name = this.getName(ctx.uri());
            Job job = CommandExecutor.this.getJob(name);
            if (job == null) {
                return;
            }
            if (ctx.confirm() == null && !CommandExecutor.this.confirmJobAction(job, Job.Action.START)) {
                return;
            }
            JobControl command = new JobControl(name, Job.Action.START);
            command.setForce(ctx.force() != null);
            this.command = command;
        }

        @Override
        @Usage(name="job kill", args="<name>", description="Kill a running job.")
        public void exitJobKill(CommandsParser.JobKillContext ctx) {
            if (this.wasError()) {
                return;
            }
            Name name = this.getName(ctx.uri());
            Job job = CommandExecutor.this.getJob(name);
            if (job == null) {
                return;
            }
            if (ctx.confirm() == null && !CommandExecutor.this.confirmJobAction(job, Job.Action.START)) {
                return;
            }
            this.command = new JobControl(name, Job.Action.KILL);
        }

        @Override
        @Usages(value={@Usage(name="job enable", args="<name>", description="Enable a job."), @Usage(name="job disable", args="<name>", description="Disable a job."), @Usage(name="job bypass", args="<name>", description="Place a job into bypass mode.")})
        public void exitJobMode(CommandsParser.JobModeContext ctx) {
            if (this.wasError()) {
                return;
            }
            Job.Mode mode = null;
            if (this.childEquals(ctx, 0, "enable")) {
                mode = Job.Mode.ENABLED;
            } else if (this.childEquals(ctx, 0, "disable")) {
                mode = Job.Mode.DISABLED;
            } else if (this.childEquals(ctx, 0, "bypass")) {
                mode = Job.Mode.BYPASS;
            }
            this.command = new JobControl(this.getName(ctx.uri()), mode);
        }

        @Override
        @Usage(name="job status", args="[<status>] [<filter>]", description="List the status of all jobs or a specific job.")
        public void exitJobStatus(CommandsParser.JobStatusContext ctx) {
            if (this.wasError()) {
                return;
            }
            JobStatusQuery query = new JobStatusQuery();
            if (ctx.status() != null) {
                query.setStatusFilter(new Status.Filter(CommandExecutor.getStrings(ctx.status())));
            }
            if (ctx.uri() != null || CommandExecutor.this.currentGroupSet) {
                query.setFilter(this.getPathFilter(this.getName(ctx.uri()).toString()));
            }
            CommandExecutor.this.summaryOutput = ctx.full() == null;
            this.command = query;
        }

        @Override
        @Usage(name="job status subscribe", args="[<status>] [<duration> (seconds|minutes|hours)]? [<filter>]", description="Subscribe to updates for all or specific jobs, for all or a specific status, optionally for a specific duration.")
        public void exitJobStatusSubscribe(CommandsParser.JobStatusSubscribeContext ctx) {
            long expiry;
            if (this.wasError()) {
                return;
            }
            if (CommandExecutor.this.jobStatusListener == null) {
                CommandExecutor.this.jobStatusListener = new JobStatusListener();
            } else {
                CommandExecutor.this.jobStatusListener.stop();
            }
            if (ctx.status() != null) {
                CommandExecutor.this.jobStatusListener.setStatusFilter(new Status.Filter(CommandExecutor.getStrings(ctx.status())));
            }
            if (ctx.NUMBER() != null) {
                long l = Long.parseLong(ctx.NUMBER().getText());
                expiry = System.currentTimeMillis() + Period.Unit.fromString((String)ctx.secondsHours().getText()).getMilliseconds(l);
            } else {
                expiry = System.currentTimeMillis() + Period.Unit.MINUTE.getMilliseconds(1L);
            }
            CommandExecutor.this.jobStatusListener.setExpiry(expiry);
            CommandExecutor.this.jobStatusListener.start(ctx.uri() != null ? this.getPathFilter(ctx.uri().getText()) : null);
        }

        @Override
        @Usage(name="job status unsubscribe", description="Unsubscribe to job updates.")
        public void exitJobStatusUnsubscribe(CommandsParser.JobStatusUnsubscribeContext ctx) {
            if (this.wasError()) {
                return;
            }
            if (CommandExecutor.this.jobStatusListener != null) {
                CommandExecutor.this.jobStatusListener.stop();
                CommandExecutor.this.jobStatusListener = null;
            }
        }

        @Override
        @Usage(name="job changes", args="<name>", description="List changes to a specific job.")
        public void exitJobChanges(CommandsParser.JobChangesContext ctx) {
            if (this.wasError()) {
                return;
            }
            CommandExecutor.this.summaryOutput = true;
            this.command = new ChangeQuery(this.getName(ctx.uri()), ChangeQuery.Type.JOB);
        }

        @Override
        @Usage(name="job diff", args="<name> [<change> [<change>]]", description="Show the difference between two versions of a job")
        public void exitJobDiff(CommandsParser.JobDiffContext ctx) {
            if (this.wasError()) {
                return;
            }
            this.command = new JobQuery(this.getName(ctx.uri()), CommandExecutor.getChangeIds(ctx.token(), "0", "0"));
        }

        @Override
        @Usage(name="job history", args="[full] <name> [last <int>? (seconds|minutes|hours|days)]", description="List the status history of a job.")
        public void exitJobHistory(CommandsParser.JobHistoryContext ctx) {
            int index;
            if (this.wasError()) {
                return;
            }
            Name name = this.getName(ctx.uri());
            if (name.isWildcard()) {
                if (!CommandExecutor.this.isGroup(name.isRootGroup() ? Name.ROOT : name.getGroup())) {
                    CommandExecutor.this.outputError("Group %s does not exist", name.getGroup());
                    return;
                }
            } else if (CommandExecutor.this.isGroup(name)) {
                name = Name.parse((Name)name, (String[])new String[]{"*"});
            } else {
                Job job = CommandExecutor.this.getJob(name);
                if (job == null) {
                    return;
                }
            }
            CommandExecutor.this.jobHistoryFilter.reset();
            if (ctx.result() != null) {
                CommandExecutor.this.jobHistoryFilter.add(CommandExecutor.getStrings(ctx.result()));
            }
            long startTimestamp = System.currentTimeMillis();
            List<String> tokens = CommandExecutor.getStrings(ctx);
            CommandExecutor.this.summaryOutput = !tokens.get(1).equalsIgnoreCase("full");
            int n = index = CommandExecutor.this.summaryOutput ? 2 : 3;
            if (index < tokens.size() && tokens.get(index++).equals("last")) {
                long i = 1L;
                try {
                    i = Integer.parseInt(ctx.NUMBER().getText());
                    ++index;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                startTimestamp -= Period.Unit.valueOf((String)StringUtils.singular((String)tokens.get(index)).toUpperCase()).getMilliseconds(i);
            } else {
                startTimestamp -= Period.Unit.DAY.getMilliseconds(1L);
            }
            this.command = new JobHistoryQuery(name, startTimestamp);
        }

        @Override
        @Usage(name="job history", args="clear <name>", description="Clear the status history of a job.")
        public void exitJobHistoryClear(CommandsParser.JobHistoryClearContext ctx) {
            if (this.wasError()) {
                return;
            }
            this.command = new JobHistoryClear(this.getName(ctx.uri()));
        }

        @Override
        @Usage(name="job output", args="<name> [<timestamp>]", description="List the output of a job.")
        public void exitJobOutput(CommandsParser.JobOutputContext ctx) {
            long timestamp;
            if (this.wasError()) {
                return;
            }
            Name name = this.getName(ctx.uri());
            Job job = CommandExecutor.this.getJob(name);
            if (job == null) {
                return;
            }
            try {
                timestamp = Long.parseLong(ctx.NUMBER().getText());
            }
            catch (Exception e) {
                timestamp = -1L;
            }
            this.command = new JobOutputQuery(name, timestamp);
        }

        @Override
        @Usage(name="job output", args="set <name> <path>", description="Set a job specific output path.")
        public void exitJobOutputSet(CommandsParser.JobOutputSetContext ctx) {
            if (this.wasError()) {
                return;
            }
            Name name = this.getName(ctx.uri());
            Job job = CommandExecutor.this.getJob(name);
            if (job == null) {
                return;
            }
            File file = new File(CommandExecutor.getString(ctx.token()));
            if (!FileUtils.isAbsolute((File)file)) {
                CommandExecutor.this.outputError("Path must be absolute: %s", file.getPath());
                return;
            }
            try {
                job.setOutput(file.toURI().toURL());
            }
            catch (Exception e) {
                CommandExecutor.this.outputError("Invalid path: %s", file.getPath());
                return;
            }
            this.command = new JobCommand(job, JobCommand.Action.UPDATE);
        }

        @Override
        @Usage(name="job output", args="clear <name>", description="Clear a job specific output path.")
        public void exitJobOutputClear(CommandsParser.JobOutputClearContext ctx) {
            if (this.wasError()) {
                return;
            }
            Name name = this.getName(ctx.uri());
            Job job = CommandExecutor.this.getJob(name);
            if (job == null) {
                return;
            }
            job.setOutput(null);
            this.command = new JobCommand(job, JobCommand.Action.UPDATE);
        }

        @Override
        @Usage(name="job timezone", args="<name> (<timezone>|current)", description="Set the timezone for the job schedule/s.")
        public void exitJobTimeZoneSet(CommandsParser.JobTimeZoneSetContext ctx) {
            if (this.wasError()) {
                return;
            }
            Job job = CommandExecutor.this.getJob(this.getName(ctx.uri()));
            if (job != null) {
                TimeZone timeZone;
                String id = ctx.token().getText();
                TimeZone timeZone2 = timeZone = id.equals("current") ? CommandExecutor.this.getTimeZone() : TimeUtils.getTimeZone((String)id);
                if (timeZone == null) {
                    this.parseError(Localise.format((String)"Unknown timezone: %s", (Object[])new Object[]{id}), new Object[0]);
                    return;
                }
                CommandExecutor.this.jobTimeZone = timeZone;
                job.setTimeZone(timeZone);
                this.command = new JobCommand(job, JobCommand.Action.UPDATE);
            }
        }

        @Override
        @Usages(value={@Usage(name="queue delete", args="<name>", description="Delete the specified queue."), @Usage(name="queue flush", args="<name>", description="Flush all messages from the specified queue.")})
        public void exitQueueAction(CommandsParser.QueueActionContext ctx) {
            if (this.wasError()) {
                return;
            }
            this.command = new QueueCommand(ctx.name().getText(), this.childEquals(ctx, 0, "delete") ? QueueCommand.Action.DELETE : QueueCommand.Action.FLUSH);
        }

        @Override
        @Usage(name="queue list", args="[full] [<filter>]", description="List details (summary or full) of all queues or a specific queue.")
        public void exitQueueList(CommandsParser.QueueListContext ctx) {
            if (this.wasError()) {
                return;
            }
            QueueQuery query = new QueueQuery();
            if (ctx.name() != null) {
                query.setFilter(Filter.getFilter((String)ctx.name().getText()));
            }
            CommandExecutor.this.summaryOutput = ctx.full() == null;
            this.command = query;
        }

        @Override
        @Usage(name="property changes", args="<name>", description="List changes to a specific groups properties.")
        public void exitPropertyChanges(CommandsParser.PropertyChangesContext ctx) {
            if (this.wasError()) {
                return;
            }
            CommandExecutor.this.summaryOutput = true;
            this.command = new ChangeQuery(this.getName(ctx.uri()), ChangeQuery.Type.PROPERTIES);
        }

        @Override
        @Usage(name="property diff", args="<name> [<change> [<change>]]", description="Show the difference between two versions of a groups properties")
        public void exitPropertyDiff(CommandsParser.PropertyDiffContext ctx) {
            if (this.wasError()) {
                return;
            }
            this.command = new PropertyQuery(this.getName(ctx.uri()), CommandExecutor.getChangeIds(ctx.token()));
        }

        @Override
        @Usage(name="property list", args="[full] <name>", description="List the effective properties a job or group")
        public void exitPropertyList(CommandsParser.PropertyListContext ctx) {
            if (this.wasError()) {
                return;
            }
            Name name = this.getName(ctx.uri());
            this.command = new PropertyQuery(name, ctx.full() == null && CommandExecutor.this.isGroup(name));
        }

        @Override
        @Usage(name="property list", args="<group> <change>", description="List properties a of group for a specific change")
        public void exitPropertyListChange(CommandsParser.PropertyListChangeContext ctx) {
            if (this.wasError()) {
                return;
            }
            PropertyQuery query = new PropertyQuery(this.getName(ctx.uri()));
            query.addChangeId(ctx.token().getText());
            this.command = query;
        }

        @Override
        @Usage(name="property set", args="<name> [secret] [environment|header|parameter|resource|system|variable] <property> <value>", description="Set a property on the specified group.")
        public void exitPropertySet(CommandsParser.PropertySetContext ctx) {
            String message;
            if (this.wasError()) {
                return;
            }
            String name = ctx.propertyName().getText();
            Property property = new Property(name, CommandExecutor.getString(ctx.token()));
            Name group = this.getName(ctx.uri());
            property.setGroup(group);
            if (ctx.propertySecret() != null) {
                property.setSecret(true);
            }
            if (ctx.propertyType() != null) {
                property.setType(Property.Type.getType((String)ctx.propertyType().getText()));
            }
            if ((message = property.validate(Schema.Scope.GROUP).getMessage()) != null) {
                CommandExecutor.this.outputError(message, new Object[0]);
                return;
            }
            this.command = new PropertyCommand(group, property, PropertyCommand.Action.SET);
        }

        @Override
        @Usage(name="property delete", args="<name> [<property>]", description="Delete a property or all properties on the specified group.")
        public void exitPropertyDelete(CommandsParser.PropertyDeleteContext ctx) {
            Property property;
            if (this.wasError()) {
                return;
            }
            Name group = this.getName(ctx.uri());
            Property property2 = property = ctx.propertyName() != null ? new Property(ctx.propertyName().getText(), "") : null;
            if (property != null) {
                property.setGroup(group);
                this.command = new PropertyCommand(group, property, PropertyCommand.Action.DELETE);
            } else {
                this.command = new PropertyCommand(group, PropertyCommand.Action.DELETE);
            }
        }

        @Override
        @Usage(name="property unset", args="<name> <property>", description="Unset an inherited property")
        public void exitPropertyUnset(CommandsParser.PropertyUnsetContext ctx) {
            if (this.wasError()) {
                return;
            }
            Name group = this.getName(ctx.uri());
            String name = ctx.propertyName().getText();
            Property property = new Property(name, "");
            property.setGroup(group);
            property.setType(Property.Type.UNSET);
            if (!property.canUnset()) {
                CommandExecutor.this.outputError("Cannot unset property", new Object[0]);
                return;
            }
            if (group.equals((Object)Name.ROOT)) {
                CommandExecutor.this.outputError("Cannon unset properties in %s", group.toString());
                return;
            }
            if (!CommandExecutor.this.isGroupProperty(group.isRootGroup() ? Name.ROOT : group.getGroup(), name)) {
                CommandExecutor.this.outputError("Property %s is not inherited by %s", name, group);
                return;
            }
            this.command = new PropertyCommand(group, property, PropertyCommand.Action.SET);
        }

        @Override
        @Usage(name="protected", args="(host|user) changes", description="List changes to protected hosts or users.")
        public void exitProtectedChanges(CommandsParser.ProtectedChangesContext ctx) {
            if (this.wasError()) {
                return;
            }
            Protected.Type type = Protected.Type.valueOf((String)ctx.hostUser().getText().toUpperCase());
            CommandExecutor.this.summaryOutput = true;
            this.command = new ChangeQuery(ProtectedList.getPersistName((Protected.Type)type), ChangeQuery.Type.ACLS);
        }

        @Override
        @Usage(name="protected", args="(host|user) list [<change>]", description="List all protected hosts/users.")
        public void exitProtectedList(CommandsParser.ProtectedListContext ctx) {
            if (this.wasError()) {
                return;
            }
            Protected.Type type = Protected.Type.valueOf((String)ctx.hostUser().getText().toUpperCase());
            ProtectedQuery query = new ProtectedQuery(type);
            if (ctx.token() != null) {
                query.addChangeId(ctx.token().getText());
            }
            this.command = query;
        }

        @Override
        @Usage(name="protected", args="(host|user) add <name>", description="Add a protected host/user.")
        public void exitProtectedAdd(CommandsParser.ProtectedAddContext ctx) {
            if (this.wasError()) {
                return;
            }
            Protected.Type type = Protected.Type.valueOf((String)ctx.hostUser().getText().toUpperCase());
            this.command = new ProtectedCommand(type, ctx.token().getText(), ProtectedCommand.Action.ADD);
        }

        @Override
        @Usage(name="protected", args="(host|user) delete <name>", description="Delete a protected host/user.")
        public void exitProtectedDelete(CommandsParser.ProtectedDeleteContext ctx) {
            if (this.wasError()) {
                return;
            }
            Protected.Type type = Protected.Type.valueOf((String)ctx.hostUser().getText().toUpperCase());
            this.command = new ProtectedCommand(type, ctx.token().getText(), ProtectedCommand.Action.DELETE);
        }

        @Override
        @Usage(name="protected", args="(host|user) diff [<change> [<change>]]", description="Show the differences between two versions of protected hosts/users")
        public void exitProtectedDiff(CommandsParser.ProtectedDiffContext ctx) {
            if (this.wasError()) {
                return;
            }
            Protected.Type type = Protected.Type.valueOf((String)ctx.hostUser().getText().toUpperCase());
            this.command = new ProtectedQuery(type, CommandExecutor.getChangeIds(ctx.token()));
        }

        @Override
        @Usage(name="role list", args="[<filter>]", description="List details of all user roles or a specific role.")
        public void exitRoleList(CommandsParser.RoleListContext ctx) {
            if (this.wasError()) {
                return;
            }
            RoleQuery command = new RoleQuery();
            if (ctx.name() != null) {
                command.setFilter(Filter.getFilter((String)ctx.name().getText()));
            }
            this.command = command;
        }

        @Override
        @Usage(name="role add", args="<name> [<description>]", description="Add/create the specified role.")
        public void exitRoleAdd(CommandsParser.RoleAddContext ctx) {
            if (this.wasError()) {
                return;
            }
            Role role = new Role(ctx.name().getText());
            if (ctx.token().size() > 0) {
                role.setDescription(CommandExecutor.getString(ctx.token()));
            }
            this.command = new RoleCommand(role, RoleCommand.Action.CREATE);
        }

        @Override
        @Usage(name="role delete", args="<name>", description="Delete the specified role")
        public void exitRoleDelete(CommandsParser.RoleDeleteContext ctx) {
            if (this.wasError()) {
                return;
            }
            this.command = new RoleCommand(ctx.name().getText(), RoleCommand.Action.DELETE);
        }

        @Override
        @Usage(name="role description", args="<name> [<description>]", description="Change the specified roles description")
        public void exitRoleDescription(CommandsParser.RoleDescriptionContext ctx) {
            if (this.wasError()) {
                return;
            }
            Role role = CommandExecutor.this.getRole(ctx.name().getText(), false);
            if (role != null) {
                role.setDescription(CommandExecutor.getString(ctx.token()));
                this.command = new RoleCommand(role, RoleCommand.Action.UPDATE);
            }
        }

        @Override
        @Usage(name="cluster info", args="[<selector> ...]", description="List detailed BeyondCron information")
        public void exitClusterInfo(CommandsParser.ClusterInfoContext ctx) {
            if (this.wasError()) {
                return;
            }
            ArrayList<String> filter = new ArrayList<String>();
            for (CommandsParser.WordContext word : ctx.word()) {
                filter.add(word.getText());
            }
            this.command = new ClusterQuery(filter);
        }

        @Override
        @Usage(name="server list", args="[full]", description="List server details.")
        public void exitServerList(CommandsParser.ServerListContext ctx) {
            if (this.wasError()) {
                return;
            }
            CommandExecutor.this.summaryOutput = ctx.full() == null;
            this.command = new ServerQuery();
        }

        @Override
        @Usage(name="timezone list [<filter>]", description="List (all or a subset of) available timezones.")
        public void exitTimezoneList(CommandsParser.TimezoneListContext ctx) {
            if (this.wasError()) {
                return;
            }
            String filter = ctx.name() != null ? ctx.name().getText().toLowerCase() : null;
            TreeMap<String, String> timezones = new TreeMap<String, String>();
            TableFormatter table = new TableFormatter();
            table.addColumn("Timezone");
            table.addColumn("Description");
            for (String id : TimeZone.getAvailableIDs()) {
                String name = TimeZone.getTimeZone(id).getDisplayName();
                if (filter != null && !id.toLowerCase().contains(filter) && !name.toLowerCase().contains(filter)) continue;
                timezones.put(id, name);
            }
            for (String id : timezones.keySet()) {
                table.addRow(new Object[]{id, timezones.get(id)});
            }
            CommandExecutor.this.output(table);
        }

        @Override
        @Usage(name="timezone print", description="Print the current timezone.")
        public void exitTimezonePrint(CommandsParser.TimezonePrintContext ctx) {
            CommandExecutor.this.output("%s (%s)", CommandExecutor.this.timeZone.getDisplayName(), CommandExecutor.this.timeZone.getID());
        }

        @Override
        @Usage(name="timezone set", description="Set the local/default timezone.")
        public void exitTimezoneSet(CommandsParser.TimezoneSetContext ctx) {
            String id = ctx.token().getText();
            TimeZone timeZone = TimeUtils.getTimeZone((String)id);
            if (timeZone == null) {
                this.parseError("Unknown timezone: %s", id);
                return;
            }
            CommandExecutor.this.setTimeZone(timeZone);
        }

        @Override
        @Usage(name="timestamp (on|off)", description="Show the execution time of each command")
        public void exitTimestampOnOff(CommandsParser.TimestampOnOffContext ctx) {
            if (this.wasError()) {
                return;
            }
            CommandExecutor.this.timestamp = ctx.onOff().getText().equals("on");
        }

        @Override
        @Usage(name="topic list", args="[full] [<filter>]", description="List details (summary or full) of all topcis or a specific queue.")
        public void exitTopicList(CommandsParser.TopicListContext ctx) {
            if (this.wasError()) {
                return;
            }
            TopicQuery query = new TopicQuery();
            if (ctx.name() != null) {
                query.setFilter(Filter.getFilter((String)ctx.name().getText()));
            }
            CommandExecutor.this.summaryOutput = ctx.full() == null;
            this.command = query;
        }

        @Override
        @Usage(name="user list", args="[<filter>]", description="List details of all users or specific users.")
        public void exitUserList(CommandsParser.UserListContext ctx) {
            if (this.wasError()) {
                return;
            }
            UserQuery command = new UserQuery();
            if (ctx.name() != null) {
                command.setFilter(Filter.getFilter((String)ctx.name().getText()));
            }
            this.command = command;
        }

        @Override
        @Usage(name="user show", args="[<name>]", description="List details of the current or specific user.")
        public void exitUserShow(CommandsParser.UserShowContext ctx) {
            if (this.wasError()) {
                return;
            }
            this.command = new UserQuery(ctx.name() != null ? ctx.name().getText() : CommandExecutor.this.user.getName());
        }

        @Override
        @Usage(name="user add", args="<name> [<description>]", description="Add/create the specified user.")
        public void exitUserAdd(CommandsParser.UserAddContext ctx) {
            if (this.wasError()) {
                return;
            }
            User user = new User(ctx.name().getText());
            if (ctx.token().size() > 0) {
                user.setDescription(CommandExecutor.getString(ctx.token()));
            }
            this.command = new UserCommand(user, UserCommand.Action.CREATE);
        }

        @Override
        @Usage(name="user role add", args="<name> <role> ...", description="Add one or more roles to the specified user.")
        public void exitUserAddRole(CommandsParser.UserAddRoleContext ctx) {
            if (this.wasError()) {
                return;
            }
            User user = CommandExecutor.this.getUser(ctx.name().getText());
            if (user != null) {
                for (CommandsParser.RoleContext role : ctx.role()) {
                    user.addRole(role.getText());
                }
                this.command = new UserCommand(user, UserCommand.Action.UPDATE);
            }
        }

        @Override
        @Usage(name="user delete", args="<name>", description="Delete the specified user.")
        public void exitUserDelete(CommandsParser.UserDeleteContext ctx) {
            if (this.wasError()) {
                return;
            }
            this.command = new UserCommand(ctx.name().getText(), UserCommand.Action.DELETE);
        }

        @Override
        @Usage(name="user role delete", args="<name> <role> ...", description="Delete one more roles from the specified user.")
        public void exitUserDeleteRole(CommandsParser.UserDeleteRoleContext ctx) {
            if (this.wasError()) {
                return;
            }
            User user = CommandExecutor.this.getUser(ctx.name().getText());
            if (user != null) {
                for (CommandsParser.RoleContext role : ctx.role()) {
                    user.removeRole(role.getText());
                }
                this.command = new UserCommand(user, UserCommand.Action.UPDATE);
            }
        }

        @Override
        @Usage(name="user description", args="<name> [<description>]", description="Change the specified users description.")
        public void exitUserDescription(CommandsParser.UserDescriptionContext ctx) {
            if (this.wasError()) {
                return;
            }
            User user = CommandExecutor.this.getUser(ctx.name().getText());
            if (user != null) {
                user.setDescription(CommandExecutor.getString(ctx.token()));
                this.command = new UserCommand(user, UserCommand.Action.UPDATE);
            }
        }

        @Override
        @Usage(name="user password", args="[<name>] <password>", description="Change the specified users password")
        public void exitUserPassword(CommandsParser.UserPasswordContext ctx) {
            if (this.wasError()) {
                return;
            }
            User user = CommandExecutor.this.getUser(ctx.name() != null ? ctx.name().getText() : CommandExecutor.USER_SELF);
            if (user == null) {
                return;
            }
            String password = ctx.password().getText();
            if (password.equals(CommandExecutor.PASSWORD_MASK)) {
                CommandExecutor.this.outputError("Invalid password", new Object[0]);
                return;
            }
            this.command = new UserPassword(user.getName(), password);
        }

        @Override
        @Usages(value={@Usage(name="user service show", description="show details of the user service"), @Usage(name="user service refresh", description="refresh the user cache"), @Usage(name="user service reload", description="reload the user service")})
        public void exitUserService(CommandsParser.UserServiceContext ctx) {
            if (this.wasError()) {
                return;
            }
            String action = ctx.showReloadRefresh().getText();
            this.command = action.equals("refresh") ? new ServiceCommand(Service.Type.USER, ServiceCommand.Action.REFRESH) : (action.equals("reload") ? new ServiceCommand(Service.Type.USER, ServiceCommand.Action.RELOAD) : new ServiceQuery(Service.Type.USER));
        }

        @Override
        @Usages(value={@Usage(name="status service show", description="show details of the status service"), @Usage(name="status service reload", description="reload the status service")})
        public void exitStatusService(CommandsParser.StatusServiceContext ctx) {
            if (this.wasError()) {
                return;
            }
            String action = ctx.showReload().getText();
            this.command = action.equals("reload") ? new ServiceCommand(Service.Type.STATUS, ServiceCommand.Action.RELOAD) : new ServiceQuery(Service.Type.STATUS);
        }

        @Override
        @Usage(name="host acl changes", description="List host acl changes.")
        public void exitHostAclChanges(CommandsParser.HostAclChangesContext ctx) {
            if (this.wasError()) {
                return;
            }
            CommandExecutor.this.summaryOutput = true;
            this.command = new ChangeQuery(new HostACLList(null).getPersistName(), ChangeQuery.Type.ACLS);
        }

        @Override
        @Usage(name="host acl diff", args="[<change> [<change>]]", description="Show the differences between two versions of the host acls")
        public void exitHostAclDiff(CommandsParser.HostAclDiffContext ctx) {
            if (this.wasError()) {
                return;
            }
            this.command = new HostACLQuery(CommandExecutor.getChangeIds(ctx.token()));
        }

        @Override
        @Usage(name="host acl list", args="[<change>|<userRole>|self]", description="List all host acls of all users/roles or a specific user/role.")
        public void exitHostAclList(CommandsParser.HostAclListContext ctx) {
            if (this.wasError()) {
                return;
            }
            HostACLQuery command = new HostACLQuery();
            if (ctx.token() != null) {
                String s = ctx.token().getText();
                if (Change.isChangeId((String)s)) {
                    command.addChangeId(s);
                } else {
                    if (s.equals(Localise.format((String)CommandExecutor.USER_SELF))) {
                        s = CommandExecutor.this.user.getName();
                    }
                    command.setUserRole(s);
                }
            }
            this.command = command;
        }

        @Override
        @Usage(name="host acl set", args="<userRole> [regex:][<userPattern>@]?<hostPattern>", description="Add/update a job user acl for the specified user/role.")
        public void exitHostAclSet(CommandsParser.HostAclSetContext ctx) {
            if (this.wasError()) {
                return;
            }
            try {
                this.command = new HostACLCommand(new HostACL(ctx.name().getText(), ctx.token().getText()), HostACLCommand.Action.SET);
            }
            catch (IllegalArgumentException e) {
                this.parseError(StringUtils.capitalise((Object)e.getMessage()), new Object[0]);
            }
        }

        @Override
        @Usage(name="host acl delete", args="<userRole> [[<userPattern>@]<hostPattern>]", description="Clear a job user acl for the specified user/role.")
        public void exitHostAclDelete(CommandsParser.HostAclDeleteContext ctx) {
            if (this.wasError()) {
                return;
            }
            String userRole = ctx.name().getText();
            CommandsParser.TokenContext pattern = ctx.token();
            HostACL acl = pattern != null ? new HostACL(userRole, pattern.getText()) : null;
            try {
                this.command = acl != null ? new HostACLCommand(acl, HostACLCommand.Action.DELETE) : new HostACLCommand(userRole, HostACLCommand.Action.DELETE);
            }
            catch (IllegalArgumentException e) {
                this.parseError(StringUtils.capitalise((Object)e.getMessage()), new Object[0]);
            }
        }

        @Override
        @Usages(value={@Usage(name="export", args="[(acls|calendars|configs|hosts|jobs|properties|protected|all)*] <name> [(json|yaml|yml)] [relative]", description="Export BeyondCron configuration to the console as json or yaml."), @Usage(name="export", args="[(acls|calendars|configs|hosts|jobs|properties|protected|all)*] <name> <file>.(json|yaml|yml) [relative] [verbose]", description="Export BeyondCron configuration file as json or yaml.")})
        public void exitExportCommand(CommandsParser.ExportCommandContext ctx) {
            String suffix;
            if (this.wasError()) {
                return;
            }
            List<CommandsParser.UriContext> uris = ctx.uri();
            Name name = this.getName(uris.get(0));
            String fileName = uris.size() > 1 ? uris.get(1).getText() : "yaml";
            boolean relative = !ctx.relative().isEmpty();
            Name group = null;
            if (relative) {
                group = CommandExecutor.this.isGroup(name) ? name : (name.isRootGroup() ? Name.ROOT : name.getGroup());
            }
            boolean summary = ctx.verbose().isEmpty();
            ExportIO data = new ExportIO(CommandExecutor.this.connection, group);
            if (!data.exists(name)) {
                CommandExecutor.this.outputError("%s does not exist", name.toString());
                return;
            }
            HashSet<AbstractIO.DataType> types = new HashSet<AbstractIO.DataType>();
            for (CommandsParser.DataTypeContext type : ctx.dataType()) {
                types.add(AbstractIO.DataType.getDataType((String)type.getText()));
            }
            if (types.isEmpty()) {
                types.addAll(AbstractIO.DataType.getDefaultTypes());
            }
            data.add(name, AbstractIO.DataType.consolidateTypes(types));
            String s = fileName.toLowerCase();
            boolean stdout = false;
            switch (s) {
                case "json": 
                case "yaml": 
                case "yml": {
                    stdout = true;
                }
            }
            if (stdout) {
                ByteArrayOutputStream outBuffer = new ByteArrayOutputStream();
                PrintStream out = new PrintStream(outBuffer);
                switch (fileName.toLowerCase()) {
                    case "json": {
                        data.writeJSON((OutputStream)out);
                        break;
                    }
                    case "yaml": 
                    case "yml": {
                        data.writeYAML((OutputStream)out);
                    }
                }
                CommandExecutor.this.output(outBuffer.toString(), false);
                return;
            }
            if (CommandExecutor.this.commandListener != null && !CommandExecutor.this.connection.hasPermission(BlissUtils.ACL_DIR_WEB_FILESYSTEM, ACL.Permission.WRITE)) {
                CommandExecutor.this.outputError("Insufficient permission to export to the filesystem using %1$s", Program.getName());
                return;
            }
            File file = new File(fileName);
            switch (suffix = FileUtils.getSuffix((File)file, (String)"").toLowerCase()) {
                case "json": {
                    break;
                }
                case "yaml": 
                case "yml": {
                    break;
                }
                case "": {
                    this.parseError("File type missing, expected .json, .yaml or .yml", new Object[0]);
                    return;
                }
                default: {
                    this.parseError("Unsupported file type .%s, expected .json, .yaml, or .yml", suffix);
                    return;
                }
            }
            if (file.exists()) {
                if (!file.canWrite()) {
                    this.parseError("Cannot overwrite file %s (Permission denied)", file);
                    return;
                }
            } else {
                File dir = file.getAbsoluteFile().getParentFile();
                if (!dir.exists()) {
                    this.parseError("Directory %s does not exist", dir);
                    return;
                }
                if (!dir.canWrite()) {
                    this.parseError("Cannot create file %s (Permission denied)", file);
                    return;
                }
            }
            try (FileOutputStream out = new FileOutputStream(file);){
                switch (suffix) {
                    case "json": {
                        data.writeJSON((OutputStream)out);
                        break;
                    }
                    case "yaml": 
                    case "yml": {
                        data.writeYAML((OutputStream)out);
                    }
                }
                if (!data.isEmpty()) {
                    Object items;
                    if (summary) {
                        items = new ArrayList();
                        for (AbstractIO.DataType type : data.getTypes()) {
                            int count = 0;
                            switch (type) {
                                case ACL: {
                                    count = data.getACLs().size();
                                    break;
                                }
                                case CALENDAR: {
                                    count = data.getCalendars().size();
                                    break;
                                }
                                case CONFIG: {
                                    count = data.getConfigs().size();
                                    break;
                                }
                                case HOST: {
                                    count = data.getHostAcls().size();
                                    break;
                                }
                                case JOB: {
                                    count = data.getJobs().size();
                                    break;
                                }
                                case PROPERTY: {
                                    count = data.getProperties().size();
                                    break;
                                }
                                case PROTECTED: {
                                    count = data.getProtected(Protected.Type.HOST).size() + data.getProtected(Protected.Type.USER).size();
                                    break;
                                }
                                case ROLE: {
                                    count = data.getRoles().size();
                                    break;
                                }
                                case USER: {
                                    count = data.getUsers().size();
                                }
                            }
                            if (count <= 0) continue;
                            items.add((String)Localise.format((String)"%d %s", (Object[])new Object[]{count, StringUtils.plural((String)type.getLabel(), (int)count)}));
                        }
                        CommandExecutor.this.output("Exported %1$s.", StringUtils.join((String)", ", (String)" & ", items));
                    } else {
                        CommandExecutor.this.output("Exported:", new Object[0]);
                        for (User user : data.getUsers()) {
                            CommandExecutor.this.output("- %1$s (%2$s)", user.getName(), AbstractIO.DataType.USER);
                        }
                        for (Role role : data.getRoles()) {
                            CommandExecutor.this.output("- %1$s (%2$s)", role.getName(), AbstractIO.DataType.ROLE);
                        }
                        for (Config config : data.getConfigs()) {
                            CommandExecutor.this.output("- %1$s (%2$s)", config.getName(), AbstractIO.DataType.CONFIG);
                        }
                        for (String value : data.getProtected(Protected.Type.HOST)) {
                            CommandExecutor.this.output("- %1$s (%2$s host)", value, AbstractIO.DataType.PROTECTED);
                        }
                        for (String value : data.getProtected(Protected.Type.USER)) {
                            CommandExecutor.this.output("- %1$s (%2$s user)", value, AbstractIO.DataType.PROTECTED);
                        }
                        for (HostACL acl : data.getHostAcls()) {
                            CommandExecutor.this.output("- %1$s (%2$s)", acl.getUserRole(), AbstractIO.DataType.HOST);
                        }
                        items = new TreeSet();
                        for (ACL acl : data.getACLs()) {
                            items.add(Localise.format((String)"- %1$s (%2$s)", (Object[])new Object[]{acl.getName(), AbstractIO.DataType.ACL}));
                        }
                        for (Calendar calendar : data.getCalendars()) {
                            items.add(Localise.format((String)"- %1$s (%2$s)", (Object[])new Object[]{calendar.getName(), AbstractIO.DataType.CALENDAR}));
                        }
                        for (Job job : data.getJobs()) {
                            items.add(Localise.format((String)"- %1$s (%2$s)", (Object[])new Object[]{job.getName(), AbstractIO.DataType.JOB}));
                        }
                        if (!items.isEmpty()) {
                            CommandExecutor.this.output(StringUtils.join((String)"\n", new ArrayList(items)), new Object[0]);
                        }
                    }
                } else {
                    CommandExecutor.this.output("Nothing selected/readable to export", new Object[0]);
                }
                this.command = new Result();
            }
            catch (IOException e) {
                this.parseError("Error creating %1$s - %2$s", file, e.getMessage());
            }
        }

        @Override
        @Usage(name="import", args="(acls|calendars|configs|hosts|jobs|properties|protected|all)* <name> <file>.(json|yaml|yml) [(insert|replace|update)] [confirm] [quiet] [timestamp] [<name>=<value>] ...[-- <reference>]", description="Import a json or yaml BeyondCron configuration file.")
        public void exitImportCommand(CommandsParser.ImportCommandContext ctx) {
            String reference;
            String token;
            if (this.wasError()) {
                return;
            }
            Name name = this.getName(ctx.uri(0));
            File file = new File(ctx.uri(1).getText());
            ImportIO.Mode mode = ctx.updateReplace().isEmpty() ? ImportIO.Mode.INSERT : ImportIO.Mode.valueOf((String)ctx.updateReplace().get(0).getText().toUpperCase());
            boolean confirm = ctx.confirm().isEmpty();
            boolean verbose = ctx.quiet().isEmpty();
            List<String> tokens = CommandExecutor.getStrings(ctx.token());
            HashMap<String, String> variables = new HashMap<String, String>();
            while (!tokens.isEmpty() && !(token = tokens.remove(0)).equals("--")) {
                Matcher m = PROPERTY_DEFINE_REGEX.matcher(token);
                if (m.matches()) {
                    variables.put(m.group(1), m.group(2));
                    continue;
                }
                CommandExecutor.this.outputError("Invalid property definition - %1$s", token);
                return;
            }
            String string = reference = !tokens.isEmpty() ? StringUtils.join((String)" ", tokens) : "";
            if (CommandExecutor.this.commandListener != null && !CommandExecutor.this.connection.hasPermission(BlissUtils.ACL_DIR_WEB_FILESYSTEM, ACL.Permission.WRITE)) {
                CommandExecutor.this.outputError("Insufficient permission to import from the filesystem using %1$s", Program.getName());
                return;
            }
            HashSet<AbstractIO.DataType> types = new HashSet<AbstractIO.DataType>();
            for (CommandsParser.DataTypeContext type : ctx.dataType()) {
                types.add(AbstractIO.DataType.getDataType((String)type.getText()));
            }
            if (types.isEmpty()) {
                types.addAll(AbstractIO.DataType.getDefaultTypes());
            }
            types = AbstractIO.DataType.consolidateTypes(types);
            long time = System.currentTimeMillis();
            new ImportCommand(CommandExecutor.this.connection, CommandExecutor.this.commandListener).execute(name, file, types, mode, variables, reference, confirm, verbose);
            if (CommandExecutor.this.timestamp || !ctx.timestamp().isEmpty()) {
                CommandExecutor.this.printTimestamp(System.currentTimeMillis() - time);
            }
        }

        @Override
        @Usage(name="clear", description="Clear terminal")
        public void exitClear(CommandsParser.ClearContext ctx) {
            if (!this.wasError() && CommandExecutor.this.commandListener == null) {
                CommandExecutor.this.outputError("command not supported in %s", Program.getName());
            }
        }

        @Override
        @Usages(value={@Usage(name="exit", description="Exit program"), @Usage(name="quit", description="Exit program")})
        public void exitQuit(CommandsParser.QuitContext ctx) {
            if (!this.wasError() && CommandExecutor.this.commandListener != null) {
                CommandExecutor.this.outputError("command not supported in %s", Program.getName());
            }
        }

        @Override
        @Usages(value={@Usage(name="help", description="Print this message"), @Usage(name="?", description="Print this message")})
        public void exitHelp(CommandsParser.HelpContext ctx) {
            if (this.wasError()) {
                return;
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            if (ctx.name() == null) {
                this.usage.printUsage((OutputStream)out, true);
            } else if (!this.usage.printUsage((OutputStream)out, ctx.name().getText(), CommandExecutor.getStrings(ctx.token()))) {
                CommandExecutor.this.outputError("Unknown command/s: %s", ctx.name().getText());
            }
            if (out.size() > 0) {
                CommandExecutor.this.output(out.toString(), new Object[0]);
            }
        }

        @Override
        @Usage(name="server license", description="Display the servers license")
        public void exitServerLicense(CommandsParser.ServerLicenseContext ctx) {
            if (this.wasError()) {
                return;
            }
            this.command = new LicenseQuery(LicenseQuery.Type.SERVER);
        }

        @Override
        @Usage(name="server license", args="instance", description="Get the current server license instance")
        public void exitServerLicenseInstance(CommandsParser.ServerLicenseInstanceContext ctx) {
            if (this.wasError()) {
                return;
            }
            this.command = new LicenseQuery(LicenseQuery.Type.INSTANCE);
        }

        @Override
        @Usage(name="server license", args="request", description="Get the BeyondCron store url for purchasing/upgrading the server license")
        public void exitServerLicenseRequest(CommandsParser.ServerLicenseRequestContext ctx) {
            License license;
            long minJobs;
            if (this.wasError()) {
                return;
            }
            long jobs = minJobs = 10L;
            long servers = 1L;
            ArrayList<CallSite> params = new ArrayList<CallSite>();
            ResultMessage message = CommandExecutor.this.connection.sendReceive((CommandMessage)new LicenseQuery(LicenseQuery.Type.INSTANCE));
            if (message instanceof LicenseQuery.Response) {
                params.add((CallSite)((Object)("instance=" + ((LicenseQuery.Response)message).getInstance())));
            }
            License license2 = license = (message = CommandExecutor.this.connection.sendReceive((CommandMessage)new LicenseQuery(LicenseQuery.Type.SERVER))) instanceof LicenseQuery.Response ? ((LicenseQuery.Response)message).getLicense() : null;
            if (license != null) {
                jobs = Math.max(license.getMaxJobs(), minJobs);
                servers = Math.max((long)license.getMaxServers(), servers);
            }
            if ((license == null || jobs == Long.MAX_VALUE) && (message = CommandExecutor.this.connection.sendReceive((CommandMessage)new LimitQuery(LimitQuery.Type.SERVER))) instanceof LimitQuery.Response) {
                Limit limit = ((LimitQuery.Response)message).getLimit();
                jobs = Math.max(limit.getJobs(), minJobs);
            }
            if (servers == Integer.MAX_VALUE && (message = CommandExecutor.this.connection.sendReceive((CommandMessage)new ServerQuery())) instanceof ServerQuery.Response) {
                servers = ((ServerQuery.Response)message).getServers().size();
            }
            params.add((CallSite)((Object)("jobs=" + (jobs == Long.MAX_VALUE ? -1L : jobs))));
            params.add((CallSite)((Object)("servers=" + servers)));
            String storeUrl = (String)Configs.get((String)"beyondcron.url.store");
            String storePath = String.format("%1$s?%2$s", storeUrl, StringUtils.join((String)"&", params));
            if (CommandExecutor.this.hasHtml) {
                String storeLink = String.format("<a href=\"%1$s\" target=\"bc-store\">%2$s %3$s</a>", storePath, storeUrl, "<i class=\"fas fa-external-link-alt\"></i>");
                CommandExecutor.this.output(new CommandOutput(CommandOutput.Level.INFO, Localise.format((String)"Store URL: %1$s", (Object[])new Object[]{storeLink})).setHtml(true), true);
            } else {
                CommandExecutor.this.output("Store URL: %1$s", storePath);
            }
        }

        @Override
        @Usage(name="server license", args="load <file>", description="Load a BeyondCron license file")
        public void exitServerLicenseLoad(CommandsParser.ServerLicenseLoadContext ctx) {
            if (this.wasError()) {
                return;
            }
            String value = ctx.uri().getText();
            URI uri = null;
            try {
                uri = NetUtils.parseURI((String)value, (String)"file");
            }
            catch (IllegalArgumentException e) {
                CommandExecutor.this.outputError("Invalid license file name: %s", value);
            }
            new LicenseLoadCommand(CommandExecutor.this.connection, CommandExecutor.this.commandListener).load(uri);
        }

        @Override
        public void exitUserLicense(CommandsParser.UserLicenseContext ctx) {
            if (this.wasError()) {
                return;
            }
            String userName = null;
            try {
                userName = ctx.name().getText();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            this.command = new LicenseQuery(LicenseQuery.Type.USER, userName);
        }

        @Override
        @Usage(name="server limits", args="[full]", description="Display the servers limits")
        public void exitServerLimits(CommandsParser.ServerLimitsContext ctx) {
            if (this.wasError()) {
                return;
            }
            CommandExecutor.this.summaryOutput = ctx.full() == null;
            this.command = new LimitQuery(LimitQuery.Type.SERVER);
        }

        @Override
        @Usages(value={@Usage(name="user limits", args="[full] [<name>]", description="Display a users limits"), @Usage(name="user limits reset", args="[<name>]", description="Reset a users limits")})
        public void exitUserLimits(CommandsParser.UserLimitsContext ctx) {
            if (this.wasError()) {
                return;
            }
            String userName = null;
            try {
                userName = ctx.name().getText();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            if (this.childEquals(ctx, 1, "reset")) {
                this.command = new LimitReset(userName);
            } else {
                CommandExecutor.this.summaryOutput = ctx.full() == null;
                this.command = new LimitQuery(LimitQuery.Type.USER, userName);
            }
        }

        @Override
        @Usage(name="version [full]", description="Print the program version")
        public void exitVersion(CommandsParser.VersionContext ctx) {
            if (this.wasError()) {
                return;
            }
            TableFormatter table = new TableFormatter();
            if (ctx.full() != null) {
                table.addColumns(new String[]{Program.getName(), Program.getVersion().toString(), Program.getCopyright()});
                for (Credit credit : Program.getCredits()) {
                    table.addRow(new Object[]{credit.getName(), credit.getVersion(), credit.getLicense()});
                }
            } else {
                table.displayHeader(false);
                table.addRow(new Object[]{Program.getName(), Program.getVersion(), Program.getCopyright()});
            }
            CommandExecutor.this.output(table);
        }

        @Override
        @Usage(name="updates", args="[refresh] [full]", description="List any available BeyondCron updates")
        public void exitUpdates(CommandsParser.UpdatesContext ctx) {
            Updates updates;
            Exception error;
            if (this.wasError()) {
                return;
            }
            if (ctx.refresh() != null) {
                Versions.Companion.updateVersions(true);
            }
            if ((error = (updates = new Updates(CommandExecutor.this.connection)).getError()) != null) {
                CommandExecutor.this.outputError("Could not read versions list - %1$s", error.getMessage());
                return;
            }
            TableFormatter table = new TableFormatter();
            if (ctx.full() == null) {
                table.displayHeader(false);
                table.addRow(new Object[]{updates.getMessage(CommandExecutor.this.hasHtml)});
            } else {
                table.addColumns(new String[]{Localise.format((String)"Host"), Localise.format((String)"Type"), Localise.format((String)"Current"), Localise.format((String)"Licensed"), Localise.format((String)"Latest")});
                Versions versions = updates.getVersions();
                Version latest = versions.getLatest();
                Version latestLicensed = versions.getLatestLicensed();
                for (Connection connection : updates.getConnections()) {
                    table.startRow();
                    table.addValue((Object)connection.getClientHostName());
                    table.addValue((Object)connection.getClientType().getLabel());
                    table.addValue((Object)connection.getClientVersion());
                    Version version = new Version(connection.getClientVersion());
                    table.addValue((Object)updates.getVersionText(latestLicensed, CommandExecutor.this.hasHtml && !version.equals((Object)latestLicensed), false), latestLicensed.toString().length());
                    table.addValue((Object)updates.getVersionText(latest, CommandExecutor.this.hasHtml && !version.equals((Object)latest), true), latest.toString().length());
                }
            }
            if (CommandExecutor.this.hasHtml) {
                CommandExecutor.this.output(new CommandOutput(CommandOutput.Level.INFO, table.toString()).setHtml(true), true);
            } else {
                CommandExecutor.this.output(table);
            }
        }

        private void parseError(String format, Object ... args) {
            ++this.errors;
            CommandExecutor.this.outputError(format, args);
        }

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
            ++this.errors;
            logger.debug("syntax error: " + msg + " " + offendingSymbol);
            if (charPositionInLine == 0) {
                CommandExecutor.this.outputError((Exception)e, "Unknown command", new Object[0]);
            } else if (msg.startsWith("no viable")) {
                int i = msg.indexOf(39) + 1;
                int j = msg.indexOf(39, i);
                CommandExecutor.this.outputError((Exception)e, "Unsupported argument - %s", msg.substring(i, j));
            } else {
                CommandExecutor.this.outputError((Exception)e, "Unsupported argument", new Object[0]);
            }
        }

        public void reportAmbiguity(Parser recognizer, DFA dfa, int startIndex, int stopIndex, boolean exact, BitSet ambigAlts, ATNConfigSet configs) {
        }

        public void reportAttemptingFullContext(Parser recognizer, DFA dfa, int startIndex, int stopIndex, BitSet conflictingAlts, ATNConfigSet configs) {
        }

        public void reportContextSensitivity(Parser recognizer, DFA dfa, int startIndex, int stopIndex, int prediction, ATNConfigSet configs) {
        }

        public boolean childEquals(ParserRuleContext ctx, int child, String value) {
            return value.equals(this.getChild(ctx, child));
        }

        public String getChild(ParserRuleContext ctx, int child) {
            return ctx.getChildCount() > child ? ctx.getChild(child).getText() : null;
        }
    }
}

