/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.cli;

import java.util.HashSet;
import java.util.Set;

public class CommandOutput {
    private Level level;
    private String output;
    private boolean html = false;
    private Exception exception;
    private Set<String> styles = new HashSet<String>();

    public CommandOutput(String output) {
        this(Level.INFO, output, null);
    }

    public CommandOutput(Level level, String output) {
        this(level, output, null);
    }

    public CommandOutput(Level level, String output, Exception exception) {
        this.level = level;
        this.output = output;
        this.exception = exception;
        this.styles.add(level.getStyle());
    }

    public Level getLevel() {
        return this.level;
    }

    public String getOutput() {
        return this.output;
    }

    public boolean hasException() {
        return this.exception != null;
    }

    public Exception getException() {
        return this.exception;
    }

    public boolean isHtml() {
        return this.html;
    }

    public CommandOutput setHtml(boolean html) {
        this.html = html;
        return this;
    }

    public CommandOutput addStyle(String style) {
        this.styles.add(style);
        return this;
    }

    public Set<String> getStyles() {
        return this.styles;
    }

    public String toString() {
        String msg;
        String string = msg = this.exception != null ? this.exception.getMessage() : null;
        if (msg == null) {
            return String.format("%s: %s", this.level.toString(), this.output);
        }
        return String.format("%s: %s - %s", this.level.toString(), this.output, msg);
    }

    public static enum Level {
        FATAL("bc-fatal", 2),
        ERROR("bc-error", 1),
        WARN("bc-warn", 0),
        INFO("bc-info", 0),
        DEBUG("bc-debug", 0),
        TRACE("bc-trace", 0);

        private String style;
        private int code;

        private Level(String style, int code) {
            this.style = style;
            this.code = code;
        }

        public String getStyle() {
            return this.style;
        }

        public int getCode() {
            return this.code;
        }
    }
}

