/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.cli.command;

import com.beyondcron.cli.CommandListener;
import com.beyondcron.cli.CommandOutput;
import com.beyondcron.core.Localise;
import com.beyondcron.messaging.CommandConnection;

public abstract class AbstractCommand {
    protected CommandConnection connection;
    protected CommandListener commandListener;

    public AbstractCommand(CommandConnection connection, CommandListener commandListener) {
        this.connection = connection;
        this.commandListener = commandListener;
    }

    protected void output(String format, Object ... args) {
        this.output(CommandOutput.Level.INFO, format, args);
    }

    protected void outputError(String format, Object ... args) {
        this.output(CommandOutput.Level.ERROR, format, args);
    }

    protected void output(CommandOutput.Level level, String format, Object ... args) {
        String message = Localise.format((String)format, (Object[])args);
        if (this.commandListener != null) {
            this.commandListener.commandOutput(new CommandOutput(level, message));
        } else {
            System.out.println(message);
        }
    }
}

