/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.cli.command;

import com.beyondcron.cli.CommandListener;
import com.beyondcron.cli.CommandOutput;
import com.beyondcron.cli.command.AbstractCommand;
import com.beyondcron.core.CollectionUtils;
import com.beyondcron.core.FileUtils;
import com.beyondcron.core.IOUtils;
import com.beyondcron.core.Limit;
import com.beyondcron.core.Localise;
import com.beyondcron.core.Name;
import com.beyondcron.core.Property;
import com.beyondcron.core.io.AbstractIO;
import com.beyondcron.core.io.ImportIO;
import com.beyondcron.core.security.ACL;
import com.beyondcron.core.security.HostACL;
import com.beyondcron.core.security.Protected;
import com.beyondcron.messaging.CommandConnection;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.message.CommandMessage;
import com.beyondcron.messaging.message.LimitQuery;
import com.beyondcron.messaging.message.ResultMessage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONObject;

public class ImportCommand
extends AbstractCommand {
    public ImportCommand(CommandConnection connection, CommandListener commandListener) {
        super(connection, commandListener);
    }

    /*
     * Unable to fully structure code
     */
    public boolean execute(Name root, File file, Set<AbstractIO.DataType> types, ImportIO.Mode mode, Map<String, String> variables, String reference, boolean confirm, boolean verbose) {
        var10_10 = suffix = FileUtils.getSuffix((File)file, (String)"").toLowerCase();
        var11_11 = -1;
        switch (var10_10.hashCode()) {
            case 3271912: {
                if (!var10_10.equals("json")) break;
                var11_11 = 0;
                break;
            }
            case 3701415: {
                if (!var10_10.equals("yaml")) break;
                var11_11 = 1;
                break;
            }
            case 119768: {
                if (!var10_10.equals("yml")) break;
                var11_11 = 2;
                break;
            }
            case 0: {
                if (!var10_10.equals("")) break;
                var11_11 = 3;
            }
        }
        switch (var11_11) {
            case 0: {
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                this.outputError("File type missing, expected .json, .yaml or .yml", new Object[0]);
                return false;
            }
            default: {
                this.outputError("Unsupported file type .%s, expected .json, .yaml or .yml", new Object[]{suffix});
                return false;
            }
        }
        if (!file.exists()) {
            this.outputError("File %s does not exist", new Object[]{file});
            return false;
        }
        if (!file.canRead()) {
            this.outputError("Cannot read %s (Permission denied)", new Object[]{file});
            return false;
        }
        data = null;
        try {
            in = new FileInputStream(file);
            try {
                var12_14 = suffix;
                var13_16 = -1;
                switch (var12_14.hashCode()) {
                    case 3271912: {
                        if (!var12_14.equals("json")) break;
                        var13_16 = 0;
                        break;
                    }
                    case 3701415: {
                        if (!var12_14.equals("yaml")) break;
                        var13_16 = 1;
                        break;
                    }
                    case 119768: {
                        if (!var12_14.equals("yml")) break;
                        var13_16 = 2;
                    }
                }
                switch (var13_16) {
                    case 0: {
                        data = new ImportIO(this.connection, AbstractIO.DATA_FORMAT.JSON, (InputStream)in, root, types, variables, mode);
                        ** break;
lbl58:
                        // 1 sources

                        break;
                    }
                    case 1: 
                    case 2: {
                        data = new ImportIO(this.connection, AbstractIO.DATA_FORMAT.YAML, (InputStream)in, root, types, variables, mode);
                        break;
                    }
                    ** default:
lbl63:
                    // 1 sources

                    break;
                }
            }
            finally {
                in.close();
            }
        }
        catch (Exception e) {
            this.outputError("Error reading %1$s - %2$s", new Object[]{file, e.getMessage()});
            return false;
        }
        if (data.hasErrors()) {
            this.outputError(Localise.format((String)"Import of %s %s.\n\n%s", (Object[])new Object[]{file, confirm != false ? "would fail." : "failed", this.formatErrors(root, data.getErrors(), false)}), new Object[0]);
            return false;
        }
        changes = data.getChanges();
        if (changes.isEmpty()) {
            this.output("File %s contains no changes.", new Object[]{file});
            return true;
        }
        changeTypes = ImportIO.Change.getTypes((Collection)changes);
        if (mode != ImportIO.Mode.REPLACE && !changeTypes.contains(ImportIO.Change.Type.CREATE) && !changeTypes.contains(ImportIO.Change.Type.UPDATE)) {
            this.output("File %s contains no changes.", new Object[]{file});
            return true;
        }
        if (!this.checkLicense(changes)) {
            return false;
        }
        if (confirm) {
            if (verbose) {
                this.output(this.formatChanges(changes, mode, false), new Object[0]);
            } else {
                this.output(this.formatSummary(changes, mode, false), new Object[0]);
            }
            if (this.commandListener != null) {
                this.output(CommandOutput.Level.WARN, "Changes not implemented, use 'confirm' to implement.", new Object[0]);
                return true;
            }
        }
        if (changeTypes.contains(ImportIO.Change.Type.UPDATE) && mode == ImportIO.Mode.INSERT) {
            this.outputError("Select 'update' or 'replace' to modify existing items.", new Object[0]);
            return false;
        }
        if (confirm) {
            block35: while (true) {
                if ((response = IOUtils.readLine((String)Localise.format((String)"Implement changes (Yes/No): "))) == null) {
                    continue;
                }
                var14_19 = response.toLowerCase();
                var15_20 = -1;
                switch (var14_19.hashCode()) {
                    case 119527: {
                        if (!var14_19.equals("yes")) break;
                        var15_20 = 0;
                        break;
                    }
                    case 3521: {
                        if (!var14_19.equals("no")) break;
                        var15_20 = 1;
                    }
                }
                switch (var15_20) {
                    case 0: {
                        break block35;
                    }
                    case 1: {
                        return false;
                    }
                    default: {
                        continue block35;
                    }
                }
                break;
            }
        }
        data.load(reference);
        if (data.hasErrors()) {
            this.output(this.formatErrors(root, data.getErrors(), true), new Object[0]);
        }
        if (data.wasChanged()) {
            if (!verbose) {
                this.output(this.formatSummary(data.getChanged(), ImportIO.Mode.REPLACE, true), new Object[0]);
            } else if (!confirm || data.hasErrors()) {
                this.output(this.formatChanges(data.getChanged(), ImportIO.Mode.REPLACE, true), new Object[0]);
            }
        }
        return true;
    }

    private boolean checkLicense(List<ImportIO.Change> changes) {
        long currentJobs;
        Limit limits;
        ResultMessage response = this.connection.sendReceive((CommandMessage)new LimitQuery(LimitQuery.Type.SERVER));
        Limit limit = limits = response.getResult().wasSuccess() ? ((LimitQuery.Response)response).getLimit() : null;
        if (limits == null) {
            this.outputError("Could not get the server limits.", new Object[0]);
            return false;
        }
        long targetJobs = currentJobs = limits.getJobs();
        boolean ok = true;
        for (ImportIO.Change change : changes) {
            if (change.getDataType() != AbstractIO.DataType.JOB) continue;
            switch (change.getType()) {
                case CREATE: {
                    ++targetJobs;
                    if (limits.addJob()) break;
                    ok = false;
                    break;
                }
                case DELETE: {
                    --targetJobs;
                    limits.removeJob();
                    break;
                }
            }
        }
        if (!ok) {
            this.outputError("Import would exceed the licensed number of jobs:", new Object[0]);
            this.outputError("      licensed: %1$d", limits.getMaxJobs());
            this.outputError("       current: %1$d", currentJobs);
            this.outputError("  after import: %1$d", targetJobs);
        }
        return ok;
    }

    /*
     * Enabled aggressive block sorting
     */
    private String formatChanges(List<ImportIO.Change> changes, ImportIO.Mode mode, boolean done) {
        ByteArrayOutputStream outBuffer = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(outBuffer);
        ImportIO.Change.Type currentType = null;
        String changePrefix = "";
        Iterator iterator = CollectionUtils.sort(changes).iterator();
        while (iterator.hasNext()) {
            ACL value;
            Message object;
            ImportIO.Change change = (ImportIO.Change)iterator.next();
            if (change.getType() != currentType) {
                currentType = change.getType();
                switch (currentType) {
                    case CREATE: {
                        changePrefix = "+";
                        out.println();
                        if (done) {
                            Localise.println((PrintStream)out, (String)"Created:", (Object[])new Object[0]);
                            break;
                        }
                        Localise.println((PrintStream)out, (String)"Creating:", (Object[])new Object[0]);
                        break;
                    }
                    case UPDATE: {
                        changePrefix = "~";
                        out.println();
                        if (done) {
                            Localise.println((PrintStream)out, (String)"Updated:", (Object[])new Object[0]);
                            break;
                        }
                        Localise.println((PrintStream)out, (String)"Updating:", (Object[])new Object[0]);
                        break;
                    }
                    case DELETE: {
                        if (mode != ImportIO.Mode.REPLACE) {
                            return outBuffer.toString().trim();
                        }
                        changePrefix = "-";
                        out.println();
                        if (done) {
                            Localise.println((PrintStream)out, (String)"Deleted:", (Object[])new Object[0]);
                            break;
                        }
                        Localise.println((PrintStream)out, (String)"Deleting:", (Object[])new Object[0]);
                    }
                }
            }
            if ((object = change.getValue()) instanceof ACL) {
                value = (ACL)object;
                Localise.println((PrintStream)out, (String)"%s %s:%s (ACL)", (Object[])new Object[]{changePrefix, value.getName().toString(), value.getUserRole()});
                continue;
            }
            if (object instanceof HostACL) {
                value = (HostACL)object;
                Localise.println((PrintStream)out, (String)"%s %s:%s (Host ACL)", (Object[])new Object[]{changePrefix, value.getUserRole(), value.getPattern()});
                continue;
            }
            if (object instanceof Property) {
                value = (Property)object;
                Localise.println((PrintStream)out, (String)"%s %s:%s (Property)", (Object[])new Object[]{changePrefix, value.getGroup().toString(), value.getName()});
                continue;
            }
            if (object instanceof Protected) {
                value = (Protected)object;
                Localise.println((PrintStream)out, (String)"%s %s (Protected %s)", (Object[])new Object[]{changePrefix, value.getValue(), value.getType().toString()});
                continue;
            }
            Localise.println((PrintStream)out, (String)"%s %s (%s)", (Object[])new Object[]{changePrefix, change.getName().toString(), change.getDataType().getLabel()});
        }
        return outBuffer.toString().trim();
    }

    /*
     * Enabled aggressive block sorting
     */
    private String formatSummary(List<ImportIO.Change> changes, ImportIO.Mode mode, boolean done) {
        ByteArrayOutputStream outBuffer = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(outBuffer);
        ImportIO.Change.Type currentType = null;
        Class<?> currentClass = null;
        ImportIO.Change currentChange = null;
        int currentCount = 0;
        String changePrefix = "";
        block5: for (ImportIO.Change change : CollectionUtils.sort(changes)) {
            Message value;
            Class<?> clazz;
            if (change.getType() != currentType) {
                if (currentCount > 0) {
                    Localise.println((PrintStream)out, (String)this.formatSummaryLine(currentChange, changePrefix, currentCount), (Object[])new Object[0]);
                    currentCount = 0;
                }
                currentType = change.getType();
                switch (currentType) {
                    case CREATE: {
                        changePrefix = "+";
                        out.println();
                        if (done) {
                            Localise.println((PrintStream)out, (String)"Created:", (Object[])new Object[0]);
                            break;
                        }
                        Localise.println((PrintStream)out, (String)"Creating:", (Object[])new Object[0]);
                        break;
                    }
                    case UPDATE: {
                        changePrefix = "~";
                        out.println();
                        if (done) {
                            Localise.println((PrintStream)out, (String)"Updated:", (Object[])new Object[0]);
                            break;
                        }
                        Localise.println((PrintStream)out, (String)"Updating:", (Object[])new Object[0]);
                        break;
                    }
                    case DELETE: {
                        if (mode != ImportIO.Mode.REPLACE) break block5;
                        changePrefix = "-";
                        out.println();
                        if (done) {
                            Localise.println((PrintStream)out, (String)"Deleted:", (Object[])new Object[0]);
                            break;
                        }
                        Localise.println((PrintStream)out, (String)"Deleting:", (Object[])new Object[0]);
                    }
                }
            }
            if ((clazz = (value = change.getValue()).getClass()) == currentClass) {
                ++currentCount;
                continue;
            }
            if (currentCount > 0) {
                Localise.println((PrintStream)out, (String)this.formatSummaryLine(currentChange, changePrefix, currentCount), (Object[])new Object[0]);
            }
            currentClass = clazz;
            currentChange = change;
            currentCount = 1;
        }
        if (currentCount > 0) {
            Localise.println((PrintStream)out, (String)this.formatSummaryLine(currentChange, changePrefix, currentCount), (Object[])new Object[0]);
        }
        return outBuffer.toString().trim();
    }

    private String formatSummaryLine(ImportIO.Change change, String prefix, int count) {
        Message value = change.getValue();
        if (value instanceof ACL) {
            return String.format("%s %d (ACLs)", prefix, count);
        }
        if (value instanceof HostACL) {
            return String.format("%s %d (Host ACLs)", prefix, count);
        }
        if (value instanceof Property) {
            return String.format("%s %d (Properties)", prefix, count);
        }
        if (value instanceof Protected) {
            return String.format("%s %d (Protected values)", prefix, count);
        }
        return String.format("%s %d (%ss)", prefix, count, change.getDataType().getLabel());
    }

    private String formatErrors(Name root, Collection<ImportIO.Error> errors, boolean loading) {
        ByteArrayOutputStream outBuffer = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(outBuffer);
        ImportIO.Error.Type currentType = null;
        for (ImportIO.Error error : CollectionUtils.sort(errors)) {
            JSONObject json;
            if (error.getType() != currentType) {
                out.println();
                currentType = error.getType();
                switch (currentType) {
                    case JSON: {
                        Localise.println((PrintStream)out, (String)"Data syntax error:", (Object[])new Object[0]);
                        break;
                    }
                    case PERMISSION: {
                        Localise.println((PrintStream)out, (String)"Insufficient permission:", (Object[])new Object[0]);
                        break;
                    }
                    case SCOPE: {
                        Localise.println((PrintStream)out, (String)"Out of scope (%s):", (Object[])new Object[]{root});
                        break;
                    }
                    case DISABLE: {
                        Localise.println((PrintStream)out, (String)"Error disabling job/s:", (Object[])new Object[0]);
                        break;
                    }
                    case ENABLE: {
                        if (loading) {
                            Localise.println((PrintStream)out, (String)"Error re-enabling job/s:", (Object[])new Object[0]);
                            break;
                        }
                        Localise.println((PrintStream)out, (String)"Error enabling job/s:", (Object[])new Object[0]);
                        break;
                    }
                    case LOAD: {
                        Localise.println((PrintStream)out, (String)"Error loading item/s:", (Object[])new Object[0]);
                        break;
                    }
                    case SYNTAX: {
                        Localise.println((PrintStream)out, (String)"Definition error:", (Object[])new Object[0]);
                    }
                }
            }
            String message = error.getMessage();
            Name name = error.getName();
            if (message != null) {
                if (name != null) {
                    Localise.println((PrintStream)out, (String)"- %s (%s) - %s", (Object[])new Object[]{error.getName(), error.getDataType().getLabel(), message});
                } else {
                    Localise.println((PrintStream)out, (String)"- (%s) - %s", (Object[])new Object[]{error.getDataType().getLabel(), message});
                }
            } else if (name != null) {
                Localise.println((PrintStream)out, (String)"- %s (%s)", (Object[])new Object[]{error.getName(), error.getDataType().getLabel()});
            } else {
                Localise.println((PrintStream)out, (String)"- (%s)", (Object[])new Object[]{error.getDataType().getLabel()});
            }
            if ((json = error.getJSON()) == null) continue;
            for (String line : json.toString(2).split("\\n")) {
                out.println("  " + line);
            }
        }
        return outBuffer.toString().trim();
    }
}

