/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.cli.command;

import com.beyondcron.cli.CommandListener;
import com.beyondcron.cli.command.AbstractCommand;
import com.beyondcron.core.IOUtils;
import com.beyondcron.core.License;
import com.beyondcron.core.Result;
import com.beyondcron.messaging.CommandConnection;
import com.beyondcron.messaging.message.CommandMessage;
import com.beyondcron.messaging.message.LicenseCommand;
import com.hazelcast.core.OperationTimeoutException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;

public class LicenseLoadCommand
extends AbstractCommand {
    public LicenseLoadCommand(CommandConnection connection, CommandListener commandListener) {
        super(connection, commandListener);
    }

    public boolean load(URI uri) {
        if (uri.getScheme().equals("file")) {
            try {
                File file = new File(uri.getSchemeSpecificPart());
                if (!file.exists()) {
                    this.outputError("File %s does not exist", file);
                    return false;
                }
                if (!file.canRead()) {
                    this.outputError("Cannot read %s (Permission denied)", file);
                    return false;
                }
            }
            catch (Exception e) {
                this.outputError("Unexpected exception: %1$s", e.getMessage());
                return false;
            }
        }
        try {
            return this.load(uri.toURL().openStream());
        }
        catch (Exception e) {
            this.outputError("Could not read %1$s: %2$s", uri.toString(), e.getMessage());
            return false;
        }
    }

    public boolean load(InputStream inputStream) {
        License license;
        try {
            String licenseText = IOUtils.read((InputStream)inputStream);
            license = new License(licenseText);
        }
        catch (IOException e) {
            this.outputError("Could not read license: %1$s", e.getMessage());
            return false;
        }
        if (!license.isValid()) {
            this.outputError("Invalid license: %1$s", license.getReason());
            return false;
        }
        try {
            Result result = this.connection.sendReceive((CommandMessage)new LicenseCommand(LicenseCommand.Type.LOAD, license.toJSON().toString())).getResult();
            if (!result.wasSuccess()) {
                this.outputError(result.getMessage(), new Object[0]);
                return false;
            }
        }
        catch (OperationTimeoutException e) {
            this.outputError("Timeout loading license file", new Object[0]);
        }
        return true;
    }
}

