/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.server;

import com.beyondcron.core.BlissUtils;
import com.beyondcron.core.Localise;
import com.beyondcron.core.LogUtils;
import com.beyondcron.core.Name;
import com.beyondcron.core.Role;
import com.beyondcron.core.security.ACL;
import com.beyondcron.core.security.ACLValidator;
import com.beyondcron.core.security.HostACL;
import com.beyondcron.core.security.Protected;
import com.beyondcron.messaging.Hazelcast;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.Persist;
import com.beyondcron.messaging.message.ACLList;
import com.beyondcron.messaging.message.HostACLList;
import com.beyondcron.messaging.message.ProtectedList;
import com.beyondcron.server.DataManager;
import com.beyondcron.server.HostACLManager;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.MapEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.logging.log4j.Logger;

public class ACLManager
extends ACLValidator
implements EntryListener<Name, ACL>,
Persist.Listener {
    static final Logger logger = LogUtils.getLogger(ACLManager.class);
    private static final String LOCK_NAME = "lock";
    private static Map<String, ACLManager> managers = new HashMap<String, ACLManager>();
    private DataManager data;
    private IMap<String, Boolean> triggerPermissions;
    private HostACLManager hostACLManager;

    public static synchronized ACLManager getInstance(HazelcastInstance hazelcast) {
        String name = hazelcast.getName();
        ACLManager manager = managers.get(name);
        if (manager == null) {
            manager = new ACLManager(hazelcast);
            managers.put(name, manager);
        }
        return manager;
    }

    private ACLManager(HazelcastInstance hazelcast) {
        super(hazelcast);
        this.data = DataManager.getInstance(hazelcast);
        this.triggerPermissions = Hazelcast.getACLTriggerPermissionMap((HazelcastInstance)hazelcast);
        this.hostACLManager = HostACLManager.getInstance(hazelcast);
        this.data.getACLs().addLocalEntryListener((EntryListener)this);
    }

    public boolean initDefaults() {
        int changes = 0;
        Name name = Name.ROOT;
        if (!this.hasACL(name)) {
            changes += this.setACL(new ACL(name, Role.ADMIN_NAME, new ACL.Permission[]{ACL.Permission.ANY})) ? 1 : 0;
            changes += this.setACL(new ACL(name, Role.EVERYONE_NAME, new ACL.Permission[]{ACL.Permission.READ})) ? 1 : 0;
        }
        if (!this.hasACL(name = BlissUtils.ACL_DIR)) {
            changes += this.setACL(new ACL(name, Role.ADMIN_NAME, new ACL.Permission[]{ACL.Permission.ANY})) ? 1 : 0;
            changes += this.setACL(new ACL(name, Role.EVERYONE_NAME, new ACL.Permission[]{ACL.Permission.READ})) ? 1 : 0;
        }
        if (!this.hasACL(name = BlissUtils.ADMIN_DIR)) {
            changes += this.setACL(new ACL(name, Role.ADMIN_NAME, new ACL.Permission[]{ACL.Permission.ANY})) ? 1 : 0;
        }
        if (!this.hasACL(name = BlissUtils.CALENDAR_DIR)) {
            changes += this.setACL(new ACL(name, Role.ADMIN_NAME, new ACL.Permission[]{ACL.Permission.ANY})) ? 1 : 0;
            changes += this.setACL(new ACL(name, Role.EVERYONE_NAME, new ACL.Permission[]{ACL.Permission.READ})) ? 1 : 0;
        }
        return (changes += this.hostACLManager.initDefaults() ? 1 : 0) > 0;
    }

    public boolean setACL(ACL acl) {
        return this.data.addACL(acl);
    }

    public boolean deleteACL(ACL acl) {
        return this.data.removeACL(acl);
    }

    public boolean canTrigger(Name source, Name target) {
        boolean canTrigger;
        String key = source.toString() + ";" + target.toString();
        if (this.triggerPermissions.containsKey((Object)key)) {
            canTrigger = (Boolean)this.triggerPermissions.get((Object)key);
        } else {
            canTrigger = false;
            HashSet<String> usersRoles = new HashSet<String>();
            usersRoles.add(Role.EVERYONE_NAME);
            for (ACL acl : this.getACLs(target)) {
                if (!acl.hasPermission(ACL.Permission.EXECUTE)) continue;
                usersRoles.add(acl.getUserRole());
            }
            for (ACL acl : this.getACLs(source)) {
                if (!acl.hasPermission(ACL.Permission.READ) || !usersRoles.contains(acl.getUserRole())) continue;
                canTrigger = true;
                break;
            }
            this.triggerPermissions.put((Object)key, (Object)canTrigger);
        }
        return canTrigger;
    }

    private void clearTriggerPermissions() {
        this.triggerPermissions.lock((Object)LOCK_NAME);
        try {
            if (!this.triggerPermissions.isEmpty()) {
                this.triggerPermissions.clear();
            }
        }
        finally {
            this.triggerPermissions.unlock((Object)LOCK_NAME);
        }
    }

    @Override
    public void messageLoaded(Name name, Message<?> message) {
        if (message instanceof ACL) {
            this.setACL((ACL)message);
        } else if (message instanceof ACLList) {
            for (ACL acl : ((ACLList)message).getValues()) {
                this.setACL(acl);
            }
        } else if (message instanceof HostACL) {
            this.hostACLManager.setACL((HostACL)message);
        } else if (message instanceof HostACLList) {
            for (HostACL acl : ((HostACLList)message).getValues()) {
                this.hostACLManager.setACL(acl);
            }
        } else if (message instanceof Protected) {
            this.hostACLManager.setProtected((Protected)message);
        } else if (message instanceof ProtectedList) {
            for (Protected value : ((ProtectedList)message).getValues()) {
                this.hostACLManager.setProtected(value);
            }
        } else {
            Localise.logWarn((Logger)logger, (String)"Unsupported message type %1$s", (Object[])new Object[]{message.getClass().getName()});
        }
    }

    public void entryAdded(EntryEvent<Name, ACL> event) {
        this.clearTriggerPermissions();
    }

    public void entryRemoved(EntryEvent<Name, ACL> event) {
        this.clearTriggerPermissions();
    }

    public void entryUpdated(EntryEvent<Name, ACL> event) {
        this.clearTriggerPermissions();
    }

    public void entryEvicted(EntryEvent<Name, ACL> event) {
        Localise.logWarn((Logger)logger, (String)"Map %1$s entry %2$s unexpectedly evicted", (Object[])new Object[]{this.triggerPermissions.getName(), ((Name)event.getKey()).toString()});
    }

    public void mapCleared(MapEvent event) {
        Localise.logWarn((Logger)logger, (String)"Map %1$s unexpectedly cleared", (Object[])new Object[]{this.triggerPermissions.getName()});
    }

    public void mapEvicted(MapEvent event) {
        Localise.logWarn((Logger)logger, (String)"Map %1$s unexpectedly evicted", (Object[])new Object[]{this.triggerPermissions.getName()});
    }
}

