/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.server;

import com.beyondcron.core.Configs;
import com.beyondcron.core.FileUtils;
import com.beyondcron.core.InetSocketAddress;
import com.beyondcron.core.License;
import com.beyondcron.core.Localise;
import com.beyondcron.core.LogUtils;
import com.beyondcron.core.Metrics;
import com.beyondcron.core.NetUtils;
import com.beyondcron.core.Program;
import com.beyondcron.core.ServiceException;
import com.beyondcron.core.StringUtils;
import com.beyondcron.core.ThreadStats;
import com.beyondcron.core.TimeUtils;
import com.beyondcron.core.config.Config;
import com.beyondcron.core.config.StringConfig;
import com.beyondcron.core.job.CalendarUpdateJob;
import com.beyondcron.core.job.Job;
import com.beyondcron.core.job.StatusService;
import com.beyondcron.core.user.UserService;
import com.beyondcron.messaging.ConnectionException;
import com.beyondcron.messaging.Hazelcast;
import com.beyondcron.messaging.NamedMessage;
import com.beyondcron.messaging.ServerConnection;
import com.beyondcron.server.CalendarManager;
import com.beyondcron.server.CommandManager;
import com.beyondcron.server.ConnectionManager;
import com.beyondcron.server.DataManager;
import com.beyondcron.server.JobManager;
import com.beyondcron.server.JobStatusManager;
import com.beyondcron.server.LicenseManager;
import com.beyondcron.server.PersistManager;
import com.beyondcron.server.QueueManager;
import com.beyondcron.server.UserManager;
import com.beyondcron.service.ad.ADUserService;
import com.beyondcron.service.aws.AWSClient;
import com.beyondcron.service.aws.AWSStatusService;
import com.beyondcron.service.aws.AWSUserService;
import com.beyondcron.service.jdbc.JDBCStatusService;
import com.beyondcron.service.unix.UnixUserService;
import com.hazelcast.core.Cluster;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.Member;
import com.hazelcast.core.MemberAttributeEvent;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import com.hazelcast.instance.EndpointQualifier;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import jnr.constants.platform.Signal;
import org.apache.logging.log4j.Logger;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.Option;

public class App
implements Program.SignalHandler {
    static final Logger logger = LogUtils.getLogger(App.class);
    @Option(name="--cluster", aliases={"-c"}, usage="Name of cluster to start/join. Default = beyondcron.")
    private String argCluster = null;
    @Option(name="--data", aliases={"-d"}, metaVar="<path>", usage="Location of data directory.")
    private File dirData = null;
    @Option(name="--force", aliases={"-f"}, usage="Force server to start.")
    private boolean argForce;
    @Option(name="--help", aliases={"-?"}, usage="Print this message.")
    private boolean argHelp;
    @Option(name="--version", aliases={"-v"}, usage="Print program version")
    private boolean argVersion;
    @Argument(metaVar="[<server>][:<port>] ...", usage="Servers name and/or port number")
    private List<InetSocketAddress> servers;
    private int exitCode = 1;
    private Signal stopSignal;
    private boolean firstMember = false;
    private ServerConnection connection = null;
    private CommandManager commandManager = null;

    public static void main(String[] args) {
        Localise.addBundle((String)"bc-server");
        NetUtils.setDefaultHostName((String)Hazelcast.DEFAULT_HOST);
        NetUtils.setDefaultPort((int)Hazelcast.DEFAULT_PORT);
        try {
            boolean error;
            int exitCode = new App(args).run();
            boolean bl = error = exitCode != 0;
            if (!error) {
                LogUtils.consolePrint((Logger)logger, (String)(Program.getName() + " stopped " + new Date()));
            }
            Program.exit((int)exitCode, (boolean)error, (boolean)false);
        }
        catch (Exception e) {
            Localise.logFatal((Logger)logger, (Exception)e, (String)"Unexpected exception", (Object[])new Object[0]);
            Localise.logFatal((Logger)logger, (String)"  OS: %1$s %2$s %3$s", (Object[])new Object[]{Program.getOsName(), Program.getOsArch(), Program.getOsVersion()});
            Localise.logFatal((Logger)logger, (String)"Java: %1$s %2$s", (Object[])new Object[]{Program.getJavaVersion(), Program.getJavaVendor()});
            Program.exit((int)1);
        }
    }

    public App(String[] args) {
        Program program = new Program((Object)this);
        try {
            program.parseArgs(args);
        }
        catch (CmdLineException e) {
            System.err.println(Program.getName() + ": " + e.getMessage());
            program.printUsage((OutputStream)System.err);
            System.exit(1);
        }
        if (!this.argForce) {
            this.argForce = (Boolean)Configs.get((String)"BEYONDCRON_FORCE_START");
        }
        if (this.argVersion) {
            Program.printVersion();
            System.exit(0);
        } else if (this.argHelp) {
            program.printUsage((OutputStream)System.out, true);
            System.exit(0);
        } else if (Program.isRootUser()) {
            System.err.println(Localise.format((String)"%1$s: run as a non-root user", (Object[])new Object[]{Program.getName()}));
            System.exit(1);
        }
        if (this.dirData != null) {
            Configs.set((String)"BEYONDCRON_DATA_DIR", (Object)this.dirData.toString());
        } else {
            String s = (String)Configs.get((String)"BEYONDCRON_DATA_DIR");
            if (!StringUtils.isNullOrEmpty((String)s)) {
                this.dirData = new File(s);
            } else {
                System.err.println(Localise.format((String)"%1$s: data directory undefined", (Object[])new Object[]{Program.getName()}));
                System.exit(1);
            }
        }
        if (!this.dirData.exists()) {
            System.err.println(Localise.format((String)"%1$s: data directory %2$s does not exist", (Object[])new Object[]{Program.getName(), this.dirData.toString()}));
            System.exit(1);
        } else if (!this.dirData.isDirectory()) {
            System.err.println(Localise.format((String)"%1$s: data directory %2$s is not a directory", (Object[])new Object[]{Program.getName(), this.dirData.toString()}));
            System.exit(1);
        } else if (!this.dirData.canWrite()) {
            System.err.println(Localise.format((String)"%1$s: data directory %2$s is not writable", (Object[])new Object[]{Program.getName(), this.dirData.toString()}));
            System.exit(1);
        }
        this.dirData = this.dirData.getAbsoluteFile();
        if (!StringUtils.isNullOrEmpty((String)this.argCluster)) {
            Configs.set((String)"BEYONDCRON_CLUSTER_NAME", (Object)this.argCluster);
        }
        this.init();
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    private void exit(int code) {
        Program.setShuttingDown((boolean)true);
        this.close();
        Program.exit((int)code);
    }

    public int run() {
        if (((Boolean)Configs.get((String)"beyondcron.benchmark.start")).booleanValue()) {
            return 0;
        }
        JobManager.getInstance(this.connection.getHazelcast()).startScheduler();
        String startTime = new Date().toString();
        StringConfig config = (StringConfig)Configs.getConfig((String)"BEYONDCRON_RUNNING_FILE");
        File file = new File(config.getValue());
        if (!FileUtils.canWrite((File)file)) {
            Localise.logError((Logger)logger, (String)"Cannot create running file - %s", (Object[])new Object[]{file.toString()});
            if (!config.isDefault() && !FileUtils.canWrite((File)(file = new File((String)config.getDefault())))) {
                Localise.logError((Logger)logger, (String)"Cannot create default running file - %s", (Object[])new Object[]{file.toString()});
                file = null;
            }
        }
        if (file != null) {
            file.deleteOnExit();
            ArrayList<String> message = new ArrayList<String>();
            message.add(startTime);
            message.add(Program.getVersion().toString());
            License license = LicenseManager.getInstance(this.connection.getHazelcast()).getServerLicense();
            if (license.getType() != License.Type.FREE) {
                message.add(DateTimeFormatter.ofPattern("yyMMdd", Locale.US).format(TimeUtils.getLocalDateTime((Date)license.getExpiry())));
            }
            try {
                FileUtils.write((File)file, (String[])new String[]{StringUtils.join((String)" : ", message)});
            }
            catch (IOException e) {
                Localise.logError((Logger)logger, (Exception)e, (String)"Could create running file - %s", (Object[])new Object[]{file.toString()});
            }
        }
        LogUtils.consolePrint((Logger)logger, (String)(Program.getName() + " started " + startTime));
        this.commandManager.run();
        this.close();
        return this.exitCode;
    }

    private synchronized void close() {
        if (!Program.setShuttingDown((boolean)true)) {
            Localise.logWarn((Logger)logger, (String)"Shutting down due to an external event", (Object[])new Object[0]);
        }
        if (this.connection == null || this.connection.isClosing()) {
            return;
        }
        this.connection.close();
        this.connection = null;
    }

    private void init() {
        long initStart = System.currentTimeMillis();
        LogUtils.consolePrint((Logger)logger, (String)(Program.getName() + " " + Program.getVersion()));
        LogUtils.consolePrint((Logger)logger, (String)Program.getCopyright());
        LogUtils.consolePrint((Logger)logger, (String)("OS: " + Program.getOsName() + " " + Program.getOsVersion() + " " + Program.getOsArch()));
        LogUtils.consolePrint((Logger)logger, (String)("Java: " + Program.getJavaVersion() + " " + Program.getJavaVendor()));
        LogUtils.consolePrint((Logger)logger, (String)("Process ID: " + Program.posix.getpid()));
        LogUtils.consolePrintConfigURL((Logger)logger);
        Localise.logDebug((Logger)logger, (String)"Initing BeyondCron config", (Object[])new Object[0]);
        this.initConfig();
        this.initShutdownHandlers();
        Localise.logDebug((Logger)logger, (String)"Initing Hazelcast", (Object[])new Object[0]);
        HazelcastInstance hazelcast = this.initHazelcast();
        Localise.logDebug((Logger)logger, (String)"Initing persistence", (Object[])new Object[0]);
        this.initPersistence();
        try {
            UserManager.getInstance(hazelcast).reloadService();
        }
        catch (ServiceException e) {
            Localise.logError((Logger)logger, (Exception)((Object)e), (String)"Unexpected error initing user service - %s", (Object[])new Object[]{e.getMessage()});
        }
        Localise.logDebug((Logger)logger, (String)"Starting connection manager", (Object[])new Object[0]);
        this.initConnectionManager();
        Localise.logDebug((Logger)logger, (String)"Initing queue manager", (Object[])new Object[0]);
        QueueManager.getInstance(hazelcast);
        Localise.logDebug((Logger)logger, (String)"Initing calendar manager", (Object[])new Object[0]);
        CalendarManager.getInstance(hazelcast);
        Localise.logDebug((Logger)logger, (String)"Initing internal jobs", (Object[])new Object[0]);
        this.initInternalJobs();
        Localise.logDebug((Logger)logger, (String)"Initing command manager", (Object[])new Object[0]);
        this.initCommandManager();
        if (hazelcast.getCluster().getLocalMember().isLiteMember()) {
            this.promoteHazelcast(hazelcast);
        }
        Localise.logDebug((Logger)logger, (String)"Initing complete", (Object[])new Object[0]);
        if (logger.isDebugEnabled()) {
            Localise.logDebug((Logger)logger, (String)"Thread details:", (Object[])new Object[0]);
            for (String s : new ThreadStats().getDetails()) {
                Localise.logDebug((Logger)logger, (String)"  %s", (Object[])new Object[]{s});
            }
        }
        long initEnd = System.currentTimeMillis();
        int jobCount = DataManager.getInstance(hazelcast).getJobs().size();
        if (Metrics.logger.isInfoEnabled()) {
            Metrics.logger.info(this.getInitTime(initStart, initEnd, jobCount));
        } else {
            LogUtils.consolePrint((Logger)logger, (String)this.getInitTime(initStart, initEnd, jobCount));
        }
    }

    private String getInitTime(long startTime, long endTime, int jobCount) {
        if (this.firstMember) {
            if (jobCount != 1) {
                if (this.argForce) {
                    return Localise.format((String)"Force started cluster %1$s with %2$d jobs in %3$s", (Object[])new Object[]{this.connection.getClusterName(), jobCount, TimeUtils.formatDuration((long)(endTime - startTime), (boolean)true)});
                }
                return Localise.format((String)"Started cluster %1$s with %2$d jobs in %3$s", (Object[])new Object[]{this.connection.getClusterName(), jobCount, TimeUtils.formatDuration((long)(endTime - startTime), (boolean)true)});
            }
            if (this.argForce) {
                return Localise.format((String)"Force started cluster %1$s with %2$d job in %3$s", (Object[])new Object[]{this.connection.getClusterName(), jobCount, TimeUtils.formatDuration((long)(endTime - startTime), (boolean)true)});
            }
            return Localise.format((String)"Started cluster %1$s with %2$d job in %3$s", (Object[])new Object[]{this.connection.getClusterName(), jobCount, TimeUtils.formatDuration((long)(endTime - startTime), (boolean)true)});
        }
        if (jobCount != 1) {
            return Localise.format((String)"Joined cluster with %1$d jobs in %2$s", (Object[])new Object[]{jobCount, TimeUtils.formatDuration((long)(endTime - startTime), (boolean)true)});
        }
        return Localise.format((String)"Joined cluster with %1$d job in %2$s", (Object[])new Object[]{jobCount, TimeUtils.formatDuration((long)(endTime - startTime), (boolean)true)});
    }

    private void initConfig() {
        LogUtils.consolePrint((Logger)logger, (String)("Data directory: " + this.dirData));
        if (Configs.hasService()) {
            LogUtils.consolePrint((Logger)logger, (String)("Configuration service: " + Configs.getService().getServiceDescription()));
        } else {
            LogUtils.consolePrint((Logger)logger, (String)"Configuration service: none");
        }
        Configs.addConfigs(AWSClient.class);
        Configs.addConfigs(AWSStatusService.class);
        Configs.addConfigs(AWSUserService.class);
        Configs.addConfigs(JDBCStatusService.class);
        Configs.addConfigs(UnixUserService.class);
        if (Boolean.TRUE.equals(Configs.get((String)"BEYONDCRON_EARLY_ACCESS"))) {
            Configs.addConfigs(ADUserService.class);
        }
        if (logger.isDebugEnabled()) {
            LogUtils.consolePrint((Logger)logger, (String)"Startup configuration variables:");
            for (Config config : Configs.getConfigs((boolean)true)) {
                if (!config.isStartup()) continue;
                if (config.isDefault()) {
                    Localise.logDebug((Logger)logger, (String)"  %1$s: %2$s (default)", (Object[])new Object[]{config.getName(), config.getValue()});
                    continue;
                }
                Localise.logDebug((Logger)logger, (String)"  %1$s: %2$s", (Object[])new Object[]{config.getName(), config.getValue()});
            }
        }
    }

    private HazelcastInstance initHazelcast() {
        try {
            this.connection = new ServerConnection(this.servers);
        }
        catch (ConnectionException e) {
            Localise.logError((Logger)logger, (String)"Unexpected exception opening server connection - %s", (Object[])new Object[]{e.getMessage()});
        }
        HazelcastInstance hazelcast = this.connection.getHazelcast();
        Cluster cluster = hazelcast.getCluster();
        this.firstMember = ((Member)cluster.getMembers().iterator().next()).equals(cluster.getLocalMember());
        if (this.firstMember) {
            this.promoteHazelcast(hazelcast);
        }
        ConnectionManager.getInstance(hazelcast);
        hazelcast.getCluster().addMembershipListener(new MembershipListener(){

            public void memberAdded(MembershipEvent membershipEvent) {
                Localise.logWarn((Logger)logger, (String)"Member added - %s", (Object[])new Object[]{membershipEvent.getMember().getSocketAddress(EndpointQualifier.MEMBER)});
            }

            public void memberRemoved(MembershipEvent membershipEvent) {
                Localise.logWarn((Logger)logger, (String)"Member removed - %s", (Object[])new Object[]{membershipEvent.getMember().getSocketAddress(EndpointQualifier.MEMBER)});
            }

            public void memberAttributeChanged(MemberAttributeEvent memberAttributeEvent) {
                Localise.logWarn((Logger)logger, (String)"Member change - %s", (Object[])new Object[]{memberAttributeEvent});
            }
        });
        return hazelcast;
    }

    private void promoteHazelcast(HazelcastInstance hazelcast) {
        Cluster cluster = hazelcast.getCluster();
        int maxServers = this.firstMember ? 1 : LicenseManager.getInstance(hazelcast).getServerLicense().getMaxServers();
        int servers = 0;
        for (Member member : cluster.getMembers()) {
            if (member.isLiteMember()) continue;
            ++servers;
        }
        if (servers >= maxServers) {
            Localise.logFatal((Logger)logger, (String)"%1$s %2$ of %3$s servers are running, please contact %4$s if you wish to extend your license.", (Object[])new Object[]{Program.getName(), Integer.toString(servers), Integer.toString(maxServers), Program.getVendor()});
            this.exit(1);
        }
        Localise.logDebug((Logger)logger, (String)"Promoting hazelcast", (Object[])new Object[0]);
        try {
            cluster.promoteLocalLiteMember();
        }
        catch (Exception e) {
            Localise.logFatal((Logger)logger, (Exception)e, (String)"Unexpected error enabling hazelcast - %s", (Object[])new Object[]{e.getMessage()});
            this.exit(1);
        }
        Configs.setHazelcast((HazelcastInstance)hazelcast);
    }

    private void initConnectionManager() {
        ConnectionManager manager = ConnectionManager.getInstance(this.connection.getHazelcast());
        manager.start();
        try {
            this.connection.register(null);
        }
        catch (ConnectionException e) {
            Localise.logFatal((Logger)logger, (String)"Could not register connection with server - %s", (Object[])new Object[]{e.getMessage()});
            this.exit(1);
        }
    }

    private void initPersistence() {
        try {
            PersistManager.getInstance(this.connection.getHazelcast(), this.argForce);
        }
        catch (IllegalStateException e) {
            LogUtils.consolePrint((Logger)logger, (String)e.getMessage());
            Localise.logDebug((Logger)logger, (Exception)e, (String)e.getMessage(), (Object[])new Object[0]);
            this.exit(1);
        }
        catch (LicenseManager.LicenseException e) {
            this.exit(1);
        }
    }

    private void initCommandManager() {
        this.commandManager = new CommandManager(this.connection.getHazelcast());
        UserService service = UserManager.getInstance(this.connection.getHazelcast()).getUserService();
        if (service != null) {
            if (service.isConnected()) {
                LogUtils.consolePrint((Logger)logger, (String)Localise.format((String)"User service: %s - connected", (Object[])new Object[]{service.getServiceName()}));
            } else {
                LogUtils.consolePrint((Logger)logger, (String)Localise.format((String)"User service: %s - attempting to connect", (Object[])new Object[]{service.getServiceName()}));
            }
            if (!StringUtils.isNullOrEmpty((String)service.getServiceDescription())) {
                LogUtils.consolePrint((Logger)logger, (String)("  " + service.getServiceDescription()));
            }
        } else {
            LogUtils.consolePrint((Logger)logger, (String)"User service: local");
        }
    }

    private void initInternalJobs() {
        HazelcastInstance hazelcast = this.connection.getHazelcast();
        JobManager jobManager = JobManager.getInstance(hazelcast);
        if (!jobManager.isJob(CalendarUpdateJob.NAME)) {
            Job job = new CalendarUpdateJob().setMode(Job.Mode.ENABLED);
            jobManager.setJob(job);
            PersistManager.getInstance(hazelcast).save((NamedMessage)job, this.connection.getConnection(), 0);
        }
        LicenseManager.getInstance(hazelcast).addServerJob();
        StatusService service = JobStatusManager.getInstance(hazelcast).getStatusService();
        if (service != null) {
            if (service.isConnected()) {
                LogUtils.consolePrint((Logger)logger, (String)Localise.format((String)"Status service: %s - connected", (Object[])new Object[]{service.getServiceName()}));
            } else {
                LogUtils.consolePrint((Logger)logger, (String)Localise.format((String)"Status service: %s - attempting to connect", (Object[])new Object[]{service.getServiceName()}));
            }
            if (!StringUtils.isNullOrEmpty((String)service.getServiceDescription())) {
                LogUtils.consolePrint((Logger)logger, (String)("  " + service.getServiceDescription()));
            }
        } else {
            LogUtils.consolePrint((Logger)logger, (String)"Status service: none");
        }
    }

    private void initShutdownHandlers() {
        this.stopSignal = Program.registerHandler((Program.SignalHandler)this);
        Runtime.getRuntime().addShutdownHook(new Thread(this::close));
    }

    public void signal(int value) {
        Signal signal = Signal.valueOf((long)value);
        Localise.logDebug((Logger)logger, (String)"Received %s (%d)", (Object[])new Object[]{signal.description(), value});
        int n = this.exitCode = signal == this.stopSignal ? 0 : 2;
        if (this.exitCode == 0) {
            Program.setShuttingDown((boolean)true);
        }
        if (this.connection != null) {
            this.close();
        } else {
            Program.exit((int)this.exitCode);
        }
    }
}

