/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.server;

import com.beyondcron.core.BlissUtils;
import com.beyondcron.core.Configs;
import com.beyondcron.core.Filter;
import com.beyondcron.core.JSONUtils;
import com.beyondcron.core.License;
import com.beyondcron.core.Limit;
import com.beyondcron.core.Localise;
import com.beyondcron.core.LogUtils;
import com.beyondcron.core.Name;
import com.beyondcron.core.Program;
import com.beyondcron.core.Property;
import com.beyondcron.core.Result;
import com.beyondcron.core.Role;
import com.beyondcron.core.ServiceException;
import com.beyondcron.core.StringUtils;
import com.beyondcron.core.calendar.ICalendarData;
import com.beyondcron.core.config.Config;
import com.beyondcron.core.config.ConfigProperty;
import com.beyondcron.core.config.StringConfig;
import com.beyondcron.core.job.Command;
import com.beyondcron.core.job.CommandJob;
import com.beyondcron.core.job.Condition;
import com.beyondcron.core.job.Job;
import com.beyondcron.core.job.JobMode;
import com.beyondcron.core.job.JobModeValidator;
import com.beyondcron.core.job.Status;
import com.beyondcron.core.job.StatusService;
import com.beyondcron.core.job.Trigger;
import com.beyondcron.core.job.URLJob;
import com.beyondcron.core.security.ACL;
import com.beyondcron.core.security.HostACL;
import com.beyondcron.core.security.Protected;
import com.beyondcron.core.user.User;
import com.beyondcron.core.user.UserService;
import com.beyondcron.messaging.Hazelcast;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.NamedMessage;
import com.beyondcron.messaging.Persist;
import com.beyondcron.messaging.PersistMessage;
import com.beyondcron.messaging.message.ACLCommand;
import com.beyondcron.messaging.message.ACLList;
import com.beyondcron.messaging.message.ACLQuery;
import com.beyondcron.messaging.message.AgentQuery;
import com.beyondcron.messaging.message.Announcement;
import com.beyondcron.messaging.message.AnnouncementCommand;
import com.beyondcron.messaging.message.CalendarCommand;
import com.beyondcron.messaging.message.CalendarJobsQuery;
import com.beyondcron.messaging.message.CalendarQuery;
import com.beyondcron.messaging.message.Change;
import com.beyondcron.messaging.message.ChangeQuery;
import com.beyondcron.messaging.message.ClusterQuery;
import com.beyondcron.messaging.message.CommandMessage;
import com.beyondcron.messaging.message.ConfigCommand;
import com.beyondcron.messaging.message.ConfigQuery;
import com.beyondcron.messaging.message.Connection;
import com.beyondcron.messaging.message.ConnectionAuthenticate;
import com.beyondcron.messaging.message.ConnectionQuery;
import com.beyondcron.messaging.message.DateQuery;
import com.beyondcron.messaging.message.Group;
import com.beyondcron.messaging.message.GroupQuery;
import com.beyondcron.messaging.message.HostACLCommand;
import com.beyondcron.messaging.message.HostACLList;
import com.beyondcron.messaging.message.HostACLQuery;
import com.beyondcron.messaging.message.ICalendarCommand;
import com.beyondcron.messaging.message.ICalendarQuery;
import com.beyondcron.messaging.message.JobCommand;
import com.beyondcron.messaging.message.JobControl;
import com.beyondcron.messaging.message.JobHistoryClear;
import com.beyondcron.messaging.message.JobHistoryQuery;
import com.beyondcron.messaging.message.JobOutputQuery;
import com.beyondcron.messaging.message.JobQuery;
import com.beyondcron.messaging.message.JobStatusQuery;
import com.beyondcron.messaging.message.LicenseCommand;
import com.beyondcron.messaging.message.LicenseQuery;
import com.beyondcron.messaging.message.LimitQuery;
import com.beyondcron.messaging.message.LimitReset;
import com.beyondcron.messaging.message.Link;
import com.beyondcron.messaging.message.PersistCommand;
import com.beyondcron.messaging.message.PropertyCommand;
import com.beyondcron.messaging.message.PropertyList;
import com.beyondcron.messaging.message.PropertyQuery;
import com.beyondcron.messaging.message.ProtectedCommand;
import com.beyondcron.messaging.message.ProtectedList;
import com.beyondcron.messaging.message.ProtectedQuery;
import com.beyondcron.messaging.message.Queue;
import com.beyondcron.messaging.message.QueueCommand;
import com.beyondcron.messaging.message.QueueQuery;
import com.beyondcron.messaging.message.RoleCommand;
import com.beyondcron.messaging.message.RoleQuery;
import com.beyondcron.messaging.message.ServerQuery;
import com.beyondcron.messaging.message.ServiceCommand;
import com.beyondcron.messaging.message.ServiceQuery;
import com.beyondcron.messaging.message.Topic;
import com.beyondcron.messaging.message.TopicQuery;
import com.beyondcron.messaging.message.UserCommand;
import com.beyondcron.messaging.message.UserPassword;
import com.beyondcron.messaging.message.UserQuery;
import com.beyondcron.messaging.message.UserRefresh;
import com.beyondcron.messaging.message.calendar.Calendar;
import com.beyondcron.messaging.message.calendar.ICalendar;
import com.beyondcron.server.ACLManager;
import com.beyondcron.server.CalendarManager;
import com.beyondcron.server.ConnectionManager;
import com.beyondcron.server.DataManager;
import com.beyondcron.server.HostACLManager;
import com.beyondcron.server.JobManager;
import com.beyondcron.server.JobStatusManager;
import com.beyondcron.server.LicenseManager;
import com.beyondcron.server.PersistManager;
import com.beyondcron.server.PropertyManager;
import com.beyondcron.server.QueueManager;
import com.beyondcron.server.TopicManager;
import com.beyondcron.server.UserManager;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.ITopic;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fortuna.ical4j.model.CalendarException;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class CommandManager {
    static final Logger logger = LogUtils.getLogger(CommandManager.class);
    private HazelcastInstance hazelcast;
    private DataManager dataManager;
    private ACLManager aclManager;
    private CalendarManager calendarManager;
    private ConnectionManager connectionManager;
    private HostACLManager hostAclManager;
    private JobManager jobManager;
    private JobModeValidator jobModeValidator;
    private JobStatusManager jobStatusManager;
    private LicenseManager licenseManager;
    private PersistManager persistManager;
    private PropertyManager propertyManager;
    private UserManager userManager;
    private IQueue<CommandMessage> commandQueue;
    private ITopic<Announcement> announcementTopic;
    private static ThreadLocal<User> threadUser = new ThreadLocal();
    private static ThreadLocal<Connection> threadConnection = new ThreadLocal();
    private static ThreadLocal<Integer> threadChangeGroup = new ThreadLocal();
    private static Pattern relativeChangeIdPattern = Pattern.compile("(0|-[0-9]+)");

    public CommandManager(HazelcastInstance hazelcast) {
        this.hazelcast = hazelcast;
        this.dataManager = DataManager.getInstance(hazelcast);
        this.aclManager = ACLManager.getInstance(hazelcast);
        this.calendarManager = CalendarManager.getInstance(hazelcast);
        this.connectionManager = ConnectionManager.getInstance(hazelcast);
        this.hostAclManager = HostACLManager.getInstance(hazelcast);
        this.jobManager = JobManager.getInstance(hazelcast);
        this.jobModeValidator = JobModeValidator.getInstance((HazelcastInstance)hazelcast);
        this.jobStatusManager = JobStatusManager.getInstance(hazelcast);
        this.licenseManager = LicenseManager.getInstance(hazelcast);
        this.persistManager = PersistManager.getInstance(hazelcast);
        this.propertyManager = PropertyManager.getInstance(hazelcast);
        this.userManager = UserManager.getInstance(hazelcast);
        this.commandQueue = Hazelcast.getCommandSendQueue((HazelcastInstance)hazelcast);
        this.announcementTopic = Hazelcast.getAnnouncementTopic((HazelcastInstance)hazelcast);
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    this.execute((CommandMessage)this.commandQueue.take());
                }
            }
            catch (InterruptedException e) {
                Localise.logError((Logger)logger, (String)"Unexpectedly interrupted - %1$s", (Object[])new Object[]{e.getMessage()});
            }
            catch (HazelcastInstanceNotActiveException e) {
                if (Program.isShuttingDown()) break;
                throw e;
            }
            catch (Exception e) {
                Localise.logError((Logger)logger, (String)"Unexpected exception - %1$s", (Object[])new Object[]{e.getMessage()});
                continue;
            }
            break;
        }
    }

    public void execute(CommandMessage command) {
        ConnectionAuthenticate.Response response;
        String clientId = command.getClientId();
        if (clientId == null) {
            Localise.logError((Logger)logger, (String)"Unknown connection for message %1$s", (Object[])new Object[]{command.getClass().getName()});
            return;
        }
        Connection connection = this.connectionManager.get(clientId);
        if (connection == null) {
            Localise.logWarn((Logger)logger, (String)"%1$s command received on unregistered connection %2$s", (Object[])new Object[]{command.getClass().getName(), clientId});
            Result response2 = new Result(false, 1, "unregistered connection", new Link[0]);
            Hazelcast.getCommandReceiveQueue((HazelcastInstance)this.hazelcast, (String)clientId).add((Object)response2);
            return;
        }
        threadConnection.set(connection);
        threadChangeGroup.set(command.getChangeGroup());
        User user = this.userManager.getUser(connection.getClientUserName());
        if (user == null) {
            Localise.logWarn((Logger)logger, (String)"%1$s command received from unknown user %2$s", (Object[])new Object[]{command.getClass().getName(), connection.getClientUserName()});
            Result response3 = new Result(false, 1, "unknown user " + connection.getClientUserName(), new Link[0]);
            Hazelcast.getCommandReceiveQueue((HazelcastInstance)this.hazelcast, (String)clientId).add((Object)response3);
            return;
        }
        threadUser.set(user);
        if (command instanceof ConnectionAuthenticate) {
            response = this.connectionManager.authenticate(connection, ((ConnectionAuthenticate)command).getPassword());
        } else if (!connection.isAuthenticated()) {
            Localise.logWarn((Logger)logger, (String)"%1$s command received from unauthenticated user %2$s", (Object[])new Object[]{command.getClass().getName(), connection.getClientUserName()});
            response = new Result(false, 1, "unauthenticated connection", new Link[0]);
        } else if (command instanceof ACLQuery) {
            response = this.aclQuery((ACLQuery)command);
        } else if (command instanceof AgentQuery) {
            response = this.agentQuery((AgentQuery)command);
        } else if (command instanceof CalendarQuery) {
            response = this.calendarQuery((CalendarQuery)command);
        } else if (command instanceof CalendarJobsQuery) {
            response = this.calendarJobsQuery((CalendarJobsQuery)command);
        } else if (command instanceof ChangeQuery) {
            response = this.changeQuery((ChangeQuery)command);
        } else if (command instanceof ConfigQuery) {
            response = this.configQuery((ConfigQuery)command);
        } else if (command instanceof ConnectionQuery) {
            response = this.connectionQuery((ConnectionQuery)command);
        } else if (command instanceof DateQuery) {
            response = new DateQuery.Response(ZonedDateTime.now());
        } else if (command instanceof HostACLQuery) {
            response = this.hostACLQuery((HostACLQuery)command);
        } else if (command instanceof ICalendarQuery) {
            response = this.icalendarQuery((ICalendarQuery)command);
        } else if (command instanceof GroupQuery) {
            response = this.groupQuery((GroupQuery)command);
        } else if (command instanceof JobQuery) {
            response = this.jobQuery((JobQuery)command);
        } else if (command instanceof JobStatusQuery) {
            response = this.jobStatusQuery((JobStatusQuery)command);
        } else if (command instanceof JobHistoryQuery) {
            response = this.jobHistoryQuery((JobHistoryQuery)command);
        } else if (command instanceof JobOutputQuery) {
            response = this.jobOutputQuery((JobOutputQuery)command);
        } else if (command instanceof LicenseQuery) {
            LicenseQuery query = (LicenseQuery)command;
            response = query.getType() == LicenseQuery.Type.INSTANCE ? this.licenseQueryInstance(query) : this.licenseQuery(query);
        } else if (command instanceof LimitQuery) {
            response = this.limitQuery((LimitQuery)command);
        } else if (command instanceof PropertyQuery) {
            response = this.propertyQuery((PropertyQuery)command);
        } else if (command instanceof ProtectedQuery) {
            response = this.protectedQuery((ProtectedQuery)command);
        } else if (command instanceof QueueQuery) {
            response = this.queueQuery((QueueQuery)command);
        } else if (command instanceof RoleQuery) {
            response = this.roleQuery((RoleQuery)command);
        } else if (command instanceof ServerQuery) {
            response = this.serverQuery((ServerQuery)command);
        } else if (command instanceof ClusterQuery) {
            response = this.serverInfoQuery((ClusterQuery)command);
        } else if (command instanceof TopicQuery) {
            response = this.topicQuery((TopicQuery)command);
        } else if (command instanceof UserQuery) {
            response = this.userQuery((UserQuery)command);
        } else if (command instanceof CalendarCommand) {
            response = this.calendarCommand((CalendarCommand)command);
        } else if (command instanceof ConfigCommand) {
            response = this.configCommand((ConfigCommand)command, false);
        } else if (command instanceof ICalendarCommand) {
            response = this.icalendarCommand((ICalendarCommand)command);
        } else if (command instanceof JobCommand) {
            response = this.jobCommand((JobCommand)command);
        } else if (command instanceof JobControl) {
            response = this.jobControl((JobControl)command);
        } else if (command instanceof PersistCommand) {
            response = this.persistCommand((PersistCommand)command);
        } else if (command instanceof PropertyCommand) {
            response = this.propertyCommand((PropertyCommand)command);
        } else if (command instanceof ACLCommand) {
            response = this.aclCommand((ACLCommand)command);
        } else if (command instanceof AnnouncementCommand) {
            response = this.announcementCommand((AnnouncementCommand)command);
        } else if (command instanceof HostACLCommand) {
            response = this.hostACLCommand((HostACLCommand)command);
        } else if (command instanceof JobHistoryClear) {
            response = this.jobHistoryClear((JobHistoryClear)command);
        } else if (command instanceof LimitReset) {
            response = this.limitReset((LimitReset)command);
        } else if (command instanceof ProtectedCommand) {
            response = this.protectedCommand((ProtectedCommand)command);
        } else if (command instanceof QueueCommand) {
            response = this.queueCommand((QueueCommand)command);
        } else if (command instanceof RoleCommand) {
            response = this.roleCommand((RoleCommand)command);
        } else if (command instanceof UserCommand) {
            response = this.userCommand((UserCommand)command);
        } else if (command instanceof UserPassword) {
            response = this.userPassword((UserPassword)command);
        } else if (command instanceof UserRefresh) {
            response = this.userRefresh((UserRefresh)command);
        } else if (command instanceof LicenseCommand) {
            response = this.licenseCommand((LicenseCommand)command);
        } else if (command instanceof ServiceQuery) {
            response = this.serviceQuery((ServiceQuery)command);
        } else if (command instanceof ServiceCommand) {
            response = this.serviceCommand((ServiceCommand)command);
        } else {
            Localise.logWarn((Logger)logger, (String)"Unsupported message received %1$s", (Object[])new Object[]{command.getClass()});
            response = new Result(false, 1, "unsupported message: " + command.getClass(), new Link[0]);
        }
        Hazelcast.getCommandReceiveQueue((HazelcastInstance)this.hazelcast, (String)clientId).add((Object)response);
    }

    private ACLQuery.Response aclQuery(ACLQuery query) {
        Result result;
        ACLQuery.Response response = new ACLQuery.Response();
        String userName = query.getUserName();
        Name name = query.getName();
        if (name != null && !(result = this.checkAccess(name, ACL.Permission.READ)).wasSuccess()) {
            return response.setResult(result);
        }
        if (!StringUtils.isNullOrEmpty((String)userName)) {
            User user = this.userManager.getUser(userName);
            if (name == null) {
                response.addACLs(this.aclManager.getACLs(user));
            } else {
                response.addACLs(this.aclManager.getACLs(name, user));
            }
        } else if (name != null) {
            List changeIds = query.getChangeIds();
            if (changeIds.isEmpty()) {
                response.addACLs(this.aclManager.getACLs(name));
            } else {
                List<Change> changes = null;
                for (String changeId : changeIds) {
                    Matcher m = relativeChangeIdPattern.matcher(changeId);
                    if (m.matches()) {
                        if (changes == null) {
                            try {
                                changes = this.getChanges(name, "acls");
                            }
                            catch (Persist.PersistException e) {
                                response.getResult().setSuccess(false, Localise.format((String)"Unexpected error getting ACL %1$s change ids - %2$s", (Object[])new Object[]{name, e.getMessage()}));
                                break;
                            }
                        }
                        if (changes.isEmpty()) {
                            response.getResult().setSuccess(false, Localise.format((String)"Unknown acl %s", (Object[])new Object[]{name}));
                            break;
                        }
                        int i = Math.abs(Integer.parseInt(m.group(1)));
                        if (i >= changes.size()) {
                            response.getResult().setSuccess(false, Localise.format((String)"ACL %1$s change %2$s does not exist", (Object[])new Object[]{name, changeId}));
                            break;
                        }
                        changeId = changes.get(i).getId();
                    }
                    try {
                        ACLList acls = (ACLList)this.persistManager.getMessage(name, "acls", changeId);
                        response.addACLs(acls != null ? acls.getValues() : new ArrayList());
                        response.addChangeId(changeId);
                    }
                    catch (Persist.PersistUnknownCommitException e) {
                        response.getResult().setSuccess(false, Localise.format((String)"Unknown change - %s", (Object[])new Object[]{changeId}));
                        break;
                    }
                    catch (Persist.PersistException e) {
                        response.getResult().setSuccess(false, Localise.format((String)"Unexpected error getting ACL %1$s (%2$s) - %3$s", (Object[])new Object[]{name, changeId, e.getMessage()}));
                        break;
                    }
                }
            }
        } else {
            ArrayList<ACL> acls = new ArrayList<ACL>();
            HashMap<Name, Boolean> canRead = new HashMap<Name, Boolean>();
            for (ACL acl : this.aclManager.getACLs()) {
                Name n = acl.getName();
                if (!canRead.containsKey(n)) {
                    canRead.put(n, this.checkAccess(n, ACL.Permission.READ).wasSuccess());
                }
                if (!((Boolean)canRead.get(n)).booleanValue()) continue;
                acls.add(acl);
            }
            response.addACLs(acls);
        }
        return response;
    }

    private ACLCommand.Response aclCommand(ACLCommand command) {
        ACLCommand.Response response = new ACLCommand.Response(command);
        ACL acl = command.getACL();
        Name name = acl.getName();
        Result result = this.checkAccess(name, ACL.Permission.ADMIN);
        if (!result.wasSuccess()) {
            return response.setResult(result);
        }
        switch (command.getAction()) {
            case CREATE: {
                response.setResult(this.aclCreate(acl));
                break;
            }
            case UPDATE: {
                response.setResult(this.aclUpdate(acl));
                break;
            }
            case DELETE: {
                response.setResult(this.aclDelete(acl));
            }
        }
        return response;
    }

    private Result aclCreate(ACL acl) {
        String userRole;
        Name name = acl.getName();
        if (this.aclManager.hasACL(name, userRole = acl.getUserRole())) {
            return new Result(false, Localise.format((String)"ACL %1$s %2$s already exists", (Object[])new Object[]{name, userRole}), new Link[0]);
        }
        if (this.aclManager.setACL(acl)) {
            this.aclPersist(name);
        }
        return new Result();
    }

    private Result aclDelete(ACL acl) {
        Name name = acl.getName();
        String userRole = acl.getUserRole();
        ArrayList<ACL> acls = new ArrayList<ACL>();
        if (StringUtils.isNullOrEmpty((String)userRole)) {
            acls.addAll(this.aclManager.getACLs(name, false));
        } else {
            if (!this.aclManager.hasACL(name, userRole)) {
                return new Result(false, Localise.format((String)"ACL %1$s %2$s does not exist", (Object[])new Object[]{name, userRole}), new Link[0]);
            }
            acls.add(acl);
        }
        boolean changed = false;
        for (ACL a : acls) {
            if (!this.aclManager.deleteACL(a) || changed) continue;
            changed = true;
        }
        if (changed) {
            this.aclPersist(name);
        }
        return new Result();
    }

    private Result aclUpdate(ACL acl) {
        String userRole;
        Name name = acl.getName();
        if (!this.aclManager.hasACL(name, userRole = acl.getUserRole())) {
            return new Result(false, Localise.format((String)"ACL %1$s %2$s does not exist", (Object[])new Object[]{name, userRole}), new Link[0]);
        }
        if (this.aclManager.setACL(acl)) {
            this.aclPersist(name);
        }
        return new Result();
    }

    private void aclPersist(Name name) {
        ACLList values = new ACLList(name, this.aclManager.getACLs(name, false));
        if (values.isEmpty()) {
            this.persistManager.remove((PersistMessage)values, threadConnection.get(), (int)threadChangeGroup.get());
        } else {
            this.persistManager.save((PersistMessage)values, threadConnection.get(), (int)threadChangeGroup.get());
        }
    }

    private AgentQuery.Response agentQuery(AgentQuery query) {
        AgentQuery.Response response = new AgentQuery.Response();
        Filter filter = query.getFilter();
        Result result = this.checkAccess(BlissUtils.ACL_DIR_AGENTS, ACL.Permission.READ);
        if (!result.wasSuccess()) {
            return response.setResult(result);
        }
        for (Connection connection : this.connectionManager.getAgents()) {
            if (!filter.matches(connection.getClientHostName())) continue;
            response.addAgent(connection);
        }
        return response;
    }

    private AnnouncementCommand.Response announcementCommand(AnnouncementCommand command) {
        AnnouncementCommand.Response response = new AnnouncementCommand.Response();
        Result result = this.checkAccess(BlissUtils.ACL_DIR_ANNOUNCEMENTS, ACL.Permission.ADMIN);
        if (!result.wasSuccess()) {
            return response.setResult(result);
        }
        this.announcementTopic.publish((Object)new Announcement(command.getMessage(), threadUser.get().getName(), command.getLevel()));
        return response;
    }

    private CalendarQuery.Response calendarQuery(CalendarQuery query) {
        CalendarQuery.Response response;
        block13: {
            Filter filter;
            List changeIds;
            User user;
            block14: {
                response = new CalendarQuery.Response();
                user = threadUser.get();
                changeIds = query.getChangeIds();
                filter = query.getFilter();
                if (!changeIds.isEmpty()) break block14;
                for (Calendar calendar : this.calendarManager.getCalendars()) {
                    Name name = calendar.getName();
                    if (!filter.matches((Object)name) && !filter.matches(calendar.getDescription()) || !this.aclManager.hasPermission(user, ACL.Permission.READ, name)) continue;
                    calendar.setJobReferenceCount(this.calendarManager.getCalendarJobs(name).size());
                    response.addCalendar(calendar);
                }
                break block13;
            }
            Name name = null;
            try {
                name = new Name(filter.getPattern());
            }
            catch (URISyntaxException e) {
                response.getResult().setSuccess(false, Localise.format((String)"Invalid calendar name"));
            }
            if (name == null || !this.aclManager.hasPermission(user, ACL.Permission.READ, name)) break block13;
            List<Change> changes = null;
            for (String changeId : changeIds) {
                Matcher m = relativeChangeIdPattern.matcher(changeId);
                if (m.matches()) {
                    if (changes == null) {
                        try {
                            changes = this.getChanges(name, "cal");
                        }
                        catch (Persist.PersistException e) {
                            response.getResult().setSuccess(false, Localise.format((String)"Unexpected error getting calendar %1$s change ids - %2$s", (Object[])new Object[]{name, e.getMessage()}));
                            break;
                        }
                    }
                    if (changes.isEmpty()) {
                        response.getResult().setSuccess(false, Localise.format((String)"Unknown calendar %s", (Object[])new Object[]{name}));
                        break;
                    }
                    int i = Math.abs(Integer.parseInt(m.group(1)));
                    if (i >= changes.size()) {
                        response.getResult().setSuccess(false, Localise.format((String)"Calendar %1$s change %2$s does not exist", (Object[])new Object[]{name, changeId}));
                        break;
                    }
                    changeId = changes.get(i).getId();
                }
                try {
                    response.addCalendar((Calendar)this.persistManager.getMessage(name, "cal", changeId));
                    response.addChangeId(changeId);
                }
                catch (Persist.PersistUnknownCommitException e) {
                    response.getResult().setSuccess(false, Localise.format((String)"Unknown change - %s", (Object[])new Object[]{changeId}));
                    break;
                }
                catch (Persist.PersistException e) {
                    response.getResult().setSuccess(false, Localise.format((String)"Unexpected error getting calendar %1$s (%2$s) - %3$s", (Object[])new Object[]{name, changeId, e.getMessage()}));
                    break;
                }
            }
        }
        return response;
    }

    private CalendarJobsQuery.Response calendarJobsQuery(CalendarJobsQuery query) {
        CalendarJobsQuery.Response response = new CalendarJobsQuery.Response(query);
        Name name = query.getName();
        Result result = this.checkAccess(name, ACL.Permission.READ);
        if (!result.wasSuccess()) {
            return response.setResult(result);
        }
        if (this.calendarManager.isCalendar(name)) {
            for (Name job : this.calendarManager.getCalendarJobs(name)) {
                response.addJob(job);
            }
        } else {
            response.getResult().setSuccess(false, Localise.format((String)"Calendar %s does not exist", (Object[])new Object[]{name}));
        }
        return response;
    }

    private ConfigQuery.Response configQuery(ConfigQuery query) {
        ConfigQuery.Response response;
        block21: {
            List changeIds;
            Filter filter;
            block22: {
                block23: {
                    response = new ConfigQuery.Response();
                    Result result = this.checkAccess(BlissUtils.ACL_DIR_CONFIGURATION, ACL.Permission.READ);
                    if (!result.wasSuccess()) {
                        return response.setResult(result);
                    }
                    filter = query.getFilter();
                    changeIds = query.getChangeIds();
                    if (!changeIds.isEmpty()) break block22;
                    if (filter.getType() != Filter.Type.EXACT) break block23;
                    Config config = Configs.getConfig((String)filter.getPattern());
                    if (config == null) break block21;
                    response.addConfig(config);
                    break block21;
                }
                boolean startup = query.getStartup();
                boolean hidden = query.getHidden();
                boolean normal = !startup && !hidden;
                String pattern = filter.getPattern();
                for (Config config : Configs.getConfigs((boolean)true)) {
                    boolean match = false;
                    if (config.getName().equalsIgnoreCase(pattern)) {
                        match = true;
                    } else if (filter.matches(config.getName())) {
                        if (normal) {
                            if (!config.isStartup() && !config.isHidden()) {
                                if (config.getName().contains("yubico")) {
                                    System.out.println(config);
                                }
                                match = true;
                            }
                        } else if (startup && config.isStartup()) {
                            match = true;
                        } else if (hidden && config.isHidden()) {
                            match = true;
                        }
                    }
                    if (!match) continue;
                    response.addConfig(config);
                }
                break block21;
            }
            Name name = Config.getPath((String)filter.getPattern());
            List<Change> changes = null;
            for (String changeId : changeIds) {
                Matcher m = relativeChangeIdPattern.matcher(changeId);
                if (m.matches()) {
                    int i;
                    if (changes == null) {
                        try {
                            changes = this.getChanges(name, "config");
                        }
                        catch (Persist.PersistException e) {
                            response.getResult().setSuccess(false, Localise.format((String)"Unexpected error get configuration property %1$s change ids -%2$s", (Object[])new Object[]{name, e.getMessage()}));
                            break;
                        }
                    }
                    if ((i = Math.abs(Integer.parseInt(m.group(1)))) >= changes.size()) {
                        response.getResult().setSuccess(false, Localise.format((String)"Configuration property %1$s change %2$s does not exist", (Object[])new Object[]{name, changeId}));
                        break;
                    }
                    changeId = changes.get(i).getId();
                }
                try {
                    ConfigProperty property = (ConfigProperty)this.persistManager.getMessage(name, "config", changeId);
                    Object config = Configs.getConfig((String)property.getName());
                    config = config != null ? ((Config)config.duplicate()).setValue((Object)property.getValue()) : new StringConfig(property.getName(), property.getValue());
                    response.addConfig(config);
                    response.addChangeId(changeId);
                }
                catch (Persist.PersistUnknownCommitException e) {
                    response.getResult().setSuccess(false, Localise.format((String)"Unknown change - %s", (Object[])new Object[]{changeId}));
                    break;
                }
                catch (Persist.PersistException e) {
                    response.getResult().setSuccess(false, Localise.format((String)"Unexpected error getting configuration property %1$s (%2$s) - %3$s", (Object[])new Object[]{name, changeId, e.getMessage()}));
                    break;
                }
            }
        }
        return response;
    }

    private ConfigCommand.Response configCommand(ConfigCommand command, boolean internal) {
        ConfigCommand.Response response = new ConfigCommand.Response(command);
        Result result = this.checkAccess(BlissUtils.ACL_DIR_CONFIGURATION, ACL.Permission.WRITE);
        if (!result.wasSuccess()) {
            return response.setResult(result);
        }
        String name = command.getName();
        String value = command.getValue();
        boolean unset = value == null;
        Config config = Configs.getConfig((String)name);
        if (config == null) {
            if (unset) {
                return response.setResult(new Result(false, Localise.format((String)"Property does not exist"), new Link[0]));
            }
        } else {
            if (config.getType() == Config.Type.SYSTEM && !internal) {
                response.getResult().setSuccess(false, Localise.format((String)"System properties cannot be changed"));
                return response;
            }
            if (config.isStartup()) {
                return response.setResult(new Result(false, Localise.format((String)"Startup properties cannot be modified"), new Link[0]));
            }
            if (config.isDefault()) {
                if (unset) {
                    return response.setResult(new Result(false, Localise.format((String)"Property is already unset"), new Link[0]));
                }
            } else if (config.getValue().toString().equals(value)) {
                return response.setResult(new Result(false, Localise.format((String)"Property already set to this value"), new Link[0]));
            }
        }
        if (!unset) {
            if (config != null) {
                try {
                    config.set(value, config.getType());
                }
                catch (IllegalArgumentException e) {
                    return response.setResult(new Result(false, e.getMessage(), new Link[0]));
                }
            } else {
                config = new StringConfig(name, value);
            }
            Configs.setConfig((Config)config);
            try {
                this.persistManager.save(config.getPath(), (Message)new ConfigProperty(name, value), threadConnection.get(), threadChangeGroup.get());
            }
            catch (IllegalStateException e) {
                Localise.logWarn((Logger)logger, (String)"Error persisting set/update of configuration property %1$s - %2$s", (Object[])new Object[]{name, e.getMessage()});
                return response.setResult(new Result(false, e.getMessage(), new Link[0]));
            }
        }
        Configs.unset((String)name);
        try {
            this.persistManager.remove(config.getPath(), (Message)new ConfigProperty(name, value), threadConnection.get(), threadChangeGroup.get());
        }
        catch (IllegalStateException e) {
            Localise.logWarn((Logger)logger, (String)"Error persisting deletion of configuration property %1$s - %2$s", (Object[])new Object[]{name, e.getMessage()});
            return response.setResult(new Result(false, e.getMessage(), new Link[0]));
        }
        if (response.getResult().wasSuccess()) {
            switch (name) {
                case "beyondcron.guest.user.name": 
                case "beyondcron.guest.user.description": 
                case "beyondcron.guest.user.password": 
                case "beyondcron.guest.user.access": {
                    this.userManager.refreshGuestUser();
                }
            }
        }
        return response;
    }

    private ConnectionQuery.Response connectionQuery(ConnectionQuery query) {
        ConnectionQuery.Response response = new ConnectionQuery.Response();
        Filter filter = query.getFilter();
        Result result = this.checkAccess(BlissUtils.ACL_DIR_CONNECTIONS, ACL.Permission.READ);
        if (!result.wasSuccess()) {
            return response.setResult(result);
        }
        for (Connection connection : this.connectionManager.getActiveConnections()) {
            if (!filter.matches(connection.getClientHostName())) continue;
            response.addConnection(connection);
        }
        return response;
    }

    private ICalendarQuery.Response icalendarQuery(ICalendarQuery query) {
        ICalendarQuery.Response response = new ICalendarQuery.Response();
        Filter filter = query.getFilter();
        Result result = this.checkAccess(BlissUtils.ACL_DIR_ICALENDARS, ACL.Permission.READ);
        if (!result.wasSuccess()) {
            return response.setResult(result);
        }
        if (query.getURI() != null) {
            ICalendarData icalendar = this.calendarManager.getICalendar(query.getURI());
            if (icalendar != null) {
                response.addICalendar(new ICalendar(icalendar));
            }
        } else {
            for (ICalendarData icalendar : this.calendarManager.getICalendars()) {
                if (!filter.matches(icalendar.getName()) && !filter.matches(icalendar.getDescription())) continue;
                response.addICalendar(new ICalendar(icalendar));
            }
        }
        for (ICalendarData icalendar : response.getICalendars()) {
            icalendar.setListenerCount(this.calendarManager.getICalendarCalendars(icalendar.getURI()).size());
        }
        return response;
    }

    private ServerQuery.Response serverQuery(ServerQuery query) {
        ServerQuery.Response response = new ServerQuery.Response();
        Result result = this.checkAccess(BlissUtils.ACL_DIR_SERVERS, ACL.Permission.READ);
        if (!result.wasSuccess()) {
            return response.setResult(result);
        }
        for (Connection server : this.connectionManager.getServers()) {
            response.addServer(server);
        }
        return response;
    }

    private ClusterQuery.Response serverInfoQuery(ClusterQuery query) {
        ClusterQuery.Response response = new ClusterQuery.Response(query);
        Result result = this.checkAccess(BlissUtils.ACL_DIR_SERVERS, ACL.Permission.READ);
        if (!result.wasSuccess()) {
            return response.setResult(result);
        }
        JSONObject json = new JSONObject();
        JSONArray array = new JSONArray();
        IExecutorService executor = this.hazelcast.getExecutorService("serverInfo");
        for (Future info : executor.submitToAllMembers((Callable)new ServerInfo()).values()) {
            try {
                array.put((Object)new JSONObject((String)info.get()));
            }
            catch (Exception e) {
                JSONObject object = new JSONObject();
                object.put("exception", (Object)e.getMessage());
                array.put((Object)object);
            }
        }
        json.put("servers", (Object)array);
        array = new JSONArray();
        for (Connection connection : ConnectionManager.getInstance(this.hazelcast).getActiveConnections()) {
            if (connection.getClientType() == Connection.Type.SERVER) continue;
            array.put((Object)connection.toJSON());
        }
        json.put("connections", (Object)array);
        response.setInfo(json);
        return response;
    }

    private CalendarCommand.Response calendarCommand(CalendarCommand command) {
        CalendarCommand.Response response = new CalendarCommand.Response(command);
        Name name = command.getName();
        CalendarCommand.Action action = command.getAction();
        Result result = this.checkAccess(name, action != CalendarCommand.Action.REFRESH ? ACL.Permission.WRITE : ACL.Permission.EXECUTE);
        if (!result.wasSuccess()) {
            return response.setResult(result);
        }
        switch (action) {
            case CREATE: {
                try {
                    this.licenseManager.addCalendar(name);
                    response.setResult(this.calendarCreate(command.getCalendar()));
                    if (response.getResult().wasSuccess()) break;
                    this.licenseManager.removeCalendar(name);
                }
                catch (LicenseManager.LimitException e) {
                    response.setResult(new Result(false, Localise.format((String)"Maximum number of %s calendars already defined", (Object[])new Object[]{e.getType().getLabel()}), new Link[0]));
                }
                break;
            }
            case UPDATE: {
                response.setResult(this.calendarUpdate(command.getCalendar()));
                break;
            }
            case DELETE: {
                response.setResult(this.calendarDelete(command.getName()));
                if (!response.getResult().wasSuccess()) break;
                this.licenseManager.removeCalendar(name);
                break;
            }
            case REFRESH: {
                response.setResult(this.calendarRefresh(command.getName()));
            }
        }
        return response;
    }

    private Result calendarCreate(Calendar calendar) {
        Name name = calendar.getName();
        Result result = new Result();
        if (this.calendarManager.isCalendar(name)) {
            return result.setSuccess(false, Localise.format((String)"Calendar %s already exists", (Object[])new Object[]{name}));
        }
        String msg = this.dataManager.canCreate(name);
        if (msg != null) {
            return new Result(false, msg, new Link[0]);
        }
        try {
            this.calendarManager.setCalendar(calendar);
            this.persistManager.save((NamedMessage)calendar, threadConnection.get(), (int)threadChangeGroup.get());
        }
        catch (Exception e) {
            Localise.logWarn((Logger)logger, (String)"Error creating calendar %1$s - %2$s", (Object[])new Object[]{name, e.getMessage()});
            result.setSuccess(false, e.getMessage());
        }
        return result;
    }

    private Result calendarDelete(Name name) {
        Result result = new Result();
        Calendar calendar = this.calendarManager.getCalendar(name);
        if (calendar == null) {
            result.setSuccess(false, Localise.format((String)"Calendar %s does not exist", (Object[])new Object[]{name}));
        } else if (this.calendarManager.hasCalendarJobs(name)) {
            result.setSuccess(false, Localise.format((String)"Calendar %s has one or more references", (Object[])new Object[]{name}));
        } else {
            try {
                if (this.calendarManager.deleteCalendar(name) != null) {
                    this.persistManager.remove((NamedMessage)calendar, threadConnection.get(), (int)threadChangeGroup.get());
                } else {
                    result.setSuccess(false, Localise.format((String)"Could not delete calendar %s", (Object[])new Object[]{name}));
                }
            }
            catch (Exception e) {
                Localise.logWarn((Logger)logger, (String)"Error deleting calendar %1$s - %2$s", (Object[])new Object[]{name, e.getMessage()});
                result.setSuccess(false, e.getMessage());
            }
        }
        return result;
    }

    private Result calendarUpdate(Calendar calendar) {
        Name name = calendar.getName();
        Result result = new Result();
        if (!this.calendarManager.isCalendar(name)) {
            return result.setSuccess(false, Localise.format((String)"Calendar %s does not exist", (Object[])new Object[]{name}));
        }
        try {
            this.calendarManager.setCalendar(calendar);
            this.persistManager.save((NamedMessage)calendar, threadConnection.get(), (int)threadChangeGroup.get());
        }
        catch (Exception e) {
            Localise.logWarn((Logger)logger, (String)"Error updating calendar %1$s - %2$s", (Object[])new Object[]{name, e.getMessage()});
            result.setSuccess(false, e.getMessage());
        }
        return result;
    }

    private Result calendarRefresh(Name name) {
        Result result = new Result();
        if (!name.equals((Object)Calendar.ALL_CALENDARS)) {
            if (!this.calendarManager.isCalendar(name)) {
                return result.setSuccess(false, Localise.format((String)"Calendar %s does not exist", (Object[])new Object[]{name}));
            }
            this.calendarManager.updateCalendar(name);
        } else {
            this.calendarManager.updateICalendars(false);
        }
        return result;
    }

    private ICalendarCommand.Response icalendarCommand(ICalendarCommand command) {
        ICalendarCommand.Response response = new ICalendarCommand.Response(command);
        URI uri = command.getURI();
        Result result = this.checkAccess(BlissUtils.ACL_DIR_ICALENDARS, ACL.Permission.WRITE);
        if (!result.wasSuccess()) {
            return response.setResult(result);
        }
        result = response.getResult();
        switch (command.getAction()) {
            case CREATE: {
                if (!this.calendarManager.isICalendar(uri)) {
                    try {
                        this.calendarManager.getICalendar(uri, true);
                    }
                    catch (CalendarException e) {
                        result.setSuccess(false, e.getMessage());
                    }
                    break;
                }
                result.setSuccess(false, Localise.format((String)"icalendar %s already exists", (Object[])new Object[]{uri}));
                break;
            }
            case DELETE: {
                ICalendarData icalendar = this.calendarManager.getICalendar(uri);
                if (icalendar == null) {
                    result.setSuccess(false, Localise.format((String)"icalendar %s does not exist", (Object[])new Object[]{uri}));
                    break;
                }
                if ("beyondcron".equals(icalendar.getURI().getScheme())) {
                    result.setSuccess(false, Localise.format((String)"%s icalendars cannot be deleted", (Object[])new Object[]{StringUtils.capitalise((Object)"beyondcron")}));
                    break;
                }
                if (this.calendarManager.hasICalendarCalendars(uri)) {
                    result.setSuccess(false, Localise.format((String)"icalendar %s has one or more references", (Object[])new Object[]{uri}));
                    break;
                }
                try {
                    this.calendarManager.deleteICalendar(uri);
                }
                catch (Exception e) {
                    result.setSuccess(false, e.getMessage());
                }
                break;
            }
            case REFRESH: {
                if (uri.equals(ICalendar.ALL_CALENDARS)) {
                    this.calendarManager.updateICalendars(false);
                    break;
                }
                if (this.calendarManager.isICalendar(uri)) {
                    this.calendarManager.updateICalendar(uri);
                    break;
                }
                result.setSuccess(false, Localise.format((String)"icalendar %s does not exist", (Object[])new Object[]{uri}));
            }
        }
        return response;
    }

    private GroupQuery.Response groupQuery(GroupQuery query) {
        GroupQuery.Response response = new GroupQuery.Response();
        Name group = query.getName();
        User user = threadUser.get();
        Result result = this.checkAccess(group, ACL.Permission.READ);
        if (!result.wasSuccess()) {
            return response.setResult(result);
        }
        if (!this.dataManager.isGroup(group)) {
            response.getResult().setSuccess(false, Localise.format((String)"Group does not exist"));
            return response;
        }
        boolean addGroup = false;
        if (this.aclManager.hasACL(group)) {
            response.addEntry(new Group.Entry(Group.Entry.Type.ACL, ".", ""));
            addGroup = true;
        }
        if (this.propertyManager.hasProperty(group)) {
            response.addEntry(new Group.Entry(Group.Entry.Type.PROPERTY, ".", ""));
            addGroup = true;
        }
        if (addGroup) {
            response.addEntry(new Group.Entry(Group.Entry.Type.GROUP, ".", ""));
        }
        for (Name name : this.dataManager.getGroups().get((Object)group)) {
            if (!this.aclManager.hasPermission(user, ACL.Permission.READ, name)) continue;
            response.addEntry(new Group.Entry(name));
            if (!this.propertyManager.hasProperty(name)) continue;
            response.addEntry(new Group.Entry(Group.Entry.Type.PROPERTY, name.getName(), ""));
        }
        for (Name name : this.aclManager.getChildren(group)) {
            if (!this.aclManager.hasPermission(user, ACL.Permission.READ, name)) continue;
            response.addEntry(new Group.Entry(Group.Entry.Type.ACL, name.getName(), ""));
        }
        for (Calendar calendar : this.calendarManager.getCalendars(group)) {
            if (!this.aclManager.hasPermission(user, ACL.Permission.READ, calendar.getName())) continue;
            response.addEntry(new Group.Entry(calendar));
        }
        for (Job job : this.jobManager.getJobs(group)) {
            if (!this.aclManager.hasPermission(user, ACL.Permission.READ, job.getName())) continue;
            response.addEntry(new Group.Entry(job));
        }
        return response;
    }

    private JobQuery.Response jobQuery(JobQuery query) {
        JobQuery.Response response;
        block16: {
            Filter filter;
            List changeIds;
            User user;
            block17: {
                response = new JobQuery.Response(query);
                user = threadUser.get();
                changeIds = query.getChangeIds();
                filter = query.getFilter();
                if (!changeIds.isEmpty()) break block17;
                for (Job job : this.jobManager.getJobs(filter)) {
                    if (!this.aclManager.hasPermission(user, ACL.Permission.READ, job.getName())) continue;
                    response.addJob(job);
                }
                break block16;
            }
            Name name = null;
            try {
                name = new Name(filter.getPattern());
            }
            catch (URISyntaxException e) {
                response.getResult().setSuccess(false, Localise.format((String)"Invalid job name"));
            }
            if (name == null || !this.aclManager.hasPermission(user, ACL.Permission.READ, name)) break block16;
            boolean lastDiff = false;
            if (changeIds.size() > 1 && ((String)changeIds.get(0)).equals("0") && ((String)changeIds.get(1)).equals("0")) {
                Job job = this.jobManager.getJob(name);
                changeIds.set(0, job != null && job.isEnabled() ? "-2" : "-1");
                lastDiff = true;
            }
            List<Change> changes = null;
            for (String changeId : changeIds) {
                Matcher m = relativeChangeIdPattern.matcher(changeId);
                if (m.matches()) {
                    if (changes == null) {
                        try {
                            changes = this.getChanges(name, "job");
                        }
                        catch (Persist.PersistException e) {
                            response.getResult().setSuccess(false, Localise.format((String)"Unexpected error getting job %1$s change ids - %2$s", (Object[])new Object[]{name, e.getMessage()}));
                            break;
                        }
                    }
                    if (changes.isEmpty()) {
                        response.getResult().setSuccess(false, Localise.format((String)"Unknown job %s", (Object[])new Object[]{name}));
                        break;
                    }
                    int i = Math.abs(Integer.parseInt(m.group(1)));
                    if (i < changes.size()) {
                        changeId = changes.get(i).getId();
                    } else {
                        if (!lastDiff) {
                            response.getResult().setSuccess(false, Localise.format((String)"Job %1$s change %2$s does not exist", (Object[])new Object[]{name, changeId}));
                            break;
                        }
                        changeId = changes.get(changes.size() - 1).getId();
                    }
                }
                try {
                    response.addJob((Job)this.persistManager.getMessage(name, "job", changeId));
                    response.addChangeId(changeId);
                }
                catch (Persist.PersistUnknownCommitException e) {
                    response.getResult().setSuccess(false, Localise.format((String)"Unknown change - %s", (Object[])new Object[]{changeId}));
                    break;
                }
                catch (Persist.PersistException e) {
                    response.getResult().setSuccess(false, Localise.format((String)"Unexpected error getting job %1$s (%2$s) - %3$s", (Object[])new Object[]{name, changeId, e.getMessage()}));
                    break;
                }
            }
        }
        return response;
    }

    private ChangeQuery.Response changeQuery(ChangeQuery query) {
        return query.getType() == ChangeQuery.Type.COMMIT ? this.changeChangeQuery(query) : this.changeDataQuery(query);
    }

    private ChangeQuery.Response changeDataQuery(ChangeQuery query) {
        Name name = query.getName();
        ChangeQuery.Type type = query.getType();
        ChangeQuery.Response response = new ChangeQuery.Response(query);
        Result result = this.checkAccess(name, ACL.Permission.READ);
        if (!result.wasSuccess()) {
            return response.setResult(result);
        }
        try {
            response.addChanges(this.persistManager.getHistory(name, type.getTag()));
        }
        catch (Persist.PersistException e) {
            response.getResult().setSuccess(false, Localise.format((String)"Unexpected error getting changes for %1$s %2$s", (Object[])new Object[]{type.getLabel(), name}));
        }
        return response;
    }

    private ChangeQuery.Response changeChangeQuery(ChangeQuery query) {
        ChangeQuery.Response response = new ChangeQuery.Response(query);
        try {
            String changeId = query.getChangeId();
            if (!StringUtils.isNullOrEmpty((String)changeId)) {
                Matcher m = relativeChangeIdPattern.matcher(changeId);
                if (m.matches()) {
                    changeId = String.format("master~%d", Math.abs(Integer.parseInt(m.group(1))));
                }
                response.addChanges(this.persistManager.getCommit(changeId));
            } else {
                response.addChanges(this.persistManager.getCommits(query.getStartTimestamp(), query.getEndTimestamp()));
            }
        }
        catch (Persist.PersistException e) {
            response.getResult().setSuccess(false, Localise.format((String)"Unexpected error getting changes for change"));
            e.printStackTrace();
        }
        return response;
    }

    private JobStatusQuery.Response jobStatusQuery(JobStatusQuery query) {
        JobStatusQuery.Response response = new JobStatusQuery.Response();
        User user = threadUser.get();
        Status.Filter statusFilter = query.getStatusFilter();
        boolean filterStatus = !statusFilter.isEmpty();
        for (Status status : this.jobStatusManager.getStatuses(query.getFilter())) {
            JobMode jobMode;
            if (!this.aclManager.hasPermission(user, ACL.Permission.READ, status.getName()) || filterStatus && !statusFilter.matches(status)) continue;
            if (status.isInactive() && (jobMode = this.jobModeValidator.getMode(status.getName())).getGroup() != null) {
                status.setMode(jobMode.getMode());
            }
            response.addStatus(status);
        }
        return response;
    }

    private JobHistoryClear.Response jobHistoryClear(JobHistoryClear command) {
        Result result;
        JobHistoryClear.Response response = new JobHistoryClear.Response(command);
        Name name = command.getName();
        long timestamp = command.getTimestamp();
        if (name != null ? !(result = this.checkAccess(name, ACL.Permission.ADMIN)).wasSuccess() : !(result = this.checkAccess(BlissUtils.ACL_DIR_STATUSES, ACL.Permission.ADMIN)).wasSuccess()) {
            return response.setResult(result);
        }
        StatusService statusService = this.jobStatusManager.getStatusService();
        if (statusService == null) {
            return response.setResult(new Result(false, Localise.format((String)"Job history not enabled."), new Link[0]));
        }
        if (timestamp < 0L) {
            timestamp = System.currentTimeMillis();
        }
        try {
            if (name != null) {
                response.setRemoved(statusService.removeStatuses(name, timestamp));
            } else {
                response.setRemoved(statusService.removeStatuses(timestamp));
            }
        }
        catch (Exception e) {
            response.setResult(new Result(e));
        }
        return response;
    }

    private JobHistoryQuery.Response jobHistoryQuery(JobHistoryQuery query) {
        JobHistoryQuery.Response response = new JobHistoryQuery.Response(query);
        Name name = query.getName();
        Result result = this.checkAccess(name, ACL.Permission.READ);
        if (!result.wasSuccess()) {
            return response.setResult(result);
        }
        StatusService statusService = this.jobStatusManager.getStatusService();
        if (statusService == null) {
            return response.setResult(new Result(false, Localise.format((String)"Configure a status service to get job history."), new Link[0]));
        }
        long startTimestamp = query.getStartTimestamp();
        long endTimestamp = query.getEndTimestamp();
        try {
            if (startTimestamp <= StatusService.COUNT_LIMIT) {
                response.addStatuses(statusService.getStatusesCount(name, startTimestamp, endTimestamp));
            } else {
                response.addStatuses(statusService.getStatusesRange(name, startTimestamp, endTimestamp));
            }
        }
        catch (Exception e) {
            return response.setResult(new Result(e));
        }
        return response;
    }

    private JobOutputQuery.Response jobOutputQuery(JobOutputQuery query) {
        JobOutputQuery.Response response = new JobOutputQuery.Response(query);
        Name name = query.getName();
        long timestamp = query.getTimestamp();
        Result result = this.checkAccess(name, ACL.Permission.READ);
        if (!result.wasSuccess()) {
            return response.setResult(result);
        }
        StatusService statusService = this.jobStatusManager.getStatusService();
        if (statusService == null) {
            return response.setResult(new Result(false, Localise.format((String)"Configure a status service to get job history."), new Link[0]));
        }
        if (timestamp < 0L) {
            timestamp = this.jobStatusManager.getStatus(name).getTimestamp();
        }
        try {
            Status status = statusService.getStatus(name, timestamp, true);
            if (status != null) {
                response.setStatus(status);
            }
        }
        catch (Exception e) {
            return response.setResult(new Result(e));
        }
        return response;
    }

    private JobCommand.Response jobCommand(JobCommand command) {
        JobCommand.Response response = new JobCommand.Response(command);
        Name name = command.getName();
        Job job = command.getJob();
        Result result = this.checkAccess(name, ACL.Permission.WRITE);
        if (!result.wasSuccess()) {
            return response.setResult(result);
        }
        if (command.getAction() != JobCommand.Action.DELETE) {
            Job.Type jobType = command.getJob().getType();
            boolean jobTypeAllowed = true;
            if (jobType == Job.Type.COMMAND) {
                jobTypeAllowed = this.licenseManager.getBooleanProperty(threadUser.get(), "commandJobs");
            } else if (jobType == Job.Type.CONTAINER) {
                jobTypeAllowed = this.licenseManager.getBooleanProperty(threadUser.get(), "containerJobs");
            } else if (jobType == Job.Type.CUSTOM) {
                jobTypeAllowed = this.licenseManager.getBooleanProperty(threadUser.get(), "customJobs");
            } else if (jobType == Job.Type.MAIL) {
                jobTypeAllowed = this.licenseManager.getBooleanProperty(threadUser.get(), "messageJobs");
            } else if (jobType == Job.Type.SQL) {
                jobTypeAllowed = this.licenseManager.getBooleanProperty(threadUser.get(), "sqlJobs");
            } else if (jobType == Job.Type.TRIGGER) {
                jobTypeAllowed = this.licenseManager.getBooleanProperty(threadUser.get(), "triggerJobs");
            } else if (jobType == Job.Type.URL) {
                jobTypeAllowed = this.licenseManager.getBooleanProperty(threadUser.get(), "urlJobs");
            }
            if (!jobTypeAllowed) {
                return response.setResult(new Result(false, Localise.format((String)"%s jobs not licensed", (Object[])new Object[]{jobType.getLabel()}), new Link[0]));
            }
            Name calendar = job.getCalendar();
            if (calendar != null && !this.calendarManager.isCalendar(calendar)) {
                result = new Result(false, Localise.format((String)"Calendar %s does not exist", (Object[])new Object[]{calendar}), new Link[0]);
                return response.setResult(result);
            }
            if (jobType == Job.Type.COMMAND) {
                String hostName;
                String userName;
                CommandJob cJob = (CommandJob)job;
                Command cmd = cJob.getCommand();
                if (cmd != null) {
                    try {
                        cmd.validate();
                    }
                    catch (IllegalArgumentException e) {
                        return response.setResult(new Result(false, e.getMessage(), new Link[0]));
                    }
                }
                if (!(result = this.checkAccess(userName = cJob.getUserName(), hostName = cJob.getHostName())).wasSuccess()) {
                    return response.setResult(result);
                }
            }
            if (jobType == Job.Type.URL) {
                URL url = ((URLJob)job).getURL();
                if (url == null) {
                    Localise.logWarn((Logger)logger, (String)"Job %1$s url is null", (Object[])new Object[]{name});
                    return response.setResult(new Result(false, Localise.format((String)"URL cannot be null"), new Link[0]));
                }
                if (url.getHost() == null) {
                    return response.setResult(new Result(false, Localise.format((String)"URL host name cannot be empty"), new Link[0]));
                }
                result = this.checkAccess(url.getUserInfo(), url.getHost());
                if (!result.wasSuccess()) {
                    return response.setResult(result);
                }
            }
            if (job.hasCondition() && !this.licenseManager.getBooleanProperty(threadUser.get(), "jobFlows")) {
                return response.setResult(new Result(false, Localise.format((String)"Job flows not licensed"), new Link[0]));
            }
            if (job.hasSchedule()) {
                for (Condition condition : job.getConditions()) {
                    if (condition.getType() != Condition.Type.ANY) continue;
                    return response.setResult(new Result(false, Localise.format((String)"Job cannot have both schedule/s and trigger/s."), new Link[0]));
                }
            }
            boolean conditionWildcardsLicensed = this.licenseManager.getBooleanProperty(threadUser.get(), "jobFlowWildcards");
            for (Condition condition : job.getConditions()) {
                Name conditionName = condition.getJob();
                if (!conditionName.isWildcard()) {
                    if (!conditionName.equals((Object)name)) continue;
                    return response.setResult(new Result(false, Localise.format((String)"Job conditions/triggers cannot refer to own job"), new Link[0]));
                }
                if (!conditionWildcardsLicensed) {
                    return response.setResult(new Result(false, Localise.format((String)"Job flow wildcards not licensed"), new Link[0]));
                }
                if (condition.getType() != Condition.Type.ALL || !conditionName.isWildcardRecursive()) continue;
                return response.setResult(new Result(false, Localise.format((String)"Job conditions cannot contain recursive wildcards"), new Link[0]));
            }
        }
        switch (command.getAction()) {
            case CREATE: {
                try {
                    this.licenseManager.addJob(name);
                    response.setResult(this.jobCreate(job));
                    if (response.getResult().wasSuccess()) break;
                    this.licenseManager.removeJob(name);
                }
                catch (LicenseManager.LimitException e) {
                    if (e.getType() == LicenseManager.AbstractException.Type.SERVER) {
                        response.setResult(new Result(false, Localise.format((String)"Maximum number (%1$d) of jobs already defined", (Object[])new Object[]{e.getMaxValue()}), new Link[0]));
                        break;
                    }
                    response.setResult(new Result(false, Localise.format((String)"Maximum number (%1$d) of %2$s jobs already defined", (Object[])new Object[]{e.getMaxValue(), e.getType().getLabel()}), new Link[0]));
                }
                break;
            }
            case UPDATE: {
                response.setResult(this.jobUpdate(job));
                break;
            }
            case DELETE: {
                response.setResult(this.jobDelete(name));
                if (!response.getResult().wasSuccess()) break;
                this.licenseManager.removeJob(name);
            }
        }
        return response;
    }

    private Result jobCreate(Job job) {
        Name name = job.getName();
        if (this.jobManager.isJob(name)) {
            return new Result(false, Localise.format((String)"Job %s already exists", (Object[])new Object[]{name}), new Link[0]);
        }
        String msg = this.dataManager.canCreate(name);
        if (msg != null) {
            return new Result(false, msg, new Link[0]);
        }
        if (job.hasOutput() && !this.licenseManager.getBooleanProperty(threadUser.get(), "jobOutput")) {
            return new Result(false, Localise.format((String)"Job output not licensed"), new Link[0]);
        }
        if (job.getMode() == Job.Mode.ENABLED && !job.canEnable()) {
            return new Result(false, job.canEnableReason(), new Link[0]);
        }
        this.jobManager.setJob(job);
        this.persistManager.save((NamedMessage)job, threadConnection.get(), (int)threadChangeGroup.get());
        return new Result();
    }

    private Result jobDelete(Name name) {
        Job job = this.jobManager.getJob(name);
        if (job == null) {
            return new Result(false, Localise.format((String)"Job %s does not exist", (Object[])new Object[]{name}), new Link[0]);
        }
        if (job.getMode() != Job.Mode.DISABLED) {
            return new Result(false, Localise.format((String)"Cannot delete enabled/bypassed job %s", (Object[])new Object[]{name}), new Link[0]);
        }
        job = this.jobManager.deleteJob(name);
        if (job == null) {
            return new Result(false, Localise.format((String)"Could not delete job %s", (Object[])new Object[]{name}), new Link[0]);
        }
        this.persistManager.remove((NamedMessage)job, threadConnection.get(), (int)threadChangeGroup.get());
        return new Result();
    }

    private Result jobUpdate(Job job) {
        Name name = job.getName();
        Job j = this.jobManager.getJob(name);
        if (j == null) {
            return new Result(false, Localise.format((String)"Job %s does not exist", (Object[])new Object[]{name}), new Link[0]);
        }
        if (job.getOutput() != j.getOutput() && !this.licenseManager.getBooleanProperty(threadUser.get(), "jobOutput")) {
            return new Result(false, Localise.format((String)"Job output not licensed"), new Link[0]);
        }
        if (j.getMode() == Job.Mode.ENABLED) {
            return new Result(false, Localise.format((String)"Cannot update enabled job %s", (Object[])new Object[]{name}), new Link[0]);
        }
        this.jobManager.setJob(job);
        this.persistManager.save((NamedMessage)job, threadConnection.get(), (int)threadChangeGroup.get());
        return new Result();
    }

    private JobControl.Response jobControl(JobControl command) {
        JobControl.Response response;
        Job job = this.jobManager.getJob(command.getName());
        if (job == null) {
            response = new JobControl.Response(command.getName());
            response.getResult().setSuccess(false, Localise.format((String)"Unknown job %s", (Object[])new Object[]{command.getName()}));
        } else if (command.getAction() != null) {
            response = this.jobAction(command, job);
        } else if (command.getMode() != null) {
            response = this.jobMode(command, job);
        } else {
            response = new JobControl.Response(command.getName());
            response.getResult().setSuccess(false, Localise.format((String)"Neither mode nor action specified updating job %s", (Object[])new Object[]{command.getName()}));
        }
        return response;
    }

    private JobControl.Response jobAction(JobControl command, Job job) {
        Name name = command.getName();
        Job.Action action = command.getAction();
        boolean force = command.isForce();
        JobControl.Response response = new JobControl.Response(name, action, force);
        Result result = this.checkAccess(name, ACL.Permission.EXECUTE);
        if (!result.wasSuccess()) {
            return response.setResult(result);
        }
        result = response.getResult();
        Status status = this.jobStatusManager.getStatus(name);
        if (action == Job.Action.START) {
            if (status.isActive()) {
                result.setSuccess(false, Localise.format((String)"Job %s is already active", (Object[])new Object[]{name}));
                return response.setResult(result);
            }
        } else if (status.isInactive()) {
            result.setSuccess(false, Localise.format((String)"Job %s is already inactive", (Object[])new Object[]{name}));
            return response.setResult(result);
        }
        switch (job.getMode()) {
            case DISABLED: {
                if (!force) {
                    result.setSuccess(false, Localise.format((String)"Job %s is disabled", (Object[])new Object[]{name}));
                    return response;
                }
                if (!job.canEnable()) {
                    result.setSuccess(false, Localise.format((String)"Job %s is incomplete", (Object[])new Object[]{name}));
                    return response;
                }
            }
            case BYPASS: {
                result = this.checkAccess(name, ACL.Permission.ENABLE);
                if (result.wasSuccess()) break;
                return response.setResult(result);
            }
        }
        switch (this.jobManager.executeJob(name, new Trigger(threadUser.get()), null, action, force, false)) {
            case INITIATED: {
                break;
            }
            case UNSUPPORTED_ACTION: {
                if (action == Job.Action.START) {
                    result.setSuccess(false, Localise.format((String)"Job %s does not support interactive starting", (Object[])new Object[]{name}));
                    break;
                }
                result.setSuccess(false, Localise.format((String)"Job %s does not support interactive stopping", (Object[])new Object[]{name}));
                break;
            }
            case BYPASSED: {
                result.setSuccess(false, Localise.format((String)"Job %s in bypass mode", (Object[])new Object[]{name}));
                break;
            }
            case DISABLED: {
                result.setSuccess(false, Localise.format((String)"Job %s is disabled", (Object[])new Object[]{name}));
                break;
            }
            case MISSED: {
                if (action == Job.Action.START) {
                    result.setSuccess(false, Localise.format((String)"Job %s is already active", (Object[])new Object[]{name}));
                    break;
                }
                result.setSuccess(false, Localise.format((String)"Job %s is already inactive", (Object[])new Object[]{name}));
                break;
            }
            case MISSING_CONDITION: {
                result.setSuccess(false, Localise.format((String)"One or more conditions do not exist for job %s", (Object[])new Object[]{name}));
                break;
            }
            case MISSING_JOB: {
                result.setSuccess(false, Localise.format((String)"Job %s does not exist", (Object[])new Object[]{name}));
                break;
            }
            case WAITING: {
                result.setSuccess(false, Localise.format((String)"One or more conditions not met for job %s", (Object[])new Object[]{name}));
                break;
            }
            case MIRRORED: {
                result.setSuccess(false, Localise.format((String)"Server not master for job %s", (Object[])new Object[]{name}));
                break;
            }
            case LICENSE_EXPIRED: {
                result.setSuccess(false, Localise.format((String)"License has expired"));
                break;
            }
            case LICENSE_LIMITS: {
                result.setSuccess(false, Localise.format((String)"Job execution limit exceeded"));
                break;
            }
            case UNEXPECTED_EXCEPTION: {
                result.setSuccess(false, Localise.format((String)"Unexpected exception"));
            }
        }
        return response;
    }

    private JobControl.Response jobMode(JobControl command, Job job) {
        Name name = command.getName();
        Job.Mode mode = command.getMode();
        JobControl.Response response = new JobControl.Response(name, mode);
        Result result = this.checkAccess(name, ACL.Permission.ENABLE);
        if (!result.wasSuccess()) {
            return response.setResult(result);
        }
        if (this.jobStatusManager.getStatus(name).isActive()) {
            response.getResult().setSuccess(false, Localise.format((String)"Job %s is active", (Object[])new Object[]{name}));
        } else if (job.getMode() == mode) {
            response.getResult().setSuccess(false, Localise.format((String)"Job %1$s mode already %2$s", (Object[])new Object[]{name, mode.toString().toLowerCase()}));
        } else if (mode == Job.Mode.ENABLED && !job.canEnable()) {
            response.getResult().setSuccess(false, job.canEnableReason());
        } else if (this.jobManager.setJobMode(name, mode) != null) {
            this.persistManager.save((NamedMessage)job.setMode(mode), threadConnection.get(), (int)threadChangeGroup.get());
        } else {
            response.getResult().setSuccess(false, Localise.format((String)"Unexpected error setting job %s mode", (Object[])new Object[]{name}));
        }
        return response;
    }

    private LicenseQuery.Response licenseQuery(LicenseQuery query) {
        LicenseQuery.Response response = new LicenseQuery.Response(query);
        if (query.getType() == LicenseQuery.Type.SERVER) {
            License license = this.licenseManager.getServerLicense();
            if (license.isExpired() && license.getType() == License.Type.EVALUATION) {
                license.reset();
            }
            response.setLicense(license);
        } else {
            String userName = query.getUserName();
            if (StringUtils.isNullOrEmpty((String)userName)) {
                userName = threadUser.get().getName();
            } else {
                Result result = this.checkAccess(BlissUtils.ACL_DIR_USERS, ACL.Permission.ADMIN);
                if (!result.wasSuccess()) {
                    return response.setResult(result);
                }
                result = this.checkUserExists(userName);
                if (!result.wasSuccess()) {
                    return response.setResult(result);
                }
            }
            response.setLicense(this.licenseManager.getUserLicense(userName));
        }
        return response;
    }

    private LicenseQuery.Response licenseQueryInstance(LicenseQuery query) {
        LicenseQuery.Response response = new LicenseQuery.Response(query);
        String instance = this.licenseManager.getServerLicense().getInstance();
        response.setInstance(String.format("%1$s:%2$s", StringUtils.isNullOrEmpty((String)instance) ? "0" : instance, this.persistManager.getLastCommitId()));
        return response;
    }

    private LicenseCommand.Response licenseCommand(LicenseCommand command) {
        License serverLicense;
        License license;
        LicenseCommand.Response response = new LicenseCommand.Response(command);
        Result result = this.checkAccess(BlissUtils.ACL_DIR_CONFIGURATION, false, ACL.Permission.WRITE);
        if (!result.wasSuccess()) {
            return response.setResult(result);
        }
        String licenseText = command.getLicense();
        try {
            license = new License(licenseText);
        }
        catch (IOException e) {
            response.getResult().setSuccess(false, Localise.format((String)"Invalid license: %1$s", (Object[])new Object[]{e.getMessage()}));
            return response;
        }
        if (!license.isValid()) {
            response.getResult().setSuccess(false, Localise.format((String)"Invalid license: %1$s", (Object[])new Object[]{license.getReason()}));
            return response;
        }
        try {
            this.licenseManager.validateServerLicense(license);
        }
        catch (Exception e) {
            response.getResult().setSuccess(false, Localise.format((String)"Invalid license: %1$s", (Object[])new Object[]{e.getMessage()}));
            return response;
        }
        boolean loaded = false;
        if (!license.isTestLicense()) {
            result = this.configCommand(new ConfigCommand("beyondcron.license", JSONUtils.toYAML((JSONObject)license.toJSON())), true).getResult();
            this.configCommand(new ConfigCommand("beyondcron.license.expiry.warning", null), true);
            if (result.wasSuccess()) {
                loaded = true;
                if ((Integer)Configs.get((String)"beyondcron.license.expiry.warning") < 1 && !(result = this.configCommand(new ConfigCommand("beyondcron.license.expiry.warning", null), true).getResult()).wasSuccess()) {
                    Localise.logWarn((Logger)logger, (String)"Could not unset %1$s - %2$s", (Object[])new Object[]{"beyondcron.license.expiry.warning", result.getMessage()});
                }
            } else if (!result.getMessage().equals(Localise.format((String)"Property already set to this value"))) {
                return response.setResult(result);
            }
        }
        if ((serverLicense = this.licenseManager.getServerLicense()) != null && serverLicense.getHash().equals(license.getHash())) {
            if (!loaded) {
                response.getResult().setSuccess(false, Localise.format((String)"License is already loaded"));
            }
            return response;
        }
        try {
            this.licenseManager.setServerLicense(license);
        }
        catch (LicenseManager.LicenseException e) {
            response.getResult().setSuccess(false, e.getMessage());
        }
        return response;
    }

    private LimitQuery.Response limitQuery(LimitQuery query) {
        Limit limit;
        LimitQuery.Response response = new LimitQuery.Response(query);
        if (query.getType() == LimitQuery.Type.SERVER) {
            limit = this.licenseManager.getServerLimit();
        } else {
            String userName = query.getUserName();
            if (StringUtils.isNullOrEmpty((String)userName)) {
                userName = threadUser.get().getName();
            } else {
                Result result = this.checkAccess(BlissUtils.ACL_DIR_USERS, ACL.Permission.ADMIN);
                if (!result.wasSuccess()) {
                    return response.setResult(result);
                }
                result = this.checkUserExists(userName);
                if (!result.wasSuccess()) {
                    return response.setResult(result);
                }
            }
            limit = this.licenseManager.getUserLimit(userName);
        }
        response.setLimit(limit);
        return response;
    }

    private LimitReset.Response limitReset(LimitReset command) {
        LimitReset.Response response = new LimitReset.Response();
        Result result = this.checkAccess(BlissUtils.ACL_DIR_USERS, ACL.Permission.ADMIN);
        if (!result.wasSuccess()) {
            return response.setResult(result);
        }
        String userName = command.getUserName();
        if (StringUtils.isNullOrEmpty((String)userName)) {
            userName = threadUser.get().getName();
        }
        if (!(result = this.checkUserExists(userName)).wasSuccess()) {
            return response.setResult(result);
        }
        this.licenseManager.resetExecutionCounter(userName);
        return response;
    }

    private PropertyQuery.Response propertyQuery(PropertyQuery query) {
        PropertyQuery.Response response = new PropertyQuery.Response(query);
        Name name = query.getName();
        Result result = this.checkAccess(name, ACL.Permission.READ);
        if (!result.wasSuccess()) {
            return response.setResult(result);
        }
        List changeIds = query.getChangeIds();
        if (changeIds.isEmpty()) {
            response.addProperties(this.propertyManager.getProperties(name, !query.isNameOnly()));
        } else {
            List<Change> changes = null;
            for (String changeId : changeIds) {
                Matcher m = relativeChangeIdPattern.matcher(changeId);
                if (m.matches()) {
                    if (changes == null) {
                        try {
                            changes = this.getChanges(name, "properties");
                        }
                        catch (Persist.PersistException e) {
                            response.getResult().setSuccess(false, Localise.format((String)"Unexpected error getting property %1$s change ids - %2$s", (Object[])new Object[]{name, e.getMessage()}));
                            break;
                        }
                    }
                    if (changes.isEmpty()) {
                        response.getResult().setSuccess(false, Localise.format((String)"Unknown property %s", (Object[])new Object[]{name}));
                        break;
                    }
                    int i = Math.abs(Integer.parseInt(m.group(1)));
                    if (i < changes.size()) {
                        changeId = changes.get(i).getId();
                    } else {
                        response.getResult().setSuccess(false, Localise.format((String)"Property %1$s change %2$s does not exist", (Object[])new Object[]{name, changeId}));
                        break;
                    }
                }
                try {
                    PropertyList properties = (PropertyList)this.persistManager.getMessage(name, "properties", changeId);
                    response.addProperties(properties != null ? properties.getValues() : new ArrayList());
                    response.addChangeId(changeId);
                }
                catch (Persist.PersistUnknownCommitException e) {
                    response.getResult().setSuccess(false, Localise.format((String)"Unknown change - %s", (Object[])new Object[]{changeId}));
                    break;
                }
                catch (Persist.PersistException e) {
                    response.getResult().setSuccess(false, Localise.format((String)"Unexpected error getting property %1$s (%2$s) - %3$s", (Object[])new Object[]{name, changeId, e.getMessage()}));
                    break;
                }
            }
        }
        return response;
    }

    private PersistCommand.Response persistCommand(PersistCommand command) {
        this.persistManager.commit(command, threadConnection.get());
        return new PersistCommand.Response(command);
    }

    private PropertyCommand.Response propertyCommand(PropertyCommand command) {
        PropertyCommand.Response response = new PropertyCommand.Response(command);
        Name group = command.getGroup();
        if (group == null) {
            return response.setResult(new Result(false, Localise.format((String)"Group undefined"), new Link[0]));
        }
        Result result = this.checkAccess(group, ACL.Permission.WRITE);
        if (!result.wasSuccess()) {
            return response.setResult(result);
        }
        for (Property property : command.getProperties()) {
            if (group.equals((Object)property.getGroup())) continue;
            Name propertyGroup = property.getGroup();
            if (propertyGroup != null) {
                return response.setResult(new Result(false, Localise.format((String)"Property (%1$s) group (%2$s) is not equal to %3$s", (Object[])new Object[]{property.getName(), property.getGroup().toString(), group.toString()}), new Link[0]));
            }
            return response.setResult(new Result(false, Localise.format((String)"Property (%1$s) group is undefined", (Object[])new Object[]{property.getName()}), new Link[0]));
        }
        switch (command.getAction()) {
            case SET: {
                response.setResult(this.propertySet(group, command.getProperties(), false));
                break;
            }
            case REPLACE: {
                response.setResult(this.propertySet(group, command.getProperties(), true));
                break;
            }
            case DELETE: {
                response.setResult(this.propertyDelete(group, command.getProperties()));
            }
        }
        return response;
    }

    private Result propertySet(Name group, List<Property> properties, boolean replace) {
        String message = this.dataManager.canCreateGroup(group);
        if (message != null) {
            return new Result(false, message, new Link[0]);
        }
        HashSet<String> currentNames = new HashSet<String>();
        if (replace) {
            for (Property property : this.propertyManager.getProperties(group)) {
                currentNames.add(property.getName());
            }
        }
        boolean changed = false;
        for (Property property : properties) {
            if (this.propertyManager.setProperty(property) && !changed) {
                changed = true;
            }
            currentNames.remove(property.getName());
        }
        if (!currentNames.isEmpty()) {
            for (Property property : this.propertyManager.getProperties(group)) {
                if (!currentNames.contains(property.getName()) || !this.propertyManager.deleteProperty(property) || changed) continue;
                changed = true;
            }
        }
        if (changed) {
            this.propertyPersist(group);
        }
        return new Result();
    }

    private Result propertyDelete(Name group, List<Property> properties) {
        ArrayList<Property> props = new ArrayList<Property>();
        if (properties.isEmpty()) {
            props.addAll(this.propertyManager.getProperties(group));
            if (props.isEmpty()) {
                return new Result(false, Localise.format((String)"Properties %1$s does not exist", (Object[])new Object[]{group}), new Link[0]);
            }
        } else {
            props.addAll(properties);
        }
        boolean changed = false;
        for (Property prop : props) {
            if (!this.propertyManager.deleteProperty(prop) || changed) continue;
            changed = true;
        }
        if (changed) {
            this.propertyPersist(group);
        }
        return new Result();
    }

    private void propertyPersist(Name group) {
        PropertyList values = new PropertyList(group, this.propertyManager.getProperties(group));
        if (values.isEmpty()) {
            this.persistManager.remove((PersistMessage)values, threadConnection.get(), (int)threadChangeGroup.get());
        } else {
            this.persistManager.save((PersistMessage)values, threadConnection.get(), (int)threadChangeGroup.get());
        }
    }

    private ProtectedQuery.Response protectedQuery(ProtectedQuery query) {
        ProtectedQuery.Response response = new ProtectedQuery.Response(query);
        Result result = this.checkAccess(BlissUtils.ACL_DIR_PROTECTED, ACL.Permission.READ);
        if (!result.wasSuccess()) {
            return response.setResult(result);
        }
        Protected.Type type = query.getType();
        List changeIds = query.getChangeIds();
        if (changeIds.isEmpty()) {
            this.hostAclManager.getProtected(query.getType());
            response.addValues(this.hostAclManager.getProtected(type));
        } else {
            Name name = ProtectedList.getPersistName((Protected.Type)type);
            List<Change> changes = null;
            for (String changeId : changeIds) {
                Matcher m = relativeChangeIdPattern.matcher(changeId);
                if (m.matches()) {
                    int i;
                    if (changes == null) {
                        try {
                            changes = this.getChanges(name, "acls");
                        }
                        catch (Persist.PersistException e) {
                            response.getResult().setSuccess(false, Localise.format((String)"Unexpected error getting protected %1$s change ids - %2$s", (Object[])new Object[]{type.getLabel(), e.getMessage()}));
                            break;
                        }
                    }
                    if ((i = Math.abs(Integer.parseInt(m.group(1)))) < changes.size()) {
                        changeId = changes.get(i).getId();
                    } else {
                        response.getResult().setSuccess(false, Localise.format((String)"Protected %1$s change %2$s does not exist", (Object[])new Object[]{type.getLabel(), changeId}));
                        break;
                    }
                }
                try {
                    response.addValues((Collection)((ProtectedList)this.persistManager.getMessage(name, "acls", changeId)).getValues());
                    response.addChangeId(changeId);
                }
                catch (Persist.PersistUnknownCommitException e) {
                    response.getResult().setSuccess(false, Localise.format((String)"Unknown change - %s", (Object[])new Object[]{changeId}));
                    break;
                }
                catch (Persist.PersistException e) {
                    response.getResult().setSuccess(false, Localise.format((String)"Unexpected error getting protected %1$s (%2$s) - %3$s", (Object[])new Object[]{type.getLabel(), changeId, e.getMessage()}));
                    break;
                }
            }
        }
        return response;
    }

    private ProtectedCommand.Response protectedCommand(ProtectedCommand command) {
        ProtectedCommand.Response response = new ProtectedCommand.Response(command);
        Protected.Type type = command.getType();
        Result result = this.checkAccess(BlissUtils.ACL_DIR_PROTECTED, ACL.Permission.ADMIN);
        if (!result.wasSuccess()) {
            return response.setResult(result);
        }
        Protected name = new Protected(type, command.getValue());
        if (command.getAction() == ProtectedCommand.Action.ADD) {
            if (this.hostAclManager.setProtected(name)) {
                this.protectedPersist(type);
            }
        } else if (this.hostAclManager.deleteProtected(name)) {
            this.protectedPersist(type);
        }
        return response;
    }

    private void protectedPersist(Protected.Type type) {
        ProtectedList values = new ProtectedList(type, this.hostAclManager.getProtected(type));
        if (values.isEmpty()) {
            this.persistManager.remove((PersistMessage)values, threadConnection.get(), (int)threadChangeGroup.get());
        } else {
            this.persistManager.save((PersistMessage)values, threadConnection.get(), (int)threadChangeGroup.get());
        }
    }

    private QueueQuery.Response queueQuery(QueueQuery query) {
        QueueQuery.Response response = new QueueQuery.Response();
        Filter filter = query.getFilter();
        for (IQueue queue : QueueManager.getInstance(this.hazelcast).getQueues()) {
            if (!filter.matches(queue.getName())) continue;
            response.addQueue(new Queue(queue));
        }
        return response;
    }

    private QueueCommand.Response queueCommand(QueueCommand command) {
        QueueCommand.Response response = new QueueCommand.Response(command);
        Result result = this.checkAccess(BlissUtils.ACL_DIR_QUEUES, ACL.Permission.ADMIN, ACL.Permission.WRITE);
        if (!result.wasSuccess()) {
            return response.setResult(result);
        }
        IQueue queue = QueueManager.getInstance(this.hazelcast).getQueue(command.getName());
        if (queue == null) {
            return response.setResult(new Result(false, Localise.format((String)"Queue %s does not exist", (Object[])new Object[]{command.getName()}), new Link[0]));
        }
        switch (command.getAction()) {
            case DELETE: {
                queue.destroy();
                break;
            }
            case FLUSH: {
                queue.clear();
            }
        }
        return response;
    }

    private RoleQuery.Response roleQuery(RoleQuery query) {
        RoleQuery.Response response = new RoleQuery.Response();
        Result result = this.checkAccess(BlissUtils.ACL_DIR_ROLES, ACL.Permission.READ);
        if (!result.wasSuccess()) {
            return response.setResult(result);
        }
        Filter filter = query.getFilter();
        for (Role role : this.userManager.getRoles(filter)) {
            response.addRole(role);
        }
        if (response.isEmpty() && query.includeUsers() && filter.getType() == Filter.Type.EXACT && this.userManager.isUser(query.getFilter().getPattern())) {
            response.addRole(new Role(filter.getPattern()));
        }
        return response;
    }

    private RoleCommand.Response roleCommand(RoleCommand command) {
        RoleCommand.Response response = new RoleCommand.Response(command);
        Result result = this.checkAccess(BlissUtils.ACL_DIR_ROLES, ACL.Permission.ADMIN);
        if (!result.wasSuccess()) {
            return response.setResult(result);
        }
        if (this.userManager.hasUserService()) {
            result.setSuccess(false, Localise.format((String)"Remote roles cannot be %1$sd", (Object[])new Object[]{command.getAction().toString().toLowerCase()}));
            return response.setResult(result);
        }
        switch (command.getAction()) {
            case CREATE: {
                response.setResult(this.roleAdd(command.getRole()));
                break;
            }
            case UPDATE: {
                response.setResult(this.roleUpdate(command.getRole()));
                break;
            }
            case DELETE: {
                response.setResult(this.roleDelete(command.getName()));
            }
        }
        return response;
    }

    private Result roleAdd(Role role) {
        String name = role.getName();
        Result result = new Result();
        if (this.userManager.isRole(name)) {
            result.setSuccess(false, Localise.format((String)"Role %s already exists", (Object[])new Object[]{name}));
            return result;
        }
        try {
            this.userManager.setRole(role);
            this.persistManager.save(Name.parse((Name)BlissUtils.ACL_DIR_ROLES, (String[])new String[]{name}), (Message)role, threadConnection.get(), threadChangeGroup.get());
        }
        catch (UserManager.SecurityManagerException | IllegalStateException e) {
            Localise.logWarn((Logger)logger, (String)"Error creating role %1$s - %2$s", (Object[])new Object[]{name, e.getMessage()});
            result.setSuccess(false, e.getMessage());
        }
        return result;
    }

    private Result roleDelete(String name) {
        Role role;
        Result result = new Result();
        if (!this.userManager.isRole(name)) {
            result.setSuccess(false, Localise.format((String)"Role %s does not exist", (Object[])new Object[]{name}));
            return result;
        }
        try {
            role = this.userManager.deleteRole(name);
        }
        catch (UserManager.SecurityManagerException e) {
            Localise.logWarn((Logger)logger, (String)"Error deleting role %1$s - {%2$s", (Object[])new Object[]{name, e.getMessage()});
            result.setSuccess(false, e.getMessage());
            return result;
        }
        if (role != null) {
            try {
                this.persistManager.remove(Name.parse((Name)BlissUtils.ACL_DIR_ROLES, (String[])new String[]{name}), (Message)role, threadConnection.get(), threadChangeGroup.get());
            }
            catch (IllegalStateException e) {
                Localise.logWarn((Logger)logger, (String)"Error persisting deletion of role %1$s - %2$s", (Object[])new Object[]{name, e.getMessage()});
                result.setSuccess(false, e.getMessage());
            }
        }
        return result;
    }

    private Result roleUpdate(Role role) {
        String name = role.getName();
        Result result = new Result();
        if (!this.userManager.isRole(name)) {
            result.setSuccess(false, Localise.format((String)"Role %s does not exist exist", (Object[])new Object[]{name}));
            return result;
        }
        try {
            this.userManager.setRole(role);
            this.persistManager.save(Name.parse((Name)BlissUtils.ACL_DIR_ROLES, (String[])new String[]{name}), (Message)role, threadConnection.get(), threadChangeGroup.get());
        }
        catch (UserManager.SecurityManagerException | IllegalStateException e) {
            Localise.logWarn((Logger)logger, (String)"Error updating role %1$s - %2$s", (Object[])new Object[]{name, e.getMessage()});
            result.setSuccess(false, e.getMessage());
        }
        return result;
    }

    private TopicQuery.Response topicQuery(TopicQuery query) {
        TopicQuery.Response response = new TopicQuery.Response();
        Filter filter = query.getFilter();
        for (ITopic topic : TopicManager.getInstance(this.hazelcast).getTopics()) {
            if (!filter.matches(topic.getName())) continue;
            response.addTopic(new Topic(topic));
        }
        return response;
    }

    private UserQuery.Response userQuery(UserQuery query) {
        Result result;
        UserQuery.Response response = new UserQuery.Response();
        Filter filter = query.getFilter();
        if (!(filter.getType() == Filter.Type.EXACT && filter.matches(threadUser.get().getName()) || (result = this.checkAccess(BlissUtils.ACL_DIR_USERS, ACL.Permission.READ)).wasSuccess())) {
            return response.setResult(result);
        }
        for (User user : this.userManager.getUsers(query.getFilter())) {
            response.addUser(user);
        }
        return response;
    }

    private UserRefresh.Response userRefresh(UserRefresh command) {
        UserRefresh.Response response = new UserRefresh.Response();
        String name = command.getName();
        if (StringUtils.isNullOrEmpty((String)name)) {
            name = threadUser.get().getName();
        } else {
            Result result = this.checkAccess(BlissUtils.ACL_DIR_USERS, ACL.Permission.ADMIN);
            if (!result.wasSuccess()) {
                return response.setResult(result);
            }
        }
        User user = this.userManager.getUser(name, true);
        if (user == null) {
            return response.setResult(new Result(false, Localise.format((String)"User does not exist"), new Link[0]));
        }
        response.setUser(user);
        this.licenseManager.refreshUser(user);
        return response;
    }

    private UserCommand.Response userCommand(UserCommand command) {
        UserCommand.Response response = new UserCommand.Response(command);
        Result result = this.checkAccess(BlissUtils.ACL_DIR_USERS, ACL.Permission.ADMIN);
        if (!result.wasSuccess()) {
            return response.setResult(result);
        }
        if (this.userManager.hasUserService()) {
            result.setSuccess(false, Localise.format((String)"Remote users cannot be %sd", (Object[])new Object[]{command.getAction().toString().toLowerCase()}));
            return response.setResult(result);
        }
        switch (command.getAction()) {
            case CREATE: {
                response.setResult(this.userCreate(command.getUser()));
                break;
            }
            case UPDATE: {
                response.setResult(this.userUpdate(command.getUser(), command.isUpdatePassword()));
                break;
            }
            case DELETE: {
                response.setResult(this.userDelete(command.getName()));
            }
        }
        return response;
    }

    private Result userCreate(User user) {
        String name = user.getName();
        Result result = new Result();
        if (this.userManager.isUser(name)) {
            result.setSuccess(false, Localise.format((String)"User %s already exists", (Object[])new Object[]{name}));
            return result;
        }
        try {
            this.userManager.setUser(user);
            this.persistManager.save(Name.parse((Name)BlissUtils.ACL_DIR_USERS, (String[])new String[]{name}), (Message)user, threadConnection.get(), threadChangeGroup.get());
        }
        catch (UserManager.SecurityManagerException | IllegalStateException e) {
            Localise.logWarn((Logger)logger, (String)"Error creating user %1$s - %2$s", (Object[])new Object[]{name, e.getMessage()});
            result.setSuccess(false, e.getMessage());
        }
        return result;
    }

    private Result userUpdate(User user, boolean updatePassword) {
        String name = user.getName();
        Result result = this.checkUserExists(name);
        if (!result.wasSuccess()) {
            return result;
        }
        if (!updatePassword) {
            user.setPassword(this.userManager.getUser(name));
        }
        try {
            this.userManager.setUser(user);
            this.persistManager.save(Name.parse((Name)BlissUtils.ACL_DIR_USERS, (String[])new String[]{name}), (Message)user, threadConnection.get(), threadChangeGroup.get());
        }
        catch (UserManager.SecurityManagerException | IllegalStateException e) {
            Localise.logWarn((Logger)logger, (String)"Error updating user %1$s - %2$s", (Object[])new Object[]{name, e.getMessage()});
            return result.setSuccess(false, e.getMessage());
        }
        return new Result();
    }

    private Result userDelete(String name) {
        User user;
        Result result = this.checkUserExists(name);
        if (!result.wasSuccess()) {
            return result;
        }
        try {
            user = this.userManager.deleteUser(name);
        }
        catch (UserManager.SecurityManagerException e) {
            Localise.logWarn((Logger)logger, (String)"Error deleting user %1$s - %2$s", (Object[])new Object[]{name, e.getMessage()});
            return result.setSuccess(false, e.getMessage());
        }
        if (user != null) {
            try {
                this.persistManager.remove(Name.parse((Name)BlissUtils.ACL_DIR_USERS, (String[])new String[]{name}), (Message)user, threadConnection.get(), threadChangeGroup.get());
            }
            catch (IllegalStateException e) {
                Localise.logWarn((Logger)logger, (String)"Error persisting deletion of user %1$s - %2$s", (Object[])new Object[]{name, e.getMessage()});
                return result.setSuccess(false, e.getMessage());
            }
        }
        return new Result();
    }

    private UserPassword.Response userPassword(UserPassword command) {
        Result result;
        UserPassword.Response response = new UserPassword.Response(command);
        String name = command.getName();
        User user = threadUser.get();
        if (!user.getName().equals(name) && !(result = this.checkAccess(BlissUtils.ACL_DIR_USERS, ACL.Permission.ADMIN)).wasSuccess()) {
            return response.setResult(result);
        }
        if (this.userManager.hasUserService()) {
            response.getResult().setSuccess(false, Localise.format((String)"Cannot change password of remote users"));
            return response;
        }
        user = this.userManager.getUser(name);
        if (user == null) {
            response.getResult().setSuccess(false, Localise.format((String)"User %s does not exist", (Object[])new Object[]{name}));
            return response;
        }
        String password = command.getPassword();
        if (StringUtils.isNullOrEmpty((String)password)) {
            response.getResult().setSuccess(false, Localise.format((String)"Empty password", (Object[])new Object[]{name}));
            return response;
        }
        user.setPassword(command.getPassword());
        try {
            this.userManager.setUser(user);
            this.persistManager.save(Name.parse((Name)BlissUtils.ACL_DIR_USERS, (String[])new String[]{name}), (Message)user, threadConnection.get(), threadChangeGroup.get());
        }
        catch (UserManager.SecurityManagerException | IllegalStateException e) {
            Localise.logWarn((Logger)logger, (String)"Error updating user %1$s - %2$s", (Object[])new Object[]{name, e.getMessage()});
            response.getResult().setSuccess(false, e.getMessage());
        }
        return response;
    }

    private HostACLQuery.Response hostACLQuery(HostACLQuery query) {
        HostACLQuery.Response response = new HostACLQuery.Response();
        Result result = this.checkAccess(BlissUtils.ACL_DIR_HOST_ACLS, ACL.Permission.READ);
        if (!result.wasSuccess()) {
            return response.setResult(result);
        }
        List changeIds = query.getChangeIds();
        String userRole = query.getUserRole();
        if (!StringUtils.isNullOrEmpty((String)userRole)) {
            User user = this.userManager.getUser(userRole);
            if (user != null) {
                response.addValues(this.hostAclManager.getACLs(user));
            } else {
                response.addValues(this.hostAclManager.getACLs(userRole));
            }
        } else if (changeIds.isEmpty()) {
            response.addValues(this.hostAclManager.getACLs());
        } else {
            Name name = new HostACLList(null).getPersistName();
            List<Change> changes = null;
            for (String changeId : changeIds) {
                Matcher m = relativeChangeIdPattern.matcher(changeId);
                if (m.matches()) {
                    int i;
                    if (changes == null) {
                        try {
                            changes = this.getChanges(name, "acls");
                        }
                        catch (Persist.PersistException e) {
                            response.getResult().setSuccess(false, Localise.format((String)"Unexpected error getting host acl change ids - %1$s", (Object[])new Object[]{e.getMessage()}));
                            break;
                        }
                    }
                    if ((i = Math.abs(Integer.parseInt(m.group(1)))) < changes.size()) {
                        changeId = changes.get(i).getId();
                    } else {
                        response.getResult().setSuccess(false, Localise.format((String)"Host acl change %1$s does not exist", (Object[])new Object[]{changeId}));
                        break;
                    }
                }
                try {
                    response.addValues((Collection)((HostACLList)this.persistManager.getMessage(name, "acls", changeId)).getValues());
                    response.addChangeId(changeId);
                }
                catch (Persist.PersistUnknownCommitException e) {
                    response.getResult().setSuccess(false, Localise.format((String)"Unknown change - %s", (Object[])new Object[]{changeId}));
                    break;
                }
                catch (Persist.PersistException e) {
                    response.getResult().setSuccess(false, Localise.format((String)"Unexpected error getting host acl (%1$s) - %2$s", (Object[])new Object[]{changeId, e.getMessage()}));
                    break;
                }
            }
        }
        return response;
    }

    private HostACLCommand.Response hostACLCommand(HostACLCommand command) {
        HostACLCommand.Response response = new HostACLCommand.Response(command);
        Result result = this.checkAccess(BlissUtils.ACL_DIR_HOST_ACLS, ACL.Permission.ADMIN);
        if (!result.wasSuccess()) {
            return response.setResult(result);
        }
        switch (command.getAction()) {
            case SET: {
                response.setResult(this.hostAclSet(command.getACL()));
                break;
            }
            case DELETE: {
                response.setResult(this.hostAclDelete(command.getACL(), command.getUserRole()));
            }
        }
        return response;
    }

    private Result hostAclSet(HostACL acl) {
        if (acl == null) {
            return new Result(false, Localise.format((String)"Host ACL cannot be null"), new Link[0]);
        }
        if (this.hostAclManager.setACL(acl)) {
            this.hostAclPersist();
        }
        return new Result();
    }

    private Result hostAclDelete(HostACL acl, String userRole) {
        ArrayList<HostACL> acls = new ArrayList<HostACL>();
        if (acl != null) {
            acls.add(acl);
        } else if (!StringUtils.isNullOrEmpty((String)userRole)) {
            acls.addAll(this.hostAclManager.getACLs(userRole));
            if (acls.isEmpty()) {
                return new Result(false, Localise.format((String)"User/role %s has no host ACLs", (Object[])new Object[]{userRole}), new Link[0]);
            }
        } else {
            return new Result(false, Localise.format((String)"Neither ACL or user/role defined"), new Link[0]);
        }
        for (HostACL a : acls) {
            if (!this.hostAclManager.deleteACL(a)) continue;
            this.hostAclPersist();
        }
        return new Result();
    }

    private void hostAclPersist() {
        HostACLList values = new HostACLList(this.hostAclManager.getACLs());
        if (values.isEmpty()) {
            this.persistManager.remove((PersistMessage)values, threadConnection.get(), (int)threadChangeGroup.get());
        } else {
            this.persistManager.save((PersistMessage)values, threadConnection.get(), (int)threadChangeGroup.get());
        }
    }

    private ServiceQuery.Response serviceQuery(ServiceQuery query) {
        ServiceQuery.Response response = new ServiceQuery.Response(query);
        Result result = this.checkAccess(BlissUtils.ACL_DIR_SERVICES, ACL.Permission.READ);
        if (!result.wasSuccess()) {
            return response.setResult(result);
        }
        StatusService service = null;
        switch (query.getType()) {
            case STATUS: {
                service = this.jobStatusManager.getStatusService();
                break;
            }
            case USER: {
                service = this.userManager.getUserService();
            }
        }
        if (service != null) {
            response.setName(service.getServiceName());
            response.setDescription(service.getServiceDescription());
            response.setConnected(service.getConnected());
            if (!service.isConnected()) {
                response.setMessage(service.getConnectionMessage());
            }
        }
        return response;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ServiceCommand.Response serviceCommand(ServiceCommand command) {
        ServiceCommand.Response response = new ServiceCommand.Response(command);
        Result result = this.checkAccess(BlissUtils.ACL_DIR_SERVICES, ACL.Permission.ADMIN);
        if (!result.wasSuccess()) {
            return response.setResult(result);
        }
        switch (command.getType()) {
            case STATUS: {
                if (command.getAction() == ServiceCommand.Action.RELOAD) {
                    String s;
                    try {
                        this.jobStatusManager.reloadService();
                    }
                    catch (ServiceException e) {
                        result.setSuccess(false, e.getMessage());
                        return response.setResult(result);
                    }
                    StatusService statusService = this.jobStatusManager.getStatusService();
                    if (statusService == null || statusService.isConnected() || StringUtils.isNullOrEmpty((String)(s = statusService.getConnectionMessage()))) return response;
                    result.setSuccess(false, s);
                    return response.setResult(result);
                }
                result.setSuccess(false, Localise.format((String)"Unsupported acrtion - %1$s", (Object[])new Object[]{command.getAction().getLabel().toLowerCase()}));
                return response.setResult(result);
            }
            case USER: {
                try {
                    if (command.getAction() == ServiceCommand.Action.REFRESH) {
                        if (!this.userManager.hasUserService()) {
                            result.setSuccess(false, Localise.format((String)"No user service configured"));
                            return response.setResult(result);
                        }
                        this.userManager.refreshService();
                        return response;
                    }
                    if (command.getAction() == ServiceCommand.Action.RELOAD) {
                        String s;
                        this.userManager.reloadService();
                        UserService userService = this.userManager.getUserService();
                        if (userService == null || userService.isConnected() || StringUtils.isNullOrEmpty((String)(s = userService.getConnectionMessage()))) return response;
                        result.setSuccess(false, s);
                        return response.setResult(result);
                    }
                    result.setSuccess(false, Localise.format((String)"Unsupported action - %1$s", (Object[])new Object[]{command.getAction().getLabel().toLowerCase()}));
                    return response.setResult(result);
                }
                catch (ServiceException e) {
                    result.setSuccess(false, e.getMessage());
                    return response.setResult(result);
                }
            }
        }
        return response;
    }

    private Result checkAccess(Name name, ACL.Permission ... permissions) {
        return this.checkAccess(name, true, permissions);
    }

    private Result checkAccess(Name name, boolean validateLicense, ACL.Permission ... permissions) {
        User user = threadUser.get();
        if (validateLicense) {
            try {
                this.licenseManager.validateLicense(user);
            }
            catch (LicenseManager.LicenseException e) {
                if (e.isExpired()) {
                    ACL.Permission[] permissionArray = permissions;
                    int n = permissionArray.length;
                    for (int i = 0; i < n; ++i) {
                        ACL.Permission permission = permissionArray[i];
                        if (permission == ACL.Permission.ADMIN || permission == ACL.Permission.WRITE) {
                            return new Result(false, Localise.format((String)"%s license expired on %s, configuration changes are not permitted", (Object[])new Object[]{StringUtils.capitalise((Object)((Object)e.getType())), e.getExpiry()}), new Link[0]);
                        }
                        if (permission != ACL.Permission.EXECUTE || e.getType() != LicenseManager.AbstractException.Type.USER) continue;
                        return new Result(false, Localise.format((String)"%s license expired on %s, execution/refresh is not permitted", (Object[])new Object[]{StringUtils.capitalise((Object)((Object)e.getType())), e.getExpiry()}), new Link[0]);
                    }
                }
                return new Result(false, Localise.format((String)"Invalid %s license", (Object[])new Object[]{e.getType().toString().toLowerCase()}), new Link[0]);
            }
        }
        for (ACL.Permission permission : permissions) {
            if (this.aclManager.hasPermission(user, permission, name)) continue;
            return new Result(false, Localise.format((String)"User %s does not have %s access to %s", (Object[])new Object[]{user.getName(), permission.toString().toLowerCase(), name}), new Link[0]);
        }
        return new Result();
    }

    private Result checkAccess(String userName, String hostName) {
        Result result = null;
        if (!StringUtils.isNullOrEmpty((String)userName)) {
            if (!StringUtils.isNullOrEmpty((String)hostName)) {
                if (!this.hostAclManager.hasPermission(threadUser.get(), userName, hostName)) {
                    result = new Result(false, Localise.format((String)"Insufficient permission to execute jobs as %1$s on %2$s", (Object[])new Object[]{userName, hostName}), new Link[0]);
                }
            } else if (!this.hostAclManager.hasUserPermission(threadUser.get(), userName)) {
                result = new Result(false, Localise.format((String)"Insufficient permission to execute jobs as %s", (Object[])new Object[]{userName}), new Link[0]);
            }
        } else if (!StringUtils.isNullOrEmpty((String)hostName) && !this.hostAclManager.hasHostPermission(threadUser.get(), hostName)) {
            result = new Result(false, Localise.format((String)"Insufficient permission to execute jobs on %s", (Object[])new Object[]{hostName}), new Link[0]);
        }
        if (result != null) {
            result.addReference(new Link(Link.Type.MANPAGE, "/docs/commands/host/acl.html", "host acl overview"));
        }
        return result != null ? result : new Result();
    }

    private Result checkUserExists(String name) {
        if (!this.userManager.isUser(name)) {
            return new Result(false, Localise.format((String)"User %s does not exist", (Object[])new Object[]{name}), new Link[0]);
        }
        return new Result();
    }

    private List<Change> getChanges(Name name, String tag) throws Persist.PersistException {
        ArrayList<Change> changes = new ArrayList<Change>();
        for (Change change : this.persistManager.getHistory(name, tag)) {
            if (change.getAction() == Change.Action.REMOVED) continue;
            changes.add(change);
        }
        return changes;
    }

    static class ServerInfo
    implements Callable<String>,
    HazelcastInstanceAware,
    Serializable {
        private transient HazelcastInstance hazelcast;

        ServerInfo() {
        }

        @Override
        public String call() {
            return new com.beyondcron.server.ServerInfo(this.hazelcast).toJSON().toString();
        }

        public void setHazelcastInstance(HazelcastInstance hazelcast) {
            this.hazelcast = hazelcast;
        }
    }
}

