/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.server;

import com.beyondcron.core.Localise;
import com.beyondcron.core.Name;
import com.beyondcron.core.Property;
import com.beyondcron.core.job.Job;
import com.beyondcron.core.security.ACL;
import com.beyondcron.messaging.Hazelcast;
import com.beyondcron.messaging.message.calendar.Calendar;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.MultiMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DataManager {
    private static final Map<String, DataManager> managers = new HashMap<String, DataManager>();
    private final MultiMap<Name, Name> groups;
    private final MultiMap<Name, ACL> acls;
    private final MultiMap<Name, Name> aclGroups;
    private final IMap<Name, Calendar> calendars;
    private final MultiMap<Name, Name> calendarGroups;
    private final IMap<Name, Job> jobs;
    private final MultiMap<Name, Name> jobGroups;
    private final MultiMap<Name, Property> properties;
    private final MultiMap<Name, Name> propertyGroups;

    public static synchronized DataManager getInstance(HazelcastInstance hazelcast) {
        String name = hazelcast.getName();
        DataManager manager = managers.get(name);
        if (manager == null) {
            manager = new DataManager(hazelcast);
            managers.put(name, manager);
        }
        return manager;
    }

    private DataManager(HazelcastInstance hazelcast) {
        this.groups = Hazelcast.getGroupTreeMap((HazelcastInstance)hazelcast);
        this.acls = Hazelcast.getACLMap((HazelcastInstance)hazelcast);
        this.aclGroups = Hazelcast.getACLGroupMap((HazelcastInstance)hazelcast);
        this.calendars = Hazelcast.getCalendarMap((HazelcastInstance)hazelcast);
        this.calendarGroups = Hazelcast.getCalendarGroupMap((HazelcastInstance)hazelcast);
        this.jobs = Hazelcast.getJobMap((HazelcastInstance)hazelcast);
        this.jobGroups = Hazelcast.getJobGroupMap((HazelcastInstance)hazelcast);
        this.properties = Hazelcast.getPropertyMap((HazelcastInstance)hazelcast);
        this.propertyGroups = Hazelcast.getPropertyGroupMap((HazelcastInstance)hazelcast);
    }

    public String canCreate(Name name) {
        if (this.jobs.containsKey((Object)name) || this.calendars.containsKey((Object)name) || this.groups.containsKey((Object)name) || this.jobGroups.containsKey((Object)name) || this.calendarGroups.containsKey((Object)name)) {
            return Localise.format((String)"%s already exists", (Object[])new Object[]{name});
        }
        return this.canCreateGroup(name.getGroup());
    }

    public String canCreateGroup(Name group) {
        if (group != null && (this.jobs.containsKey((Object)group) || this.calendars.containsKey((Object)group))) {
            return Localise.format((String)"%s is not a group", (Object[])new Object[]{group});
        }
        return null;
    }

    public boolean isGroup(Name name) {
        if (this.groups.containsKey((Object)name) || this.jobGroups.containsKey((Object)name) || this.propertyGroups.containsKey((Object)name) || this.aclGroups.containsKey((Object)name) || this.calendarGroups.containsKey((Object)name)) {
            return true;
        }
        return !this.jobs.containsKey((Object)name) && !this.calendars.containsKey((Object)name) && (this.acls.containsKey((Object)name) || this.properties.containsKey((Object)name));
    }

    public boolean isGroupEmtpy(Name name) {
        return !this.groups.containsKey((Object)name) && !this.jobGroups.containsKey((Object)name) && !this.propertyGroups.containsKey((Object)name) && !this.aclGroups.containsKey((Object)name) && !this.calendarGroups.containsKey((Object)name);
    }

    public MultiMap<Name, Name> getGroups() {
        return this.groups;
    }

    public boolean addACL(ACL acl) {
        Name name = acl.getName();
        ACL previousAcl = this.getACL(name, acl.getUserRole());
        boolean added = this.acls.put((Object)name, (Object)acl);
        if (added) {
            this.addGroup(this.aclGroups, name);
            if (previousAcl != null) {
                this.acls.remove((Object)name, (Object)previousAcl);
            }
        }
        return added;
    }

    public ACL getACL(Name name, String userRole) {
        for (ACL acl : this.acls.get((Object)name)) {
            if (!acl.getUserRole().equals(userRole)) continue;
            return acl;
        }
        return null;
    }

    public boolean removeACL(ACL acl) {
        boolean removed = false;
        Name name = acl.getName();
        String userRole = acl.getUserRole();
        for (ACL a : this.acls.get((Object)name)) {
            if (!a.getUserRole().equals(userRole)) continue;
            removed = this.acls.remove((Object)name, (Object)a);
            break;
        }
        if (removed) {
            this.removeGroup(this.aclGroups, name);
        }
        return removed;
    }

    public MultiMap<Name, ACL> getACLs() {
        return this.acls;
    }

    public void addCalendar(Calendar calendar) {
        Name name = calendar.getName();
        if (this.calendars.put((Object)name, (Object)calendar) == null) {
            this.addGroup(this.calendarGroups, name);
        }
    }

    public Calendar getCalendar(Name name) {
        return (Calendar)this.calendars.get((Object)name);
    }

    public void removeCalendar(Name name) {
        if (this.calendars.remove((Object)name) != null) {
            this.removeGroup(this.calendarGroups, name);
        }
    }

    public IMap<Name, Calendar> getCalendars() {
        return this.calendars;
    }

    public Set<Name> getCalendars(Name group) {
        Collection children;
        HashSet<Name> values = new HashSet<Name>();
        if (this.calendarGroups.containsKey((Object)group)) {
            values.addAll(this.calendarGroups.get((Object)group));
        }
        if ((children = this.groups.get((Object)group)) != null) {
            for (Name child : children) {
                values.addAll(this.getCalendars(child));
            }
        }
        return values;
    }

    public MultiMap<Name, Name> getCalendarGroups() {
        return this.calendarGroups;
    }

    public void addJob(Job job) {
        Name name = job.getName();
        if (this.jobs.put((Object)name, (Object)job) == null) {
            this.addGroup(this.jobGroups, name);
        }
    }

    public Job getJob(Name name) {
        return (Job)this.jobs.get((Object)name);
    }

    public void removeJob(Name name) {
        if (this.jobs.remove((Object)name) != null) {
            this.removeGroup(this.jobGroups, name);
        }
    }

    public IMap<Name, Job> getJobs() {
        return this.jobs;
    }

    public Set<Name> getJobs(Name group) {
        Collection children;
        HashSet<Name> values = new HashSet<Name>();
        if (this.jobGroups.containsKey((Object)group)) {
            values.addAll(this.jobGroups.get((Object)group));
        }
        if ((children = this.groups.get((Object)group)) != null) {
            for (Name child : children) {
                values.addAll(this.getJobs(child));
            }
        }
        return values;
    }

    public MultiMap<Name, Name> getJobGroups() {
        return this.jobGroups;
    }

    public boolean addProperty(Property property) {
        boolean addGroup;
        Name group = property.getGroup();
        if (group == null) {
            return false;
        }
        boolean bl = addGroup = !this.properties.containsKey((Object)group);
        if (!addGroup) {
            String name = property.getName();
            for (Property p : this.properties.get((Object)group)) {
                if (!name.equals(p.getName())) continue;
                if (property.equals((Object)p)) {
                    return false;
                }
                this.properties.remove((Object)group, (Object)p);
                break;
            }
        }
        boolean added = this.properties.put((Object)group, (Object)property);
        if (addGroup) {
            this.addGroup(this.propertyGroups, group);
        }
        return added;
    }

    public boolean removeProperty(Property property) {
        Name group = property.getGroup();
        if (group == null) {
            return false;
        }
        boolean removed = false;
        if (this.properties.containsKey((Object)group)) {
            String name = property.getName();
            for (Property p : this.properties.get((Object)group)) {
                if (!name.equals(p.getName())) continue;
                this.properties.remove((Object)group, (Object)p);
                removed = true;
                break;
            }
        }
        if (removed && !this.properties.containsKey((Object)group)) {
            this.removeGroup(this.propertyGroups, group);
        }
        return removed;
    }

    public MultiMap<Name, Property> getProperties() {
        return this.properties;
    }

    private void addGroup(MultiMap<Name, Name> groups, Name name) {
        if (!name.equals((Object)Name.ROOT)) {
            Name group;
            Name name2 = group = name.isRootGroup() ? Name.ROOT : name.getGroup();
            if (groups.put((Object)group, (Object)name)) {
                this.addGroup(group);
            }
        }
    }

    private void addGroup(Name name) {
        Name group = name.getGroup();
        if (group != null) {
            if (!this.groups.containsKey((Object)group)) {
                this.addGroup(group);
            }
            this.groups.put((Object)group, (Object)name);
        } else if (!name.equals((Object)Name.ROOT)) {
            this.groups.put((Object)Name.ROOT, (Object)name);
        }
    }

    private void removeGroup(MultiMap<Name, Name> groups, Name name) {
        Name group = name.isRootGroup() ? Name.ROOT : name.getGroup();
        groups.remove((Object)group, (Object)name);
        if (!group.equals((Object)Name.ROOT) && !groups.containsKey((Object)group)) {
            this.removeGroup(group);
        }
    }

    private void removeGroup(Name name) {
        if (name.equals((Object)Name.ROOT)) {
            return;
        }
        if (this.isGroupEmtpy(name)) {
            Name group = name.isRootGroup() ? Name.ROOT : name.getGroup();
            this.groups.remove((Object)group, (Object)name);
            if (!group.equals((Object)Name.ROOT) && !this.groups.containsKey((Object)group)) {
                this.removeGroup(group);
            }
        }
    }
}

