/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.server;

import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class QueueManager {
    private static String serviceName = null;
    private static Map<String, QueueManager> managers = new HashMap<String, QueueManager>();
    private HazelcastInstance hazelcast;

    public static synchronized QueueManager getInstance(HazelcastInstance hazelcast) {
        String name = hazelcast.getName();
        QueueManager manager = managers.get(name);
        if (manager == null) {
            manager = new QueueManager(hazelcast);
            managers.put(name, manager);
        }
        return manager;
    }

    private QueueManager(HazelcastInstance hazelcast) {
        this.hazelcast = hazelcast;
        if (serviceName == null) {
            this.initServiceName();
        }
    }

    private void initServiceName() {
        IQueue queue = this.hazelcast.getQueue(Long.toString(new Random().nextLong()));
        serviceName = queue.getServiceName();
        queue.destroy();
    }

    public IQueue getQueue(String name) {
        for (DistributedObject obj : this.hazelcast.getDistributedObjects()) {
            if (!obj.getServiceName().equals(serviceName) || !obj.getName().equals(name)) continue;
            return (IQueue)obj;
        }
        return null;
    }

    public Collection<IQueue> getQueues() {
        ArrayList<IQueue> list = new ArrayList<IQueue>();
        for (DistributedObject obj : this.hazelcast.getDistributedObjects()) {
            if (!obj.getServiceName().equals(serviceName)) continue;
            list.add((IQueue)obj);
        }
        return list;
    }

    public boolean destroyQueue(String name) {
        IQueue queue = this.getQueue(name);
        if (queue != null) {
            queue.destroy();
        }
        return queue != null;
    }

    public boolean isQueue(String name) {
        return this.getQueue(name) != null;
    }
}

