/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.server;

import com.beyondcron.core.JSON;
import com.beyondcron.core.StringUtils;
import com.beyondcron.core.ThreadStats;
import com.beyondcron.messaging.message.Connection;
import com.beyondcron.server.ConnectionManager;
import com.beyondcron.server.JobStatusManager;
import com.beyondcron.server.PersistManager;
import com.beyondcron.server.UserManager;
import com.hazelcast.core.HazelcastInstance;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ServerInfo
implements JSON<ServerInfo> {
    public static final String JSON_CONNECTION = "connection";
    public static final String JSON_PERSIST = "persist";
    public static final String JSON_PENDING_UPDATES = "pendingUpdates";
    public static final String JSON_SERVICES = "services";
    public static final String JSON_STATUS = "status";
    public static final String JSON_THREADS = "threads";
    public static final String JSON_USER = "user";
    private JSONObject data = new JSONObject();

    public ServerInfo(HazelcastInstance hazelcast) {
        String id = hazelcast.getLocalEndpoint().getUuid();
        for (Connection connection : ConnectionManager.getInstance(hazelcast).getServers()) {
            if (!connection.getId().equals(id)) continue;
            this.data.put(JSON_CONNECTION, (Object)connection.toJSON());
        }
        JSONObject object = new JSONObject();
        object.put(JSON_USER, (Object)StringUtils.get((String)UserManager.getInstance(hazelcast).getUserServiceName()));
        object.put(JSON_STATUS, (Object)StringUtils.get((String)JobStatusManager.getInstance(hazelcast).getStatusServiceName()));
        this.data.put(JSON_SERVICES, (Object)object);
        object = new JSONObject();
        object.put(JSON_PENDING_UPDATES, PersistManager.getInstance(hazelcast).getPendingUpdates());
        this.data.put(JSON_PERSIST, (Object)object);
        JSONArray array = new JSONArray();
        for (String thread : new ThreadStats().getDetails()) {
            array.put((Object)thread);
        }
        this.data.put(JSON_THREADS, (Object)array);
    }

    public String toString() {
        return this.data.toString(2);
    }

    public ServerInfo fromJSON(JSONObject data) throws JSONException {
        this.data = data;
        return this;
    }

    public JSONObject toJSON() {
        return this.data;
    }
}

