/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.server;

import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ITopic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class TopicManager {
    private static String serviceName = null;
    private static Map<String, TopicManager> managers = new HashMap<String, TopicManager>();
    private HazelcastInstance hazelcast;

    public static synchronized TopicManager getInstance(HazelcastInstance hazelcast) {
        String name = hazelcast.getName();
        TopicManager manager = managers.get(name);
        if (manager == null) {
            manager = new TopicManager(hazelcast);
            managers.put(name, manager);
        }
        return manager;
    }

    private TopicManager(HazelcastInstance hazelcast) {
        this.hazelcast = hazelcast;
        if (serviceName == null) {
            this.initServiceName();
        }
    }

    private void initServiceName() {
        ITopic topic = this.hazelcast.getTopic(Long.toString(new Random().nextLong()));
        serviceName = topic.getServiceName();
        topic.destroy();
    }

    public ITopic getTopic(String name) {
        for (DistributedObject obj : this.hazelcast.getDistributedObjects()) {
            if (!obj.getServiceName().equals(serviceName) || !obj.getName().equals(name)) continue;
            return (ITopic)obj;
        }
        return null;
    }

    public Collection<ITopic> getTopics() {
        ArrayList<ITopic> list = new ArrayList<ITopic>();
        for (DistributedObject obj : this.hazelcast.getDistributedObjects()) {
            if (!obj.getServiceName().equals(serviceName)) continue;
            list.add((ITopic)obj);
        }
        return list;
    }

    public boolean isTopic(String name) {
        return this.getTopic(name) != null;
    }
}

